/*
 * Tigase XMPP/Jabber Test Suite
 * Copyright (C) 2004-2009 "Artur Hefczyc" <artur.hefczyc@tigase.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. Look for COPYING file in the top folder.
 * If not, see http://www.gnu.org/licenses/.
 *
 * $Rev: 145 $
 * Last modified by $Author: kobit $
 * $Date: 2008-10-02 00:13:28 +0200 (Thu, 02 Oct 2008) $
 */
package tigase.test.impl;

import java.util.List;
import tigase.test.util.Params;
import tigase.test.TestAbstract;
import javax.management.Attribute;
import tigase.xml.Element;

import static tigase.util.JIDUtils.*;

/**
 * Describe class TestUnregister here.
 *
 *
 * Created: Sun May 22 11:05:15 2005
 *
 * @author <a href="mailto:artur.hefczyc@tigase.org">Artur Hefczyc</a>
 * @version $Rev: 145 $
 */
public class TestUnregister extends TestAbstract {

  private String user_name = "test_user@localhost";
  private String user_resr = "xmpp-test";
  private String user_emil = "test_user@localhost";
  private String hostname = "localhost";
  private String jid = null;

  private String[] elems = {"iq"};
  private int counter = 0;

  /**
   * Creates a new <code>TestUnregister</code> instance.
   *
   */
  public TestUnregister() {
    super(
      new String[] {"jabber:client"},
      new String[] {"user-unregister"},
      new String[] {"stream-open", "auth", "xmpp-bind"},
      new String[] {"user-register", "tls-init"}
      );
  }

  public String nextElementName(final Element reply) {
    if (counter < elems.length) {
      return elems[counter++];
    } // end of if (counter < elems.length)
    return null;
  }

  public String getElementData(final String element) throws Exception {
    switch (counter) {
    case 1:
      return "<iq type='set' id='unreg1' from='" + jid + "'>"
        + "<query xmlns='jabber:iq:register'>"
        + "<remove/>"
        + "</query>" +
        "</iq>";
    default:
      return null;
    } // end of switch (counter)
  }

  public String[] getRespElementNames(final String element) {
    return new String[] {"iq"};
  }

  public Attribute[] getRespElementAttributes(final String element) {
    switch (counter) {
    case 1:
      return new Attribute[]
      {
        new Attribute("type", "result")
				, new Attribute("id", "unreg1")
				//				, new Attribute("to", jid)
      };
    default:
      return null;
    } // end of switch (counter)
  }

  public String[] getRespOptionalNames(final String element) {
    return null;
  }

  // Implementation of tigase.test.TestIfc

  /**
   * Describe <code>init</code> method here.
   *
   * @param params a <code>Params</code> value
   */
  public void init(final Params params) {
    super.init(params);
    user_name = params.get("-user-name", user_name);
    user_resr = params.get("-user-resr", user_resr);
    user_emil = params.get("-user-emil", user_emil);
    hostname = params.get("-host", hostname);
    String name = getNodeNick(user_name);
    if (name == null || name.equals("")) {
      jid = user_name + "@" + hostname + "/" + user_resr;
    } else {
      jid = user_name + "/" + user_resr;
    } // end of else
  }

} // TestUnregister
