/*
 * Decompiled with CFR 0.152.
 */
package tigase.test.util;

import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import tigase.xml.Element;

public class ElementUtil {
    public static boolean hasAttributes(Element elem, Attribute[] attrs) {
        for (Attribute attr : attrs) {
            String val = elem.getAttribute(attr.getName());
            if (val == null) {
                return false;
            }
            if (val.equals(attr.getValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean equalElems(Element el1, Element el2) {
        String cdata1;
        if (!el1.getName().equals(el2.getName())) {
            return false;
        }
        Map attrs = el1.getAttributes();
        if (attrs != null) {
            for (String key : attrs.keySet()) {
                String atval2 = el2.getAttribute(key);
                if (atval2 == null) {
                    return false;
                }
                if (((String)attrs.get(key)).equals(atval2)) continue;
                return false;
            }
        }
        if ((cdata1 = el1.getCData()) != null) {
            String cdata2 = el2.getCData();
            if (cdata2 == null) {
                return false;
            }
            if (!cdata1.equals(cdata2)) {
                return false;
            }
        }
        return true;
    }

    public static boolean equalElemsDeep(Element el1, Element el2) {
        boolean equal = ElementUtil.equalElems(el1, el2);
        if (!equal) {
            return false;
        }
        List children = el1.getChildren();
        if (children == null) {
            return true;
        }
        for (Element child1 : children) {
            List children2 = el2.getChildren();
            if (children2 == null || children2.size() == 0) {
                return false;
            }
            boolean found_child = false;
            for (Element child2 : children2) {
                found_child |= ElementUtil.equalElemsDeep(child1, child2);
            }
            if (found_child) continue;
            return false;
        }
        return true;
    }
}

