/*
 * Decompiled with CFR 0.152.
 */
package tigase.test.impl;

import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Queue;
import javax.management.Attribute;
import tigase.test.ResultCode;
import tigase.test.TestAbstract;
import tigase.test.util.Params;
import tigase.test.util.TestUtil;
import tigase.test.util.XMLIO;
import tigase.util.JIDUtils;
import tigase.xml.Element;

public class TestReceiveMessage
extends TestAbstract {
    private String user_name = "test_user@localhost";
    private String user_resr = "xmpp-test";
    private String hostname = "localhost";
    private String jid = null;
    private String msg_1 = null;
    private String msg_2 = null;
    private String data = null;
    private Attribute[] resp_attribs = null;

    public TestReceiveMessage() {
        super(new String[]{"jabber:client"}, new String[]{"msg-listen"}, new String[]{"socket", "stream-open", "auth"}, new String[]{"user-register", "tls-init", "privacy-block-msg", "privacy-long-list"});
    }

    @Override
    public String nextElementName(Element element) throws Exception {
        if (element == null) {
            TestUtil.addDaemonJID(this.jid, (Socket)this.params.get("socket"));
            this.data = null;
            return "";
        }
        this.data = this.msg_1 + element.getAttribute("from") + this.msg_2;
        return "message";
    }

    @Override
    public String getElementData(String string) throws Exception {
        return this.data;
    }

    @Override
    public String[] getRespElementNames(String string) throws Exception {
        return new String[]{"message"};
    }

    @Override
    public String[] getRespOptionalNames(String string) throws Exception {
        return null;
    }

    @Override
    public Attribute[] getRespElementAttributes(String string) throws Exception {
        return this.resp_attribs;
    }

    @Override
    public void init(Params params) {
        super.init(params);
        this.user_name = params.get("-user-name", this.user_name);
        this.hostname = params.get("-host", this.hostname);
        this.user_resr = params.get("-user_resr", this.user_resr);
        String name = JIDUtils.getNodeNick((String)this.user_name);
        this.jid = name == null || name.equals("") ? this.user_name + "@" + this.hostname + "/" + this.user_resr : this.user_name + "/" + this.user_resr;
        this.msg_1 = "<message from='" + this.jid + "' to='";
        this.msg_2 = "'>Message OK</message>";
    }

    @Override
    public boolean run() {
        try {
            String elem = null;
            XMLIO io = (XMLIO)this.params.get("socketxmlio");
            if (io == null) {
                TestUtil.removeDaemonJID(this.jid);
                this.resultCode = ResultCode.SOCKET_NOT_INITALIZED;
                System.out.println("Message listener FINISHED 1");
                return false;
            }
            elem = this.nextElementName(this.reply);
            while (elem != null) {
                this.debug("Processing element: " + elem + "\n");
                Queue<Element> results = io.read();
                Element rep = null;
                while ((rep = results.poll()) != null) {
                    this.reply = rep;
                    this.debug("Response data: " + this.reply.toString() + "\n");
                    elem = this.nextElementName(this.reply);
                    String data = this.getElementData(elem);
                    if (data == null || data.equals("")) continue;
                    this.debug("Element data: " + data + "\n");
                    io.write(data);
                }
            }
            TestUtil.removeDaemonJID(this.jid);
            System.out.println("Message listener FINISHED 2");
            return true;
        }
        catch (SocketTimeoutException e) {
            TestUtil.removeDaemonJID(this.jid);
            this.addInput("" + e + "\n" + TestUtil.stack2String(e));
            this.resultCode = ResultCode.PROCESSING_EXCEPTION;
            this.exception = e;
            System.out.println("Message listener FINISHED 3");
            return false;
        }
        catch (Exception e) {
            TestUtil.removeDaemonJID(this.jid);
            this.addInput("" + e + "\n" + TestUtil.stack2String(e));
            this.resultCode = ResultCode.PROCESSING_EXCEPTION;
            this.exception = e;
            e.printStackTrace();
            System.out.println("Message listener FINISHED 4");
            return false;
        }
    }
}

