/*
 * Decompiled with CFR 0.152.
 */
package tigase.test.impl;

import java.util.LinkedList;
import java.util.List;
import javax.management.Attribute;
import tigase.test.StatItem;
import tigase.test.TestAbstract;
import tigase.test.util.Params;
import tigase.util.JIDUtils;
import tigase.xml.Element;

public class TestIQStats
extends TestAbstract {
    private String hostname = "localhost";
    private String from = null;
    private String[] elems = new String[]{"iq"};
    private int counter = 0;

    public TestIQStats() {
        super(new String[]{"jabber:client"}, new String[]{"iq-stats"}, new String[]{"socket", "stream-open", "auth"}, new String[]{"stream-open", "auth", "user-register", "tls-init"});
    }

    @Override
    public String nextElementName(Element element) throws Exception {
        if (this.counter < this.elems.length) {
            return this.elems[this.counter++];
        }
        LinkedList<StatItem> stats = new LinkedList<StatItem>();
        List items = element.getChildren("/iq/query");
        for (Element item : items) {
            String name = item.getAttribute("name");
            int idx = name.indexOf("/");
            String comp = "unknown";
            String stat = name;
            if (idx >= 0) {
                comp = name.substring(0, idx);
                stat = name.substring(idx + 1);
            }
            stats.add(new StatItem(comp, item.getAttribute("value"), item.getAttribute("units"), stat));
        }
        this.params.put("Statistics", (Object)stats);
        return null;
    }

    @Override
    public String getElementData(String string) throws Exception {
        switch (this.counter) {
            case 1: {
                return "<iq type='get' to='" + this.hostname + "' from='" + this.from + "' id='stats_1'>" + "<query xmlns='http://jabber.org/protocol/stats'/>" + "</iq>";
            }
        }
        return null;
    }

    @Override
    public String[] getRespElementNames(String string) throws Exception {
        return new String[]{"iq"};
    }

    @Override
    public String[] getRespOptionalNames(String string) throws Exception {
        return null;
    }

    @Override
    public Attribute[] getRespElementAttributes(String string) throws Exception {
        switch (this.counter) {
            case 1: {
                return new Attribute[]{new Attribute("type", "result"), new Attribute("id", "stats_1")};
            }
        }
        return null;
    }

    @Override
    public void init(Params map) {
        super.init(map);
        this.hostname = this.params.get("-host", this.hostname);
        String user_name = this.params.get("-user-name", "test_user@localhost");
        String user_resr = this.params.get("-user_resr", "xmpp-test");
        String name = JIDUtils.getNodeNick((String)user_name);
        this.from = name == null || name.equals("") ? user_name + "@" + this.hostname + "/" + user_resr : user_name + "/" + user_resr;
    }
}

