/*
 * Decompiled with CFR 0.152.
 */
package tigase.test.impl;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import tigase.test.ResultCode;
import tigase.test.TestEmpty;
import tigase.test.util.ElementUtil;
import tigase.test.util.Params;
import tigase.test.util.TestUtil;
import tigase.test.util.XMLIO;
import tigase.util.JIDUtils;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;

public class TestCommon
extends TestEmpty {
    private static final SimpleParser parser = SingletonFactory.getParserInstance();
    protected Params params = null;
    private String user_name = "test_user@localhost";
    private String user_resr = "xmpp-test";
    private String user_emil = "test_user@localhost";
    private String hostname = "localhost";
    private String source_file = "tests/data/sample-file.cot";
    private String jid = null;
    private String id = null;
    private String to = "test_user@localhost";
    protected boolean timeoutOk = false;
    private boolean fullExceptionStack = false;
    protected ResultCode resultCode = ResultCode.TEST_OK;
    protected Exception exception = null;
    private String error_message = "";
    private Queue<StanzaEntry> stanzas = null;

    public TestCommon() {
        super(new String[]{"jabber:client"}, new String[]{"common"}, new String[]{"socket", "stream-open", "auth"}, new String[]{"user-register", "tls-init"});
    }

    @Override
    public boolean run() {
        try {
            StanzaEntry entry = null;
            block7: while ((entry = this.stanzas.poll()) != null) {
                XMLIO io = (XMLIO)this.params.get("socketxmlio");
                if (io == null) {
                    this.resultCode = ResultCode.SOCKET_NOT_INITALIZED;
                    return false;
                }
                switch (entry.action) {
                    case send: {
                        for (Element elem : entry.stanza) {
                            this.debug("\nSending: " + elem.toString());
                            this.addOutput(elem.toString());
                            io.write(elem);
                        }
                        continue block7;
                    }
                    case expect: {
                        boolean found = false;
                        LinkedList<Element> all_results = new LinkedList<Element>();
                        Queue<Element> results = null;
                        while (results == null || results.size() == 0) {
                            results = io.read();
                        }
                        all_results.addAll(results);
                        for (int exp = 0; exp < entry.stanza.length && !found; ++exp) {
                            Element received = null;
                            while ((received = results.poll()) != null && !found) {
                                this.addInput(received.toString());
                                found = ElementUtil.equalElemsDeep(entry.stanza[exp], received);
                            }
                        }
                        if (found) break;
                        this.resultCode = ResultCode.RESULT_DOESNT_MATCH;
                        this.error_message = "Expected one of: " + Arrays.toString(entry.stanza) + ", received: " + Arrays.toString(all_results.toArray(new Element[0]));
                        return false;
                    }
                }
            }
            return true;
        }
        catch (SocketTimeoutException e) {
            if (this.timeoutOk) {
                return true;
            }
            this.resultCode = ResultCode.PROCESSING_EXCEPTION;
            this.exception = e;
            this.addInput(this.getClass().getName() + ", " + e.getMessage());
            return false;
        }
        catch (Exception e) {
            this.addInput(this.getClass().getName() + ", " + e + "\n" + TestUtil.stack2String(e));
            this.resultCode = ResultCode.PROCESSING_EXCEPTION;
            this.exception = e;
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public ResultCode getResultCode() {
        return this.resultCode;
    }

    @Override
    public String getResultMessage() {
        switch (this.resultCode) {
            case PROCESSING_EXCEPTION: {
                if (this.fullExceptionStack) {
                    return this.getClass().getName() + ", " + this.resultCode.getMessage() + this.exception.toString() + "\n" + TestUtil.stack2String(this.exception);
                }
                return this.getClass().getName() + ", " + this.exception.getMessage();
            }
        }
        return this.resultCode.getMessage() + ", " + this.error_message;
    }

    @Override
    public void init(Params params) {
        super.init(params);
        this.params = params;
        this.user_name = params.get("-user-name", this.user_name);
        this.user_resr = params.get("-user_resr", this.user_resr);
        this.user_emil = params.get("-user-emil", this.user_emil);
        this.hostname = params.get("-host", this.hostname);
        String name = JIDUtils.getNodeNick((String)this.user_name);
        this.jid = name == null || name.equals("") ? this.user_name + "@" + this.hostname + "/" + this.user_resr : this.user_name + "/" + this.user_resr;
        this.id = name == null || name.equals("") ? this.user_name + "@" + this.hostname : this.user_name;
        this.to = params.get("-to-jid", this.to);
        this.timeoutOk = params.containsKey("-time-out-ok");
        this.fullExceptionStack = params.containsKey("-full-stack-trace");
        this.source_file = params.get("-source-file", this.source_file);
        this.stanzas = new LinkedList<StanzaEntry>();
        this.loadSourceFile(this.source_file);
    }

    private void loadSourceFile(String file) {
        try {
            ParserState state = ParserState.start;
            StringBuilder buff = null;
            BufferedReader buffr = new BufferedReader(new FileReader(file));
            String line = buffr.readLine();
            while (line != null) {
                line = line.trim();
                switch (state) {
                    case start: {
                        if (line.toLowerCase().startsWith("send:")) {
                            state = ParserState.send_stanza;
                            buff = new StringBuilder();
                        }
                        if (!line.toLowerCase().startsWith("expect:")) break;
                        state = ParserState.expect_stanza;
                        buff = new StringBuilder();
                        break;
                    }
                    case send_stanza: 
                    case expect_stanza: {
                        if (!(line.equals("{") || line.equals("}") || line.startsWith("#"))) {
                            buff.append(line + '\n');
                        }
                        if (!line.equals("}")) break;
                        Element[] elems = this.parseXMLData(buff.toString());
                        if (elems != null) {
                            switch (state) {
                                case send_stanza: {
                                    this.stanzas.offer(new StanzaEntry(Action.send, elems));
                                    break;
                                }
                                case expect_stanza: {
                                    this.stanzas.offer(new StanzaEntry(Action.expect, elems));
                                    break;
                                }
                            }
                        }
                        state = ParserState.start;
                        break;
                    }
                }
                line = buffr.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Can't read source file: " + file, e);
        }
    }

    private Element[] parseXMLData(String data) {
        data = data.replace("$(from-jid)", this.jid);
        data = data.replace("$(to-jid)", this.to);
        data = data.replace("$(hostname)", this.hostname);
        data = data.replace("$(number)", "");
        data = data.replace("$(cdata)", "");
        DomBuilderHandler domHandler = new DomBuilderHandler();
        parser.parse((SimpleHandler)domHandler, data.toCharArray(), 0, data.length());
        Queue elems = domHandler.getParsedElements();
        if (elems != null && elems.size() > 0) {
            return elems.toArray(new Element[elems.size()]);
        }
        return null;
    }

    private static enum Action {
        send,
        expect;

    }

    private class StanzaEntry {
        private Action action = null;
        private Element[] stanza = null;

        public StanzaEntry(Action action, Element[] stanza) {
            this.action = action;
            this.stanza = stanza;
        }
    }

    private static enum ParserState {
        start,
        send_stanza,
        expect_stanza;

    }
}

