/*
 * Decompiled with CFR 0.152.
 */
package tigase.test;

import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.Queue;
import javax.management.Attribute;
import tigase.test.ResultCode;
import tigase.test.ResultsDontMatchException;
import tigase.test.TestEmpty;
import tigase.test.util.Params;
import tigase.test.util.TestUtil;
import tigase.test.util.XMLIO;
import tigase.xml.Element;

public abstract class TestAbstract
extends TestEmpty {
    protected Params params = null;
    protected ResultCode resultCode = ResultCode.TEST_OK;
    protected Exception exception = null;
    protected Element reply = null;
    protected boolean timeoutOk = false;
    private boolean fullExceptionStack = false;
    private String error_message = "";

    public TestAbstract(String[] base_xmlns, String[] implemented, String[] depends, String[] optional) {
        super(base_xmlns, implemented, depends, optional);
    }

    public static String substituteVars(String data, String[] vars, String[] vals) {
        String result = data;
        for (int i = 0; i < vars.length; ++i) {
            result = result.replace(vars[i], vals[i]);
        }
        return result;
    }

    public static boolean hasAttributes(Element elem, Attribute[] attrs) {
        if (attrs != null) {
            for (Attribute attr : attrs) {
                String val = elem.getAttribute(attr.getName());
                if (val == null) {
                    return false;
                }
                if (val.equals(attr.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    public abstract String nextElementName(Element var1) throws Exception;

    public abstract String getElementData(String var1) throws Exception;

    public abstract String[] getRespElementNames(String var1) throws Exception;

    public abstract String[] getRespOptionalNames(String var1) throws Exception;

    public abstract Attribute[] getRespElementAttributes(String var1) throws Exception;

    public void replyElement(Element reply) throws Exception {
    }

    @Override
    public boolean run() {
        try {
            String elem = null;
            while ((elem = this.nextElementName(this.reply)) != null) {
                this.debug("Processing element: " + elem + "\n");
                XMLIO io = (XMLIO)this.params.get("socketxmlio");
                if (io == null) {
                    this.resultCode = ResultCode.SOCKET_NOT_INITALIZED;
                    return false;
                }
                String data = this.getElementData(elem);
                if (data != null && !data.equals("")) {
                    this.debug("Element data: " + data + "\n");
                    this.addOutput(data);
                    io.write(data);
                }
                String[] responses = this.getRespElementNames(elem);
                boolean[] resp_found = new boolean[responses.length];
                String[] optional_resp = this.getRespOptionalNames(elem);
                Arrays.fill(resp_found, false);
                int index = 0;
                while (!resp_found[resp_found.length - 1]) {
                    Queue<Element> results = io.read();
                    Element rep = null;
                    while (index < resp_found.length && (rep = results.poll()) != null) {
                        this.reply = rep;
                        this.replyElement(this.reply);
                        this.debug("Response data: " + this.reply.toString() + "\n");
                        this.addInput(this.reply.toString());
                        resp_found[index] = this.checkResponse(this.reply, responses[index], optional_resp);
                        if (resp_found[index++]) continue;
                        this.resultCode = ResultCode.RESULT_DOESNT_MATCH;
                        return false;
                    }
                    if (results.size() <= 0) continue;
                    this.reply = results.poll();
                    this.resultCode = ResultCode.RESULT_DOESNT_MATCH;
                    return false;
                }
            }
            return true;
        }
        catch (SocketTimeoutException e) {
            if (this.timeoutOk) {
                return true;
            }
            this.resultCode = ResultCode.PROCESSING_EXCEPTION;
            this.exception = e;
            this.addInput(this.getClass().getName() + ", " + e.getMessage());
            return false;
        }
        catch (ResultsDontMatchException e) {
            this.resultCode = ResultCode.PROCESSING_EXCEPTION;
            this.exception = e;
            this.addInput(this.getClass().getName() + ", " + e.getMessage());
            return false;
        }
        catch (Exception e) {
            this.addInput(this.getClass().getName() + ", " + e + "\n" + TestUtil.stack2String(e));
            this.resultCode = ResultCode.PROCESSING_EXCEPTION;
            this.exception = e;
            e.printStackTrace();
            return false;
        }
    }

    private boolean checkResponse(Element reply, String response, String[] optional_resp) throws Exception {
        if (reply.getName().equals(response) && TestAbstract.hasAttributes(reply, this.getRespElementAttributes(response))) {
            return true;
        }
        if (optional_resp != null) {
            for (String opt : optional_resp) {
                if (!reply.getName().equals(opt) || !TestAbstract.hasAttributes(reply, this.getRespElementAttributes(opt))) continue;
                return true;
            }
        }
        this.error_message = this.getClass().getName() + ", expected: '" + response + "', Received: '" + reply.toString() + "'";
        return false;
    }

    @Override
    public void init(Params params) {
        super.init(params);
        this.params = params;
        this.timeoutOk = params.containsKey("-time-out-ok");
        this.fullExceptionStack = params.containsKey("-full-stack-trace");
    }

    @Override
    public ResultCode getResultCode() {
        return this.resultCode;
    }

    @Override
    public Element getLastResult() {
        return this.reply;
    }

    @Override
    public String getResultMessage() {
        switch (this.resultCode) {
            case PROCESSING_EXCEPTION: {
                if (this.fullExceptionStack) {
                    return this.getClass().getName() + ", " + this.resultCode.getMessage() + this.exception.toString() + "\n" + TestUtil.stack2String(this.exception);
                }
                return this.getClass().getName() + ", " + this.exception.getMessage();
            }
        }
        return this.getClass().getName() + ", " + this.resultCode.getMessage() + ", " + this.error_message;
    }
}

