/*
 * Decompiled with CFR 0.152.
 */
package tigase.test;

import java.net.Socket;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import tigase.test.HistoryEntry;
import tigase.test.TestIfc;
import tigase.test.parser.TestNode;
import tigase.test.util.Params;
import tigase.test.util.TestUtil;
import tigase.xml.Element;

public class Test {
    public static final String NS_SEP = ";";
    private String testName = null;
    private Map<String, String> pars = null;
    private Params main_params = null;
    private String description = null;
    private String[] test_ns = null;
    private boolean result = false;
    private String errorMsg = null;
    private Exception exception = null;
    private List<HistoryEntry> history = null;
    private int tests_ok = 0;
    private int tests_er = 0;
    private long total_time = 0L;
    private long total_successful = 0L;
    private boolean collectHistory = false;
    private boolean on_one_socket = false;
    private boolean active_connection = false;
    private Element lastResult = null;
    private Test onError = null;
    private TestNode node = null;
    private boolean debug = false;
    protected boolean debug_on_error = false;

    public Test(TestNode node) {
        String ldescr;
        this.node = node;
        this.testName = node.getName();
        this.test_ns = node.getId() != null ? node.getId().split(NS_SEP) : null;
        this.pars = node.getPars();
        this.main_params = new Params(this.pars);
        this.description = node.getShortDescr();
        if ((this.description == null || this.description.trim().equals("")) && (ldescr = node.getLongDescr()) != null) {
            this.description = ldescr.substring(2, ldescr.length() - 2);
        }
        if (node.getOnError() != null) {
            this.onError = new Test(node.getOnError());
        }
        if (!this.main_params.isFalse("-output-history") && !this.main_params.containsKey("-daemon")) {
            this.collectHistory = true;
            this.history = new LinkedList<HistoryEntry>();
        }
    }

    private void initParams() {
        this.on_one_socket = this.main_params.containsKey("-on-one-socket");
        this.active_connection = this.main_params.containsKey("-active-connection");
    }

    public void runTest() {
        this.initParams();
        this.debug = this.main_params.containsKey("-debug");
        this.debug_on_error = this.main_params.containsKey("-debug-on-error") && !this.main_params.containsKey("-no-record");
        int loop = this.main_params.get("-loop", 1);
        String user_name = (String)this.main_params.get("-user-name");
        boolean loop_user_name = false;
        if (user_name != null && user_name.contains("$(loop)")) {
            loop_user_name = true;
            user_name = user_name.replace("$(loop)", "");
        }
        long loop_delay = 0L;
        if (this.main_params.containsKey("-loop-delay")) {
            loop_delay = this.main_params.get("-loop-delay", 10);
        }
        List<TestIfc> suite = null;
        Params test_params = null;
        boolean this_result = false;
        for (int cnt = 0; cnt < loop; ++cnt) {
            try {
                if (this.on_one_socket && cnt > 0 && this_result) {
                    List<TestIfc> suite_tmp = TestUtil.getDependsTree(this.test_ns, test_params);
                    suite = suite_tmp.subList(suite_tmp.size() - 1, suite_tmp.size());
                } else {
                    test_params = new Params();
                    test_params.putAll((Map)this.main_params);
                    suite = TestUtil.getDependsTree(this.test_ns, test_params);
                }
                if (suite.size() == 0) {
                    this.errorMsg = "No tests implementation found for given name space: " + this.node.getId();
                    this.result = false;
                    return;
                }
                if (loop_user_name) {
                    test_params.put("-user-name", (Object)(user_name + cnt));
                }
                long test_start_time = System.currentTimeMillis();
                this_result = this.runTest(suite, test_params);
                long this_test = System.currentTimeMillis() - test_start_time;
                this.total_time += this_test;
                if (this_result) {
                    this.total_successful += this_test;
                    ++this.tests_ok;
                } else {
                    ++this.tests_er;
                    if (cnt > 10 && this.tests_ok <= this.tests_er) {
                        TestUtil.debug("Too many errors, stopping test...\n", this.debug);
                        this.result = false;
                        this.errorMsg = "Too many errors, stopping test: " + this.tests_ok + " OK, " + this.tests_er + " ER";
                        return;
                    }
                    String on_error = (String)test_params.get("-on-error");
                    if (this.onError != null) {
                        this.onError.runTest();
                    }
                }
            }
            catch (Exception e) {
                this.result = false;
                this.errorMsg = e.getMessage();
                this.exception = e;
                return;
            }
            if (loop_delay <= 0L) continue;
            try {
                Thread.sleep(loop_delay);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.main_params = test_params;
        boolean bl = this.result = this.tests_ok > this.tests_er;
        if (this.main_params.containsKey("-delay")) {
            long delay = this.main_params.get("-delay", 1000);
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    private boolean runTest(List<TestIfc> suite, Params test_params) {
        boolean daemon = test_params.containsKey("-daemon");
        long socket_wait = test_params.get("-socket-wait", 5000);
        DaemonTest dt = new DaemonTest(suite, test_params);
        if (daemon) {
            this.runThread(dt);
            return true;
        }
        dt.run();
        return dt.getResult();
    }

    private void runThread(Runnable task) {
        Thread t = new Thread(task);
        t.setDaemon(true);
        t.start();
    }

    public int getTestsOK() {
        return this.tests_ok;
    }

    public void addTestsOK(int tests) {
        this.tests_ok += tests;
    }

    public int getTestsErr() {
        return this.tests_er;
    }

    public void addTestsErr(int tests) {
        this.tests_er += tests;
    }

    public long getTestsTotalTime() {
        return this.total_time;
    }

    public void addTestsTotalTime(long time) {
        this.total_time += time;
    }

    public long getSuccessfulTotalTime() {
        return this.total_successful;
    }

    public void addSuccessfulTotalTime(long time) {
        this.total_successful += time;
    }

    public List<HistoryEntry> getHistory() {
        return this.history;
    }

    public Exception getException() {
        return this.exception;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public Element getLastResult() {
        return this.lastResult;
    }

    public boolean getResult() {
        return this.result;
    }

    public void setResult(boolean res) {
        this.result = res;
    }

    public void setName(String name) {
        this.testName = name;
    }

    public String getName() {
        return this.testName;
    }

    public Params getParams() {
        return this.main_params;
    }

    public void setDescription(String descr) {
        this.description = descr;
    }

    public String getDescription() {
        return this.description;
    }

    class DaemonTest
    implements Runnable {
        private List<TestIfc> suite = null;
        private Params params = null;
        private boolean result = false;
        private boolean authorized = false;

        public DaemonTest(List<TestIfc> suite, Params params) {
            this.suite = suite;
            this.params = params;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (TestIfc test : this.suite) {
                    DaemonTest daemonTest;
                    TestUtil.debug("Testing: " + TestUtil.toStringArrayNS(test.implemented(), "..."), Test.this.debug);
                    test.init(this.params);
                    boolean res = test.run();
                    if (Test.this.collectHistory) {
                        Test.this.history.addAll(test.getHistory());
                    }
                    if (res) {
                        Test.this.lastResult = test.getLastResult();
                        this.authorized = this.params.get("authorized", false);
                        if (this.authorized) {
                            daemonTest = this;
                            synchronized (daemonTest) {
                                this.notifyAll();
                            }
                        }
                        TestUtil.debug("     success!\n", Test.this.debug);
                        continue;
                    }
                    Test.this.errorMsg = test.getResultMessage();
                    TestUtil.debug("       failure!\n", Test.this.debug || Test.this.debug_on_error);
                    TestUtil.debug("Error code: " + (Object)((Object)test.getResultCode()) + ", error message: " + test.getResultMessage() + "\n", Test.this.debug || Test.this.debug_on_error);
                    this.result = false;
                    daemonTest = this;
                    synchronized (daemonTest) {
                        this.notifyAll();
                    }
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Test.this.exception = e;
                Test.this.errorMsg = e.toString();
                this.result = false;
                DaemonTest daemonTest = this;
                synchronized (daemonTest) {
                    this.notifyAll();
                }
                return;
            }
            if (!Test.this.on_one_socket && !Test.this.active_connection) {
                try {
                    ((Socket)this.params.get("socket")).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.result = true;
            DaemonTest daemonTest = this;
            synchronized (daemonTest) {
                this.notifyAll();
            }
        }

        public boolean getResult() {
            return this.result;
        }

        public boolean isAuthorized() {
            return this.authorized;
        }
    }
}

