/*
 * Decompiled with CFR 0.152.
 */
package tigase.test.junit;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import org.junit.Assert;
import tigase.test.junit.JUnitXMLIO;
import tigase.test.junit.ScriptEntry;
import tigase.test.junit.ScriptEntryKind;
import tigase.test.junit.TestHelper;
import tigase.test.util.ElementUtil;
import tigase.xml.Element;

public abstract class XMPPTestCase {
    private String configFile;

    public static boolean isScriptValid(Collection<ScriptEntry> entries) {
        ScriptEntryKind wantKind = ScriptEntryKind.send;
        block3: for (ScriptEntry scriptEntry : entries) {
            if (wantKind != null && scriptEntry.getKind() != wantKind) {
                throw new RuntimeException("Invalid script for JUnit test! Expected " + (Object)((Object)wantKind));
            }
            if (wantKind == null && scriptEntry.getKind() == ScriptEntryKind.send) {
                throw new RuntimeException("Invalid script for JUnit test! Expected not send element!");
            }
            if (scriptEntry.getKind() == ScriptEntryKind.send && (scriptEntry.getStanza() == null || scriptEntry.getStanza().length != 1)) {
                throw new RuntimeException("Invalid script for JUnit test! send may have only one element!");
            }
            switch (scriptEntry.getKind()) {
                case send: {
                    wantKind = null;
                    continue block3;
                }
            }
            wantKind = ScriptEntryKind.send;
        }
        return true;
    }

    private static boolean equalsOneOf(Element[] expect, Collection<Element> data) {
        if (expect == null && data == null) {
            return true;
        }
        if (expect == null || data == null) {
            return false;
        }
        boolean result = false;
        for (Element d : data) {
            for (Element e : expect) {
                result |= ElementUtil.equalElemsDeep(e, d);
            }
        }
        return result;
    }

    private static boolean equalsAll(Element[] expect, Collection<Element> data) {
        if (expect == null && data == null) {
            return true;
        }
        if (expect == null || data == null) {
            return false;
        }
        boolean result = true;
        for (Element e : expect) {
            boolean found = false;
            for (Element d : data) {
                found |= ElementUtil.equalElemsDeep(e, d);
            }
            result &= found;
        }
        return result;
    }

    private static boolean equalsStrict(Element[] expect, Collection<Element> data) {
        if (expect == null && data == null) {
            return true;
        }
        if (expect == null || data == null) {
            return false;
        }
        if (expect.length != data.size()) {
            return false;
        }
        boolean result = true;
        Iterator<Element> dataI = data.iterator();
        int c = 0;
        while (dataI.hasNext()) {
            Element e = expect[c++];
            Element d = dataI.next();
            result &= ElementUtil.equalElemsDeep(e, d);
        }
        return result;
    }

    public static void test(String configFile, JUnitXMLIO xmlio) {
        try {
            if (configFile == null) {
                throw new RuntimeException("Script file must be specified.");
            }
            Queue<ScriptEntry> script = TestHelper.loadSourceFile(configFile);
            XMPPTestCase.isScriptValid(script);
            for (ScriptEntry scriptEntry : script) {
                Boolean ok = null;
                switch (scriptEntry.getKind()) {
                    case send: {
                        xmlio.read().clear();
                        xmlio.write(scriptEntry.getStanza()[0]);
                        break;
                    }
                    case expect: {
                        ok = XMPPTestCase.equalsOneOf(scriptEntry.getStanza(), xmlio.read());
                        if (ok.booleanValue()) break;
                        String error_message = "Expected one of: " + Arrays.toString(scriptEntry.getStanza()) + ", received: " + Arrays.toString(xmlio.read().toArray(new Element[0]));
                        Assert.fail((String)error_message);
                        break;
                    }
                    case expect_all: {
                        ok = XMPPTestCase.equalsAll(scriptEntry.getStanza(), xmlio.read());
                        if (ok.booleanValue()) break;
                        String error_message = "Expected all of: " + Arrays.toString(scriptEntry.getStanza()) + ", received: " + Arrays.toString(xmlio.read().toArray(new Element[0]));
                        Assert.fail((String)error_message);
                        break;
                    }
                    case expect_strict: {
                        ok = XMPPTestCase.equalsStrict(scriptEntry.getStanza(), xmlio.read());
                        if (ok.booleanValue()) break;
                        String error_message = "Expected sequence: " + Arrays.toString(scriptEntry.getStanza()) + ", received: " + Arrays.toString(xmlio.read().toArray(new Element[0]));
                        Assert.fail((String)error_message);
                        break;
                    }
                }
                if (ok == null || ok.booleanValue()) continue;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        XMPPTestCase.test("processPresence-empty.cor", null);
    }

    public XMPPTestCase() {
        this.configFile = null;
    }

    public XMPPTestCase(String sourceFile) {
        this.configFile = sourceFile;
    }

    public void test(JUnitXMLIO xmlio) {
        XMPPTestCase.test(this.configFile, xmlio);
    }
}

