/*
 * Decompiled with CFR 0.152.
 */
package tigase.test;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import tigase.test.HistoryEntry;
import tigase.test.StatItem;
import tigase.test.Test;
import tigase.test.parser.TestNode;
import tigase.test.parser.TestScript;
import tigase.test.util.HTMLFilter;
import tigase.test.util.NullFilter;
import tigase.test.util.OutputFilter;
import tigase.test.util.Params;
import tigase.test.util.TestUtil;

public class TestScriptLoader {
    private TestScript parser = null;
    private Params params = null;
    private List<TestNode> testNodes = null;
    private String scriptName = "xmpp-tests.xmpt";
    private File dir_name = new File("");
    private OutputFilter filter = null;
    private int output_cols = 5;
    private boolean stop_on_fail = false;
    private boolean output_history = false;
    private JobControll jobContr = new JobControll();
    private Test multiResCont = null;

    public TestScriptLoader(Params params) {
        this.params = params;
    }

    public void loadTests() throws Exception {
        this.scriptName = this.params.get("-script", this.scriptName);
        TestUtil.debug("Script name: " + this.scriptName + "\n", true);
        this.parser = new TestScript(new InputStreamReader((InputStream)new FileInputStream(this.scriptName), "UTF-8"));
        this.parser.Input();
        this.testNodes = this.parser.getTests();
        Params pars = new Params(this.parser.getGlobalPars());
        pars.putAll((Map)this.params);
        this.params = pars;
        this.stop_on_fail = this.params.get("-stop-on-fail", false);
    }

    public void runTests() throws Exception {
        this.filter = this.initOutputFilter();
        for (TestNode node : this.testNodes) {
            node.addGlobalPars(this.params.getMap());
            node.addGlobalVars(this.parser.getGlobalVars());
            boolean result = this.runTest(node);
            if (!this.stop_on_fail || result) continue;
            break;
        }
        this.closeFilter(this.filter);
    }

    private boolean runTest(TestNode node) throws Exception {
        if (node.getPars().containsKey("-multi-thread")) {
            TestUtil.debug(node.getName() + ": " + this.getDescription(node) + " ... ", true);
            this.multiResCont = new Test(node);
            this.multiResCont.getParams().put("-loop", (Object)0);
            this.runMultiTest(node);
            this.jobContr.allDone(0L);
            this.calculateResult(this.multiResCont);
            return true;
        }
        boolean result = true;
        if (node.getId() != null) {
            TestUtil.debug(node.getName() + ": " + this.getDescription(node) + " ... ", true);
            Test test = new Test(node);
            test.runTest();
            this.calculateResult(test);
            result = test.getResult();
        }
        if (this.stop_on_fail && !result) {
            return result;
        }
        if (node.getChildren() != null) {
            for (TestNode child : node.getChildren()) {
                long delay;
                result = this.runTest(child);
                if (this.stop_on_fail && !result) {
                    return result;
                }
                if (!node.getPars().containsKey("-delay") || (delay = Long.decode(node.getPars().get("-delay").toString()).longValue()) <= 0L) continue;
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e) {}
            }
        }
        return result;
    }

    private boolean runMultiTest(TestNode node) throws IOException {
        if (node.getId() != null) {
            Test test = new Test(node);
            ThreadTest tt = new ThreadTest(test);
            new Thread(tt).start();
        }
        if (node.getChildren() != null) {
            for (TestNode child : node.getChildren()) {
                this.runMultiTest(child);
            }
        }
        return true;
    }

    private synchronized void calculateMultiResult(Test test) {
        Params multiParams = this.multiResCont.getParams();
        multiParams.put("-loop", (Object)(multiParams.get("-loop", 0) + test.getParams().get("-loop", 1)));
        this.multiResCont.addTestsTotalTime(test.getTestsTotalTime());
        this.multiResCont.addSuccessfulTotalTime(test.getSuccessfulTotalTime());
        this.multiResCont.addTestsOK(test.getTestsOK());
        this.multiResCont.addTestsErr(test.getTestsErr());
        if (this.output_history) {
            this.multiResCont.getHistory().addAll(test.getHistory());
        }
        this.multiResCont.setResult(this.multiResCont.getTestsOK() > this.multiResCont.getTestsErr());
    }

    private void calculateResult(Test test) throws IOException {
        this.debugResult(test);
        if (!test.getParams().containsKey("-no-record")) {
            this.filterResult(test);
        }
    }

    private void debugResult(Test test) {
        if (test.getResult()) {
            TestUtil.debug("success,  ", true);
        } else {
            TestUtil.debug("FAILURE,  " + (test.debug_on_error ? "(" + test.getErrorMsg() + "),  " : ""), true);
        }
        if (test.getTestsOK() > 0) {
            int loop = test.getParams().get("-loop", 1);
            if (loop > 1) {
                TestUtil.debug("Total: " + test.getTestsTotalTime() + "ms, Average: " + test.getSuccessfulTotalTime() / (long)test.getTestsOK() + "ms, Loop: " + loop + ", OK: " + test.getTestsOK() + "\n", true);
            } else {
                TestUtil.debug("Total: " + test.getTestsTotalTime() + "ms\n", true);
            }
        } else {
            TestUtil.debug("Total: " + test.getTestsTotalTime() + "ms\n", true);
        }
    }

    private void filterResult(Test test) throws IOException {
        String test_result = null;
        test_result = test.getResult() ? "success" : "FAILURE";
        String hist_file = test.getName().replace(' ', '_') + ".xml";
        if (this.output_history) {
            this.saveHistory(test, new File(this.dir_name, hist_file));
        }
        long average = test.getTestsOK() > 0 ? test.getSuccessfulTotalTime() / (long)test.getTestsOK() : 0L;
        switch (this.output_cols) {
            case 7: {
                this.filter.addRow(test.getName(), "<b>" + test_result + "</b>", "" + test.getTestsTotalTime() / 1000L + " sec", "" + test.getTestsOK(), "<b>" + average + "</b> ms", test.getDescription(), "<a href='" + hist_file + "'>" + test.getName() + "</a>");
                break;
            }
            case 6: {
                this.filter.addRow(test.getName(), "<b>" + test_result + "</b>", "" + test.getTestsTotalTime() / 1000L + " sec", "" + test.getTestsOK(), "<b>" + average + "</b> ms", test.getDescription());
                break;
            }
            case 5: {
                this.filter.addRow(test.getName(), "<b>" + test_result + "</b>", "<b>" + test.getTestsTotalTime() + "</b> ms", test.getDescription(), "<a href='" + hist_file + "'>" + test.getName() + "</a>");
                break;
            }
            default: {
                this.filter.addRow(test.getName(), "<b>" + test_result + "</b>", "" + test.getTestsTotalTime() + " ms", test.getDescription());
            }
        }
    }

    private OutputFilter initOutputFilter() throws IOException {
        OutputFilter filter = null;
        if (this.params.get("-output-format") != null && this.params.get("-output-format", "html").equals("html")) {
            File file_name = new File(this.params.get("-output-file", "functional-tests.html"));
            this.dir_name = file_name.getAbsoluteFile().getParentFile();
            BufferedWriter bw = new BufferedWriter(new FileWriter(file_name, false));
            filter = new HTMLFilter();
            filter.init(bw, this.params.get("-title", ""), this.getDescription());
            Map<String, String> ver_map = this.getVersion();
            if (ver_map != null && ver_map.size() > 0) {
                filter.addContent("   <h3>Server version info:</h3>\n");
                filter.addContent("   <table width=\"800\">\n");
                filter.addContent("    <tr valign=\"top\"><td width=\"15%\">Name:</td><td width=\"3%\">&nbsp;</td><td width=\"2%\">&nbsp;</td><td width=\"80%\"><b>" + ver_map.get("Name") + "</b></td></tr>\n");
                filter.addContent("    <tr valign=\"top\"><td width=\"15%\">Version:</td><td width=\"3%\">&nbsp;</td><td width=\"2%\">&nbsp;</td><td width=\"80%\"><b>" + ver_map.get("Version") + "</b></td></tr>\n");
                filter.addContent("    <tr valign=\"top\"><td width=\"15%\">OS:</td><td width=\"3%\">&nbsp;</td><td width=\"2%\">&nbsp;</td><td width=\"80%\"><b>" + ver_map.get("OS") + "</b></td></tr>\n");
                filter.addContent("    <tr valign=\"top\"><td width=\"15%\">&nbsp;</td><td width=\"3%\">&nbsp;</td><td width=\"2%\">&nbsp;</td><td width=\"80%\">&nbsp;</td></tr>\n");
                filter.addContent("    <tr valign=\"top\"><td width=\"15%\">Local IP:</td><td width=\"3%\">&nbsp;</td><td width=\"2%\">&nbsp;</td><td width=\"80%\"><b>" + ver_map.get("Local IP") + "</b></td></tr>\n");
                filter.addContent("    <tr valign=\"top\"><td width=\"15%\">Remote IP:</td><td width=\"3%\">&nbsp;</td><td width=\"2%\">&nbsp;</td><td width=\"80%\"><b>" + ver_map.get("Remote IP") + "</b></td></tr>\n");
                filter.addContent("   </table>\n");
            }
            List<StatItem> stat_list = this.getConfiguration();
            filter.addContent(this.outputStatistics(stat_list, "before"));
            filter.addContent("   <h3>Tests results:</h3>\n");
            this.output_cols = this.params.get("-output-cols", 5);
            this.output_history = this.params.get("-output-history", true);
            if (!this.output_history) {
                --this.output_cols;
            }
            switch (this.output_cols) {
                case 7: {
                    filter.setColumnHeaders("Test name", "Result", "Total time", "OK", "Average", "Description", "History");
                    break;
                }
                case 6: {
                    filter.setColumnHeaders("Test name", "Result", "Total time", "OK", "Average", "Description");
                    break;
                }
                case 5: {
                    filter.setColumnHeaders("Test name", "Result", "Test time", "Description", "History");
                    break;
                }
                default: {
                    filter.setColumnHeaders("Test name", "Result", "Test time", "Description");
                    break;
                }
            }
        } else {
            filter = new NullFilter();
        }
        return filter;
    }

    private void closeFilter(OutputFilter filter) throws IOException {
        filter.close(this.outputStatistics(this.getStatistics(), "after"));
    }

    private Map<String, String> getVersion() {
        TestNode node = this.getTestNode("Version");
        if (node != null) {
            node.addGlobalPars(this.params.getMap());
            node.addGlobalVars(this.parser.getGlobalVars());
            Test tmp_test = new Test(node);
            tmp_test.runTest();
            return (Map)tmp_test.getParams().get("Version");
        }
        return null;
    }

    private String outputStatistics(List<StatItem> stats, String when) {
        StringBuilder sb = new StringBuilder();
        if (stats != null && stats.size() > 0) {
            if (when.equals("before")) {
                sb.append("      <h3>Server basic configuration parameters:</h3>\n");
            } else {
                sb.append("      <h3>Server stats " + when + " test:</h3>\n");
            }
            sb.append("   <table width=\"800\">\n");
            for (StatItem item : stats) {
                if (item.getDescription().equals("Note")) continue;
                sb.append("    <tr valign=\"top\"><td width=\"20%\">" + item.getName() + ":</td>" + "<td width=\"20%\">" + item.getDescription() + "</td>" + "<td width=\"2%\">&nbsp;</td>" + "<td width=\"58%\"><b>" + item.getValue() + "</b></td></tr>\n");
            }
            sb.append("   </table>\n");
            sb.append("  </p>\n");
        }
        return sb.toString();
    }

    private List<StatItem> getStatistics() {
        TestNode node = this.getTestNode("Statistics");
        if (node != null) {
            node.addGlobalPars(this.params.getMap());
            node.addGlobalVars(this.parser.getGlobalVars());
            Test tmp_test = new Test(node);
            tmp_test.runTest();
            return (List)tmp_test.getParams().get("Statistics");
        }
        return null;
    }

    private List<StatItem> getConfiguration() {
        TestNode node = this.getTestNode("Configuration");
        if (node != null) {
            node.addGlobalPars(this.params.getMap());
            node.addGlobalVars(this.parser.getGlobalVars());
            Test tmp_test = new Test(node);
            tmp_test.runTest();
            return (List)tmp_test.getParams().get("Configuration");
        }
        return null;
    }

    private TestNode getTestNode(String testName) {
        for (TestNode node : this.testNodes) {
            if (!testName.equalsIgnoreCase(node.getName())) continue;
            return node;
        }
        return null;
    }

    private String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("<b>\n");
        sb.append("   <ol>\n");
        for (TestNode node : this.testNodes) {
            String descr = node.getLongDescr();
            sb.append("    <li>" + descr.substring(2, descr.length() - 2) + "</li>\n");
        }
        sb.append("   </ol>\n");
        sb.append("  </b>\n");
        return sb.toString();
    }

    private void saveHistory(Test test, File file_name) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(file_name, false));
        for (HistoryEntry entry : test.getHistory()) {
            bw.write(entry.toString() + "\n");
        }
        bw.close();
    }

    private String getDescription(TestNode node) {
        String descr = node.getShortDescr();
        if (descr == null || descr.trim().equals("")) {
            String ldescr = node.getLongDescr();
            descr = ldescr.substring(2, ldescr.length() - 2);
        }
        return descr;
    }

    private class ThreadTest
    implements Runnable {
        private Test test = null;

        public ThreadTest(Test test) {
            TestScriptLoader.this.jobContr.threadStarted();
            this.test = test;
        }

        @Override
        public void run() {
            this.test.runTest();
            try {
                TestScriptLoader.this.calculateMultiResult(this.test);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            TestScriptLoader.this.jobContr.threadDone();
        }
    }

    private class JobControll {
        private int running = 0;
        private Lock lock = new ReentrantLock();
        private Condition done = this.lock.newCondition();

        private JobControll() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean allDone(long sleep) throws InterruptedException {
            this.lock.lock();
            try {
                if (sleep > 0L) {
                    Thread.sleep(sleep);
                }
                while (this.running > 0) {
                    this.done.await();
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void threadStarted() {
            this.lock.lock();
            try {
                ++this.running;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void threadDone() {
            this.lock.lock();
            try {
                --this.running;
                if (this.running <= 0) {
                    this.done.signal();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

