/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats.collector.provider;

import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.stats.collector.ElementSigner;
import tigase.stats.collector.SignatureException;
import tigase.stats.collector.StatisticsData;
import tigase.stats.collector.provider.StatisticsUploader;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.BareJID;

public class Main {
    private static final StatisticsUploader uploader = new StatisticsUploader(new ElementSigner(){

        public Element sign(Element elmnt) {
            return elmnt;
        }

        public Element verify(Element elmnt) throws SignatureException {
            System.out.println("verifying element = " + elmnt.toString());
            if (elmnt.getName() != "result") {
                throw new SignatureException("Incorrect result type");
            }
            return elmnt;
        }
    });

    public static void main(String[] argv) throws TigaseStringprepException {
        StatisticsData data = new StatisticsData(BareJID.bareJIDInstance((String)"example.com"));
        data.addVHost(BareJID.bareJIDInstance((String)"test1.com"));
        data.addVHost(BareJID.bareJIDInstance((String)"test2.com"));
        data.setUptime(10000L);
        data.setHeapUsed(0xA00000L);
        data.setHeapMax(0x6400000L);
        data.setClusterNodesCount(4);
        data.setUsersOnline(1000L);
        data.setUsersActive(100L);
        uploader.upload(data, new StatisticsUploader.ResultCallback(){

            @Override
            public void onSuccess(Element result) {
                System.out.println("statistics uploaded = " + (result != null ? result.toString() : null));
                System.exit(0);
            }

            @Override
            public void onFailure(Exception ex) {
                System.out.println("could not upload statistics");
                System.exit(0);
            }
        });
        try {
            Thread.sleep(600000L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

