/*
 * Tigase Stats Collector library - Tigase Stats Collector library-library
 * Copyright (C) 2013 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package tigase.stats.collector;

import org.junit.Assert;
import org.junit.Test;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.*;
import tigase.xmpp.jid.BareJID;

import javax.crypto.spec.SecretKeySpec;
import java.util.Queue;

import static org.junit.Assert.*;

/**
 * @author andrzej
 */
public class StatisticsDataTest {

	protected static final SimpleParser parser = SingletonFactory.getParserInstance();

	@Test
	public void testAdditionalDataTransfer() throws TigaseStringprepException {
		String additionalData = "some additional data to transfer to destination";

		StatisticsData src = new StatisticsData(BareJID.bareJIDInstance("example.com"));
		src.setAdditionalData(additionalData);

		src.addVHost(BareJID.bareJIDInstance("example.com"));
		src.setHeapMax(100);
		src.setHeapUsed(100);
		src.setUptime(100);
		src.setUsersActive(0);
		src.setUsersOnline(10);
		src.setClusterNodesCount(1);

		String data = src.toElement().toString();
		DomBuilderHandler domHandler = new DomBuilderHandler();
		parser.parse(domHandler, data.toCharArray(), 0, data.length());

		Element parsedEl = domHandler.getParsedElements().poll();
		StatisticsData dst = StatisticsData.fromElement(parsedEl);
		assertEquals(additionalData, dst.getAdditionalData());
	}

	@Test
	public void testInvalidVHost() throws TigaseStringprepException, SignatureException {
		String payload = "<signature ver=\"1\"><timestamp>1633605707843</timestamp><object><statistics version=\"1\"><domain>imac-andrzej</domain><timestamp>2021-10-07T13:21:47.573+0200</timestamp><vhosts><item>[test-domain.com]</item><item>a.localhost</item><item>b.localhost</item><item>default</item><item>localhost</item><item>test-domain.com</item></vhosts><uptime>188923</uptime><heap><used>131844864</used><max>32178700288</max></heap><cluster><nodes_count>1</nodes_count></cluster><users><online>1</online><active>1</active><max_today>2</max_today><max_yesterday>0</max_yesterday></users><additional_data>xyz</additional_data></statistics></object><signaturevalue>f2Zbc6gDgV7lldSD/fH9PEke8Tqr82WJSTI4PTXCUUU=</signaturevalue></signature>";

		DomBuilderHandler handler = new DomBuilderHandler();
		parser.parse(handler, payload.toCharArray(), 0, payload.length());
		final Queue<Element> parsedElements = handler.getParsedElements();
		assertFalse(parsedElements.isEmpty());
		final Element elementSigned = parsedElements.poll();
		Element elem = elementSigned.getChild("object", null).getChildren().get(0);

		StatisticsData dst = StatisticsData.fromElement(elem);
		assertTrue(dst.getVHosts().contains(BareJID.bareJIDInstance("test-domain.com")));
	}

	@Test
	public void testInvalidVHostList() throws TigaseStringprepException, SignatureException {
		String payload = "<signature ver=\"1\"><timestamp>1637308969214</timestamp><object><statistics version=\"1\"><domain>tigase1</domain><timestamp>2021-11-19T16:02:49.175+0800</timestamp><vhosts><item>[tigase1, tigase2]</item><item>tigase1</item><item>tigase2</item></vhosts><uptime>486896</uptime><heap><used>84437824</used><max>5502926848</max></heap><cluster><nodes_count>2</nodes_count></cluster><users><online>1</online><active>1</active><max_today>2</max_today><max_yesterday>0</max_yesterday></users><additional_data>xyz</additional_data></statistics></object><signaturevalue>sJFQ8EUAZUNGQKEZTIgWqF1D9yNnssEvV2pcFulL9KA=</signaturevalue></signature>";

		DomBuilderHandler handler = new DomBuilderHandler();
		parser.parse(handler, payload.toCharArray(), 0, payload.length());
		final Queue<Element> parsedElements = handler.getParsedElements();
		assertFalse(parsedElements.isEmpty());
		final Element elementSigned = parsedElements.poll();
		Element elem = elementSigned.getChild("object", null).getChildren().get(0);

		StatisticsData dst = StatisticsData.fromElement(elem);
		assertTrue(dst.getVHosts().contains(BareJID.bareJIDInstance("tigase1")));
		assertTrue(dst.getVHosts().contains(BareJID.bareJIDInstance("tigase2")));
	}

	@Test
	public void testTestAdditionalDataExtraction() throws TigaseStringprepException, SignatureException {

		String payload = "<statistics version=\"1\"><domain>atlantiscity.local</domain><timestamp>2021-06-18T15:51:54.554+0200</timestamp><vhosts><item>atlantiscity</item><item>default</item></vhosts><uptime>69691</uptime><heap><used>182560448</used><max>4294967296</max></heap><cluster><nodes_count>1</nodes_count></cluster><users><online>1</online><active>0</active><max_today>2</max_today><max_yesterday>0</max_yesterday></users><additional_data>&lt;installation-id&gt;1A9ENK95xxxxxxxxxxxxxxxxxxM3P12TB&lt;/installation-id&gt;&lt;components&gt;&lt;cmpInfo&gt;&lt;name&gt;upload&lt;/name&gt;&lt;title&gt;Tigase HTTP API component&lt;/title&gt;&lt;version&gt;2.2.0-SNAPSHOT-b368/b954b466-8.2.0-SNAPSHOT-b5828/5b90e20b&lt;/version&gt;&lt;class&gt;tigase.http.upload.FileUploadComponent&lt;/class&gt;&lt;/cmpInfo&gt;&lt;cmpInfo&gt;&lt;name&gt;cl-comp&lt;/name&gt;&lt;title&gt;Tigase XMPP Server&lt;/title&gt;&lt;version&gt;8.2.0-SNAPSHOT-b5828/5b90e20b&lt;/version&gt;&lt;class&gt;tigase.cluster.ClusterConnectionManager&lt;/class&gt;&lt;/cmpInfo&gt;&lt;cmpInfo&gt;&lt;name&gt;ext-disco&lt;/name&gt;&lt;title&gt;Tigase XMPP Server&lt;/title&gt;&lt;version&gt;8.2.0-SNAPSHOT-b5828/5b90e20b&lt;/version&gt;&lt;class&gt;tigase.server.extdisco.ExternalServiceDiscoveryComponent&lt;/class&gt;&lt;/cmpInfo&gt;&lt;cmpInfo&gt;&lt;name&gt;sess-man&lt;/name&gt;&lt;title&gt;Tigase XMPP Server&lt;/title&gt;&lt;version&gt;8.2.0-SNAPSHOT-b5828/5b90e20b&lt;/version&gt;&lt;class&gt;tigase.cluster.SessionManagerClustered&lt;/class&gt;&lt;cmpData&gt;&lt;ClusteringStrategy&gt;class tigase.server.cluster.strategy.OnlineUsersCachingStrategy&lt;/ClusteringStrategy&gt;&lt;/cmpData&gt;&lt;/cmpInfo&gt;&lt;cmpInfo&gt;&lt;name&gt;pubsub&lt;/name&gt;&lt;title&gt;Tigase ACS - PubSub Component&lt;/title&gt;&lt;version&gt;3.0.0-SNAPSHOT-b153/9dad8da7-5.0.0-SNAPSHOT-b791/c645fc1b&lt;/version&gt;&lt;class&gt;tigase.pubsub.cluster.PubSubComponentClustered&lt;/class&gt;&lt;cmpData&gt;&lt;PubSubClusteringStrategy&gt;class tigase.pubsub.cluster.PartitionedStrategy&lt;/PubSubClusteringStrategy&gt;&lt;/cmpData&gt;&lt;/cmpInfo&gt;&lt;cmpInfo&gt;&lt;name&gt;c2s&lt;/name&gt;&lt;title&gt;Tigase XMPP Server&lt;/title&gt;&lt;version&gt;8.2.0-SNAPSHOT-b5828/5b90e20b&lt;/version&gt;&lt;class&gt;tigase.cluster.ClientConnectionClustered&lt;/class&gt;&lt;/cmpInfo&gt;&lt;cmpInfo&gt;&lt;name&gt;s2s&lt;/name&gt;&lt;title&gt;Tigase XMPP Server&lt;/title&gt;&lt;version&gt;8.2.0-SNAPSHOT-b5828/5b90e20b&lt;/version&gt;&lt;class&gt;tigase.server.xmppserver.S2SConnectionManager&lt;/class&gt;&lt;/cmpInfo&gt;&lt;cmpInfo&gt;&lt;name&gt;eventbus&lt;/name&gt;&lt;title&gt;Tigase XMPP Server&lt;/title&gt;&lt;version&gt;8.2.0-SNAPSHOT-b5828/5b90e20b&lt;/version&gt;&lt;class&gt;tigase.eventbus.component.EventBusComponent&lt;/class&gt;&lt;/cmpInfo&gt;&lt;cmpInfo&gt;&lt;name&gt;http&lt;/name&gt;&lt;title&gt;Tigase HTTP API component&lt;/title&gt;&lt;version&gt;2.2.0-SNAPSHOT-b368/b954b466-8.2.0-SNAPSHOT-b5828/5b90e20b&lt;/version&gt;&lt;class&gt;tigase.http.HttpMessageReceiver&lt;/class&gt;&lt;/cmpInfo&gt;&lt;cmpInfo&gt;&lt;name&gt;muc&lt;/name&gt;&lt;title&gt;Tigase ACS - MUC Component&lt;/title&gt;&lt;version&gt;2.2.0-SNAPSHOT-b140/edf5724e-3.2.0-SNAPSHOT-b660/0ef2278a&lt;/version&gt;&lt;class&gt;tigase.muc.cluster.MUCComponentClustered&lt;/class&gt;&lt;cmpData&gt;&lt;MUCClusteringStrategy&gt;class tigase.muc.cluster.ShardingStrategy&lt;/MUCClusteringStrategy&gt;&lt;/cmpData&gt;&lt;/cmpInfo&gt;&lt;cmpInfo&gt;&lt;name&gt;message-archive&lt;/name&gt;&lt;title&gt;Tigase Message Archiving Component&lt;/title&gt;&lt;version&gt;3.0.0-SNAPSHOT-b301/3c299087-8.2.0-SNAPSHOT-b5828/5b90e20b&lt;/version&gt;&lt;class&gt;tigase.archive.MessageArchiveComponent&lt;/class&gt;&lt;/cmpInfo&gt;&lt;cmpInfo&gt;&lt;name&gt;amp&lt;/name&gt;&lt;title&gt;Tigase XMPP Server&lt;/title&gt;&lt;version&gt;8.2.0-SNAPSHOT-b5828/5b90e20b&lt;/version&gt;&lt;class&gt;tigase.cluster.AmpComponentClustered&lt;/class&gt;&lt;/cmpInfo&gt;&lt;cmpInfo&gt;&lt;name&gt;bosh&lt;/name&gt;&lt;title&gt;Tigase XMPP Server&lt;/title&gt;&lt;version&gt;8.2.0-SNAPSHOT-b5828/5b90e20b&lt;/version&gt;&lt;class&gt;tigase.cluster.BoshConnectionClustered&lt;/class&gt;&lt;/cmpInfo&gt;&lt;cmpInfo&gt;&lt;name&gt;mix&lt;/name&gt;&lt;class&gt;tigase.mix.cluster.MixComponentClustered&lt;/class&gt;&lt;cmpData&gt;&lt;MixClusteringStrategy&gt;class tigase.mix.cluster.ClusteredChannelsStrategy&lt;/MixClusteringStrategy&gt;&lt;/cmpData&gt;&lt;/cmpInfo&gt;&lt;cmpInfo&gt;&lt;name&gt;someTestComponent&lt;/name&gt;&lt;class&gt;tigase.SomeTestComponent&lt;/class&gt;&lt;/cmpInfo&gt;&lt;cmpInfo&gt;&lt;name&gt;ws2s&lt;/name&gt;&lt;title&gt;Tigase XMPP Server&lt;/title&gt;&lt;version&gt;8.2.0-SNAPSHOT-b5828/5b90e20b&lt;/version&gt;&lt;class&gt;tigase.cluster.WebSocketClientConnectionClustered&lt;/class&gt;&lt;/cmpInfo&gt;&lt;cmpInfo&gt;&lt;name&gt;monitor&lt;/name&gt;&lt;title&gt;Tigase XMPP Server&lt;/title&gt;&lt;version&gt;8.2.0-SNAPSHOT-b5828/5b90e20b&lt;/version&gt;&lt;class&gt;tigase.monitor.MonitorComponent&lt;/class&gt;&lt;/cmpInfo&gt;&lt;cmpInfo&gt;&lt;name&gt;message-router&lt;/name&gt;&lt;title&gt;Tigase XMPP Server&lt;/title&gt;&lt;version&gt;8.2.0-SNAPSHOT-b5828/5b90e20b&lt;/version&gt;&lt;class&gt;tigase.server.MessageRouter&lt;/class&gt;&lt;/cmpInfo&gt;&lt;cmpInfo&gt;&lt;name&gt;stats&lt;/name&gt;&lt;title&gt;Tigase XMPP Server&lt;/title&gt;&lt;version&gt;8.2.0-SNAPSHOT-b5828/5b90e20b&lt;/version&gt;&lt;class&gt;tigase.stats.StatisticsCollector&lt;/class&gt;&lt;/cmpInfo&gt;&lt;cmpInfo&gt;&lt;name&gt;cluster-contr&lt;/name&gt;&lt;title&gt;Tigase XMPP Server&lt;/title&gt;&lt;version&gt;8.2.0-SNAPSHOT-b5828/5b90e20b&lt;/version&gt;&lt;class&gt;tigase.cluster.ClusterController&lt;/class&gt;&lt;/cmpInfo&gt;&lt;cmpInfo&gt;&lt;name&gt;vhost-man&lt;/name&gt;&lt;title&gt;Tigase XMPP Server&lt;/title&gt;&lt;version&gt;8.2.0-SNAPSHOT-b5828/5b90e20b&lt;/version&gt;&lt;class&gt;tigase.vhosts.VHostManager&lt;/class&gt;&lt;/cmpInfo&gt;&lt;/components&gt;&lt;unlicensed-components/&gt;</additional_data></statistics>";

		DomBuilderHandler handler = new DomBuilderHandler();
		parser.parse(handler, payload.toCharArray(), 0, payload.length());
		final Queue<Element> parsedElements = handler.getParsedElements();
		assertFalse(parsedElements.isEmpty());
		Element elem = parsedElements.poll();

		StatisticsData dst = StatisticsData.fromElement(elem);
		assertEquals("1A9ENK95xxxxxxxxxxxxxxxxxxM3P12TB", dst.getInstallation_id());
		assertEquals("8.2.0-SNAPSHOT-b5828/5b90e20b", dst.getInstallation_version());
	}

}
