/*
 * Tigase Stats Collector library - Tigase Stats Collector library-library
 * Copyright (C) 2013 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.stats.collector;

import org.junit.Assert;
import org.junit.Test;
import tigase.stats.collector.DefaultElementSigner.BufferWriter;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;

import javax.crypto.spec.SecretKeySpec;
import java.security.Key;
import java.util.Queue;

public class DefaultElementSignerTest {

	protected static final SimpleParser parser = SingletonFactory.getParserInstance();

	@Test
	public void testElementToBuffer1() {
		String t = "" + System.currentTimeMillis();
		Element ss = new Element("jeden");
		ss.addAttribute("to", "afsd");
		ss.addAttribute("from", "forv");

		Element ss1 = new Element("koloro", "peolb");
		ss1.addAttribute("from", "jid@to");
		ss1.setAttribute("v", "" + t);
		ss1.addAttribute("to", "sdgfsdgwdf");
		ss.addChild(ss1);

		final StringBuilder buffer = new StringBuilder();
		DefaultElementSigner s = new DefaultElementSigner((Key) null);
		s.elementToBuffer(new BufferWriter() {

			@Override
			public void append(CharSequence t) {
				buffer.append(t);
			}
		}, ss);

		Assert.assertEquals("<jeden from=\"forv\" to=\"afsd\"><koloro from=\"jid@to\" to=\"sdgfsdgwdf\" v=\"" + t +
									"\">peolb</koloro></jeden>", buffer.toString());
	}

	@Test
	public void testElementToBuffer2() {
		String t = "" + System.currentTimeMillis();
		Element ss = new Element("jeden");
		ss.addAttribute("to", "afsd");
		ss.addAttribute("from", "forv");

		final StringBuilder buffer = new StringBuilder();
		DefaultElementSigner s = new DefaultElementSigner((Key) null);
		s.elementToBuffer(new BufferWriter() {

			@Override
			public void append(CharSequence t) {
				buffer.append(t);
			}
		}, ss);

		Assert.assertEquals("<jeden from=\"forv\" to=\"afsd\"/>", buffer.toString());
	}

	@Test
	public void testElementToBuffer3() {
		String t = "" + System.currentTimeMillis();
		Element ss = new Element("jeden", "dwa");
		ss.addAttribute("to", "afsd");
		ss.addAttribute("from", "forv");

		final StringBuilder buffer = new StringBuilder();
		DefaultElementSigner s = new DefaultElementSigner((Key) null);
		s.elementToBuffer(new BufferWriter() {

			@Override
			public void append(CharSequence t) {
				buffer.append(t);
			}
		}, ss);

		Assert.assertEquals("<jeden from=\"forv\" to=\"afsd\">dwa</jeden>", buffer.toString());
	}

	@Test
	public void testSign1() {
		String t = "111";
		Element ss = new Element("jeden");
		ss.addAttribute("to", "afsd");
		ss.addAttribute("from", "forv");

		SecretKeySpec key = new SecretKeySpec("0000".getBytes(), "HmacSHA1");
		DefaultElementSigner s = new DefaultElementSigner(key);

		Element signed = s.sign(ss, t);
		final StringBuilder buffer = new StringBuilder();
		s.elementToBuffer(new BufferWriter() {

			@Override
			public void append(CharSequence t) {
				buffer.append(t);
			}
		}, signed);

		String exp = "<signature ver=\"1\"><timestamp>111</timestamp><object><jeden from=\"forv\" to=\"afsd\"/></object><signaturevalue>bKcv4Ul3kxnXTzssr1x1R4of+TeDM3ymiKcE821zv1c=</signaturevalue></signature>";
		Assert.assertEquals(exp, buffer.toString());
	}

	@Test
	public void testVerify() {
		Element ss = new Element("jeden");
		ss.addAttribute("to", "afsd");
		ss.addAttribute("from", "forv");

		DefaultElementSigner signer = new DefaultElementSigner("0000".getBytes());
		Element signed = signer.sign(ss);

		try {
			Element m = signer.verify(signed);

			Assert.assertEquals(ss, m);
		} catch (Exception e) {
			Assert.fail(e.getMessage());
		}

	}

	@Test
	public void testVerify1() {
		String originalMessage = "<signature ver=\"1\"><timestamp>111</timestamp><object><jeden from=\"forv\" to=\"afsd\"/></object><signaturevalue>bKcv4Ul3kxnXTzssr1x1R4of+TeDM3ymiKcE821zv1c=</signaturevalue></signature>";

		DomBuilderHandler domHandler = new DomBuilderHandler();
		parser.parse(domHandler, originalMessage.toCharArray(), 0, originalMessage.length());
		Queue<Element> queue = domHandler.getParsedElements();

		Element signed = queue.poll();

		DefaultElementSigner signer = new DefaultElementSigner("0000".getBytes());

		try {
			signer.verify(signed);
		} catch (Exception e) {
			Assert.fail(e.getMessage());
		}

	}

	@Test
	public void testVerifyFail() {
		String originalMessage = "<signature ver=\"1\"><timestamp>111</timestamp><object><jeden from=\"forv\" to=\"afsd\"/></object><signaturevalue>___</signaturevalue></signature>";

		DomBuilderHandler domHandler = new DomBuilderHandler();
		parser.parse(domHandler, originalMessage.toCharArray(), 0, originalMessage.length());
		Queue<Element> queue = domHandler.getParsedElements();

		Element signed = queue.poll();

		DefaultElementSigner signer = new DefaultElementSigner("0000".getBytes());

		try {
			signer.verify(signed);
			Assert.fail();
		} catch (SignatureException e) {
		} catch (Exception e) {
			Assert.fail();
		}

	}
}
