/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats.collector;

import org.junit.Assert;
import org.junit.Test;
import tigase.stats.collector.StatisticsData;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.jid.BareJID;

public class StatisticsDataTest {
    protected static final SimpleParser parser = SingletonFactory.getParserInstance();

    @Test
    public void testAdditionalDataTransfer() throws TigaseStringprepException {
        String additionalData = "some additional data to transfer to destination";
        StatisticsData src = new StatisticsData(BareJID.bareJIDInstance((String)"example.com"));
        src.setAdditionalData(additionalData);
        src.addVHost(BareJID.bareJIDInstance((String)"example.com"));
        src.setHeapMax(100L);
        src.setHeapUsed(100L);
        src.setUptime(100L);
        src.setUsersActive(0L);
        src.setUsersOnline(10L);
        src.setClusterNodesCount(1);
        String data = src.toElement().toString();
        DomBuilderHandler domHandler = new DomBuilderHandler();
        parser.parse((SimpleHandler)domHandler, data.toCharArray(), 0, data.length());
        Element parsedEl = (Element)domHandler.getParsedElements().poll();
        StatisticsData dst = StatisticsData.fromElement((Element)parsedEl);
        Assert.assertEquals((Object)additionalData, (Object)dst.getAdditionalData());
    }
}

