/*
 * Decompiled with CFR 0.152.
 */
package tigase.spam.filters;

import java.util.ArrayDeque;
import java.util.logging.Level;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import tigase.server.Packet;
import tigase.spam.filters.MessageFilterSameLongBody;
import tigase.stats.StatisticsList;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

@Ignore
public class MessageFilterSameLongBodyTest {
    public static final String SPAM_MESSAGE = "Here we need some long and ugly spam message!";

    @Test
    public void testSkipOpenPGP() throws TigaseStringprepException {
        MessageFilterSameLongBody filter = new MessageFilterSameLongBody();
        Packet packet = this.createSpamMessage();
        packet.getElement().addChild((XMLNodeIfc)new Element("openpgp", new String[]{"xmlns"}, new String[]{"urn:xmpp:openpgp:0"}));
        Assert.assertTrue((boolean)filter.shouldSkipBodyCheck(packet));
    }

    @Test
    public void testSkipFallback() throws TigaseStringprepException {
        MessageFilterSameLongBody filter = new MessageFilterSameLongBody();
        Packet packet = this.createSpamMessage();
        packet.getElement().addChild((XMLNodeIfc)new Element("fallback", new String[]{"xmlns"}, new String[]{"urn:xmpp:fallback:0"}));
        Assert.assertTrue((boolean)filter.shouldSkipBodyCheck(packet));
    }

    @Test
    public void testSkipOMEMO_old() throws TigaseStringprepException {
        MessageFilterSameLongBody filter = new MessageFilterSameLongBody();
        Packet packet = this.createSpamMessage();
        packet.getElement().addChild((XMLNodeIfc)new Element("encrypted", new String[]{"xmlns"}, new String[]{"eu.siacs.conversations.axolotl"}));
        Assert.assertTrue((boolean)filter.shouldSkipBodyCheck(packet));
    }

    @Test
    public void testSkipOMEMO_new() throws TigaseStringprepException {
        MessageFilterSameLongBody filter = new MessageFilterSameLongBody();
        Packet packet = this.createSpamMessage();
        packet.getElement().addChild((XMLNodeIfc)new Element("encrypted", new String[]{"xmlns"}, new String[]{"urn:xmpp:omemo:1"}));
        Assert.assertTrue((boolean)filter.shouldSkipBodyCheck(packet));
    }

    @Test
    public void testNoSkip() throws TigaseStringprepException {
        MessageFilterSameLongBody filter = new MessageFilterSameLongBody();
        Packet packet = this.createSpamMessage();
        Assert.assertFalse((boolean)filter.shouldSkipBodyCheck(packet));
    }

    @Test
    public void test() throws TigaseStringprepException, InterruptedException {
        MessageFilterSameLongBody filter = new MessageFilterSameLongBody();
        long start = System.currentTimeMillis();
        this.executeTest(() -> {
            for (int i = 0; i < 50; ++i) {
                long begin = System.currentTimeMillis();
                for (int j = 0; j < 10000; ++j) {
                    try {
                        Packet spamMessage = this.createSpamMessage();
                        filter.filter(spamMessage, null);
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                StatisticsList list = new StatisticsList(Level.FINEST);
                filter.getStatistics("SPAM", list);
                if (list.getValue("SPAM", "message-same-long-body/Average processing time", 0L) != 0L) {
                    list.forEach(rec -> System.out.println(rec.toString()));
                }
                System.out.println("10000 messages in " + (System.currentTimeMillis() - begin) + "ms, " + (System.currentTimeMillis() - begin) / 10000L + " per message");
            }
        });
        System.out.println("completed in " + (System.currentTimeMillis() - start) + "ms");
    }

    public void executeTest(Runnable task) throws InterruptedException {
        ArrayDeque<Thread> threads = new ArrayDeque<Thread>();
        for (int i = 0; i < Runtime.getRuntime().availableProcessors() * 8; ++i) {
            Thread thread = new Thread(task);
            thread.start();
            threads.offer(thread);
        }
        Thread thread = null;
        while ((thread = (Thread)threads.poll()) != null) {
            thread.join();
        }
    }

    public Packet createSpamMessage() throws TigaseStringprepException {
        return Packet.packetInstance((Element)this.createSpamMessageEl());
    }

    public Element createSpamMessageEl() {
        return new Element("message", new Element[]{new Element("body", SPAM_MESSAGE)}, new String[]{"from", "to"}, new String[]{"spammer@example.com", "recipient@example.com"});
    }
}

