/*
 * Decompiled with CFR 0.152.
 */
package tigase.spam.filters;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.server.Packet;
import tigase.server.Presence;
import tigase.spam.filters.PresenceSubscribeFilter;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.ProcessorTestCase;
import tigase.xmpp.jid.JID;

public class PresenceSubscribeFilterTest
extends ProcessorTestCase {
    private PresenceSubscribeFilter filter;

    @Before
    public void initializeFilter() {
        this.filter = (PresenceSubscribeFilter)this.getKernel().getInstance(PresenceSubscribeFilter.class);
    }

    @After
    public void releaseFilter() {
        this.filter = null;
    }

    public void setupKernel() {
        super.setupKernel();
        this.getKernel().registerBean(PresenceSubscribeFilter.class).setActive(true).exec();
    }

    @Test
    public void testLocalSpammer() throws TigaseStringprepException, NotAuthorizedException {
        JID spammerJid = JID.jidInstance((String)"spammer1@example.com");
        XMPPResourceConnection session = this.getSession(spammerJid, spammerJid);
        for (int i = 0; i < 10; ++i) {
            JID targetJid = JID.jidInstance((String)UUID.randomUUID().toString(), (String)"example.com");
            Presence packet = this.createSubscriptionRequest(spammerJid, targetJid);
            Assert.assertEquals((String)("test no: " + i), (Object)(i < 5 ? 1 : 0), (Object)this.filter.filterPacket((Packet)packet, session));
        }
        this.filter.cleanUp();
        JID targetJid = JID.jidInstance((String)UUID.randomUUID().toString(), (String)"example.com");
        Presence packet = this.createSubscriptionRequest(spammerJid, targetJid);
        Assert.assertEquals((String)"test no: 11", (Object)false, (Object)this.filter.filterPacket((Packet)packet, session));
        this.cleanUpCounters();
        Assert.assertEquals((String)"test 1 after reset", (Object)true, (Object)this.filter.filterPacket((Packet)packet, session));
    }

    @Test
    public void testRemoteSpammer() throws TigaseStringprepException, NotAuthorizedException {
        JID spammerJid = JID.jidInstance((String)"spammer1@example-ext");
        for (int i = 0; i < 10; ++i) {
            JID targetJid = JID.jidInstance((String)UUID.randomUUID().toString(), (String)"example.com");
            XMPPResourceConnection session = this.getSession(targetJid, targetJid);
            Presence packet = this.createSubscriptionRequest(spammerJid, targetJid);
            Assert.assertEquals((String)("test no: " + i), (Object)(i < 5 ? 1 : 0), (Object)this.filter.filterPacket((Packet)packet, session));
        }
        this.filter.cleanUp();
        JID targetJid = JID.jidInstance((String)UUID.randomUUID().toString(), (String)"example.com");
        XMPPResourceConnection session = this.getSession(targetJid, targetJid);
        Presence packet = this.createSubscriptionRequest(spammerJid, targetJid);
        Assert.assertEquals((String)"test no: 11", (Object)false, (Object)this.filter.filterPacket((Packet)packet, session));
        this.cleanUpCounters();
        Assert.assertEquals((String)"test 1 after reset", (Object)true, (Object)this.filter.filterPacket((Packet)packet, session));
    }

    private void cleanUpCounters() {
        try {
            Field f = PresenceSubscribeFilter.class.getDeclaredField("counters");
            f.setAccessible(true);
            Map counters = (Map)f.get(this.filter);
            counters.clear();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Presence createSubscriptionRequest(JID from, JID to) {
        Presence presence = new Presence(new Element("presence", new String[]{"type"}, new String[]{StanzaType.subscribe.name()}), from, to);
        presence.setPacketFrom(from);
        return presence;
    }
}

