/*
 * Decompiled with CFR 0.152.
 */
package tigase.spam.filters;

import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Packet;
import tigase.spam.SpamProcessor;
import tigase.spam.filters.AbstractSpamFilter;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.jid.BareJID;

@Bean(name="presence-subscribe", parent=SpamProcessor.class, active=true)
public class PresenceSubscribeFilter
extends AbstractSpamFilter
implements Initializable,
UnregisterAware {
    private static final Logger log = Logger.getLogger(PresenceSubscribeFilter.class.getCanonicalName());
    protected static final String ID = "presence-subscribe";
    private final ConcurrentHashMap<BareJID, Counter> counters = new ConcurrentHashMap();
    private Timer cleanerTimer;
    @ConfigField(desc="Number of allowed subscription requests per minute", alias="limit-per-minute")
    private int numberOfAllowedRequestsPerMinute = 5;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public double getSpamProbability() {
        return 0.5;
    }

    public void initialize() {
        this.cleanerTimer = new Timer("presence-subscribe-cleanup");
        this.cleanerTimer.schedule((TimerTask)new CleanerTask(), 60000L, 60000L);
    }

    public void beforeUnregister() {
        if (this.cleanerTimer != null) {
            this.cleanerTimer.cancel();
            this.cleanerTimer = null;
        }
    }

    @Override
    protected boolean filterPacket(Packet packet, XMPPResourceConnection session) {
        try {
            if (packet.getType() == StanzaType.subscribe) {
                if (session != null && session.isAuthorized() && packet.getPacketFrom() != null && !packet.getPacketFrom().equals((Object)session.getConnectionId()) && packet.getStanzaFrom() != null && session.isLocalDomain(packet.getStanzaFrom().getDomain(), false)) {
                    return true;
                }
                if (session == null && packet.getPacketFrom() != null && "sess-man".equals(packet.getPacketFrom().getLocalpart())) {
                    return true;
                }
                BareJID from = null;
                if (packet.getStanzaFrom() != null) {
                    from = packet.getStanzaFrom().getBareJID();
                } else if (session != null) {
                    from = session.getBareJID();
                } else {
                    return true;
                }
                Counter counter = this.counters.computeIfAbsent(from, x -> new Counter());
                return counter.check(this.numberOfAllowedRequestsPerMinute);
            }
        }
        catch (NoConnectionIdException | NotAuthorizedException throwable) {
            // empty catch block
        }
        return true;
    }

    protected void cleanUp() {
        this.counters.entrySet().stream().filter(e -> ((Counter)e.getValue()).cleanUp()).forEach(e -> this.counters.remove(e.getKey(), e.getValue()));
    }

    private class CleanerTask
    extends TimerTask {
        private CleanerTask() {
        }

        @Override
        public void run() {
            try {
                PresenceSubscribeFilter.this.cleanUp();
            }
            catch (Throwable ex) {
                log.log(Level.WARNING, "Exception during cleanup of suspected SPAM message counter table", ex);
            }
        }
    }

    public static class Counter {
        protected List<Long> timestamps = new LinkedList<Long>();

        public synchronized boolean check(int limit) {
            this.timestamps.add(System.currentTimeMillis());
            this.cleanUp();
            if (this.timestamps.size() > limit) {
                while (this.timestamps.size() > limit) {
                    this.timestamps.remove(0);
                }
                return false;
            }
            return true;
        }

        public synchronized boolean cleanUp() {
            while (!this.timestamps.isEmpty() && System.currentTimeMillis() - this.timestamps.get(0) > 60000L) {
                this.timestamps.remove(0);
            }
            return this.timestamps.isEmpty();
        }
    }
}

