/*
 * Decompiled with CFR 0.152.
 */
package tigase.spam.filters;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.spam.SpamProcessor;
import tigase.spam.filters.AbstractSpamFilter;
import tigase.stats.StatisticsList;
import tigase.util.Algorithms;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;

@Bean(name="message-same-long-body", parent=SpamProcessor.class, active=true)
public class MessageFilterSameLongBody
extends AbstractSpamFilter {
    protected static final String ID = "message-same-long-body";
    private static final Logger log = Logger.getLogger(MessageFilterSameLongBody.class.getCanonicalName());
    private static final Charset CHARSET_UTF8 = Charset.forName("utf-8");
    private final AtomicBoolean cleanerRunning = new AtomicBoolean(false);
    private final ConcurrentHashMap<String, Integer> counter = new ConcurrentHashMap();
    @ConfigField(desc="Check message with body bigger that this limit", alias="body-size")
    private int longMessageSize = 100;
    @ConfigField(desc="Limit size of message counter cache", alias="counter-size-limit")
    private int messageCounterSizeLimit = 10000;
    @ConfigField(desc="Limit number of message with same body", alias="number-limit")
    private int messageNumberLimit = 20;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public double getSpamProbability() {
        return 0.4;
    }

    @Override
    public void getStatistics(String name, StatisticsList list) {
        super.getStatistics(name, list);
        if (list.checkLevel(Level.FINE)) {
            list.add(name, this.getId() + "/Cache size", this.counter.size(), Level.FINE);
        }
    }

    @Override
    protected boolean filterPacket(Packet packet, XMPPResourceConnection session) {
        if (packet.getElemName() != "message" || packet.getType() == StanzaType.groupchat) {
            return true;
        }
        try {
            String body = packet.getElemCDataStaticStr(Message.MESSAGE_BODY_PATH);
            if (body == null || body.length() <= this.longMessageSize) {
                return true;
            }
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            String hash = Algorithms.bytesToHex((byte[])md.digest(body.getBytes(CHARSET_UTF8)));
            Integer count = this.counter.compute(hash, (k, v) -> {
                if (v == null) {
                    return 1;
                }
                return v + 1;
            });
            if (this.counter.size() > this.messageCounterSizeLimit && this.cleanerRunning.compareAndSet(false, true)) {
                new CleanerTask().start();
            }
            if (count > this.messageNumberLimit) {
                if (log.isLoggable(Level.FINEST) && count < this.messageNumberLimit + 10) {
                    log.log(Level.FINEST, "Message is assumed to be spam. Already seen {0} message with body: {1}", new Object[]{count, body});
                }
                return false;
            }
        }
        catch (NoSuchAlgorithmException ex) {
            log.log(Level.WARNING, "Algorithm SHA-256 in not available!", ex);
        }
        return true;
    }

    private class CleanerTask
    extends Thread {
        public CleanerTask() {
            super("message-same-long-body-cleaner-task");
        }

        @Override
        public void run() {
            try {
                MessageFilterSameLongBody.this.counter.entrySet().stream().filter(e -> (Integer)e.getValue() < MessageFilterSameLongBody.this.messageNumberLimit).forEach(e -> MessageFilterSameLongBody.this.counter.remove(e.getKey(), e.getValue()));
            }
            catch (Throwable ex) {
                log.log(Level.WARNING, "Exception during cleanup of suspected SPAM message counter table", ex);
            }
            MessageFilterSameLongBody.this.cleanerRunning.set(false);
        }
    }
}

