/*
 * Decompiled with CFR 0.152.
 */
package tigase.socks5.repository;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.socks5.Limits;
import tigase.socks5.Socks5ConnectionType;
import tigase.socks5.repository.Socks5Repository;
import tigase.xmpp.BareJID;

public class JDBCSocks5Repository
implements Socks5Repository {
    private static final String DEF_CREATE_TRANSFER_USED_BY_CONNECTION_KEY = "create-transfer-used-by-connection";
    private static final String DEF_CREATE_TRANSFER_USED_BY_CONNECTION_QUERY = "{ call TigSocks5CreateTransferUsed(?, ?, ?) }";
    private static final String DEF_CREATE_UID_KEY = "create-uid";
    private static final String DEF_CREATE_UID_QUERY = "{ call TigSocks5CreateUid(?, ?) }";
    private static final String DEF_GET_UID_KEY = "get-uid";
    private static final String DEF_GET_UID_QUERY = "{ call TigSocks5GetUid(?) }";
    private static final String DEF_GLOBAL_SETTINGS = "socks5-global";
    private static final String DEF_TRANSFER_LIMITS_DOMAIN_KEY = "file-size-limit-domain";
    private static final String DEF_TRANSFER_LIMITS_DOMAIN_QUERY = "{ call TigSocks5GetTransferLimits(?) }";
    private static final String DEF_TRANSFER_LIMITS_GENERAL_KEY = "file-size-limit-general";
    private static final String DEF_TRANSFER_LIMITS_GENERAL_QUERY = "{ call TigSocks5GetTransferLimits(?) }";
    private static final String DEF_TRANSFER_LIMITS_USER_KEY = "file-size-limit-user";
    private static final String DEF_TRANSFER_LIMITS_USER_QUERY = "{ call TigSocks5GetTransferLimits(?) }";
    private static final String DEF_TRANSFER_USED_DOMAIN_KEY = "transfer-used-domain";
    private static final String DEF_TRANSFER_USED_DOMAIN_QUERY = "{ call TigSocks5TransferUsedDomain(?) }";
    private static final String DEF_TRANSFER_USED_GENERAL_KEY = "transfer-used-general";
    private static final String DEF_TRANSFER_USED_GENERAL_QUERY = "{ call TigSocks5TransferUsedGeneral() }";
    private static final String DEF_TRANSFER_USED_INSTANCE_KEY = "transfer-used-instance";
    private static final String DEF_TRANSFER_USED_INSTANCE_QUERY = "{ call TigSocks5TransferUsedInstance(?) }";
    private static final String DEF_TRANSFER_USED_USER_KEY = "transfer-used-user";
    private static final String DEF_TRANSFER_USED_USER_QUERY = "{ call TigSocks5TransferUsedUser(?) }";
    private static final String DEF_UPDATE_TRANSFER_USED_BY_CONNECTION_KEY = "update-transfer-used-by-connection";
    private static final String DEF_UPDATE_TRANSFER_USED_BY_CONNECTION_QUERY = "{ call TigSocks5UpdateTransferUsed(?, ?) }";
    private static final Logger log = Logger.getLogger(Socks5Repository.class.getCanonicalName());
    protected DataRepository data_repo;
    private String createTransferUsedByConnection_query = null;
    private String createUid_query = null;
    private String getUid_query = null;
    private String transferLimitsDomain_query = null;
    private String transferLimitsGeneral_query = null;
    private String transferLimitsUser_query = null;
    private String transferUsedDomain_query = null;
    private String transferUsedGeneral_query = null;
    private String transferUsedInstance_query = null;
    private String transferUsedUser_query = null;
    private String updateTransferUsedByConnection_query = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long createTransferUsedByConnection(BareJID user, Socks5ConnectionType type, BareJID instance) throws TigaseDBException {
        long connectionId = 0L;
        long uid = this.getUID(user);
        ResultSet rs = null;
        try {
            PreparedStatement createTransferUsedByConnection;
            PreparedStatement preparedStatement = createTransferUsedByConnection = this.data_repo.getPreparedStatement(null, this.createTransferUsedByConnection_query);
            synchronized (preparedStatement) {
                createTransferUsedByConnection.setLong(1, uid);
                createTransferUsedByConnection.setInt(2, type == Socks5ConnectionType.Requester ? 0 : 1);
                createTransferUsedByConnection.setString(3, instance.toString());
                rs = createTransferUsedByConnection.executeQuery();
                if (rs.next()) {
                    connectionId = rs.getLong(1);
                }
            }
        }
        catch (SQLIntegrityConstraintViolationException e) {
            try {
                throw new UserExistsException("Error while adding user to repository, user exists?", (Throwable)e);
                catch (SQLException e2) {
                    throw new TigaseDBException("Problem accessing repository.", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, rs);
                throw throwable;
            }
        }
        this.data_repo.release(null, rs);
        return connectionId;
    }

    @Override
    public void initRepository(String connectionString, Map<String, String> params) throws TigaseDBException {
        try {
            this.data_repo = RepositoryFactory.getDataRepository(null, (String)connectionString, params);
            this.createUid_query = this.getParamWithDef(params, DEF_CREATE_UID_KEY, DEF_CREATE_UID_QUERY);
            if (this.createUid_query != null) {
                this.data_repo.initPreparedStatement(this.createUid_query, this.createUid_query);
            }
            this.getUid_query = this.getParamWithDef(params, DEF_GET_UID_KEY, DEF_GET_UID_QUERY);
            if (this.getUid_query != null) {
                this.data_repo.initPreparedStatement(this.getUid_query, this.getUid_query);
            }
            this.transferLimitsGeneral_query = this.getParamWithDef(params, DEF_TRANSFER_LIMITS_GENERAL_KEY, "{ call TigSocks5GetTransferLimits(?) }");
            if (this.transferLimitsGeneral_query != null) {
                this.data_repo.initPreparedStatement(this.transferLimitsGeneral_query, this.transferLimitsGeneral_query);
            }
            this.transferLimitsDomain_query = this.getParamWithDef(params, DEF_TRANSFER_LIMITS_DOMAIN_KEY, "{ call TigSocks5GetTransferLimits(?) }");
            if (this.transferLimitsDomain_query != null) {
                this.data_repo.initPreparedStatement(this.transferLimitsDomain_query, this.transferLimitsDomain_query);
            }
            this.transferLimitsUser_query = this.getParamWithDef(params, DEF_TRANSFER_LIMITS_USER_KEY, "{ call TigSocks5GetTransferLimits(?) }");
            if (this.transferLimitsUser_query != null) {
                this.data_repo.initPreparedStatement(this.transferLimitsUser_query, this.transferLimitsUser_query);
            }
            this.transferUsedGeneral_query = this.getParamWithDef(params, DEF_TRANSFER_USED_GENERAL_KEY, DEF_TRANSFER_USED_GENERAL_QUERY);
            if (this.transferUsedGeneral_query != null) {
                this.data_repo.initPreparedStatement(this.transferUsedGeneral_query, this.transferUsedGeneral_query);
            }
            this.transferUsedInstance_query = this.getParamWithDef(params, DEF_TRANSFER_USED_INSTANCE_KEY, DEF_TRANSFER_USED_INSTANCE_QUERY);
            if (this.transferUsedInstance_query != null) {
                this.data_repo.initPreparedStatement(this.transferUsedInstance_query, this.transferUsedInstance_query);
            }
            this.transferUsedDomain_query = this.getParamWithDef(params, DEF_TRANSFER_USED_DOMAIN_KEY, DEF_TRANSFER_USED_DOMAIN_QUERY);
            if (this.transferUsedDomain_query != null) {
                this.data_repo.initPreparedStatement(this.transferUsedDomain_query, this.transferUsedDomain_query);
            }
            this.transferUsedUser_query = this.getParamWithDef(params, DEF_TRANSFER_USED_USER_KEY, DEF_TRANSFER_USED_USER_QUERY);
            if (this.transferUsedUser_query != null) {
                this.data_repo.initPreparedStatement(this.transferUsedUser_query, this.transferUsedUser_query);
            }
            this.createTransferUsedByConnection_query = this.getParamWithDef(params, DEF_CREATE_TRANSFER_USED_BY_CONNECTION_KEY, DEF_CREATE_TRANSFER_USED_BY_CONNECTION_QUERY);
            if (this.createTransferUsedByConnection_query != null) {
                this.data_repo.initPreparedStatement(this.createTransferUsedByConnection_query, this.createTransferUsedByConnection_query);
            }
            this.updateTransferUsedByConnection_query = this.getParamWithDef(params, DEF_UPDATE_TRANSFER_USED_BY_CONNECTION_KEY, DEF_UPDATE_TRANSFER_USED_BY_CONNECTION_QUERY);
            if (this.updateTransferUsedByConnection_query != null) {
                this.data_repo.initPreparedStatement(this.updateTransferUsedByConnection_query, this.updateTransferUsedByConnection_query);
            }
        }
        catch (Exception ex) {
            throw new DBInitException(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTransferUsedByConnection(long stream_id, long transferred_bytes) throws TigaseDBException {
        ResultSet rs = null;
        try {
            PreparedStatement updateTransferUsedByConnection;
            PreparedStatement preparedStatement = updateTransferUsedByConnection = this.data_repo.getPreparedStatement(null, this.updateTransferUsedByConnection_query);
            synchronized (preparedStatement) {
                updateTransferUsedByConnection.setLong(1, stream_id);
                updateTransferUsedByConnection.setLong(2, transferred_bytes);
                updateTransferUsedByConnection.executeUpdate();
            }
        }
        catch (SQLIntegrityConstraintViolationException e) {
            throw new UserExistsException("Error while adding user to repository, user exists?", (Throwable)e);
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", (Throwable)e);
        }
        finally {
            this.data_repo.release(null, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Limits getTransferLimits() throws TigaseDBException {
        Limits limits = new Limits();
        ResultSet rs = null;
        try {
            PreparedStatement transferLimitsGeneral;
            PreparedStatement preparedStatement = transferLimitsGeneral = this.data_repo.getPreparedStatement(null, this.transferLimitsGeneral_query);
            synchronized (preparedStatement) {
                transferLimitsGeneral.setString(1, DEF_GLOBAL_SETTINGS);
                rs = transferLimitsGeneral.executeQuery();
                if (rs.next()) {
                    limits.setTransferLimitPerFile(rs.getLong(1));
                    limits.setTransferLimitPerUser(rs.getLong(2));
                    limits.setTransferLimitPerDomain(rs.getLong(3));
                }
            }
        }
        catch (SQLIntegrityConstraintViolationException e) {
            try {
                throw new UserExistsException("Error while adding user to repository, user exists?", (Throwable)e);
                catch (SQLException e2) {
                    throw new TigaseDBException("Problem accessing repository.", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, rs);
                throw throwable;
            }
        }
        this.data_repo.release(null, rs);
        return limits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Limits getTransferLimits(String domain) throws TigaseDBException {
        Limits limits = new Limits();
        ResultSet rs = null;
        try {
            PreparedStatement transferLimitsDomain;
            PreparedStatement preparedStatement = transferLimitsDomain = this.data_repo.getPreparedStatement(null, this.transferLimitsDomain_query);
            synchronized (preparedStatement) {
                transferLimitsDomain.setString(1, domain);
                rs = transferLimitsDomain.executeQuery();
                if (rs.next()) {
                    limits.setTransferLimitPerFile(rs.getLong(1));
                    limits.setTransferLimitPerUser(rs.getLong(2));
                    limits.setTransferLimitPerDomain(rs.getLong(3));
                }
            }
        }
        catch (SQLIntegrityConstraintViolationException e) {
            try {
                throw new UserExistsException("Error while adding user to repository, user exists?", (Throwable)e);
                catch (SQLException e2) {
                    throw new TigaseDBException("Problem accessing repository.", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, rs);
                throw throwable;
            }
        }
        this.data_repo.release(null, rs);
        return limits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Limits getTransferLimits(BareJID user) throws TigaseDBException {
        Limits limits = new Limits();
        ResultSet rs = null;
        try {
            PreparedStatement transferLimitsUser;
            PreparedStatement preparedStatement = transferLimitsUser = this.data_repo.getPreparedStatement(null, this.transferLimitsUser_query);
            synchronized (preparedStatement) {
                transferLimitsUser.setString(1, user.toString());
                rs = transferLimitsUser.executeQuery();
                if (rs.next()) {
                    limits.setTransferLimitPerFile(rs.getLong(1));
                    limits.setTransferLimitPerUser(rs.getLong(2));
                    limits.setTransferLimitPerDomain(rs.getLong(3));
                }
            }
        }
        catch (SQLIntegrityConstraintViolationException e) {
            try {
                throw new UserExistsException("Error while adding user to repository, user exists?", (Throwable)e);
                catch (SQLException e2) {
                    throw new TigaseDBException("Problem accessing repository.", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, rs);
                throw throwable;
            }
        }
        this.data_repo.release(null, rs);
        return limits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getTransferUsed() throws TigaseDBException {
        long transferUsed = 0L;
        ResultSet rs = null;
        try {
            PreparedStatement transferUsedGeneral;
            PreparedStatement preparedStatement = transferUsedGeneral = this.data_repo.getPreparedStatement(null, this.transferUsedGeneral_query);
            synchronized (preparedStatement) {
                rs = transferUsedGeneral.executeQuery();
                if (rs.next()) {
                    transferUsed = rs.getLong(1);
                }
            }
        }
        catch (SQLIntegrityConstraintViolationException e) {
            try {
                throw new UserExistsException("Error while adding user to repository, user exists?", (Throwable)e);
                catch (SQLException e2) {
                    throw new TigaseDBException("Problem accessing repository.", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, rs);
                throw throwable;
            }
        }
        this.data_repo.release(null, rs);
        return transferUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getTransferUsedByDomain(String domain) throws TigaseDBException {
        long transferUsed = 0L;
        ResultSet rs = null;
        try {
            PreparedStatement transferUsedDomain;
            PreparedStatement preparedStatement = transferUsedDomain = this.data_repo.getPreparedStatement(null, this.transferUsedDomain_query);
            synchronized (preparedStatement) {
                transferUsedDomain.setString(1, domain);
                rs = transferUsedDomain.executeQuery();
                if (rs.next()) {
                    transferUsed = rs.getLong(1);
                }
            }
        }
        catch (SQLIntegrityConstraintViolationException e) {
            try {
                throw new UserExistsException("Error while adding user to repository, user exists?", (Throwable)e);
                catch (SQLException e2) {
                    throw new TigaseDBException("Problem accessing repository.", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, rs);
                throw throwable;
            }
        }
        this.data_repo.release(null, rs);
        return transferUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getTransferUsedByInstance(String instance) throws TigaseDBException {
        long transferUsed = 0L;
        ResultSet rs = null;
        try {
            PreparedStatement transferUsedInstance;
            PreparedStatement preparedStatement = transferUsedInstance = this.data_repo.getPreparedStatement(null, this.transferUsedInstance_query);
            synchronized (preparedStatement) {
                transferUsedInstance.setString(1, instance);
                rs = transferUsedInstance.executeQuery();
                if (rs.next()) {
                    transferUsed = rs.getLong(1);
                }
            }
        }
        catch (SQLIntegrityConstraintViolationException e) {
            try {
                throw new UserExistsException("Error while adding user to repository, user exists?", (Throwable)e);
                catch (SQLException e2) {
                    throw new TigaseDBException("Problem accessing repository.", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, rs);
                throw throwable;
            }
        }
        this.data_repo.release(null, rs);
        return transferUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getTransferUsedByUser(BareJID user) throws TigaseDBException {
        long transferUsed = 0L;
        ResultSet rs = null;
        long uid = this.getUID(user);
        try {
            PreparedStatement transferUsedUser;
            PreparedStatement preparedStatement = transferUsedUser = this.data_repo.getPreparedStatement(null, this.transferUsedUser_query);
            synchronized (preparedStatement) {
                transferUsedUser.setLong(1, uid);
                rs = transferUsedUser.executeQuery();
                if (rs.next()) {
                    transferUsed = rs.getLong(1);
                }
            }
        }
        catch (SQLIntegrityConstraintViolationException e) {
            try {
                throw new UserExistsException("Error while adding user to repository, user exists?", (Throwable)e);
                catch (SQLException e2) {
                    throw new TigaseDBException("Problem accessing repository.", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, rs);
                throw throwable;
            }
        }
        this.data_repo.release(null, rs);
        return transferUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long createUID(BareJID user) throws TigaseDBException {
        if (this.createUid_query == null) {
            return 0L;
        }
        long uid = 0L;
        ResultSet rs = null;
        try {
            PreparedStatement create_uid;
            PreparedStatement preparedStatement = create_uid = this.data_repo.getPreparedStatement(user, this.createUid_query);
            synchronized (preparedStatement) {
                create_uid.setString(1, user.toString());
                create_uid.setString(2, user.getDomain());
                rs = create_uid.executeQuery();
                if (rs.next()) {
                    uid = rs.getLong(1);
                }
            }
        }
        catch (SQLIntegrityConstraintViolationException e) {
            try {
                throw new UserExistsException("Error while adding user to repository, user exists?", (Throwable)e);
                catch (SQLException e2) {
                    throw new TigaseDBException("Problem accessing repository.", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, rs);
                throw throwable;
            }
        }
        this.data_repo.release(null, rs);
        return uid;
    }

    private String getParamWithDef(Map<String, String> params, String key, String defValue) {
        if (params == null) {
            return defValue;
        }
        String result = params.get(key);
        if (result != null) {
            log.log(Level.CONFIG, "Custom query loaded for ''{0}'': ''{1}''", new Object[]{key, result});
        } else {
            log.log(Level.CONFIG, "Default query loaded for ''{0}'': ''{1}''", new Object[]{key, defValue});
        }
        if (result != null) {
            result.trim();
            if (result.isEmpty()) {
                result = null;
            }
        }
        return result != null ? result : defValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getUID(BareJID user) throws TigaseDBException {
        ResultSet rs;
        long uid;
        block11: {
            long l;
            if (this.getUid_query == null) {
                return 0L;
            }
            uid = 0L;
            rs = null;
            try {
                PreparedStatement get_uid;
                PreparedStatement preparedStatement = get_uid = this.data_repo.getPreparedStatement(user, this.getUid_query);
                synchronized (preparedStatement) {
                    block10: {
                        get_uid.setString(1, user.toString());
                        rs = get_uid.executeQuery();
                        if (!rs.next()) break block10;
                        uid = rs.getLong(1);
                        break block11;
                    }
                    l = this.createUID(user);
                }
            }
            catch (SQLIntegrityConstraintViolationException e) {
                try {
                    throw new UserExistsException("Error while adding user to repository, user exists?", (Throwable)e);
                    catch (SQLException e2) {
                        throw new TigaseDBException("Problem accessing repository.", (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
            }
            this.data_repo.release(null, rs);
            return l;
        }
        this.data_repo.release(null, rs);
        return uid;
    }
}

