/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.mam;

import java.text.ParseException;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.component.exceptions.ComponentException;
import tigase.kernel.beans.Bean;
import tigase.server.Command;
import tigase.server.DataForm;
import tigase.server.Packet;
import tigase.util.datetime.TimestampHelper;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.Query;
import tigase.xmpp.mam.QueryParser;
import tigase.xmpp.rsm.RSM;

@Bean(name="mamQueryParser", active=true)
public class MAMQueryParser<Query extends Query>
implements QueryParser<Query> {
    protected static final String MAM_XMLNS = "urn:xmpp:mam:1";
    private final TimestampHelper timestampHelper = new TimestampHelper();
    private final Set<String> XMLNNS;

    public MAMQueryParser() {
        this(Stream.empty());
    }

    protected MAMQueryParser(Stream<String> additionalNamespaces) {
        this.XMLNNS = Stream.concat(additionalNamespaces, Stream.of(MAM_XMLNS)).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Set<String> getXMLNSs() {
        return this.XMLNNS;
    }

    @Override
    public Query parseQuery(Query query, Packet packet) throws ComponentException {
        Element queryEl = packet.getElement().getChildStaticStr("query");
        query.setXMLNS(queryEl.getXMLNS());
        query.setQuestionerJID(packet.getStanzaFrom());
        query.setComponentJID(packet.getStanzaTo());
        query.setId(queryEl.getAttributeStaticStr("queryid"));
        if (queryEl.getChild("x", "jabber:x:data") == null) {
            query.getRsm().fromElement(queryEl);
            this.validateRsm(query.getRsm());
            return query;
        }
        if (!this.getXMLNSs().contains(DataForm.getFieldValue(queryEl, "FORM_TYPE"))) {
            throw new ComponentException(Authorization.BAD_REQUEST, "Invalid form type");
        }
        String start = DataForm.getFieldValue(queryEl, "start");
        try {
            query.setStart(this.timestampHelper.parseTimestamp(start));
        }
        catch (ParseException ex) {
            throw new ComponentException(Authorization.BAD_REQUEST, "Invalid value in 'start' field", ex);
        }
        String end = DataForm.getFieldValue(queryEl, "end");
        try {
            query.setEnd(this.timestampHelper.parseTimestamp(end));
        }
        catch (ParseException ex) {
            throw new ComponentException(Authorization.BAD_REQUEST, "Invalid value in 'end' field", ex);
        }
        String with = DataForm.getFieldValue(queryEl, "with");
        if (with != null && !with.isEmpty()) {
            try {
                query.setWith(JID.jidInstance((String)with));
            }
            catch (TigaseStringprepException ex) {
                throw new ComponentException(Authorization.BAD_REQUEST, "Invalid value in 'with' field", ex);
            }
        }
        query.getRsm().fromElement(queryEl);
        this.validateRsm(query.getRsm());
        return query;
    }

    @Override
    public Element prepareForm(Element elem) {
        return this.prepareForm(elem, MAM_XMLNS);
    }

    @Override
    public Element prepareForm(Element elem, String xmlns, Packet packet) {
        Element x = DataForm.addDataForm(elem, Command.DataType.form);
        DataForm.addHiddenField(elem, "FORM_TYPE", xmlns);
        this.addField(x, "with", "jid-single", "With");
        this.addField(x, "start", "jid-single", "Start");
        this.addField(x, "end", "jid-single", "End");
        return elem;
    }

    protected void addField(Element x, String var, String type, String label) {
        Element field = new Element("field", new String[]{"type", "var"}, new String[]{type, var});
        if (label != null) {
            field.setAttribute("label", label);
        }
        x.addChild((XMLNodeIfc)field);
    }

    protected void validateRsm(RSM rsm) throws ComponentException {
        this.assertIsUUID(rsm.getAfter());
        this.assertIsUUID(rsm.getBefore());
    }

    protected void assertIsUUID(String uuid) throws ComponentException {
        if (uuid == null) {
            return;
        }
        try {
            UUID.fromString(uuid);
        }
        catch (IllegalArgumentException ex) {
            throw new ComponentException(Authorization.NOT_ACCEPTABLE, "Invalid item id: " + uuid, ex);
        }
    }
}

