/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.push;

import java.util.List;
import tigase.kernel.beans.Bean;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.push.PushNotifications;
import tigase.xmpp.impl.push.PushNotificationsFilter;
import tigase.xmpp.jid.BareJID;

@Bean(name="groupchat-filter", parent=PushNotifications.class, active=true)
public class GroupchatFilter
implements PushNotificationsFilter {
    public static final String XMLNS = "tigase:push:filter:groupchat:0";
    public static final String ID = "groupchat-filter";
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"tigase:push:filter:groupchat:0"})};

    @Override
    public Element[] getDiscoFeatures() {
        return DISCO_FEATURES;
    }

    @Override
    public void processEnableElement(Element enableEl, Element settingsEl) {
        Element allowNotMentionedEl = enableEl.getChild("groupchat", XMLNS);
        if (allowNotMentionedEl != null) {
            settingsEl.addChild((XMLNodeIfc)allowNotMentionedEl);
        }
    }

    @Override
    public boolean isSendingNotificationAllowed(BareJID userJid, XMPPResourceConnection session, Element pushServiceSettings, Packet packet) {
        if (packet.getType() != StanzaType.groupchat) {
            return true;
        }
        Element mucEl = pushServiceSettings.getChild("groupchat", XMLNS);
        if (mucEl == null) {
            return true;
        }
        List rooms = mucEl.getChildren();
        if (rooms == null) {
            return false;
        }
        for (Element room : rooms) {
            String jidStr = room.getAttributeStaticStr("jid");
            if (jidStr == null || !packet.getStanzaFrom().getBareJID().toString().equals(jidStr)) continue;
            String allow = room.getAttributeStaticStr("allow");
            if (allow == null) {
                return false;
            }
            switch (allow) {
                case "always": {
                    return true;
                }
                case "mentioned": {
                    String nick = room.getAttributeStaticStr("nick");
                    if (nick == null) {
                        return false;
                    }
                    return this.isMentioned(packet, nick);
                }
            }
            return false;
        }
        return false;
    }

    protected boolean isMentioned(Packet packet, String nick) {
        String body = packet.getElemCDataStaticStr(Message.MESSAGE_BODY_PATH);
        if (body == null) {
            return false;
        }
        return body.contains(nick);
    }
}

