/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.server.PolicyViolationException;
import tigase.server.xmppsession.SessionManager;
import tigase.vhosts.AbstractVHostItemExtension;
import tigase.vhosts.VHostItemExtensionBackwardCompatible;
import tigase.vhosts.VHostItemExtensionManager;
import tigase.vhosts.VHostItemExtensionProvider;
import tigase.vhosts.VHostManagerIfc;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.PresenceAbstract;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.Id;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.jid.JID;

@Id(value="presence-subscription")
@Handle(path={"presence"}, xmlns="jabber:client")
@Bean(name="presence-subscription", parent=SessionManager.class, active=true)
public class PresenceSubscription
extends PresenceAbstract {
    public static final String AUTO_AUTHORIZE_PROP_KEY = "auto-authorize";
    protected static final String ID = "presence-subscription";
    private static final Logger log = Logger.getLogger(PresenceSubscription.class.getCanonicalName());
    private static final Set<StanzaType> TYPES = new HashSet<StanzaType>(Arrays.asList(StanzaType.subscribe, StanzaType.subscribed, StanzaType.unsubscribe, StanzaType.unsubscribed));
    @ConfigField(desc="Automatically authorize subscription requests", alias="auto-authorize")
    private static boolean autoAuthorize = false;
    @Inject(nullAllowed=true)
    protected VHostManagerIfc vHostManager = null;

    @Override
    public Set<StanzaType> supTypes() {
        return TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Session is null, ignoring packet: {0}", packet);
            }
            return;
        }
        if (!session.isAuthorized()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Session is not authorized, ignoring packet: {0}", packet);
            }
            return;
        }
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            try {
                RosterAbstract.PresenceType pres_type = this.roster_util.getPresenceType(session, packet);
                if (pres_type == null) {
                    log.log(Level.CONFIG, "Invalid presence found: {0}", packet);
                    return;
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "{0} | {1} presence found: {2}", new Object[]{session.getBareJID().toString(), pres_type, packet});
                }
                switch (pres_type) {
                    case in_unsubscribe: 
                    case in_subscribe: 
                    case in_unsubscribed: 
                    case in_subscribed: {
                        if (packet.getStanzaFrom() == null) {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("'in' subscription presence without valid 'from' address, dropping packet: " + packet);
                            }
                            return;
                        }
                        if (session.isUserId(packet.getStanzaFrom().getBareJID())) {
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "''in'' subscription to myself, not allowed, returning error for packet: {0}", packet);
                            }
                            results.offer(Authorization.NOT_ALLOWED.getResponseMessage(packet, "You can not subscribe to yourself.", false));
                            return;
                        }
                        packet.initVars(packet.getStanzaFrom().copyWithoutResource(), session.getJID().copyWithoutResource());
                        break;
                    }
                    case out_subscribe: 
                    case out_unsubscribe: 
                    case out_subscribed: 
                    case out_unsubscribed: {
                        if (packet.getStanzaTo() == null || packet.getStanzaTo().toString().isEmpty()) {
                            results.offer(Authorization.JID_MALFORMED.getResponseMessage(packet, "The destination address is incorrect.", false));
                            return;
                        }
                        packet.initVars(session.getJID().copyWithoutResource(), packet.getStanzaTo().copyWithoutResource());
                        break;
                    }
                }
                switch (pres_type) {
                    case out_subscribe: 
                    case out_unsubscribe: {
                        this.processOutSubscribe(packet, session, results, settings, pres_type);
                        break;
                    }
                    case out_subscribed: 
                    case out_unsubscribed: {
                        this.processOutSubscribed(packet, session, results, settings, pres_type);
                        break;
                    }
                    case in_subscribe: {
                        this.processInSubscribe(packet, session, results, settings, pres_type);
                        break;
                    }
                    case in_unsubscribe: {
                        this.processInUnsubscribe(packet, session, results, settings, pres_type);
                        break;
                    }
                    case in_subscribed: {
                        this.processInSubscribed(packet, session, results, settings, pres_type);
                        break;
                    }
                    case in_unsubscribed: {
                        this.processInUnsubscribed(packet, session, results, settings, pres_type);
                        break;
                    }
                    default: {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                        break;
                    }
                }
            }
            catch (NotAuthorizedException e) {
                log.log(Level.CONFIG, "Can not access user Roster, user session is not authorized yet: {0}", packet);
                log.log(Level.FINEST, "presence problem...", e);
            }
            catch (PolicyViolationException e) {
                log.log(Level.FINE, "Violation of roster items number policy: {0}", packet);
            }
            catch (TigaseDBException e) {
                log.log(Level.WARNING, "Error accessing database for presence data: {0}", e);
            }
        }
    }

    protected void processInSubscribe(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType pres_type) throws NotAuthorizedException, TigaseDBException, NoConnectionIdException, PolicyViolationException {
        if (this.roster_util.isSubscribedFrom(session, packet.getStanzaFrom())) {
            PresenceSubscription.sendPresence(StanzaType.subscribed, session.getJID().copyWithoutResource(), packet.getStanzaFrom(), results, null);
        } else {
            RosterAbstract.SubscriptionType curr_sub = this.roster_util.getBuddySubscription(session, packet.getStanzaFrom());
            if (curr_sub == null) {
                this.roster_util.addBuddy(session, packet.getStanzaFrom(), null, null, null, null);
            }
            boolean preApproved = this.roster_util.isPreApproved(session, packet.getStanzaFrom());
            this.roster_util.updateBuddySubscription(session, pres_type, packet.getStanzaFrom());
            if (!this.isAutoAuthorizeEnabled(session.getJID().getDomain())) {
                if (!preApproved) {
                    PresenceSubscription.updatePresenceChange(packet, session, results);
                } else {
                    Element buddyItem = this.roster_util.getBuddyItem(session, packet.getStanzaFrom().copyWithoutResource());
                    this.roster_util.updateBuddyChange(session, results, buddyItem);
                    this.broadcastProbe(session, results, settings);
                    PresenceSubscription.sendPresence(StanzaType.subscribed, session.getJID(), packet.getStanzaFrom(), results, null);
                }
            } else {
                this.roster_util.setBuddySubscription(session, RosterAbstract.SubscriptionType.both, packet.getStanzaFrom().copyWithoutResource());
            }
        }
        if (this.isAutoAuthorizeEnabled(session.getJID().getDomain())) {
            Element buddyItem = this.roster_util.getBuddyItem(session, packet.getStanzaFrom().copyWithoutResource());
            this.roster_util.updateBuddyChange(session, results, buddyItem);
            this.broadcastProbe(session, results, settings);
            PresenceSubscription.sendPresence(StanzaType.subscribed, session.getJID(), packet.getStanzaFrom(), results, null);
        }
    }

    protected void processInSubscribed(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType pres_type) throws NotAuthorizedException, TigaseDBException, NoConnectionIdException, PolicyViolationException {
        boolean subscr_changed;
        RosterAbstract.SubscriptionType curr_sub = this.roster_util.getBuddySubscription(session, packet.getStanzaFrom());
        if (!this.isAutoAuthorizeEnabled(session.getJID().getDomain()) && curr_sub == null) {
            this.roster_util.addBuddy(session, packet.getStanzaFrom(), null, null, null, null);
        }
        if (subscr_changed = this.roster_util.updateBuddySubscription(session, pres_type, packet.getStanzaFrom())) {
            Packet forward_p = packet.copyElementOnly();
            forward_p.setPacketTo(session.getConnectionId());
            results.offer(forward_p);
            if (this.isAutoAuthorizeEnabled(session.getJID().getDomain())) {
                this.roster_util.setBuddySubscription(session, RosterAbstract.SubscriptionType.both, packet.getStanzaFrom().copyWithoutResource());
            }
            this.roster_util.updateBuddyChange(session, results, this.roster_util.getBuddyItem(session, packet.getStanzaFrom()));
            Element delay = packet.getElement().getChild("delay", "urn:xmpp:delay");
            if (delay != null) {
                Element presProbe = PresenceSubscription.prepareProbe(session);
                PresenceSubscription.sendPresence(null, session.getJID(), packet.getStanzaFrom(), results, presProbe);
            }
        }
    }

    protected void processInUnsubscribe(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType pres_type) throws NotAuthorizedException, TigaseDBException, NoConnectionIdException, PolicyViolationException {
        boolean subscr_changed = this.roster_util.updateBuddySubscription(session, pres_type, packet.getStanzaFrom());
        if (subscr_changed) {
            Element item;
            if (!this.isAutoAuthorizeEnabled(session.getJID().getDomain())) {
                Packet forward_p = packet.copyElementOnly();
                forward_p.setPacketTo(session.getConnectionId());
                results.offer(forward_p);
            }
            if ((item = this.roster_util.getBuddyItem(session, packet.getStanzaFrom())) != null) {
                this.roster_util.updateBuddyChange(session, results, item);
            } else if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Received unsubscribe request from a user who is not in the roster: {0}", packet.getStanzaFrom());
            }
            if (this.isAutoAuthorizeEnabled(session.getJID().getDomain())) {
                this.broadcastProbe(session, results, settings);
            }
        }
    }

    protected void processInUnsubscribed(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType pres_type) throws NotAuthorizedException, TigaseDBException, NoConnectionIdException, PolicyViolationException {
        RosterAbstract.SubscriptionType curr_sub = this.roster_util.getBuddySubscription(session, packet.getStanzaFrom());
        if (curr_sub != null) {
            boolean subscr_changed;
            if (!this.isAutoAuthorizeEnabled(session.getJID().getDomain())) {
                Packet forward_p = packet.copyElementOnly();
                forward_p.setPacketTo(session.getConnectionId());
                results.offer(forward_p);
            }
            if (subscr_changed = this.roster_util.updateBuddySubscription(session, pres_type, packet.getStanzaFrom())) {
                Element item = this.roster_util.getBuddyItem(session, packet.getStanzaFrom());
                if (item != null) {
                    this.roster_util.updateBuddyChange(session, results, this.roster_util.getBuddyItem(session, packet.getStanzaFrom()));
                } else if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Received unsubscribe request from a user who is not in the roster: {0}", packet.getStanzaFrom());
                }
                if (this.isAutoAuthorizeEnabled(session.getJID().getDomain())) {
                    this.broadcastProbe(session, results, settings);
                }
            }
        }
    }

    protected void processOutSubscribe(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType pres_type) throws NotAuthorizedException, TigaseDBException, NoConnectionIdException, PolicyViolationException {
        boolean subscr_changed = false;
        PresenceSubscription.forwardPresence(results, packet, session.getJID().copyWithoutResource());
        RosterAbstract.SubscriptionType current_subscription = this.roster_util.getBuddySubscription(session, packet.getStanzaTo());
        if (pres_type == RosterAbstract.PresenceType.out_subscribe) {
            if (current_subscription == null) {
                this.roster_util.addBuddy(session, packet.getStanzaTo(), null, null, null, null);
            }
            subscr_changed = this.roster_util.updateBuddySubscription(session, pres_type, packet.getStanzaTo());
            if (this.isAutoAuthorizeEnabled(session.getJID().getDomain())) {
                this.roster_util.setBuddySubscription(session, RosterAbstract.SubscriptionType.both, packet.getStanzaTo().copyWithoutResource());
            }
            if (subscr_changed) {
                this.roster_util.updateBuddyChange(session, results, this.roster_util.getBuddyItem(session, packet.getStanzaTo()));
            }
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "out_subscribe: current_subscription = " + current_subscription);
            }
            if (current_subscription != null) {
                subscr_changed = this.roster_util.updateBuddySubscription(session, pres_type, packet.getStanzaTo());
                current_subscription = this.roster_util.getBuddySubscription(session, packet.getStanzaTo());
                if (subscr_changed) {
                    this.roster_util.updateBuddyChange(session, results, this.roster_util.getBuddyItem(session, packet.getStanzaTo()));
                }
                if (RosterAbstract.SUB_NONE.contains((Object)current_subscription)) {
                    this.roster_util.removeBuddy(session, packet.getStanzaTo());
                }
            }
        }
    }

    protected void processOutSubscribed(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType pres_type) throws NotAuthorizedException, TigaseDBException, NoConnectionIdException, PolicyViolationException {
        Element initial_presence = session.getPresence();
        JID buddy = packet.getStanzaTo().copyWithoutResource();
        boolean subscr_changed = this.roster_util.updateBuddySubscription(session, pres_type, buddy);
        boolean isPreApproved = this.roster_util.isPreApproved(session, packet.getStanzaTo());
        if (this.isAutoAuthorizeEnabled(session.getJID().getDomain()) && pres_type == RosterAbstract.PresenceType.out_subscribed) {
            this.roster_util.setBuddySubscription(session, RosterAbstract.SubscriptionType.both, buddy.copyWithoutResource());
        }
        if (!isPreApproved) {
            PresenceSubscription.forwardPresence(results, packet, session.getJID().copyWithoutResource());
        }
        if (subscr_changed) {
            this.roster_util.updateBuddyChange(session, results, this.roster_util.getBuddyItem(session, buddy));
            if (initial_presence != null && !isPreApproved) {
                if (pres_type == RosterAbstract.PresenceType.out_subscribed) {
                    List<XMPPResourceConnection> activeSessions = session.getActiveSessions();
                    for (XMPPResourceConnection userSessions : activeSessions) {
                        Element presence = userSessions.getPresence();
                        PresenceSubscription.sendPresence(StanzaType.available, userSessions.getjid(), buddy, results, presence);
                    }
                    this.roster_util.setPresenceSent(session, buddy, true);
                } else {
                    PresenceSubscription.sendPresence(StanzaType.unavailable, session.getJID(), buddy, results, null);
                }
            }
        }
    }

    private boolean isAutoAuthorizeEnabled(String domain) {
        PresenceSubscriptionVHostItemExtension extension;
        AUTO_AUTHORIZE_MODE mode = AUTO_AUTHORIZE_MODE.global;
        if (this.vHostManager != null && (extension = this.vHostManager.getVHostItem(domain).getExtension(PresenceSubscriptionVHostItemExtension.class)) != null) {
            mode = extension.getAutoAuthorizeMode();
        }
        if (AUTO_AUTHORIZE_MODE.global.equals((Object)mode)) {
            return autoAuthorize;
        }
        return mode.isEnabled();
    }

    static enum AUTO_AUTHORIZE_MODE {
        global,
        on(true),
        off(false);

        private static String[] names;
        private boolean enabled;

        private AUTO_AUTHORIZE_MODE() {
            this.enabled = false;
        }

        private AUTO_AUTHORIZE_MODE(boolean b) {
            this.enabled = b;
        }

        protected boolean isEnabled() {
            return this.enabled;
        }

        static {
            names = null;
        }
    }

    public static class PresenceSubscriptionVHostItemExtension
    extends AbstractVHostItemExtension<PresenceSubscriptionVHostItemExtension>
    implements VHostItemExtensionBackwardCompatible<PresenceSubscriptionVHostItemExtension> {
        public static final String ID = "presence-subscription";
        private AUTO_AUTHORIZE_MODE autoAuthorizeMode = AUTO_AUTHORIZE_MODE.global;

        public AUTO_AUTHORIZE_MODE getAutoAuthorizeMode() {
            return this.autoAuthorizeMode;
        }

        @Override
        public String getId() {
            return "presence-subscription";
        }

        @Override
        public void initFromElement(Element item) {
            String tmp = item.getAttributeStaticStr(PresenceSubscription.AUTO_AUTHORIZE_PROP_KEY);
            this.autoAuthorizeMode = tmp != null ? AUTO_AUTHORIZE_MODE.valueOf(tmp) : AUTO_AUTHORIZE_MODE.global;
        }

        @Override
        public void initFromCommand(String prefix, Packet packet) throws IllegalArgumentException {
            String tmp = Command.getFieldValue(packet, prefix + "-auto-authorize");
            this.autoAuthorizeMode = AUTO_AUTHORIZE_MODE.global;
            if (tmp != null) {
                this.autoAuthorizeMode = Boolean.parseBoolean(tmp) ? AUTO_AUTHORIZE_MODE.on : AUTO_AUTHORIZE_MODE.off;
            }
        }

        @Override
        public String toDebugString() {
            return "mode: " + this.autoAuthorizeMode;
        }

        @Override
        public Element toElement() {
            if (this.autoAuthorizeMode == AUTO_AUTHORIZE_MODE.global) {
                return null;
            }
            Element el = new Element(this.getId());
            el.setAttribute(PresenceSubscription.AUTO_AUTHORIZE_PROP_KEY, this.autoAuthorizeMode.name());
            return el;
        }

        @Override
        public void addCommandFields(String prefix, Packet packet, boolean forDefault) {
            Element commandEl = packet.getElemChild("command", "http://jabber.org/protocol/commands");
            Boolean value = null;
            switch (this.autoAuthorizeMode) {
                case global: {
                    break;
                }
                case off: {
                    value = false;
                    break;
                }
                case on: {
                    value = true;
                }
            }
            this.addBooleanFieldWithDefaultToCommand(commandEl, prefix + "-auto-authorize", "Automatically authorize subscription requests", value, forDefault);
        }

        @Override
        public PresenceSubscriptionVHostItemExtension mergeWithDefaults(PresenceSubscriptionVHostItemExtension defaults) {
            return this.autoAuthorizeMode == AUTO_AUTHORIZE_MODE.global ? defaults : this;
        }

        @Override
        public void initFromData(Map<String, Object> data) {
            String tmp = (String)data.remove(PresenceSubscription.AUTO_AUTHORIZE_PROP_KEY);
            this.autoAuthorizeMode = tmp == null ? AUTO_AUTHORIZE_MODE.global : AUTO_AUTHORIZE_MODE.valueOf(tmp);
        }
    }

    @Bean(name="presence-subscription", parent=VHostItemExtensionManager.class, active=true)
    public static class PresenceSubscriptionVHostItemExtensionProvider
    implements VHostItemExtensionProvider<PresenceSubscriptionVHostItemExtension> {
        @Override
        public String getId() {
            return PresenceSubscription.ID;
        }

        @Override
        public Class<PresenceSubscriptionVHostItemExtension> getExtensionClazz() {
            return PresenceSubscriptionVHostItemExtension.class;
        }
    }
}

