/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.AuthRepository;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.eventbus.EventBus;
import tigase.eventbus.EventBusEvent;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.core.Kernel;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.server.xmppsession.SessionManagerHandler;
import tigase.server.xmppsession.UserConnectedEvent;
import tigase.server.xmppsession.UserSessionEvent;
import tigase.util.cache.LRUConcurrentCache;
import tigase.util.dns.DNSResolverFactory;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.vhosts.VHostItemImpl;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPPreprocessorIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;
import tigase.xmpp.impl.Privacy;
import tigase.xmpp.impl.PrivacyList;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.impl.roster.RosterFactory;
import tigase.xmpp.impl.roster.RosterFlat;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="jabber:iq:privacy", parent=SessionManager.class, active=true)
public class JabberIqPrivacy
extends XMPPProcessor
implements XMPPProcessorIfc,
XMPPPreprocessorIfc,
XMPPPacketFilterIfc,
RegistrarBean,
Initializable,
UnregisterAware {
    protected static final String ACTIVE_EL_NAME = "active";
    protected static final Element BLOCKED_ELEM = new Element("blocked", new String[]{"xmlns"}, new String[]{"urn:xmpp:blocking:errors"});
    protected static final String DEFAULT_EL_NAME = "default";
    protected static final String[][] ELEMENTS = new String[][]{Iq.IQ_QUERY_PATH};
    protected static final String LIST_EL_NAME = "list";
    protected static final String ERROR_EL_NAME = "error";
    protected static final String PRESENCE_EL_NAME = "presence";
    protected static final String PRESENCE_IN_EL_NAME = "presence-in";
    protected static final String PRESENCE_OUT_EL_NAME = "presence-out";
    protected static final String XMLNS = "jabber:iq:privacy";
    protected static final String ID = "jabber:iq:privacy";
    protected static final String[] XMLNSS = new String[]{"jabber:iq:privacy"};
    protected static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"jabber:iq:privacy"})};
    protected static final Comparator<Element> compar = new Comparator<Element>(){

        @Override
        public int compare(Element el1, Element el2) {
            String or1 = el1.getAttributeStaticStr("order");
            String or2 = el2.getAttributeStaticStr("order");
            if (or1.length() != or2.length()) {
                return Integer.compare(or1.length(), or2.length());
            }
            return or1.compareTo(or2);
        }
    };
    protected static Logger log = Logger.getLogger(JabberIqPrivacy.class.getName());
    protected static RosterAbstract roster_util = RosterFactory.getRosterImplementation(true);
    @Inject(nullAllowed=true)
    protected PrivacyListOfflineCache cache;
    @Inject
    private EventBus eventBus;

    public static Authorization validateList(XMPPResourceConnection session, List<Element> items) {
        Authorization result = null;
        try {
            JID[] jids;
            HashSet<Integer> orderSet = new HashSet<Integer>();
            HashSet<String> groups = new HashSet<String>();
            if (session != null && (jids = roster_util.getBuddies(session)) != null) {
                for (JID jid : jids) {
                    String[] buddyGroups = roster_util.getBuddyGroups(session, jid);
                    if (buddyGroups == null) continue;
                    for (String group : buddyGroups) {
                        groups.add(group);
                    }
                }
            }
            for (Element item : items) {
                ITEM_TYPE type = ITEM_TYPE.all;
                if (item.getAttributeStaticStr("type") != null) {
                    type = ITEM_TYPE.valueOf(item.getAttributeStaticStr("type"));
                }
                String value = item.getAttributeStaticStr("value");
                switch (type) {
                    case jid: {
                        JID.jidInstance((String)value);
                        break;
                    }
                    case group: {
                        boolean matched = groups.contains(value);
                        if (matched) break;
                        result = Authorization.ITEM_NOT_FOUND;
                        break;
                    }
                    case subscription: {
                        ITEM_SUBSCRIPTIONS.valueOf(value);
                        break;
                    }
                }
                if (result == null) {
                    ITEM_ACTION.valueOf(item.getAttributeStaticStr("action"));
                    Integer order = Integer.parseInt(item.getAttributeStaticStr("order"));
                    if (order == null || order < 0 || !orderSet.add(order)) {
                        result = Authorization.BAD_REQUEST;
                    }
                    if (result == null) continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            result = Authorization.BAD_REQUEST;
        }
        return result;
    }

    @Override
    public void register(Kernel kernel) {
    }

    @Override
    public void unregister(Kernel kernel) {
    }

    @Override
    public void filter(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        if (session == null || !session.isAuthorized() || results == null || results.size() == 0) {
            return;
        }
        ArrayDeque<Packet> errors = null;
        Iterator it = results.iterator();
        while (it.hasNext()) {
            Packet res = (Packet)it.next();
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Checking outbound packet: {0}", res);
            }
            if (res.getType() == StanzaType.unavailable || res.isXMLNSStaticStr(Iq.IQ_QUERY_PATH, "jabber:iq:privacy") || this.allowed(res, session)) continue;
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Packet not allowed to go, removing: {0}", res);
            }
            it.remove();
            Packet error = this.prepareError(res, session);
            if (error == null) continue;
            if (errors == null) {
                errors = new ArrayDeque<Packet>();
            }
            errors.offer(error);
        }
        if (errors != null) {
            results.addAll(errors);
        }
    }

    @Override
    public String id() {
        return "jabber:iq:privacy";
    }

    @Override
    public boolean preProcess(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        Packet error;
        if (packet.isXMLNSStaticStr(Iq.IQ_QUERY_PATH, "jabber:iq:privacy")) {
            return false;
        }
        boolean sendError = session != null && session.isAuthorized();
        boolean allowed = this.allowed(packet, session);
        if (!allowed && sendError && (error = this.prepareError(packet, session)) != null) {
            results.offer(error);
        }
        return !allowed;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            return;
        }
        if (session.isAnonymous()) {
            return;
        }
        try {
            StanzaType type = packet.getType();
            if (type == StanzaType.get) {
                this.processGetRequest(packet, session, results);
            } else if (type == StanzaType.set) {
                this.processSetRequest(packet, session, results);
            } else if (type != StanzaType.result && type != StanzaType.error) {
                results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
            }
        }
        catch (NotAuthorizedException e) {
            log.log(Level.FINEST, "Received privacy request but user session is not authorized yet: {0}", packet);
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
        catch (TigaseDBException e) {
            log.log(Level.WARNING, "Database problem, please contact admin: {0}", e);
            results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database access problem, please contact administrator.", true));
        }
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public void initialize() {
        this.eventBus.registerAll(this);
    }

    @Override
    public void beforeUnregister() {
        this.eventBus.unregisterAll(this);
    }

    @HandleEvent
    public void privacyListUpdated(PrivacyListUpdatedEvent event) {
        String name = event.getPrivacyListName();
        boolean first = true;
        for (XMPPResourceConnection session : event.getSession().getActiveResources()) {
            try {
                if (event.getSender().equals((Object)session.getJID())) continue;
                PrivacyList activeList = Privacy.getActiveList(session);
                if (activeList != null && event.getPrivacyListName().equals(activeList.getName())) {
                    Privacy.setActiveList(session, activeList.getName());
                }
                if (!first) continue;
                if (name.equals(Privacy.getDefaultListName(session))) {
                    Element defaultListEl = Privacy.getDefaultListElement(session);
                    Privacy.setDefaultList(session, defaultListEl);
                }
                first = false;
            }
            catch (TigaseDBException | NotAuthorizedException exception) {}
        }
    }

    protected boolean allowed(Packet packet, JID connId, BareJID userJid, PrivacyList privacyList) {
        if (this.allowedByDefault(packet, connId, userJid)) {
            return true;
        }
        if (privacyList != null) {
            JID jid = packet.getStanzaFrom();
            boolean packetIn = true;
            if (jid == null || userJid.equals((Object)jid.getBareJID())) {
                jid = packet.getStanzaTo();
                packetIn = false;
            }
            PrivacyList.Item.Type type = null;
            if (packetIn) {
                switch (packet.getElemName()) {
                    case "presence": {
                        type = PrivacyList.Item.Type.presenceIn;
                        break;
                    }
                    case "message": {
                        type = PrivacyList.Item.Type.message;
                        break;
                    }
                    case "iq": {
                        type = PrivacyList.Item.Type.iq;
                        break;
                    }
                }
            } else if (packet.getElemName() == PRESENCE_EL_NAME) {
                type = PrivacyList.Item.Type.presenceOut;
            }
            if (type != null) {
                return privacyList.isAllowed(jid, type);
            }
        }
        return true;
    }

    protected boolean allowed(Packet packet, XMPPResourceConnection session) {
        PrivacyList list;
        JID to;
        if (session != null && session.isAuthorized()) {
            try {
                PrivacyList list2 = Privacy.getActiveList(session);
                if (list2 == null) {
                    list2 = Privacy.getDefaultList(session);
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Using privacy list: {0}", list2);
                }
                if (list2 != null) {
                    return this.allowed(packet, session.getConnectionId(), session.getBareJID(), list2);
                }
            }
            catch (NoConnectionIdException list2) {
            }
            catch (NotAuthorizedException list2) {
            }
            catch (TigaseDBException e) {
                log.log(Level.WARNING, "Database problem, please notify the admin. {0}", e);
            }
        } else if (this.cache != null && (to = packet.getStanzaTo()) != null && (list = this.cache.getPrivacyList(to.getBareJID())) != null) {
            return this.allowed(packet, null, to.getBareJID(), list);
        }
        return true;
    }

    protected boolean allowedByDefault(Packet packet, JID connId, BareJID userJid) {
        Element error;
        if (connId != null && connId.equals((Object)packet.getPacketFrom())) {
            return true;
        }
        if (packet.getStanzaFrom() == null || packet.getStanzaFrom().getLocalpart() == null && userJid.getDomain().equals(packet.getStanzaFrom().getDomain())) {
            return true;
        }
        if (packet.getStanzaTo() == null || packet.getStanzaTo().getLocalpart() == null && userJid.getDomain().equals(packet.getStanzaTo().getDomain())) {
            return true;
        }
        if (packet.getStanzaFrom() != null && packet.getStanzaTo() != null && packet.getStanzaFrom().getBareJID().equals((Object)packet.getStanzaTo().getBareJID())) {
            return true;
        }
        return packet.getType() == StanzaType.error && packet.getStanzaTo() != null && userJid.equals((Object)packet.getStanzaTo().getBareJID()) && (error = packet.getElement().findChild(e -> e.getName() == ERROR_EL_NAME)) != null && error.findChild(e -> e.getName() == Authorization.NOT_ACCEPTABLE.getCondition()) != null && error.findChild(e -> e.getName() == BLOCKED_ELEM.getName() && e.getXMLNS() == BLOCKED_ELEM.getXMLNS()) != null;
    }

    protected Packet prepareError(Packet packet, XMPPResourceConnection session) {
        if (packet.getType() != StanzaType.error) {
            try {
                Packet error = null;
                switch (packet.getElemName()) {
                    case "presence": {
                        break;
                    }
                    case "message": {
                        if (packet.getStanzaFrom() == null || session.isUserId(packet.getStanzaFrom().getBareJID())) {
                            if (packet.getPacketTo() != null) {
                                return null;
                            }
                            error = Authorization.NOT_ACCEPTABLE.getResponseMessage(packet, null, true);
                            error.getElement().getChild(ERROR_EL_NAME).addChild((XMLNodeIfc)BLOCKED_ELEM.clone());
                        } else {
                            error = Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, null, true);
                        }
                        return error;
                    }
                    case "iq": {
                        if (packet.getType() == StanzaType.get || packet.getType() == StanzaType.set) {
                            if (packet.getStanzaFrom() == null || session.isUserId(packet.getStanzaFrom().getBareJID())) {
                                error = Authorization.NOT_ACCEPTABLE.getResponseMessage(packet, null, true);
                                error.getElement().getChild(ERROR_EL_NAME).addChild((XMLNodeIfc)BLOCKED_ELEM.clone());
                            } else {
                                error = Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, null, true);
                            }
                        }
                        return error;
                    }
                }
            }
            catch (NotAuthorizedException ex) {
                log.log(Level.FINEST, "Packet droped due to privacy list rules. Error could not be generated properly as session is not authorized yet, should not happen.", ex);
            }
            catch (PacketErrorTypeException ex) {
                log.log(Level.FINER, "Packet dropped due to privacy list rules. Packet is error type already: {0}", packet.toStringSecure());
            }
        }
        return null;
    }

    protected void processGetRequest(Packet packet, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException, XMPPException, TigaseDBException {
        List<Element> children = packet.getElemChildrenStaticStr(Iq.IQ_QUERY_PATH);
        if (children == null || children.size() == 0) {
            String[] lists = Privacy.getLists(session);
            if (lists != null) {
                StringBuilder sblists = new StringBuilder(100);
                for (String list : lists) {
                    sblists.append("<list name=\"").append(list).append("\"/>");
                }
                String list = Privacy.getDefaultListName(session);
                if (list != null) {
                    sblists.append("<default name=\"").append(list).append("\"/>");
                }
                if ((list = Privacy.getActiveListName(session)) != null) {
                    sblists.append("<active name=\"").append(list).append("\"/>");
                }
                results.offer(packet.okResult(sblists.toString(), 1));
            } else {
                results.offer(packet.okResult((String)null, 1));
            }
        } else if (children.size() > 1) {
            results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "You can retrieve only one list at a time.", true));
        } else {
            Element eList = Privacy.getList(session, children.get(0).getAttributeStaticStr("name"));
            if (eList != null) {
                results.offer(packet.okResult(eList, 1));
            } else {
                results.offer(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "Requested list not found.", true));
            }
        }
    }

    protected void processSetRequest(Packet packet, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException, XMPPException, TigaseDBException {
        List<Element> children = packet.getElemChildrenStaticStr(Iq.IQ_QUERY_PATH);
        if (children != null && children.size() == 1) {
            Element list;
            String listName;
            Element child = children.get(0);
            if (child.getName() == LIST_EL_NAME) {
                List items;
                String name = child.getAttributeStaticStr("name");
                if (name == null || name.length() == 0) {
                    child.setAttribute("name", DEFAULT_EL_NAME);
                }
                if ((items = child.getChildren()) == null || items.isEmpty()) {
                    boolean inUse;
                    boolean bl = inUse = session.getCommonSessionData("privacy-lists-loaded") != null && session.getCommonSessionData("default-list") != null;
                    if (!inUse) {
                        for (XMPPResourceConnection activeSession : session.getActiveSessions()) {
                            if (activeSession.equals(session)) continue;
                            inUse |= name.equals(Privacy.getActiveListName(activeSession));
                        }
                    }
                    if (inUse) {
                        results.offer(Authorization.CONFLICT.getResponseMessage(packet, "Can not modify list while being in use by other session", true));
                    } else {
                        Privacy.removeList(session, child);
                        results.offer(packet.okResult((String)null, 0));
                    }
                } else {
                    Authorization error = JabberIqPrivacy.validateList(session, items);
                    if (error == null) {
                        Privacy.addList(session, child);
                        for (XMPPResourceConnection activeSession : session.getActiveSessions()) {
                            if (!name.equals(Privacy.getActiveListName(activeSession))) continue;
                            Privacy.setActiveList(activeSession, name);
                        }
                        if (name.equals(Privacy.getDefaultListName(session))) {
                            Privacy.setDefaultList(session, child);
                        }
                        this.eventBus.fire(new PrivacyListUpdatedEvent(session.getJID(), session.getJID().copyWithoutResource(), session.getParentSession(), name));
                        results.offer(packet.okResult((String)null, 0));
                    } else {
                        results.offer(error.getResponseMessage(packet, null, true));
                    }
                }
            }
            if (child.getName() == DEFAULT_EL_NAME) {
                listName = child.getAttributeStaticStr("name");
                list = Privacy.getList(session, listName);
                if (listName != null && list == null) {
                    results.offer(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "Selected list was not found on the server", true));
                } else {
                    Privacy.setDefaultList(session, list);
                    results.offer(packet.okResult((String)null, 0));
                }
            }
            if (child.getName() == ACTIVE_EL_NAME) {
                listName = child.getAttributeStaticStr("name");
                list = Privacy.getList(session, listName);
                if (listName != null && list == null) {
                    results.offer(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "Selected list was not found on the server", true));
                } else {
                    Privacy.setActiveList(session, child.getAttributeStaticStr("name"));
                    results.offer(packet.okResult((String)null, 0));
                }
            }
        } else {
            results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Only 1 element is allowed in privacy set request.", true));
        }
    }

    protected static enum ITEM_TYPE {
        jid,
        group,
        subscription,
        all;

    }

    protected static enum ITEM_SUBSCRIPTIONS {
        both,
        to,
        from,
        none;

    }

    protected static enum ITEM_ACTION {
        allow,
        deny;

    }

    public static class PrivacyListUpdatedEvent
    extends UserSessionEvent
    implements EventBusEvent {
        private String privacyListName;

        public PrivacyListUpdatedEvent() {
        }

        public PrivacyListUpdatedEvent(JID sender, JID userJid, XMPPSession session, String privacyListName) {
            super(sender, userJid, session);
            this.privacyListName = privacyListName;
        }

        public String getPrivacyListName() {
            return this.privacyListName;
        }

        public void setPrivacyListName(String privacyListName) {
            this.privacyListName = privacyListName;
        }
    }

    @Bean(name="privacyListOfflineCache", parent=JabberIqPrivacy.class, active=false)
    public static class PrivacyListOfflineCache
    implements SessionManagerHandler,
    Initializable,
    UnregisterAware {
        @Inject
        private AuthRepository authRepository;
        @ConfigField(desc="Cache size", alias="size")
        private int cacheSize = 10000;
        private LRUConcurrentCache<BareJID, PrivacyList> cache = new LRUConcurrentCache(this.cacheSize);
        private JID compId = JID.jidInstanceNS((String)"privacy-sessman", (String)DNSResolverFactory.getInstance().getDefaultHost());
        @Inject
        private EventBus eventBus;
        private JID offlineConnectionId = JID.jidInstanceNS((String)"offline-connection", (String)DNSResolverFactory.getInstance().getDefaultHost());
        @Inject
        private UserRepository userRepository;

        public void clear() {
            this.cache.clear();
        }

        @Override
        public JID getComponentId() {
            return this.compId;
        }

        @Override
        public void handleLogin(BareJID userId, XMPPResourceConnection conn) {
        }

        @Override
        public void handleDomainChange(String domain, XMPPResourceConnection conn) {
        }

        @Override
        public void handleLogout(BareJID userId, XMPPResourceConnection conn) {
        }

        @Override
        public void handlePresenceSet(XMPPResourceConnection conn) {
        }

        @Override
        public void handleResourceBind(XMPPResourceConnection conn) {
        }

        @Override
        public boolean isLocalDomain(String domain, boolean includeComponents) {
            return false;
        }

        @Override
        public void initialize() {
            this.eventBus.registerAll(this);
        }

        @Override
        public void beforeUnregister() {
            this.eventBus.unregisterAll(this);
        }

        public void setCacheSize(int cacheSize) {
            this.cacheSize = cacheSize;
            if (this.cache.limit() != cacheSize) {
                this.cache = new LRUConcurrentCache(cacheSize);
            }
        }

        @HandleEvent
        protected void userConnected(UserConnectedEvent event) {
            this.cache.remove((Object)event.getUserJid().getBareJID());
        }

        protected PrivacyList getPrivacyList(BareJID userJID) {
            if (!this.cache.containsKey((Object)userJID)) {
                try {
                    PrivacyList list = this.loadList(userJID);
                    this.cache.put((Object)userJID, (Object)list);
                }
                catch (TigaseDBException | NotAuthorizedException ex) {
                    return null;
                }
            }
            return (PrivacyList)this.cache.get((Object)userJID);
        }

        protected PrivacyList loadList(BareJID userJID) throws NotAuthorizedException, TigaseDBException {
            XMPPResourceConnection session = this.createXMPPResourceConnection(userJID);
            if (roster_util instanceof RosterFlat) {
                Element listEl = Privacy.getDefaultListElement(session);
                if (listEl == null) {
                    return PrivacyList.ALLOW_ALL;
                }
                Map<BareJID, RosterElement> roster = ((RosterFlat)roster_util).loadUserRoster(session);
                return PrivacyList.create(roster, listEl);
            }
            return Privacy.getDefaultList(session);
        }

        private XMPPResourceConnection createXMPPResourceConnection(BareJID userJid) {
            try {
                OfflineResourceConnection session = new OfflineResourceConnection(this.offlineConnectionId, this.userRepository, this.authRepository, this);
                VHostItemImpl vhost = new VHostItemImpl(userJid.getDomain());
                session.setDomain(vhost);
                session.authorizeJID(userJid, false);
                XMPPSession parentSession = new XMPPSession(userJid.getLocalpart());
                session.setParentSession(parentSession);
                return session;
            }
            catch (TigaseStringprepException ex) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "creation of temporary session for offline user " + userJid + " failed", ex);
                }
                return null;
            }
        }
    }

    public static class OfflineResourceConnection
    extends XMPPResourceConnection {
        public OfflineResourceConnection(JID connectionId, UserRepository rep, AuthRepository authRepo, SessionManagerHandler loginHandler) {
            super(connectionId, rep, authRepo, loginHandler);
        }

        @Override
        public boolean isAuthorized() {
            return true;
        }
    }
}

