/*
 * Decompiled with CFR 0.152.
 */
package tigase.vhosts;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.DataSourceHelper;
import tigase.db.TigaseDBException;
import tigase.db.comp.AbstractSDComponentRepositoryBean;
import tigase.db.comp.ComponentRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.core.Kernel;
import tigase.server.AbstractComponentRegistrator;
import tigase.server.ServerComponent;
import tigase.stats.StatisticsContainer;
import tigase.stats.StatisticsList;
import tigase.util.reflection.ReflectionHelper;
import tigase.vhosts.VHostComponentRepository;
import tigase.vhosts.VHostComponentRepositoryDataSourceAware;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostListener;
import tigase.vhosts.VHostManagerIfc;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="vhost-man", parent=Kernel.class, active=true, exportable=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode, ConfigTypeEnum.SessionManagerMode, ConfigTypeEnum.ConnectionManagersMode, ConfigTypeEnum.ComponentMode})
public class VHostManager
extends AbstractComponentRegistrator<VHostListener>
implements VHostManagerIfc,
StatisticsContainer,
RegistrarBean {
    private static final Logger log = Logger.getLogger(VHostManager.class.getName());
    @Inject
    protected VHostComponentRepository repo = null;
    private long getComponentsForLocalDomainCalls = 0L;
    private long getComponentsForNonLocalDomainCalls = 0L;
    private String identity_type = "generic";
    private long isAnonymousEnabledCalls = 0L;
    private long isLocalDomainCalls = 0L;
    private Kernel kernel;
    private LinkedHashSet<VHostListener> localDomainsHandlers = new LinkedHashSet(10);
    private LinkedHashSet<VHostListener> nameSubdomainsHandlers = new LinkedHashSet(10);
    private LinkedHashSet<VHostListener> nonLocalDomainsHandlers = new LinkedHashSet(10);
    private ConcurrentSkipListSet<String> registeredComponentDomains = new ConcurrentSkipListSet();

    @Override
    public void addComponentDomain(String domain) {
        this.registeredComponentDomains.add(domain);
    }

    @Override
    public void componentAdded(VHostListener component) {
        component.setVHostManager(this);
        if (component.handlesLocalDomains()) {
            this.localDomainsHandlers.add(component);
        }
        if (component.handlesNonLocalDomains()) {
            this.nonLocalDomainsHandlers.add(component);
        }
        if (component.handlesNameSubdomains()) {
            this.nameSubdomainsHandlers.add(component);
        }
    }

    @Override
    public void componentRemoved(VHostListener component) {
        this.localDomainsHandlers.remove(component);
        this.nonLocalDomainsHandlers.remove(component);
        this.nameSubdomainsHandlers.remove(component);
    }

    @Override
    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put("comp_repo", (Object)this.repo);
        binds.put("kernel", (Object)this.kernel);
    }

    @Override
    public void removeComponentDomain(String domain) {
        this.registeredComponentDomains.remove(domain);
    }

    @Override
    public void register(Kernel kernel) {
        this.kernel = kernel;
    }

    @Override
    public void unregister(Kernel kernel) {
    }

    @Override
    public List<JID> getAllVHosts() {
        ArrayList<JID> list = new ArrayList<JID>();
        try {
            for (VHostItem item : this.repo.allItems()) {
                list.add(item.getVhost());
            }
        }
        catch (TigaseDBException ex) {
            Logger.getLogger(VHostManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        return list;
    }

    @Override
    public ServerComponent[] getComponentsForLocalDomain(String domain) {
        ++this.getComponentsForLocalDomainCalls;
        VHostItem vhost = (VHostItem)this.repo.getItem(domain);
        if (vhost == null) {
            int idx = domain.indexOf(46);
            if (idx > 0) {
                String name = domain.substring(0, idx);
                String basedomain = domain.substring(idx + 1);
                VHostListener listener = (VHostListener)this.components.get(name);
                if (listener != null && listener.handlesNameSubdomains() && this.isLocalDomain(basedomain)) {
                    return new ServerComponent[]{listener};
                }
            }
            return null;
        }
        LinkedHashSet<VHostListener> results = new LinkedHashSet<VHostListener>(10);
        String[] comps = vhost.getComps();
        if (comps != null && comps.length > 0) {
            for (String name : comps) {
                VHostListener listener = (VHostListener)this.components.get(name);
                if (listener == null) continue;
                results.add(listener);
            }
        }
        if (results.size() == 0) {
            results.addAll(this.localDomainsHandlers);
        }
        if (results.size() > 0) {
            return results.toArray(new ServerComponent[results.size()]);
        }
        return null;
    }

    @Override
    public ServerComponent[] getComponentsForNonLocalDomain(String domain) {
        ++this.getComponentsForNonLocalDomainCalls;
        if (this.nonLocalDomainsHandlers.size() > 0) {
            return this.nonLocalDomainsHandlers.toArray(new ServerComponent[this.nonLocalDomainsHandlers.size()]);
        }
        return null;
    }

    @Override
    public BareJID getDefVHostItem() {
        return this.repo.getDefaultVHostItem().getVhost().getBareJID();
    }

    @Override
    public String getDiscoCategoryType() {
        return this.identity_type;
    }

    @Override
    public String getDiscoDescription() {
        return "VHost Manager";
    }

    @Override
    public void getStatistics(StatisticsList list) {
        list.add(this.getName(), "Number of VHosts", this.repo.size(), Level.FINE);
        list.add(this.getName(), "Checks: is local domain", this.isLocalDomainCalls, Level.FINER);
        list.add(this.getName(), "Checks: is anonymous domain", this.isAnonymousEnabledCalls, Level.FINER);
        list.add(this.getName(), "Get components for local domain", this.getComponentsForLocalDomainCalls, Level.FINER);
        list.add(this.getName(), "Get components for non-local domain", this.getComponentsForNonLocalDomainCalls, Level.FINER);
    }

    @Override
    public VHostItem getVHostItem(String domain) {
        return (VHostItem)this.repo.getItem(domain);
    }

    @Override
    public VHostItem getVHostItemDomainOrComponent(String domain) {
        int idx;
        VHostItem item = this.getVHostItem(domain);
        if (item == null && (idx = domain.indexOf(46)) > 0) {
            String name = domain.substring(0, idx);
            String basedomain = domain.substring(idx + 1);
            VHostListener listener = (VHostListener)this.components.get(name);
            if (listener != null && listener.handlesNameSubdomains()) {
                item = this.getVHostItem(basedomain);
            }
        }
        return item;
    }

    @Override
    public boolean isAnonymousEnabled(String domain) {
        ++this.isAnonymousEnabledCalls;
        VHostItem vhost = (VHostItem)this.repo.getItem(domain);
        if (vhost == null) {
            return false;
        }
        return vhost.isAnonymousEnabled();
    }

    @Override
    public boolean isCorrectType(ServerComponent component) {
        return component instanceof VHostListener;
    }

    @Override
    public boolean isLocalDomain(String domain) {
        ++this.isLocalDomainCalls;
        return this.repo.contains(domain);
    }

    @Override
    public boolean isLocalDomainOrComponent(String domain) {
        int idx;
        boolean result = this.isLocalDomain(domain);
        if (!result) {
            result = this.registeredComponentDomains.contains(domain);
        }
        if (!result && (idx = domain.indexOf(46)) > 0) {
            String name = domain.substring(0, idx);
            String basedomain = domain.substring(idx + 1);
            VHostListener listener = (VHostListener)this.components.get(name);
            result = listener != null && listener.handlesNameSubdomains() && this.isLocalDomain(basedomain);
        }
        return result;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    public void initializeRepository() throws TigaseDBException {
        this.repo.reload();
    }

    public String generateSecret() {
        String random = UUID.randomUUID().toString();
        return random;
    }

    public ComponentRepository<VHostItem> getComponentRepository() {
        return this.repo;
    }

    @Bean(name="vhostRepository", parent=VHostManager.class, active=true)
    public static class DefVHostRepositoryBean
    extends AbstractSDComponentRepositoryBean<VHostItem>
    implements VHostComponentRepository {
        private static DataSourceHelper.Matcher matcher = clazz -> ReflectionHelper.classMatchesClassWithParameters(clazz, VHostComponentRepositoryDataSourceAware.class, new Type[]{DataSource.class});

        @Override
        public VHostItem getDefaultVHostItem() {
            return ((VHostComponentRepository)this.getRepository()).getDefaultVHostItem();
        }

        @Override
        protected Class<? extends VHostComponentRepositoryDataSourceAware<DataSource>> findClassForDataSource(DataSource dataSource) throws DBInitException {
            Class<VHostComponentRepository> cls = DataSourceHelper.getDefaultClass(VHostComponentRepository.class, dataSource.getResourceUri(), matcher);
            return cls;
        }
    }
}

