/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.reflection;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.util.ClassComparator;
import tigase.util.ClassUtil;

public class ClassUtilBean {
    private static final String[] DEFAULT_PACKAGES_TO_SKIP = new String[]{"com.fasterxml.jackson", "com.mongodb", "org.bson", "com.mysql", "com.notnoop", "javax.jmdns", "javax.mail", "javax.servlet", "org.apache.commons", "org.apache.derby", "org.apache.felix", "org.apache.http.client", "org.apache.xml", "org.bouncycastle", "org.eclipse.jetty", "org.hamcrest.core", "org.postgresql", "org.slf4j", "ch.qos.logback", "com.sun", "groovy", "org.codehaus.groovy", "org.netbeans", "org.python", "tigase.jaxmpp", "tigase.pubsub.Utils"};
    private static ClassUtilBean instance;
    private static Logger log;
    protected HashSet<Class<?>> classes = new HashSet();

    public static List<String> getPackagesToSkip(String[] packagesToSkip) {
        if (packagesToSkip == null) {
            return Arrays.asList(DEFAULT_PACKAGES_TO_SKIP);
        }
        return Stream.concat(Arrays.stream(DEFAULT_PACKAGES_TO_SKIP), Arrays.stream(packagesToSkip)).distinct().collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassUtilBean getInstance() {
        Class<ClassUtilBean> clazz = ClassUtilBean.class;
        synchronized (ClassUtilBean.class) {
            if (instance == null) {
                ClassUtilBean instance = new ClassUtilBean();
                instance.initialize(ClassUtilBean.getPackagesToSkip(null));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Collection<String> skipPackages) {
        try {
            Predicate<String> filter = null;
            if (skipPackages == null) {
                filter = className -> true;
            } else {
                List packages = skipPackages.stream().map(packageName -> packageName + ".").collect(Collectors.toList());
                filter = className -> {
                    for (String packageName : packages) {
                        if (!className.startsWith(packageName)) continue;
                        return false;
                    }
                    return true;
                };
            }
            this.classes.addAll(ClassUtil.getClassesFromClassPath(filter));
            this.classes.addAll(this.getClassesFromSurefireClassLoader());
        }
        catch (IOException | ClassNotFoundException e) {
            log.log(Level.SEVERE, "Could not initialize list of classes", e);
        }
        Class<ClassUtilBean> clazz = ClassUtilBean.class;
        synchronized (ClassUtilBean.class) {
            instance = this;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public Set<Class<?>> getAllClasses() {
        return Collections.unmodifiableSet(this.classes);
    }

    private Set<Class<?>> getClassesFromSurefireClassLoader() {
        TreeSet classes_set = new TreeSet((Comparator<Class<?>>)new ClassComparator());
        String classpath = System.getProperty("surefire.test.class.path");
        if (classpath == null) {
            return classes_set;
        }
        StringTokenizer stok = new StringTokenizer(classpath, File.pathSeparator, false);
        while (stok.hasMoreTokens()) {
            String path = stok.nextToken();
            File file = new File(path);
            if (!file.exists()) continue;
            try {
                Set class_names;
                if (file.isDirectory()) {
                    class_names = ClassUtil.getClassNamesFromDir((File)file);
                    tigase.osgi.util.ClassUtil.getClassesFromNames(Thread.currentThread().getContextClassLoader(), class_names).stream().forEach(classes_set::add);
                }
                if (!file.isFile()) continue;
                class_names = ClassUtil.getClassNamesFromJar((File)file);
                tigase.osgi.util.ClassUtil.getClassesFromNames(Thread.currentThread().getContextClassLoader(), class_names).stream().forEach(classes_set::add);
            }
            catch (IOException | ClassNotFoundException ex) {
                log.log(Level.WARNING, "Could not load classes for " + file.getAbsolutePath());
            }
        }
        return classes_set;
    }

    static {
        log = Logger.getLogger(ClassUtilBean.class.getCanonicalName());
    }
}

