/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.log;

import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.LogRecord;
import tigase.util.log.LogFormatter;
import tigase.xmpp.XMPPSession;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class LogUserFilter
implements Filter {
    Map<BareJID, XMPPSession> sessionsByNodeId = null;
    private LogFormatter format = new LogFormatter();
    private BareJID jid = null;
    private XMPPSession tracker = null;

    public LogUserFilter(BareJID jid, Map<BareJID, XMPPSession> sessionsByNodeId) {
        this.jid = jid;
        this.sessionsByNodeId = sessionsByNodeId;
    }

    public String getId() {
        return this.jid.toString();
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        String msg;
        boolean matchTracker = false;
        if (this.tracker == null || this.tracker.getActiveResourcesSize() == 0) {
            this.tracker = this.sessionsByNodeId.get(this.jid);
        }
        if (this.tracker != null && (msg = this.format.format(record)) != null) {
            int i;
            JID[] trackers;
            if (!matchTracker && (trackers = this.tracker.getConnectionIds()) != null && trackers.length > 0) {
                i = 0;
                while (!matchTracker && i < trackers.length) {
                    matchTracker = msg.contains(trackers[i++].toString());
                }
            }
            if (!matchTracker && (trackers = this.tracker.getJIDs()) != null && trackers.length > 0) {
                i = 0;
                while (!matchTracker && i < trackers.length) {
                    matchTracker = msg.contains(trackers[i++].toString());
                }
            }
        }
        return matchTracker;
    }
}

