/*
 * Decompiled with CFR 0.152.
 */
package tigase.sys;

import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.JMException;
import javax.management.ObjectName;
import tigase.sys.NMTScope;

public class NativeMemoryTracking {
    private static final Logger log = Logger.getLogger(NativeMemoryTracking.class.getName());
    private static final Pattern subScopeHeaderPattern = Pattern.compile("^-\\s+([\\w\\s]+)\\(reserved=(\\d+)[GKM]B, committed=(\\d+)[GKM]B\\).*");
    private static final Pattern mmapPattern = Pattern.compile("^\\s+\\(mmap: reserved=(\\d+)[GKM]B, committed=(\\d+)[GKM]B\\).*");
    private static final Pattern mallocArenaPattern = Pattern.compile("^\\s*\\((malloc|arena)=(\\d+)[GKM]B.*\\).*");
    private final SCALE scale;
    private final Map<String, NMTScope> scopes;

    private static String executeMBeanCommand(String command2, String ... args) throws JMException {
        return (String)ManagementFactory.getPlatformMBeanServer().invoke(new ObjectName("com.sun.management:type=DiagnosticCommand"), command2, new Object[]{args}, new String[]{"[Ljava.lang.String;"});
    }

    private static Map<String, NMTScope> getNMTScopesFrom(String summary) {
        ConcurrentHashMap<String, NMTScope> scopes = new ConcurrentHashMap<String, NMTScope>();
        String[] summaryLines = summary.split("\\r?\\n");
        for (int currentLine = 0; currentLine < summaryLines.length; ++currentLine) {
            String summaryLine = summaryLines[currentLine];
            if (summaryLine.startsWith("Total")) {
                NativeMemoryTracking.processTotalScope(scopes, summaryLine);
                continue;
            }
            if (!summaryLine.startsWith("-")) continue;
            currentLine = NativeMemoryTracking.processSubScope(scopes, summaryLines, currentLine);
        }
        return scopes;
    }

    static Optional<NativeMemoryTracking> getNativeMemoryTracking() {
        return NativeMemoryTracking.getNativeMemoryTracking(SCALE.MB);
    }

    static Optional<NativeMemoryTracking> getNativeMemoryTracking(SCALE scale) {
        Optional<String> nativeMemoryTrackingSummary = NativeMemoryTracking.getNativeMemoryTrackingTextSummary(scale);
        return nativeMemoryTrackingSummary.flatMap(summary -> NativeMemoryTracking.parse(summary, scale));
    }

    private static Optional<String> getNativeMemoryTrackingTextSummary(SCALE scale) {
        String result = null;
        try {
            result = NativeMemoryTracking.executeMBeanCommand("vmNativeMemory", "summary", "scale=" + scale);
        }
        catch (Exception e) {
            log.log(Level.FINER, e, () -> "There was a problem obtaining NMT summary");
        }
        return Optional.ofNullable(result);
    }

    public static void main(String[] args) {
        System.out.println(NativeMemoryTracking.getNativeMemoryTracking(SCALE.MB));
    }

    static Optional<NativeMemoryTracking> parse(String summary) {
        return NativeMemoryTracking.parse(summary, SCALE.KB);
    }

    static Optional<NativeMemoryTracking> parse(String summary, SCALE scale) {
        Map<String, NMTScope> scopes = NativeMemoryTracking.getNMTScopesFrom(summary);
        return scopes != null && !scopes.isEmpty() ? Optional.of(new NativeMemoryTracking(scopes, scale)) : Optional.empty();
    }

    private static void processMallocAndArena(NMTScope.NMTScopeBuilder scopeBuilder, String subSummaryLine, Matcher mallocArenaMatcher) {
        String type;
        switch (type = mallocArenaMatcher.group(1)) {
            case "malloc": {
                NativeMemoryTracking.tryParsingMatched(mallocArenaMatcher.group(2), subSummaryLine).ifPresent(scopeBuilder::withMalloc);
                break;
            }
            case "arena": {
                NativeMemoryTracking.tryParsingMatched(mallocArenaMatcher.group(2), subSummaryLine).ifPresent(scopeBuilder::withArena);
            }
        }
    }

    private static void processMmap(NMTScope.NMTScopeBuilder scopeBuilder, String subSummaryLine, Matcher mmapMatcher) {
        NativeMemoryTracking.tryParsingMatched(mmapMatcher.group(1), subSummaryLine).ifPresent(scopeBuilder::withMmapReserved);
        NativeMemoryTracking.tryParsingMatched(mmapMatcher.group(2), subSummaryLine).ifPresent(scopeBuilder::withMmapCommitted);
    }

    private static int processSubScope(Map<String, NMTScope> scopes, String[] summaryLines, int currentLine) {
        Matcher subScopeHeaderMatcher = subScopeHeaderPattern.matcher(summaryLines[currentLine]);
        if (subScopeHeaderMatcher.matches()) {
            String scope = subScopeHeaderMatcher.group(1).trim();
            Long reserverd = Long.valueOf(subScopeHeaderMatcher.group(2));
            Long commited = Long.valueOf(subScopeHeaderMatcher.group(3));
            NMTScope.NMTScopeBuilder scopeBuilder = NMTScope.NMTScopeBuilder.aNMTScope(scope, reserverd, commited);
            while (currentLine + 1 < summaryLines.length && !summaryLines[currentLine + 1].startsWith("-")) {
                Matcher mallocArenaMatcher;
                String subSummaryLine;
                Matcher mmapMatcher;
                if ((mmapMatcher = mmapPattern.matcher(subSummaryLine = summaryLines[currentLine++])).matches()) {
                    NativeMemoryTracking.processMmap(scopeBuilder, subSummaryLine, mmapMatcher);
                }
                if (!(mallocArenaMatcher = mallocArenaPattern.matcher(subSummaryLine)).matches()) continue;
                NativeMemoryTracking.processMallocAndArena(scopeBuilder, subSummaryLine, mallocArenaMatcher);
            }
            NMTScope tmpScope = scopeBuilder.build();
            scopes.put(tmpScope.getScopeType(), tmpScope);
        }
        return currentLine;
    }

    private static void processTotalScope(Map<String, NMTScope> scopes, String summaryLine) {
        Pattern compile = Pattern.compile("Total: reserved=(\\d+)[GKM]B, committed=(\\d+)[GKM]B");
        Matcher matcher = compile.matcher(summaryLine);
        if (matcher.matches()) {
            NMTScope total = new NMTScope("Total", Long.valueOf(matcher.group(1)), Long.valueOf(matcher.group(2)));
            scopes.put(total.getScopeType(), total);
        }
    }

    private static Optional<Long> tryParsingMatched(String matched, String line) {
        try {
            return Optional.of(Long.valueOf(matched));
        }
        catch (NumberFormatException e) {
            log.log(Level.WARNING, e, () -> "Can''t parse string: " + matched + " from line: " + line);
            return Optional.empty();
        }
    }

    public NativeMemoryTracking(Map<String, NMTScope> scopes) {
        this(scopes, SCALE.MB);
    }

    public NativeMemoryTracking(Map<String, NMTScope> scopes, SCALE scale) {
        Objects.nonNull(scopes);
        this.scopes = scopes;
        this.scale = scale;
    }

    public Map<String, NMTScope> getScopes() {
        return Collections.unmodifiableMap(this.scopes);
    }

    public SCALE getScale() {
        return this.scale;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("scopes: ").append(this.scopes.size());
        NMTScope totalScope = this.scopes.get(NMTScope.COMMON_SCOPES.TOTAL.name);
        if (totalScope != null) {
            sb.append(", total reserved: ").append(totalScope.getReserved()).append(", total commited: ").append(totalScope.getCommitted()).append(", scale: ").append((Object)this.scale);
        }
        return sb.toString();
    }

    static enum SCALE {
        KB,
        MB,
        GB;

    }
}

