/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppsession;

import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;
import java.security.cert.CertificateFactory;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.annotations.TigaseDeprecated;
import tigase.component.ComponenScriptCommandProcessor;
import tigase.component.PacketWriter;
import tigase.component.adhoc.AdHocCommandManager;
import tigase.component.exceptions.ComponentException;
import tigase.component.modules.impl.AdHocCommandModule;
import tigase.component.responses.AsyncCallback;
import tigase.conf.Configurable;
import tigase.db.AuthRepository;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.eventbus.EventBus;
import tigase.eventbus.EventBusFactory;
import tigase.eventbus.HandleEvent;
import tigase.eventbus.events.ShutdownEvent;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.selector.ClusterModeRequired;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.core.Kernel;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.MessageRouter;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.server.ReceiverTimeoutHandler;
import tigase.server.XMPPServer;
import tigase.server.xmppclient.StreamManagementCommand;
import tigase.server.xmppsession.PacketDefaultHandler;
import tigase.server.xmppsession.SMResourceConnection;
import tigase.server.xmppsession.SessionManagerHandler;
import tigase.server.xmppsession.UserConnectedEvent;
import tigase.server.xmppsession.UserPresenceChangedEvent;
import tigase.stats.MaxDailyCounterQueue;
import tigase.stats.StatisticsList;
import tigase.sys.OnlineJidsReporter;
import tigase.sys.TigaseRuntime;
import tigase.util.Base64;
import tigase.util.common.TimerTask;
import tigase.util.processing.ProcessingThreads;
import tigase.util.processing.QueueItem;
import tigase.util.processing.WorkerThread;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostItemImpl;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.InvalidPacketException;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPImplIfc;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPPostprocessorIfc;
import tigase.xmpp.XMPPPreprocessorIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorConcurrencyAwareIfc;
import tigase.xmpp.XMPPProcessorException;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;
import tigase.xmpp.XMPPStopListenerIfc;
import tigase.xmpp.impl.C2SDeliveryErrorProcessor;
import tigase.xmpp.impl.PresenceCapabilitiesManager;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="sess-man", parent=Kernel.class, active=true, exportable=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode, ConfigTypeEnum.SessionManagerMode})
@ClusterModeRequired(active=false)
public class SessionManager
extends AbstractMessageReceiver
implements Configurable,
SessionManagerHandler,
OnlineJidsReporter,
RegistrarBean {
    protected static final String ADMIN_COMMAND_NODE = "http://jabber.org/protocol/admin";
    private static final Logger log = Logger.getLogger(SessionManager.class.getName());
    private static final String SESSION_CLOSE_TIMER_KEY = "session-close-timer";
    protected ConcurrentHashMap<JID, XMPPResourceConnection> connectionsByFrom = new ConcurrentHashMap(100000);
    protected ConcurrentHashMap<BareJID, XMPPSession> sessionsByNodeId = new ConcurrentHashMap(100000);
    private int activeUserNumber = 0;
    @ConfigField(desc="ActiveUsers timeframe", alias="active-user-timeframe")
    private long activeUserTimeframe = 300000L;
    @Inject
    private AdHocCommandModule adHocCommandModule;
    @Inject
    private ConcurrentSkipListSet<XMPPImplIfc> allPlugins = new ConcurrentSkipListSet();
    @ConfigField(desc="Authentication timeout", alias="auth-timeout")
    private long authTimeout = 120L;
    private long authTimeouts = 0L;
    @Inject
    private AuthRepository auth_repository = null;
    private long closedConnections = 0L;
    private ConnectionCheckCommandHandler connectionCheckCommandHandler = new ConnectionCheckCommandHandler();
    @ConfigField(desc="Period after which connection may be checked when authenticating a new session")
    private long connectionCheckPeriod = 30000L;
    @Inject
    private DefaultHandlerProc defHandlerProc = null;
    private PacketDefaultHandler defPacketHandler = new PacketDefaultHandler();
    private String defPluginsThreadsPool = "default-threads-pool";
    private EventBus eventBus = EventBusFactory.getInstance();
    @ConfigField(desc="Force detail check of stale connections", alias="stale-connection-closer-queue-size")
    private boolean forceDetailStaleConnectionCheck = true;
    private Kernel kernel = null;
    private Calendar lastDailyStatsReset = Calendar.getInstance();
    private int maxDailyUsersConnectionsWithinLastWeek = 0;
    private MaxDailyCounterQueue<Integer> maxDailyUsersSessions = new MaxDailyCounterQueue(31);
    private int maxIdx = 100;
    private int maxUserConnections = 0;
    private int maxUserSessions = 0;
    private int maxUserSessionsDaily = 0;
    private int maxUserSessionsYesterday = 0;
    private Long activeUsersLastDay = null;
    private Long activeUsersLastWeek = null;
    private Long activeUsersLast30Days = null;
    @Inject
    private NonAuthUserRepository naUserRepository;
    private NodeShutdownTask nodeShutdownTask = new NodeShutdownTask();
    private Map<String, XMPPPacketFilterIfc> outFilters = new ConcurrentHashMap<String, XMPPPacketFilterIfc>(10);
    @Deprecated
    @TigaseDeprecated(since="8.0.0")
    private Map<String, Map<String, Object>> plugin_config = new ConcurrentHashMap<String, Map<String, Object>>(20);
    @ConfigField(desc="Factor for number of threads per plugin", alias="sm-threads-factor")
    private int pluginsThreadFactor = 1;
    private Map<String, XMPPPostprocessorIfc> postProcessors = new ConcurrentHashMap<String, XMPPPostprocessorIfc>(10);
    private Map<String, long[]> postTimes = new ConcurrentSkipListMap<String, long[]>();
    private Map<String, XMPPPreprocessorIfc> preProcessors = new ConcurrentHashMap<String, XMPPPreprocessorIfc>(10);
    private Map<String, XMPPProcessorIfc> processors = new ConcurrentHashMap<String, XMPPProcessorIfc>(32);
    @Inject(nullAllowed=true)
    private MessageRouter router;
    @Inject
    private SessionCloseProc sessionCloseProc = null;
    @Inject
    private SessionOpenProc sessionOpenProc = null;
    @ConfigField(desc="Include CAPS in stream features")
    private boolean includeCapsInStream = true;
    @ConfigField(desc="Skip privacy check", alias="skip-privacy")
    private boolean skipPrivacy = false;
    @ConfigField(desc="Max no. of connections single user can user", alias="user-connections-limit")
    private Integer singleUserConnectionsLimit = null;
    private SMResourceConnection smResourceConnection = null;
    @ConfigField(desc="Default processors threads pool size", alias="sm-threads-pool")
    private String smThreadsPool = "default";
    @Inject(nullAllowed=true)
    protected MessageArchive messageArchive = null;
    private StaleConnectionCloser staleConnectionCloser = new StaleConnectionCloser();
    private Map<String, XMPPStopListenerIfc> stopListeners = new ConcurrentHashMap<String, XMPPStopListenerIfc>(10);
    private int tIdx = 0;
    private long totalUserConnections = 0L;
    private long totalUserSessions = 0L;
    @Inject
    private UserRepository user_repository = null;
    private Map<String, ProcessingThreads<ProcessorWorkerThread>> workerThreads = new ConcurrentHashMap<String, ProcessingThreads<ProcessorWorkerThread>>(32);

    @Override
    public boolean addOutPacket(Packet packet) {
        if (packet.getPacketFrom() == null) {
            packet.setPacketFrom(this.getComponentId());
        }
        return super.addOutPacket(packet);
    }

    public XMPPImplIfc addPlugin(XMPPImplIfc proc) throws ClassNotFoundException, InstantiationException, IllegalAccessException, TigaseDBException {
        boolean loaded = false;
        if (proc instanceof XMPPProcessorIfc) {
            int threadsNo = proc.concurrentQueuesNo();
            int queueSize = this.maxQueueSize / threadsNo;
            boolean requireNewPool = false;
            if (proc instanceof XMPPProcessorConcurrencyAwareIfc) {
                XMPPProcessorConcurrencyAwareIfc procca = (XMPPProcessorConcurrencyAwareIfc)((Object)proc);
                if (threadsNo != procca.getThreadsNo()) {
                    threadsNo = procca.getThreadsNo();
                    log.log(Level.CONFIG, "Concurrency for plugin: {0} set to: {1}", new Object[]{proc.id(), threadsNo});
                    requireNewPool = true;
                }
                if (procca.getQueueSize() != null) {
                    queueSize = procca.getQueueSize();
                    log.log(Level.CONFIG, "Queue for plugin: {0} set to: {1} per thread", new Object[]{proc.id(), queueSize});
                    requireNewPool = true;
                } else {
                    queueSize = this.maxQueueSize / threadsNo;
                }
            }
            threadsNo *= this.pluginsThreadFactor;
            if ((this.workerThreads.get(this.defPluginsThreadsPool) == null || requireNewPool) && !this.workerThreads.containsKey(proc.id())) {
                ProcessorWorkerThread worker = new ProcessorWorkerThread();
                ProcessingThreads<ProcessorWorkerThread> pt = new ProcessingThreads<ProcessorWorkerThread>(worker, threadsNo, queueSize, proc.id());
                this.workerThreads.put(proc.id(), pt);
                log.log(Level.CONFIG, "Created thread pool: {0}, queue per thread: {1} for plugin id: {2}", new Object[]{threadsNo, queueSize, proc.id()});
            }
            this.processors.put(proc.id(), (XMPPProcessorIfc)proc);
            log.log(Level.CONFIG, "Added processor: {0} for plugin id: {1}", new Object[]{proc.getClass().getSimpleName(), proc.id()});
            loaded = true;
            String version = proc.getComponentInfo().getComponentVersion();
            log.log(Level.INFO, "Loading plugin: " + proc.id() + "=" + threadsNo + ":" + queueSize + " ... " + (String)(version.isEmpty() ? "" : "\t, version: " + version));
        }
        if (proc instanceof XMPPPreprocessorIfc) {
            this.preProcessors.put(proc.id(), (XMPPPreprocessorIfc)proc);
            log.log(Level.CONFIG, "Added preprocessor: {0} for plugin id: {1}", new Object[]{proc.getClass().getSimpleName(), proc.id()});
            loaded = true;
        }
        if (proc instanceof XMPPPostprocessorIfc) {
            this.postProcessors.put(proc.id(), (XMPPPostprocessorIfc)proc);
            log.log(Level.CONFIG, "Added postprocessor: {0} for plugin id: {1}", new Object[]{proc.getClass().getSimpleName(), proc});
            loaded = true;
        }
        if (proc instanceof XMPPStopListenerIfc) {
            this.stopListeners.put(proc.id(), (XMPPStopListenerIfc)proc);
            log.log(Level.CONFIG, "Added stopped processor: {0} for plugin id: {1}", new Object[]{proc.getClass().getSimpleName(), proc.id()});
            loaded = true;
        }
        if (proc instanceof XMPPPacketFilterIfc) {
            this.outFilters.put(proc.id(), (XMPPPacketFilterIfc)proc);
            log.log(Level.CONFIG, "Added packet filter: {0} for plugin id: {1}", new Object[]{proc.getClass().getSimpleName(), proc.id()});
            loaded = true;
        }
        if (!loaded) {
            log.log(Level.WARNING, "No implementation found for plugin id: {0}", proc.id());
        }
        if (proc != null) {
            if (this.allPlugins.add(proc)) {
                HashMap<String, Object> settings = new HashMap<String, Object>();
                try {
                    Method m = proc.getClass().getDeclaredMethod("init", Map.class);
                    if (m.getAnnotation(Deprecated.class) == null) {
                        log.log(Level.WARNING, "processor " + proc.getClass().getCanonicalName() + " is using deprecated init() method!");
                        proc.init(settings);
                    }
                }
                catch (NoSuchMethodException | SecurityException exception) {
                    // empty catch block
                }
                this.eventBus.registerAll(proc);
            }
            if (proc instanceof PresenceCapabilitiesManager.PresenceCapabilitiesListener) {
                PresenceCapabilitiesManager.registerPresenceHandler((PresenceCapabilitiesManager.PresenceCapabilitiesListener)((Object)proc));
            }
        }
        return proc;
    }

    @Override
    public boolean containsJid(BareJID jid) {
        return this.sessionsByNodeId.containsKey(jid);
    }

    @Override
    public boolean containsJidLocally(BareJID jid) {
        return this.sessionsByNodeId.containsKey(jid);
    }

    @Override
    public boolean containsJidLocally(JID jid) {
        XMPPSession session = this.sessionsByNodeId.get(jid.getBareJID());
        return session != null && session.getResourceForJID(jid) != null;
    }

    public void handleLocalPacket(Packet packet, XMPPResourceConnection conn) {
    }

    @Override
    public void handleLogin(BareJID userId, XMPPResourceConnection conn) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "handleLogin called for: {0}, conn_id: {1}", new Object[]{userId, conn});
        }
        this.registerNewSession(userId, conn);
    }

    @Override
    public void handleLogout(BareJID userId, XMPPResourceConnection conn) {
        this.closeSession(conn, false);
        try {
            this.connectionsByFrom.remove(conn.getConnectionId());
            Packet cmd = Command.CLOSE.getPacket(this.getComponentId(), conn.getConnectionId(), StanzaType.set, conn.nextStanzaId());
            String error = (String)conn.getSessionData("error-key");
            if (error != null) {
                Element err_el = new Element(error);
                err_el.setXMLNS("urn:ietf:params:xml:ns:xmpp-streams");
                cmd.getElement().getChild("command").addChild((XMLNodeIfc)err_el);
            }
            this.fastAddOutPacket(cmd);
        }
        catch (NoConnectionIdException ex) {
            log.log(Level.WARNING, "Connection ID not set for session: {0}", conn);
        }
    }

    @Override
    public void handlePresenceSet(XMPPResourceConnection conn) {
        XMPPSession parentSession = conn.getParentSession();
        if (parentSession == null) {
            return;
        }
        Element presence = conn.getPresence();
        this.processPresenceUpdate(parentSession, presence);
    }

    @Override
    public void handleResourceBind(XMPPResourceConnection conn) {
        if (!(conn.isServerSession() || "USER_STATUS".equals(conn.getSessionId()) || conn.isTmpSession())) {
            try {
                Packet user_login_cmd = Command.USER_LOGIN.getPacket(this.getComponentId(), conn.getConnectionId(), StanzaType.set, conn.nextStanzaId(), Command.DataType.submit);
                Command.addFieldValue(user_login_cmd, "user-jid", conn.getjid().toString());
                this.addOutPacket(user_login_cmd);
                this.eventBus.fire(new UserConnectedEvent(conn.getjid()));
            }
            catch (NoConnectionIdException ex) {
                log.log(Level.WARNING, "This should not happen, check it out!, ", ex);
            }
            this.checkSingleUserConnectionsLimit(conn);
        }
    }

    protected void checkSingleUserConnectionsLimit(XMPPResourceConnection conn) {
        int overlimit;
        XMPPSession session;
        if (this.getSingleUserConnectionsLimit() != null && (session = conn.getParentSession()) != null && (overlimit = session.getActiveResourcesSize() - this.getSingleUserConnectionsLimit()) > 0) {
            session.getActiveResources().stream().sorted(Comparator.comparing(XMPPResourceConnection::getCreationTime)).limit(overlimit).forEach(connToStop -> {
                connToStop.putSessionData("error-key", "resource-constraint");
                try {
                    connToStop.logout();
                }
                catch (NotAuthorizedException ex) {
                    log.log(Level.CONFIG, "Exception during closing old connection, ignoring.", ex);
                }
                session.removeResourceConnection((XMPPResourceConnection)connToStop);
            });
        }
    }

    @Override
    public boolean handlesLocalDomains() {
        return true;
    }

    @Override
    public int hashCodeForPacket(Packet packet) {
        if (packet.getPacketFrom() != null && !this.getComponentId().equals((Object)packet.getPacketFrom())) {
            return packet.getPacketFrom().hashCode();
        }
        return super.hashCodeForPacket(packet);
    }

    @Override
    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put("authRepository", (Object)this.auth_repository);
        binds.put("userConnections", (Object)this.connectionsByFrom);
        binds.put("userRepository", (Object)this.user_repository);
        binds.put("userSessions", (Object)this.sessionsByNodeId);
        binds.put("kernel", (Object)this.kernel);
        binds.put("eventBus", (Object)this.eventBus);
    }

    @Override
    public int processingInThreads() {
        return Runtime.getRuntime().availableProcessors() * 8;
    }

    @Override
    public int processingOutThreads() {
        return Runtime.getRuntime().availableProcessors() * 8;
    }

    @Override
    public void processPacket(Packet packet) {
        XMPPResourceConnection conn;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Received packet: {0}", packet.toStringSecure());
        }
        if (packet.isCommand() && this.processCommand(packet)) {
            packet.processedBy("SessionManager");
            return;
        }
        if (this.messageArchive != null) {
            this.messageArchive.generateStableId(packet);
        }
        if ((conn = this.getXMPPResourceConnection(packet)) == null && this.isBrokenPacket(packet) || this.processAdminsOrDomains(packet)) {
            return;
        }
        this.processPacket(packet, conn);
    }

    public void removePlugin(XMPPImplIfc proc) {
        String plug_id = proc.id();
        this.removePlugin(plug_id);
    }

    public void removePlugin(String plug_id) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Removing plugin {0}", plug_id);
        }
        XMPPImplIfc p = null;
        ProcessingThreads<ProcessorWorkerThread> pt = this.workerThreads.remove(plug_id);
        if (pt != null) {
            p = this.processors.remove(plug_id);
            pt.shutdown();
            if (p != null) {
                this.allPlugins.remove(p);
            }
        }
        if (this.preProcessors.get(plug_id) != null) {
            p = this.preProcessors.remove(plug_id);
            this.allPlugins.remove(p);
        }
        if (this.postProcessors.get(plug_id) != null) {
            p = this.postProcessors.remove(plug_id);
            this.allPlugins.remove(p);
        }
        if (this.stopListeners.get(plug_id) != null) {
            p = this.stopListeners.remove(plug_id);
            this.allPlugins.remove(p);
        }
        if (p != null) {
            this.eventBus.unregisterAll(p);
            if (p instanceof PresenceCapabilitiesManager.PresenceCapabilitiesListener) {
                PresenceCapabilitiesManager.unregisterPresenceHandler((PresenceCapabilitiesManager.PresenceCapabilitiesListener)((Object)p));
            }
        }
    }

    public boolean skipPrivacy() {
        return this.skipPrivacy;
    }

    @Override
    public void start() {
        super.start();
        if (!this.staleConnectionCloser.isScheduled()) {
            this.addTimerTask(this.staleConnectionCloser, this.staleConnectionCloser.getTimeout());
        }
        this.eventBus.registerAll(this);
    }

    @Override
    public void stop() {
        this.eventBus.unregisterAll(this);
        super.stop();
        ArrayList<String> pluginsToStop = new ArrayList<String>(this.workerThreads.keySet());
        for (String plugin_id : pluginsToStop) {
            try {
                this.removePlugin(plugin_id);
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Exception while stopping plugin", ex);
            }
        }
    }

    @Override
    public JID[] getConnectionIdsForJid(BareJID jid) {
        XMPPSession session;
        if (this.skipPrivacy() && (session = this.sessionsByNodeId.get(jid)) != null) {
            return session.getConnectionIds();
        }
        return null;
    }

    @Override
    public String getDiscoCategoryType() {
        return "sm";
    }

    @Override
    public String getDiscoDescription() {
        return "Session manager";
    }

    @Override
    public List<Element> getDiscoFeatures(JID from) {
        LinkedList<Element> features = new LinkedList<Element>();
        List<Element> tmp = super.getDiscoFeatures(from);
        if (tmp != null) {
            features.addAll(tmp);
        }
        for (XMPPProcessorIfc proc_t : this.processors.values()) {
            Element[] discoFeatures = proc_t.supDiscoFeatures(null);
            if (discoFeatures == null) continue;
            features.addAll(Arrays.asList(discoFeatures));
        }
        return features;
    }

    @Override
    public Element getDiscoInfo(String node, JID jid, JID from) {
        if (jid != null && (this.getName().equals(jid.getLocalpart()) || this.isLocalDomain(jid.toString()))) {
            Element query = super.getDiscoInfo(node, jid, from);
            if (query == null) {
                query = new Element("query");
                query.setXMLNS("http://jabber.org/protocol/disco#info");
            }
            if (node == null) {
                for (XMPPProcessorIfc proc_t : this.processors.values()) {
                    Element[] discoFeatures = proc_t.supDiscoFeatures(null);
                    if (discoFeatures == null) continue;
                    query.addChildren(Arrays.asList(discoFeatures));
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Found disco info: {0}", query != null ? query.toString() : null);
            }
            return query;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Not found disco info for node: {0}, jid: {1}", new Object[]{node, jid});
        }
        return null;
    }

    @Override
    public List<Element> getDiscoItems(String node, JID jid, JID from) {
        if ("http://jabber.org/protocol/commands".equals(node)) {
            return this.adHocCommandModule.getScriptItems(node, jid, from);
        }
        return super.getDiscoItems(node, jid, from);
    }

    public XMPPResourceConnection getResourceConnection(JID jid) {
        XMPPSession session = this.getSession(jid.getBareJID());
        if (session != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Session not null, searching session for jid: {0}", jid);
            }
            XMPPResourceConnection res = session.getResourceConnection(jid);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Found session: {0}, for jid: {1}", new Object[]{res, jid});
            }
            return res;
        }
        if (this.isLocalDomain(jid.toString(), false)) {
            return this.smResourceConnection;
        }
        return null;
    }

    public int getOpenUsersConnectionsAmount() {
        return this.connectionsByFrom.size();
    }

    public Integer getSingleUserConnectionsLimit() {
        return this.singleUserConnectionsLimit;
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        if (list.checkLevel(Level.FINEST)) {
            list.add(this.getName(), "Registered accounts", this.user_repository.getUsersCount(), Level.FINEST);
        }
        list.add(this.getName(), "Open user connections", this.connectionsByFrom.size(), Level.INFO);
        list.add(this.getName(), "Maximum user connections", this.maxUserConnections, Level.INFO);
        list.add(this.getName(), "Total user connections", this.totalUserConnections, Level.FINER);
        list.add(this.getName(), "Closed user connections", this.closedConnections, Level.FINER);
        list.add(this.getName(), "Open user sessions", this.sessionsByNodeId.size(), Level.INFO);
        list.add(this.getName(), "Maximum user sessions", this.maxUserSessions, Level.FINE);
        list.add(this.getName(), "Total user sessions", this.totalUserSessions, Level.FINER);
        list.add(this.getName(), "Active user connections", this.activeUserNumber, Level.FINER);
        list.add(this.getName(), "Authentication timouts", this.authTimeouts, Level.INFO);
        if (list.checkLevel(Level.INFO)) {
            int totalQueuesWait = list.getValue(this.getName(), "Total queues wait", 0);
            long totalQueuesOverflow = list.getValue(this.getName(), "Total queues overflow", 0L);
            for (Map.Entry<String, ProcessingThreads<ProcessorWorkerThread>> procent : this.workerThreads.entrySet()) {
                ProcessingThreads<ProcessorWorkerThread> proc = procent.getValue();
                totalQueuesWait += proc.getTotalQueueSize();
                totalQueuesOverflow += proc.getDroppedPackets();
                if (!list.checkLevel(Level.INFO, (long)proc.getTotalQueueSize() + proc.getDroppedPackets())) continue;
                list.add(this.getName(), "Processor: " + procent.getKey(), ", Queue: " + proc.getTotalQueueSize() + ", AvTime: " + proc.getAverageProcessingTime() + ", Runs: " + proc.getTotalRuns() + ", Lost: " + proc.getDroppedPackets(), Level.INFO);
            }
            list.add(this.getName(), "Total queues wait", totalQueuesWait, Level.INFO);
            list.add(this.getName(), "Total queues overflow", totalQueuesOverflow, Level.INFO);
        }
        if (list.checkLevel(Level.FINE)) {
            Iterator<Map.Entry<String, long[]>> iterator = this.postTimes.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, long[]> tmEntry;
                Map.Entry<String, long[]> entry = tmEntry = iterator.next();
                list.add(this.getName(), "Average " + tmEntry.getKey() + " on last " + entry.getValue().length + " runs [ms]", this.calcAverage(entry.getValue()), Level.FINE);
            }
        }
        list.add(this.getName(), "Maximum user sessions today", this.maxUserSessionsDaily, Level.INFO);
        list.add(this.getName(), "Maximum user sessions yesterday", this.maxUserSessionsYesterday, Level.INFO);
        list.add(this.getName(), "Max daily users sessions count last month", this.maxDailyUsersSessions, Level.INFO);
        list.add(this.getName(), "Max users sessions within last week", this.maxDailyUsersConnectionsWithinLastWeek, Level.INFO);
        if (list.checkLevel(Level.FINE)) {
            if (this.activeUsersLastDay == null || this.activeUsersLastWeek == null || this.activeUsersLast30Days == null) {
                this.updateActiveUsersStatistics();
            }
            if (this.activeUsersLastDay != null) {
                list.add(this.getName(), "Active users within last 24h", this.activeUsersLastDay, Level.FINE);
            }
            if (this.activeUsersLastWeek != null) {
                list.add(this.getName(), "Active users within last 7 days", this.activeUsersLastWeek, Level.FINE);
            }
            if (this.activeUsersLast30Days != null) {
                list.add(this.getName(), "Active users within last 30 days", this.activeUsersLast30Days, Level.FINE);
            }
        }
        for (XMPPImplIfc plugin : this.allPlugins) {
            plugin.getStatistics(list);
        }
    }

    @Override
    public boolean hasCompleteJidsInfo() {
        return true;
    }

    @Override
    public boolean isLocalDomain(String domain, boolean includeComponents) {
        if (includeComponents) {
            return this.isLocalDomainOrComponent(domain);
        }
        return this.isLocalDomain(domain);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        TigaseRuntime.getTigaseRuntime().addOnlineJidsReporter(this);
    }

    public void setAllPlugins(ConcurrentSkipListSet<XMPPImplIfc> allPlugins) {
        ConcurrentSkipListSet<XMPPImplIfc> oldPlugins = this.allPlugins;
        HashSet<XMPPImplIfc> removed = new HashSet<XMPPImplIfc>(oldPlugins);
        removed.removeAll(allPlugins);
        for (XMPPImplIfc proc : removed) {
            this.removePlugin(proc);
        }
        HashSet<XMPPImplIfc> added = new HashSet<XMPPImplIfc>(allPlugins);
        added.removeAll(oldPlugins);
        for (XMPPImplIfc proc : added) {
            try {
                this.addPlugin(proc);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | TigaseDBException e) {
                log.log(Level.SEVERE, "Failed initialization of processor " + proc.id(), e);
            }
        }
    }

    public void setSmThreadsPool(String val) {
        this.smThreadsPool = val;
        if (!"default".equals(val)) {
            String[] threads_pool_params = val.split(":");
            int size = 100;
            if (threads_pool_params.length > 1) {
                try {
                    size = Integer.parseInt(threads_pool_params[1]);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Incorrect threads pool size: {0}, setting default to 100", threads_pool_params[1]);
                    size = 100;
                }
            }
            try {
                ProcessorWorkerThread worker = new ProcessorWorkerThread();
                ProcessingThreads<ProcessorWorkerThread> pt = new ProcessingThreads<ProcessorWorkerThread>(worker, size, this.maxQueueSize, this.defPluginsThreadsPool);
                this.workerThreads.put(this.defPluginsThreadsPool, pt);
                if (this.isInitializationComplete()) {
                    log.log(Level.CONFIG, "Created a default thread pool: {0}", size);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "");
            }
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.smResourceConnection = new SMResourceConnection(null, this.user_repository, this.auth_repository, this);
        this.registerNewSession(this.getComponentId().getBareJID(), this.smResourceConnection);
    }

    @Override
    public void setSchedulerThreads_size(int size) {
        super.setSchedulerThreads_size(size);
        if (!this.staleConnectionCloser.isScheduled()) {
            this.addTimerTask(this.staleConnectionCloser, this.staleConnectionCloser.getTimeout());
        }
    }

    @Override
    public int schedulerThreads() {
        return 2;
    }

    @Override
    public void register(Kernel kernel) {
        this.kernel = kernel;
        kernel.registerBean("writer").asClass(SMPacketWriter.class).exportable().exec();
        kernel.registerBean("adHocCommandManager").asClass(AdHocCommandManager.class).exec();
        kernel.registerBean("scriptCommandProcessor").asClass(ComponenScriptCommandProcessor.class).exec();
        kernel.registerBean("adHocCommandModule").asClass(AdHocCommandModule.class).exec();
    }

    @Override
    public void unregister(Kernel kernel) {
        this.kernel = null;
    }

    public Map<String, XMPPProcessorIfc> getProcessors() {
        return Collections.unmodifiableMap(this.processors);
    }

    public Map<String, XMPPPreprocessorIfc> getPreProcessors() {
        return Collections.unmodifiableMap(this.preProcessors);
    }

    public Map<String, XMPPPostprocessorIfc> getPostProcessors() {
        return Collections.unmodifiableMap(this.postProcessors);
    }

    public Map<String, XMPPPacketFilterIfc> getOutFilters() {
        return Collections.unmodifiableMap(this.outFilters);
    }

    @Override
    public synchronized void everySecond() {
        super.everySecond();
    }

    @Override
    public synchronized void everyMinute() {
        super.everyMinute();
        this.calculateActiveUsers();
        Calendar now = Calendar.getInstance();
        if (now.get(1) != this.lastDailyStatsReset.get(1) || now.get(6) != this.lastDailyStatsReset.get(6)) {
            this.lastDailyStatsReset = Calendar.getInstance();
            this.maxUserSessionsYesterday = this.maxUserSessionsDaily;
            this.maxUserSessionsDaily = this.sessionsByNodeId.size();
        }
        this.maxDailyUsersSessions.add(this.maxUserSessionsDaily - 1);
        this.maxDailyUsersConnectionsWithinLastWeek = this.maxDailyUsersSessions.getMaxValueInRange(7).orElse(-1);
    }

    @Override
    public synchronized void everyHour() {
        super.everyHour();
        this.updateActiveUsersStatistics();
    }

    private void updateActiveUsersStatistics() {
        this.activeUsersLastDay = this.auth_repository.getActiveUsersCountIn(Duration.ofDays(1L));
        this.activeUsersLastWeek = this.auth_repository.getActiveUsersCountIn(Duration.ofDays(7L));
        this.activeUsersLast30Days = this.auth_repository.getActiveUsersCountIn(Duration.ofDays(30L));
    }

    @Override
    public void handleDomainChange(String domain, XMPPResourceConnection conn) {
        try {
            VHostItem vHostItem = this.getVHostItem(domain);
            if (vHostItem == null) {
                if (log.isLoggable(Level.CONFIG)) {
                    log.log(Level.CONFIG, "Can''t get VHostItem for domain: {0}, using default one instead: {1}", new Object[]{domain, this.getDefHostName()});
                }
                vHostItem = new VHostItemImpl(this.getDefHostName().getDomain());
            }
            conn.setDomain(vHostItem);
        }
        catch (TigaseStringprepException ex) {
            log.log(Level.CONFIG, "Stringprep problem for resource connection: {0}", conn);
        }
    }

    protected void addOutPackets(Packet packet, XMPPResourceConnection conn, Queue<Packet> results) {
        for (XMPPPacketFilterIfc outfilter : this.outFilters.values()) {
            outfilter.filter(packet, conn, this.naUserRepository, results);
        }
        this.addOutPackets(results);
    }

    protected boolean addTrusted(JID jid) {
        return this.trusted.add(jid.getBareJID().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection(XMPPResourceConnection connection, JID connectionId, String userId, boolean closeOnly) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Stream closed from: {0}", connectionId);
        }
        if (connection == null) {
            connection = this.connectionsByFrom.remove(connectionId);
        }
        if (connection != null) {
            XMPPResourceConnection xMPPResourceConnection = connection;
            synchronized (xMPPResourceConnection) {
                connection.putSessionData("closing-conn", "closing-conn");
                this.closeSession(connection, closeOnly);
            }
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Can not find resource connection for connectionId: {0}", connectionId);
            }
            if (userId != null) {
                JID userJid;
                XMPPSession sessionByUserId;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Found trying to find stale XMPPResourceConnection by userId {0}...", userId);
                }
                if ((sessionByUserId = this.getSession((userJid = JID.jidInstanceNS((String)userId)).getBareJID())) != null && (connection = sessionByUserId.getResourceForConnectionId(connectionId)) != null) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Found stale XMPPResourceConnection {0} by userId {1}, removing...", new Object[]{connection, userId});
                    }
                    sessionByUserId.removeResourceConnection(connection);
                }
                return;
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "queuing connection {0} for user {1} for detail stale connection check - should not happen!!", new Object[]{connectionId, userId});
            }
            if (!this.forceDetailStaleConnectionCheck) {
                return;
            }
            this.staleConnectionCloser.queueForClose(connectionId);
        }
    }

    protected void closeSession(XMPPResourceConnection conn, boolean closeOnly) {
        if (!closeOnly) {
            ArrayDeque<Packet> results = new ArrayDeque<Packet>(50);
            for (XMPPStopListenerIfc stopProc : this.stopListeners.values()) {
                stopProc.stopped(conn, results, this.plugin_config.get(stopProc.id()));
            }
            this.addOutPackets(null, conn, results);
        }
        try {
            if (conn.isAuthorized()) {
                XMPPSession sessionParent;
                JID userJid = conn.getJID();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Closing connection for: {0}, conn: {1}", new Object[]{userJid, conn});
                }
                if ((sessionParent = conn.getParentSession()) != null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Found parent session for: {0}", userJid);
                    }
                    sessionParent.removeResourceConnection(conn);
                    if (sessionParent.getActiveResourcesSize() <= 1) {
                        if (sessionParent.getActiveResourcesSize() > 0 && !sessionParent.getActiveResources().contains(conn)) {
                            log.log(Level.FINE, "Session contains connection for other resource than: {0}, not removing session", userJid);
                            if (log.isLoggable(Level.FINER)) {
                                sb = new StringBuilder(100);
                                for (XMPPResourceConnection res_con : sessionParent.getActiveResources()) {
                                    sb.append(", res=").append(res_con.getResource());
                                }
                                log.log(Level.FINER, "Number of connections is {0} for the user: {1}{2}", new Object[]{sessionParent.getActiveResourcesSize(), userJid, sb.toString()});
                            }
                            return;
                        }
                        XMPPSession sessionFromMap = this.getSession(userJid.getBareJID());
                        if (sessionParent.equals(sessionFromMap) && sessionFromMap.getActiveResources().isEmpty()) {
                            sessionParent = this.sessionsByNodeId.remove(userJid.getBareJID());
                        }
                        if (sessionParent == null) {
                            log.log(Level.CONFIG, "UPS can''t remove, session not found in map: {0}", userJid);
                        } else if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, "Number of user sessions: {0}", this.sessionsByNodeId.size());
                        }
                        this.auth_repository.logout(userJid.getBareJID());
                    } else if (log.isLoggable(Level.FINER)) {
                        sb = new StringBuilder(100);
                        for (XMPPResourceConnection res_con : sessionParent.getActiveResources()) {
                            sb.append(", res=").append(res_con.getResource());
                        }
                        log.log(Level.FINER, "Number of connections is {0} for the user: {1}{2}", new Object[]{sessionParent.getActiveResourcesSize(), userJid, sb.toString()});
                    }
                }
            }
        }
        catch (NotAuthorizedException e) {
            log.log(Level.CONFIG, "Closed not authorized session: {0}", e);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Exception closing session... ", e);
        }
        ++this.closedConnections;
        conn.streamClosed();
    }

    protected XMPPResourceConnection createUserSession(JID conn_id, String domain) throws TigaseStringprepException {
        XMPPResourceConnection connection = new XMPPResourceConnection(conn_id, this.user_repository, this.auth_repository, this);
        VHostItem vitem = null;
        if (domain != null) {
            vitem = this.getVHostItem(domain);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Setting hostname {0} for connection: {1}, VHostItem: {2}", new Object[]{domain, conn_id, vitem});
            }
        }
        if (vitem == null) {
            if (log.isLoggable(Level.CONFIG)) {
                log.log(Level.CONFIG, "Can''t get VHostItem for domain: {0}, using default one instead: {1}", new Object[]{domain, this.getDefHostName()});
            }
            vitem = new VHostItemImpl(this.getDefHostName().getDomain());
        }
        connection.setDomain(vitem);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Domain set for connectionId {0}", conn_id);
        }
        this.connectionsByFrom.put(conn_id, connection);
        int currSize = this.connectionsByFrom.size();
        if (currSize > this.maxUserConnections) {
            this.maxUserConnections = currSize;
        }
        ++this.totalUserConnections;
        return connection;
    }

    protected boolean delTrusted(JID jid) {
        return this.trusted.remove(jid.getBareJID().toString());
    }

    protected boolean fastAddOutPacket(Packet packet) {
        return this.addOutPacket(packet);
    }

    public XMPPResourceConnection loginUserSession(JID conn_id, String domain, BareJID user_id, String resource, String xmpp_sessionId, boolean tmpSession) {
        try {
            XMPPResourceConnection conn = this.createUserSession(conn_id, domain);
            conn.setTmpSession(tmpSession);
            conn.setSessionId(xmpp_sessionId);
            conn.authorizeJID(user_id, false);
            if (conn.isAuthorized()) {
                this.handleLogin(user_id, conn);
                if (resource == null) {
                    resource = UUID.randomUUID().toString();
                }
            } else {
                this.connectionsByFrom.remove(conn_id);
                return null;
            }
            conn.setResource(resource);
            return conn;
        }
        catch (TigaseStringprepException | NotAuthorizedException ex) {
            log.log(Level.WARNING, "Problem logging user: " + user_id + "/" + resource, ex);
            return null;
        }
    }

    protected boolean processAdminsOrDomains(Packet packet) {
        if (packet.getStanzaFrom() == null && packet.getPacketFrom() != null) {
            return false;
        }
        JID to = packet.getStanzaTo();
        if (to != null && this.isLocalDomain(to.getBareJID().toString())) {
            if (packet.getElemName() == "message") {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Packet for admin: {0}", packet);
                }
                this.sendToAdmins(packet);
                packet.processedBy("admins-or-domains");
                return true;
            }
            if (packet.getElemName() == "iq" && packet.getType() == StanzaType.result) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "IQ result packet addressed directly to server and not handle by any plugin: {0}", packet);
                }
                packet.processedBy("iq-result-to-server");
                return true;
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Packet for hostname, should be handled elsewhere: {0}", packet);
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean processCommand(Packet pc) {
        block121: {
            if (pc.getStanzaTo() == null) return false;
            if (!this.getComponentId().equals((Object)pc.getStanzaTo())) {
                if (this.isLocalDomain(pc.getStanzaTo().getDomain()) == false) return false;
                if (pc.getStanzaTo().getLocalpart() != null && !this.getName().equals(pc.getStanzaTo().getLocalpart())) {
                    return false;
                }
            }
            iqc = (Iq)pc;
            processing_result = false;
            if (SessionManager.log.isLoggable(Level.FINER)) {
                SessionManager.log.log(Level.FINER, "{0} command from: {1}", new Object[]{iqc.getCommand().toString(), iqc.getFrom()});
            }
            connection = this.connectionsByFrom.get(iqc.getFrom());
            switch (1.$SwitchMap$tigase$server$Command[iqc.getCommand().ordinal()]) {
                case 1: {
                    SessionManager.log.log(Level.WARNING, "Unexpected packet: {0}", pc);
                    return true;
                }
                case 2: {
                    pt = this.workerThreads.get(this.sessionOpenProc.id());
                    if (pt == null) {
                        pt = this.workerThreads.get(this.defPluginsThreadsPool);
                    }
                    pt.addItem(this.sessionOpenProc, iqc, connection);
                    return true;
                }
                case 3: {
                    if (iqc.getType() != StanzaType.get) return true;
                    ssl = iqc.getStanzaId().startsWith("ssl_");
                    connection = this.connectionsByFrom.get(iqc.getStanzaFrom());
                    if (connection != null && ssl) {
                        connection.putSessionData("SSL", ssl);
                    }
                    features = this.getFeatures(connection);
                    result = iqc.commandResult(null);
                    Command.setData(result, features);
                    this.addOutPacket(result);
                    return true;
                }
                case 4: {
                    this.fastAddOutPacket(iqc.okResult((String)null, 0));
                    if (connection != null) {
                        if (!connection.isAuthorized()) {
                            this.connectionsByFrom.remove(iqc.getFrom(), connection);
                        }
                        if ((session = connection.getParentSession()) != null) {
                            session.removeResourceConnection(connection);
                            try {
                                connection.setParentSession(session);
                            }
                            catch (TigaseStringprepException ex) {
                                SessionManager.log.log(Level.FINE, "this should not happen as JID was already created once", ex);
                            }
                        }
                    }
                    if (connection == null || !connection.isAuthorized()) {
                        pt = this.workerThreads.get(this.sessionCloseProc.id());
                        if (pt == null) {
                            pt = this.workerThreads.get(this.defPluginsThreadsPool);
                        }
                        pt.addItem(this.sessionCloseProc, iqc, connection);
                        return true;
                    } else {
                        task = new SessionCloseTimer(iqc.getFrom(), connection.getSessionId());
                        this.addTimerTask((TimerTask)task, 10L, TimeUnit.SECONDS);
                        connection.putSessionData("closing-conn", "closing-conn");
                        connection.putSessionData("session-close-timer", task);
                    }
                    return true;
                }
                case 5: {
                    if (SessionManager.log.isLoggable(Level.FINEST)) {
                        SessionManager.log.log(Level.FINEST, "{0} processing comment, connection: {1}", new Object[]{iqc.getCommand(), connection != null ? connection : " is null"});
                    }
                    if (SessionManager.log.isLoggable(Level.FINEST)) {
                        SessionManager.log.log(Level.FINEST, "{0} adding to the processor: {1}", new Object[]{iqc.getCommand(), connection != null ? connection : " is null"});
                    }
                    if (connection == null) {
                        stanzaFrom = iqc.getStanzaFrom();
                        if (stanzaFrom == null) {
                            SessionManager.log.log(Level.WARNING, "Stream close update without an user JID: {0}", iqc);
                            return true;
                        }
                        xs = this.sessionsByNodeId.get(stanzaFrom.getBareJID());
                        if (xs == null) {
                            SessionManager.log.log(Level.CONFIG, "Stream close for the user session which does not exist: {0}", iqc);
                            return true;
                        }
                        xcr = xs.getResourceForConnectionId(iqc.getPacketFrom());
                        if (xcr == null) {
                            SessionManager.log.log(Level.CONFIG, "Stream close for the resource connection which does not exist", iqc);
                            return true;
                        } else {
                            xs.removeResourceConnection(xcr);
                            if (SessionManager.log.isLoggable(Level.FINEST) == false) return true;
                            SessionManager.log.log(Level.FINEST, "{0} removed resource connection: {1}", new Object[]{iqc.getCommand(), xcr});
                        }
                        return true;
                    }
                    pt = this.workerThreads.get(this.sessionCloseProc.id());
                    if (pt == null) {
                        pt = this.workerThreads.get(this.defPluginsThreadsPool);
                    }
                    pt.addItem(this.sessionCloseProc, iqc, connection);
                    return true;
                }
                case 6: {
                    if (SessionManager.log.isLoggable(Level.FINEST)) {
                        SessionManager.log.log(Level.FINEST, "{0} processing command, connection: {1}", new Object[]{iqc.getCommand(), connection != null ? connection : " is null"});
                    }
                    if (connection != null) {
                        task = (TimerTask)connection.getSessionData("session-close-timer");
                        if (task != null) {
                            task.cancel();
                        }
                        this.connectionsByFrom.remove(iqc.getFrom(), connection);
                    }
                    if ((pt = this.workerThreads.get(this.sessionCloseProc.id())) == null) {
                        pt = this.workerThreads.get(this.defPluginsThreadsPool);
                    }
                    pt.addItem(this.sessionCloseProc, iqc, connection);
                    return true;
                }
                case 7: {
                    try {
                        isTrusted = this.isTrusted(iqc.getStanzaFrom()) != false || this.isTrusted(iqc.getStanzaFrom().getDomain()) != false;
                        pb = Command.getFieldValue(pc, "prebind");
                        v0 = prebind = pb != null && pb.equalsIgnoreCase("true") != false;
                        if (prebind || isTrusted) {
                            av = Command.getFieldValue(pc, "available");
                            available = av == null || av.equalsIgnoreCase("false") == false;
                            user_jid = JID.jidInstance((String)Command.getFieldValue(iqc, "jid"));
                            if (prebind) {
                                id = Command.getFieldValue(pc, "session-id");
                                if (id == null) {
                                    id = UUID.randomUUID().toString();
                                }
                                this.loginUserSession(iqc.getStanzaFrom(), user_jid.getDomain(), user_jid.getBareJID(), user_jid.getResource(), id, false);
                                this.fastAddOutPacket(iqc.okResult((String)null, 0));
                            }
                            if (available) {
                                presence = null;
                                p = iqc.getElement().getChild("command").getChild("presence");
                                if (p != null) {
                                    elem = p.clone();
                                    elem.setXMLNS("jabber:client");
                                    presence = Packet.packetInstance(elem);
                                }
                                connection = this.connectionsByFrom.get(iqc.getStanzaFrom());
                                if (!prebind && connection == null) {
                                    connection = this.loginUserSession(iqc.getStanzaFrom(), user_jid.getDomain(), user_jid.getBareJID(), user_jid.getResource(), "USER_STATUS", false);
                                    connection.putSessionData("jingle", "active");
                                    this.fastAddOutPacket(iqc.okResult((String)null, 0));
                                    if (presence == null) {
                                        presence = Packet.packetInstance(new Element("presence", new Element[]{new Element("priority", "-1"), new Element("c", new String[]{"node", "ver", "ext", "xmlns"}, new String[]{"http://www.google.com/xmpp/client/caps", XMPPServer.getImplementationVersion(), "voice-v1", "http://jabber.org/protocol/caps"})}, null, null));
                                    }
                                } else {
                                    if (SessionManager.log.isLoggable(Level.FINEST)) {
                                        SessionManager.log.finest("USER_STATUS set to true for user who is already available: " + iqc.toStringSecure());
                                    }
                                    this.fastAddOutPacket(iqc.okResult((String)null, 0));
                                }
                                if (presence == null) return true;
                                presence.setPacketFrom(iqc.getStanzaFrom());
                                presence.setPacketTo(this.getComponentId());
                                this.addOutPacket(presence);
                                return true;
                            }
                            connection = this.connectionsByFrom.remove(iqc.getStanzaFrom());
                            if (connection != null) {
                                this.closeSession(connection, false);
                                this.addOutPacket(iqc.okResult((String)null, 0));
                                return true;
                            } else {
                                this.addOutPacket(Authorization.ITEM_NOT_FOUND.getResponseMessage(iqc, "The user resource you want to remove does not exist.", true));
                                SessionManager.log.log(Level.CONFIG, "Can not find resource connection for packet: " + iqc.toStringSecure());
                            }
                            return true;
                        }
                        try {
                            this.addOutPacket(Authorization.FORBIDDEN.getResponseMessage(iqc, "Only trusted entity can do it.", true));
                            return true;
                        }
                        catch (PacketErrorTypeException e) {
                            SessionManager.log.warning("Packet error type when not expected: " + iqc.toStringSecure());
                        }
                        return true;
                    }
                    catch (Exception e) {
                        try {
                            this.addOutPacket(Authorization.UNDEFINED_CONDITION.getResponseMessage(iqc, "Unexpected error occured during the request: " + e, true));
                        }
                        catch (Exception ex) {
                            SessionManager.log.log(Level.WARNING, "Error creating response packet", ex);
                        }
                        SessionManager.log.log(Level.WARNING, "USER_STATUS session creation error: ", e);
                    }
                    return true;
                }
                case 8: {
                    if (!iqc.isCommand() || !this.isLocalDomain(iqc.getStanzaTo().getDomain())) ** GOTO lbl220
                    try {
                        if (iqc.getStanzaFrom() == null && connection != null && connection.getConnectionId().equals((Object)iqc.getPacketFrom())) {
                            iqc.initVars(connection.getjid(), iqc.getStanzaTo());
                        }
                        if (iqc.getPermissions() == Permissions.NONE || iqc.getPermissions() == Permissions.REMOTE) {
                            this.setPermissions(connection, iqc);
                        }
                        if (connection != null && connection.isAuthorized()) {
                            results = new ArrayDeque<Packet>();
                            for (XMPPPreprocessorIfc preproc : this.preProcessors.values()) {
                                if (preproc.preProcess(pc, connection, this.naUserRepository, results, this.plugin_config.get(preproc.id()))) {
                                    this.addOutPackets(pc, connection, results);
                                    if (!SessionManager.log.isLoggable(Level.FINEST)) continue;
                                    SessionManager.log.log(Level.FINEST, "Packet blocked by: {0}, packet{1}", new Object[]{preproc.id(), pc});
                                    return true;
                                }
                                this.addOutPackets(pc, connection, results);
                            }
                        }
                        switch (1.$SwitchMap$tigase$server$Permissions[iqc.getPermissions().ordinal()]) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                this.adHocCommandModule.process(iqc);
                                break;
                            }
                            default: {
                                try {
                                    this.addOutPacket(Authorization.NOT_AUTHORIZED.getResponseMessage(pc, "Not authorized", false));
                                }
                                catch (PacketErrorTypeException ex1) {
                                    if (!SessionManager.log.isLoggable(Level.FINEST)) break;
                                    SessionManager.log.log(Level.FINEST, "packet already of type = error, " + iqc);
                                }
                                break;
                            }
                        }
                    }
                    catch (NoConnectionIdException ex) {
                        try {
                            this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(iqc, null, true));
                        }
                        catch (PacketErrorTypeException ex1) {
                            if (SessionManager.log.isLoggable(Level.FINEST)) {
                                SessionManager.log.log(Level.FINEST, "packet already of type = error, " + iqc);
                            }
                        }
                    }
                    catch (ComponentException ex) {
                        try {
                            this.addOutPacket(ex.makeElement(iqc, true));
                        }
                        catch (PacketErrorTypeException ex1) {
                            if (!SessionManager.log.isLoggable(Level.FINEST)) ** GOTO lbl219
                            SessionManager.log.log(Level.FINEST, "packet already of type = error, " + iqc);
                        }
                    }
lbl219:
                    // 7 sources

                    processing_result = true;
lbl220:
                    // 2 sources

                    if (this.getComponentId().equals((Object)iqc.getStanzaTo()) == false) return processing_result;
                    if (this.getComponentId().equals((Object)iqc.getPacketFrom()) == false) return processing_result;
                    try {
                        this.addOutPacket(Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(iqc, "There is no implementation for such command on the server.", true));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    SessionManager.log.log(Level.WARNING, "There is no implementation for such command on the server: " + iqc);
                    return true;
                }
                case 9: {
                    if (connection != null) {
                        if (SessionManager.log.isLoggable(Level.FINEST)) {
                            SessionManager.log.log(Level.FINEST, "Handshake details received. connection: {0}", connection);
                        }
                        if ((tlsUniqueId = Command.getFieldValue(pc, "tls-unique-id")) != null) {
                            bytes = Base64.decode((String)tlsUniqueId);
                            connection.putSessionData("TLS_UNIQUE_ID_KEY", bytes);
                            if (SessionManager.log.isLoggable(Level.FINEST)) {
                                SessionManager.log.log(Level.FINEST, "tls-unique-id {0} stored in session-data. connection: {1}", new Object[]{tlsUniqueId, connection});
                            }
                        }
                        if ((tlsExporter = Command.getFieldValue(pc, "tls-exporter")) != null) {
                            bytes = Base64.decode((String)tlsExporter);
                            connection.putSessionData("TLS_EXPORTER_KEY", bytes);
                            if (SessionManager.log.isLoggable(Level.FINEST)) {
                                SessionManager.log.log(Level.FINEST, "tls-exporter {0} stored in session-data. connection: {1}", new Object[]{tlsUniqueId, connection});
                            }
                        }
                        if ((encodedCertificate = Command.getFieldValue(pc, "peer-certificate")) != null) {
                            try {
                                bytes = Base64.decode((String)encodedCertificate);
                                bais = new ByteArrayInputStream(bytes);
                                cf = CertificateFactory.getInstance("X.509");
                                certificate = cf.generateCertificate(bais);
                                connection.putSessionData("PEER_CERTIFICATE_ENTRY_KEY", certificate);
                                if (SessionManager.log.isLoggable(Level.FINEST)) {
                                    SessionManager.log.log(Level.FINEST, "peer-certificate {0} stored in session-data. connection: {1}", new Object[]{certificate, connection});
                                }
                            }
                            catch (Exception ex) {
                                SessionManager.log.log(Level.FINEST, "could not decode peer certificate", ex);
                            }
                        }
                        if ((encodedCertificate = Command.getFieldValue(pc, "local-certificate")) == null) return true;
                        try {
                            bytes = Base64.decode((String)encodedCertificate);
                            bais = new ByteArrayInputStream(bytes);
                            cf = CertificateFactory.getInstance("X.509");
                            certificate = cf.generateCertificate(bais);
                            connection.putSessionData("LOCAL_CERTIFICATE_KEY", certificate);
                            if (SessionManager.log.isLoggable(Level.FINEST) == false) return true;
                            SessionManager.log.log(Level.FINEST, "local-certificate {0} stored in session-data. connection: {1}", new Object[]{certificate, connection});
                            return true;
                        }
                        catch (Exception ex) {
                            SessionManager.log.log(Level.FINEST, "could not decode local certificate", ex);
                        }
                        return true;
                    }
                    if (SessionManager.log.isLoggable(Level.FINEST) == false) return true;
                    SessionManager.log.finest("Handshake details received, but no connection is related.");
                    return true;
                }
                case 10: {
                    if (pc.getType() == StanzaType.error) return true;
                    if (pc.getType() == StanzaType.result) return true;
                    cmd = StreamManagementCommand.fromPacket(pc);
                    switch (1.$SwitchMap$tigase$server$xmppclient$StreamManagementCommand[cmd.ordinal()]) {
                        case 1: {
                            if (connection == null) return true;
                            if (connection.isAuthorized() == false) return true;
                            resumptionId = Command.getFieldValue(pc, "resumption-id");
                            if (resumptionId == null) return true;
                            connection.putSessionData("session-resumption-id", resumptionId);
                            return true;
                        }
                        case 2: {
                            if (connection != null && connection.isAuthorized()) {
                                oldConnectionJidStr = Command.getFieldValue(pc, "old-conn-jid");
                                oldConnJid = JID.jidInstanceNS((String)oldConnectionJidStr);
                                try {
                                    oldConn = this.connectionsByFrom.remove(oldConnJid);
                                    if (oldConn != null) {
                                        resumptionId = (String)oldConn.getSessionData("session-resumption-id");
                                        if (resumptionId != null) {
                                            oldConn.removeSessionData("session-resumption-id");
                                            connection.putSessionData("session-resumption-id", resumptionId);
                                        }
                                        if ((oldPresent = oldConn.getPresence()) != null) {
                                            connection.putSessionData("user-presence", oldPresent);
                                        }
                                        connection.setPriority(oldConn.getPriority());
                                        this.sessionsByNodeId.get(oldConn.getBareJID()).removeResourceConnection(oldConn);
                                        try {
                                            connection.setResource(oldConn.getResource());
                                        }
                                        catch (Throwable ex) {
                                            SessionManager.log.log(Level.WARNING, "Could not set resource during resumption", ex);
                                        }
                                        this.xmppStreamMoved(connection, oldConnJid, connection.getConnectionId(), Command.getFieldValue(pc, "send-response"));
                                        return true;
                                    }
                                    try {
                                        this.addOutPacket(Authorization.ITEM_NOT_FOUND.getResponseMessage(pc, "Previous session missing", false));
                                        return true;
                                    }
                                    catch (PacketErrorTypeException e) {
                                        SessionManager.log.log(Level.FINEST, "could not send error, packet already of type error", e);
                                    }
                                    return true;
                                }
                                catch (XMPPException ex) {
                                    SessionManager.log.log(Level.SEVERE, "exception while replacing old connection id = " + oldConnJid + " with new connection id = " + pc.getPacketFrom().toString(), ex);
                                }
                                return true;
                            }
                            try {
                                if (pc.getType() == StanzaType.error) return true;
                                this.addOutPacket(Authorization.NOT_AUTHORIZED.getResponseMessage(pc, "Not authorized", false));
                                return true;
                            }
                            catch (PacketErrorTypeException e) {
                                SessionManager.log.log(Level.FINEST, "could not send not-authorized error, packet already of type error", e);
                            }
                            return true;
                        }
                    }
                    return true;
                }
                case 11: {
                    try {
                        if (connection != null && connection.isAuthorized() && this.isAdmin(connection.getJID()) || iqc.getStanzaTo() != null && this.getName().equals(iqc.getStanzaTo().getLocalpart())) {
                            packetToBroadcast = null;
                            for (Object elem : pc.getElement().getChildren()) {
                                if (elem.getXMLNS() != "http://tigase.org/protocol/broadcast") continue;
                                packetToBroadcast = elem;
                                packetToBroadcast.setAttribute("xmlns", "jabber:client");
                            }
                            to = Command.getFieldValue(pc, "to");
                            if (to == null) {
                                elem = this.sessionsByNodeId.values().iterator();
                                break;
                            }
                            userJid = BareJID.bareJIDInstanceNS((String)to);
                            session = this.sessionsByNodeId.get(userJid);
                            if (session == null) return true;
                            jids = session.getJIDs();
                            if (jids == null) return true;
                            var11_64 = jids;
                            var12_69 = var11_64.length;
                            var13_72 = 0;
                            break block121;
                        }
                        if (pc.getType() == StanzaType.error) return true;
                        this.addOutPacket(Authorization.NOT_AUTHORIZED.getResponseMessage(pc, "Not authorized", false));
                        return true;
                    }
                    catch (NotAuthorizedException e) {
                        if (pc.getType() == StanzaType.error) return true;
                        try {
                            this.addOutPacket(Authorization.NOT_AUTHORIZED.getResponseMessage(pc, "Not authorized", false));
                            return true;
                        }
                        catch (PacketErrorTypeException ex) {
                            SessionManager.log.log(Level.FINEST, "could not send not-authorized error, packet already of type error", ex);
                        }
                        return true;
                    }
                    catch (PacketErrorTypeException e) {
                        SessionManager.log.log(Level.FINEST, "could not send not-authorized error, packet already of type error", e);
                    }
                    return true;
                }
                default: {
                    if (this.getComponentId().equals((Object)iqc.getStanzaTo()) == false) return processing_result;
                    if (this.getComponentId().equals((Object)iqc.getPacketFrom()) == false) return processing_result;
                    try {
                        this.addOutPacket(Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(iqc, "There is no implementation for such command on the server.", true));
                    }
                    catch (Exception ex) {
                        SessionManager.log.log(Level.WARNING, "Error creating instance", ex);
                    }
                    SessionManager.log.log(Level.WARNING, "There is no implementation for such command on the server: " + iqc);
                    return true;
                }
            }
            block64: while (true) {
                if (elem.hasNext() == false) return true;
                session = (XMPPSession)elem.next();
                jids = session.getJIDs();
                if (jids == null) continue;
                var11_63 = jids;
                var12_68 = var11_63.length;
                var13_71 = 0;
                while (true) {
                    if (var13_71 < var12_68) ** break;
                    continue block64;
                    jid = var11_63[var13_71];
                    msg = packetToBroadcast.clone();
                    msg.setAttribute("to", jid.toString());
                    try {
                        toSend = Packet.packetInstance(msg);
                        this.addOutPacket(toSend);
                    }
                    catch (TigaseStringprepException ex) {
                        SessionManager.log.log(Level.FINEST, "could not create packet for message to broadcast", ex);
                    }
                    ++var13_71;
                }
                break;
            }
        }
        while (var13_72 < var12_69) {
            jid = var11_64[var13_72];
            if (SessionManager.log.isLoggable(Level.FINEST)) {
                SessionManager.log.log(Level.FINEST, "broadcasting packet to {0}", jid);
            }
            msg = packetToBroadcast.clone();
            msg.setAttribute("to", jid.toString());
            try {
                toSend = Packet.packetInstance(msg);
                this.addOutPacket(toSend);
            }
            catch (TigaseStringprepException ex) {
                SessionManager.log.log(Level.FINEST, "could not create packet for message to broadcast", ex);
            }
            ++var13_72;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processPacket(Packet packet, XMPPResourceConnection conn) {
        long startTime = System.currentTimeMillis();
        int idx = this.tIdx;
        this.tIdx = (this.tIdx + 1) % this.maxIdx;
        packet.setPacketTo(this.getComponentId());
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "processing packet: {0}, connection: {1}", new Object[]{packet.toStringSecure(), conn});
        }
        ArrayDeque<Packet> results = new ArrayDeque<Packet>(2);
        boolean stop = false;
        if (!stop && this.defPacketHandler.preprocess(packet, conn, this.naUserRepository, results)) {
            packet.processedBy("filter-foward");
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Packet preprocessed: {0}", packet.toStringSecure());
                if (results.size() > 0) {
                    for (Packet p : results) {
                        log.log(Level.FINEST, "Preprocess result: {0}", p.toStringSecure());
                    }
                }
            }
            this.addOutPackets(packet, conn, results);
            return;
        }
        if (!stop) {
            for (XMPPPreprocessorIfc preproc : this.preProcessors.values()) {
                if (!(stop |= preproc.preProcess(packet, conn, this.naUserRepository, results, this.plugin_config.get(preproc.id()))) || !log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "Packet blocked by: {0}, packet{1}", new Object[]{preproc.id(), packet});
                break;
            }
        }
        this.setPermissions(conn, packet);
        if (!stop && this.defPacketHandler.forward(packet, conn, this.naUserRepository, results)) {
            packet.processedBy("filter-foward");
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Packet forwarded: {0}", packet);
            }
            this.addOutPackets(packet, conn, results);
            return;
        }
        if (!stop) {
            this.walk(packet, conn);
            try {
                if (conn != null && conn.getConnectionId().equals((Object)packet.getPacketFrom())) {
                    this.handleLocalPacket(packet, conn);
                }
            }
            catch (NoConnectionIdException ex) {
                log.log(Level.CONFIG, "Impossible happened, please report to developer packet: {0}, connection: {1}.", new Object[]{packet, conn});
            }
        }
        if (!stop) {
            for (XMPPPostprocessorIfc postproc : this.postProcessors.values()) {
                String plug_id = postproc.id();
                long[] postProcTime = null;
                Map<String, long[]> map = this.postTimes;
                synchronized (map) {
                    postProcTime = this.postTimes.get(plug_id);
                    if (postProcTime == null) {
                        postProcTime = new long[this.maxIdx];
                        this.postTimes.put(plug_id, postProcTime);
                    }
                }
                long stTime = System.currentTimeMillis();
                postproc.postProcess(packet, conn, this.naUserRepository, results, this.plugin_config.get(postproc.id()));
                postProcTime[idx] = System.currentTimeMillis() - stTime;
            }
        }
        if (!(stop || packet.wasProcessed() || packet.getStanzaTo() != null && this.isLocalDomain(packet.getStanzaTo().toString()) || !this.defPacketHandler.canHandle(packet, conn))) {
            ProcessingThreads<ProcessorWorkerThread> pt = this.workerThreads.get(this.defHandlerProc.id());
            if (pt == null) {
                pt = this.workerThreads.get(this.defPluginsThreadsPool);
            }
            pt.addItem(this.defHandlerProc, packet, conn);
            packet.processedBy(this.defHandlerProc.id());
        }
        this.setPermissions(conn, results);
        this.addOutPackets(packet, conn, results);
        if (packet.wasProcessed() || this.processAdminsOrDomains(packet)) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Packet processed by: {0}", packet.getProcessorsIds().toString());
            }
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Packet not processed: {0}", packet.toStringSecure());
            }
            Packet error = null;
            if (stop || conn == null && packet.getStanzaFrom() != null && packet.getStanzaTo() != null && !packet.getStanzaTo().equals((Object)this.getComponentId()) && (packet.getElemName() == "iq" || packet.getElemName() == "message")) {
                try {
                    error = Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, "Service not available.", true);
                }
                catch (PacketErrorTypeException e) {
                    log.log(Level.FINE, "Service not available. Packet is error type already: {0}", packet.toStringSecure());
                }
            } else if ((packet.getStanzaFrom() != null || conn != null) && packet.wasSkipped()) {
                try {
                    error = Authorization.RESOURCE_CONSTRAINT.getResponseMessage(packet, "Server subsystem overloaded, service temporarily unavailable.", true);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Server subsystem overloaded. Packet {0} not processed by processors {1}", new Object[]{packet.toStringSecure(), packet.getSkippedProcessorsIds()});
                    }
                }
                catch (PacketErrorTypeException e) {
                    log.log(Level.FINE, "Internal queues full. Packet is error type already: {0}", packet.toStringSecure());
                }
            } else if (packet.getStanzaFrom() != null || conn != null) {
                try {
                    error = Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(packet, "Feature not supported yet.", true);
                }
                catch (PacketErrorTypeException e) {
                    log.log(Level.FINE, "Feature not supported yet. Packet is error type already: {0}", packet.toStringSecure());
                }
            }
            if (error != null) {
                if (error.getStanzaTo() != null) {
                    conn = this.getResourceConnection(error.getStanzaTo());
                }
                try {
                    if (conn != null) {
                        error.setPacketTo(conn.getConnectionId());
                    }
                    this.addOutPacket(error);
                }
                catch (NoConnectionIdException e) {
                    log.log(Level.WARNING, "Error packet to the SM''s own session: {0}", error);
                }
            }
        }
    }

    protected void processPresenceUpdate(XMPPSession session, Element packet) {
        try {
            Packet presence = Packet.packetInstance(packet);
            this.eventBus.fire(new UserPresenceChangedEvent(session, presence));
        }
        catch (TigaseStringprepException ex) {
            log.log(Level.SEVERE, "exception processing presence update for session = " + session + " and packet = " + packet, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerNewSession(BareJID userId, XMPPResourceConnection conn) {
        XMPPResourceConnection xMPPResourceConnection = conn;
        synchronized (xMPPResourceConnection) {
            if (conn.getSessionData("closing-conn") != null) {
                return;
            }
            XMPPSession session = this.getSession(userId);
            if (session == null) {
                session = new XMPPSession(userId.getLocalpart());
                this.sessionsByNodeId.put(userId, session);
                int currSize = this.sessionsByNodeId.size();
                if (currSize > this.maxUserSessions) {
                    this.maxUserSessions = currSize;
                }
                if (currSize > this.maxUserSessionsDaily) {
                    this.maxUserSessionsDaily = currSize;
                }
                ++this.totalUserSessions;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Created new XMPPSession for: {0}", userId);
                }
            } else {
                List<XMPPResourceConnection> connections = session.getActiveResources();
                if (connections != null) {
                    for (XMPPResourceConnection connection : connections) {
                        Long lastCheck;
                        if (connection == conn || connection.getSessionData("closing-conn") != null || (lastCheck = (Long)connection.getSessionData("connection-check-timestamp")) != null && System.currentTimeMillis() - lastCheck < this.connectionCheckPeriod) continue;
                        connection.putSessionData("connection-check-timestamp", System.currentTimeMillis());
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Checking connection: {0}", connection);
                        }
                        try {
                            Packet command2 = Command.CHECK_USER_CONNECTION.getPacket(this.getComponentId(), connection.getConnectionId(), StanzaType.get, UUID.randomUUID().toString());
                            Command.addFieldValue(command2, "user-jid", userId.toString());
                            this.addOutPacketWithTimeout(command2, this.connectionCheckCommandHandler, 30L, TimeUnit.SECONDS);
                        }
                        catch (NoConnectionIdException ex) {
                            log.log(Level.WARNING, "This should not happen, check it out!, ", ex);
                        }
                    }
                }
            }
            try {
                session.addResourceConnection(conn);
                if (!("USER_STATUS".equals(conn.getSessionId()) || conn.isServerSession() || conn.isTmpSession())) {
                    try {
                        Packet user_login_cmd = Command.USER_LOGIN.getPacket(this.getComponentId(), conn.getConnectionId(), StanzaType.set, conn.nextStanzaId(), Command.DataType.submit);
                        Command.addFieldValue(user_login_cmd, "user-jid", userId.toString());
                        this.addOutPacket(user_login_cmd);
                    }
                    catch (NoConnectionIdException ex) {
                        log.log(Level.WARNING, "This should not happen, check it out!, ", ex);
                    }
                }
            }
            catch (TigaseStringprepException ex) {
                log.log(Level.CONFIG, "Stringprep problem for resource connection: {0}", conn);
                this.handleLogout(userId, conn);
            }
        }
    }

    protected void sendToAdmins(Packet packet) {
        for (BareJID admin : this.admins) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Sending packet to admin: {0}", admin);
            }
            Packet admin_pac = packet.copyElementOnly();
            admin_pac.initVars(packet.getStanzaFrom(), JID.jidInstance((BareJID)admin));
            this.processPacket(admin_pac);
        }
    }

    @HandleEvent
    protected void nodeShutdown(ShutdownEvent event) {
        if (!event.getNode().equals(this.getComponentId().getDomain())) {
            return;
        }
        if (event.getMessage() != null) {
            Element msgEl = new Element("message", new String[]{"xmlns"}, new String[]{"jabber:client"});
            msgEl.addChild((XMLNodeIfc)new Element("body", event.getMessage()));
            for (XMPPResourceConnection conn : this.connectionsByFrom.values()) {
                try {
                    Element packetEl = msgEl.clone();
                    packetEl.setAttribute("from", conn.getDomainAsJID().getDomain());
                    packetEl.setAttribute("to", conn.getJID().toString());
                    Packet packet = Packet.packetInstance(msgEl, conn.getDomainAsJID(), conn.getJID());
                    this.addPacket(packet);
                }
                catch (NotAuthorizedException ex) {
                    log.log(Level.FINEST, "could not deliver notification about shutdown as session is not authorized", ex);
                }
            }
        }
        this.addTimerTask((TimerTask)this.nodeShutdownTask, event.getDelay() * 1000L, 1000L);
    }

    protected void xmppStreamMoved(XMPPResourceConnection conn, JID oldConnId, JID newConnId, String sendResponse) {
        Packet cmd = StreamManagementCommand.STREAM_MOVED.create(this.getComponentId(), oldConnId);
        Command.addFieldValue(cmd, "cmd", "stream-moved");
        Command.addFieldValue(cmd, "new-conn-jid", newConnId.toString());
        Command.addFieldValue(cmd, "send-response", sendResponse);
        cmd.setPacketFrom(this.getComponentId());
        cmd.setPacketTo(oldConnId);
        this.addOutPacket(cmd);
    }

    @Override
    protected Integer getMaxQueueSize(int def) {
        return def * 10;
    }

    protected XMPPSession getSession(BareJID jid) {
        return this.sessionsByNodeId.get(jid);
    }

    protected XMPPResourceConnection getXMPPResourceConnection(JID connId) {
        return this.connectionsByFrom.get(connId);
    }

    protected XMPPResourceConnection getXMPPResourceConnection(Packet p) {
        XMPPResourceConnection conn = null;
        JID from = p.getPacketFrom();
        if (from != null && (conn = this.connectionsByFrom.get(from)) != null) {
            return conn;
        }
        JID to = p.getStanzaTo();
        if (to != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Searching for resource connection for: " + to);
            }
            conn = this.getResourceConnection(to);
        } else {
            log.log(Level.CONFIG, "Message without TO attribute set, don''t know what to do wih this: {0}", p);
        }
        return conn;
    }

    protected boolean isBrokenPacket(Packet p) {
        if (this.getComponentId().equals((Object)p.getPacketFrom()) && p.getPacketTo() == null) {
            return false;
        }
        if (p.getFrom() == null) {
            log.log(Level.FINE, "Broken packet: {0}", p.toStringSecure());
            return true;
        }
        if (!p.getFrom().equals((Object)p.getStanzaFrom()) && (!p.isCommand() || p.isCommand() && p.getCommand() == Command.OTHER)) {
            if (p.getStanzaFrom() != null && !this.isLocalDomain(p.getStanzaFrom().getDomain())) {
                if (p.getStanzaTo() == null || !this.isLocalDomain(p.getStanzaTo().getDomain(), false)) {
                    p.setPacketFrom(null);
                    p.setPacketTo(null);
                    this.fastAddOutPacket(p);
                    return true;
                }
                if (p.getPacketTo() == null) {
                    return false;
                }
            }
            if (C2SDeliveryErrorProcessor.isDeliveryError(p)) {
                return false;
            }
            if (p.getStanzaTo() != null && p.getStanzaTo().getResource() == null) {
                return false;
            }
            if (p.isServiceDisco() && p.getStanzaFrom() != null && p.getStanzaFrom().getResource() == null) {
                return false;
            }
            log.log(Level.FINE, "Broken packet: {0}", p.toStringSecure());
            if (p.getElemName() == "iq" || p.getElemName() == "message") {
                try {
                    Packet error = Authorization.SERVICE_UNAVAILABLE.getResponseMessage(p, "Service not available.", true);
                    error.setPacketTo(p.getFrom());
                    this.fastAddOutPacket(error);
                }
                catch (PacketErrorTypeException e) {
                    log.log(Level.FINE, "Packet is error type already: {0}", p.toStringSecure());
                }
            }
            return true;
        }
        return false;
    }

    private void calculateActiveUsers() {
        int count = 0;
        for (BareJID bareJID : this.sessionsByNodeId.keySet()) {
            XMPPSession session;
            if (bareJID.toString().startsWith("sess-man") || (session = this.sessionsByNodeId.get(bareJID)) == null) continue;
            for (XMPPResourceConnection xMPPResourceConnection : session.getActiveResources()) {
                if (System.currentTimeMillis() - xMPPResourceConnection.getLastAccessed() >= this.activeUserTimeframe) continue;
                ++count;
            }
        }
        this.activeUserNumber = count;
    }

    private long calcAverage(long[] timings) {
        long res = 0L;
        for (long ppt : timings) {
            res += ppt;
        }
        long processingTime = res / (long)timings.length;
        return processingTime;
    }

    private void walk(Packet packet, XMPPResourceConnection connection) {
        for (XMPPProcessorIfc proc_t : this.processors.values()) {
            XMPPProcessorIfc processor = proc_t;
            Authorization result = processor.canHandle(packet, connection);
            if (result == Authorization.AUTHORIZED) {
                ProcessingThreads<ProcessorWorkerThread> pt;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "XMPPProcessorIfc: {0} ({1})Request: {2}, conn: {3}", new Object[]{processor.getClass().getSimpleName(), processor.id(), packet, connection});
                }
                if ((pt = this.workerThreads.get(processor.id())) == null) {
                    pt = this.workerThreads.get(this.defPluginsThreadsPool);
                }
                if (pt.addItem(processor, packet, connection)) {
                    packet.processedBy(processor.id());
                    continue;
                }
                packet.notProcessedBy(processor.id());
                if (!log.isLoggable(Level.FINE)) continue;
                log.log(Level.FINE, "Can not add packet: {0} to processor: {1} internal queue full.", new Object[]{packet.toStringSecure(), pt.getName()});
                continue;
            }
            if (result == null) continue;
        }
    }

    private List<Element> getFeatures(XMPPResourceConnection session) {
        LinkedList<Element> results = new LinkedList<Element>();
        for (XMPPProcessorIfc proc_t : this.processors.values()) {
            Element[] features = proc_t.supStreamFeatures(session);
            if (features == null) continue;
            results.addAll(Arrays.asList(features));
        }
        if (this.includeCapsInStream && this.router != null && session != null && session.isAuthorized()) {
            this.router.getServiceEntityCaps(session.getjid()).ifPresent(results::add);
        }
        return results;
    }

    private Map<String, Object> getPluginSettings(String plug_id, Map<String, Object> props) {
        ConcurrentHashMap<String, Object> plugin_settings = new ConcurrentHashMap<String, Object>(10);
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            String[] nodes;
            if (!entry.getKey().startsWith("plugins-conf") || (nodes = entry.getKey().split("/")).length != 2) continue;
            plugin_settings.put(nodes[1], entry.getValue());
            log.log(Level.CONFIG, "Adding a common plugins option: {0} = {1}", new Object[]{nodes[1], entry.getValue()});
        }
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            String[] nodes;
            if (!entry.getKey().startsWith("plugins-conf")) continue;
            String key = entry.getKey();
            if (plug_id.contains("/")) {
                if (!key.contains(plug_id)) continue;
                key = key.replace(plug_id, "plugin-id");
            }
            if ((nodes = key.split("/")).length <= 2) continue;
            Object[] ids = nodes[1].split(",");
            Arrays.sort(ids);
            if (Arrays.binarySearch(ids, plug_id) < 0 && Arrays.binarySearch(ids, "plugin-id") < 0) continue;
            plugin_settings.put(nodes[2], entry.getValue());
            log.log(Level.CONFIG, "Adding a specific plugins option [{0}]: {1} = {2}", new Object[]{plug_id, nodes[2], entry.getValue()});
        }
        return plugin_settings;
    }

    private void setPermissions(XMPPResourceConnection conn, Packet packet) {
        Permissions perms = this.getPermissionForConnection(conn);
        packet.setPermissions(perms);
    }

    private void setPermissions(XMPPResourceConnection conn, Queue<Packet> results) {
        Permissions perms = this.getPermissionForConnection(conn);
        for (Packet res : results) {
            res.setPermissions(perms);
        }
    }

    private Permissions getPermissionForConnection(XMPPResourceConnection conn) {
        Permissions perms = Permissions.NONE;
        if (conn != null) {
            perms = Permissions.LOCAL;
            if (conn.isAuthorized()) {
                perms = Permissions.AUTH;
                if (conn.isAnonymous()) {
                    perms = Permissions.ANONYM;
                } else {
                    try {
                        JID id = conn.getJID();
                        if (this.isTrusted(id)) {
                            perms = Permissions.TRUSTED;
                        }
                        if (this.isAdmin(id)) {
                            perms = Permissions.ADMIN;
                        }
                    }
                    catch (NotAuthorizedException e) {
                        perms = Permissions.NONE;
                    }
                }
            }
        }
        return perms;
    }

    private class ConnectionCheckCommandHandler
    implements ReceiverTimeoutHandler {
        private ConnectionCheckCommandHandler() {
        }

        @Override
        public void responseReceived(Packet packet, Packet response) {
            if (response.getType() == StanzaType.error) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Connection checker error received, closing connection: {0}", packet.getTo());
                }
                String userJid = Command.getFieldValue(packet, "user-jid");
                SessionManager.this.closeConnection(null, packet.getTo(), userJid, false);
            }
        }

        @Override
        public void timeOutExpired(Packet packet) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Connection checker timeout expired, closing connection: {0}", packet.getTo());
            }
            String userJid = Command.getFieldValue(packet, "user-jid");
            SessionManager.this.closeConnection(null, packet.getTo(), userJid, false);
        }
    }

    @Bean(name="default-handler", parent=SessionManager.class, active=true)
    public static class DefaultHandlerProc
    extends XMPPProcessor
    implements XMPPProcessorIfc {
        @Inject
        SessionManager sm;

        @Override
        public int concurrentQueuesNo() {
            return Runtime.getRuntime().availableProcessors() * 4;
        }

        @Override
        public String id() {
            return "default-handler";
        }

        @Override
        public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Executing default packet handler for: {0}", packet);
            }
            this.sm.defPacketHandler.process(packet, session, repo, results);
        }
    }

    private class NodeShutdownTask
    extends TimerTask {
        private NodeShutdownTask() {
        }

        @Override
        public void run() {
            if (SessionManager.this.sessionsByNodeId.isEmpty() || SessionManager.this.sessionsByNodeId.size() == 1 && SessionManager.this.sessionsByNodeId.get(SessionManager.this.getComponentId().getBareJID()) != null) {
                log.log(Level.CONFIG, "shutdown - stopping JVM");
                System.exit(0);
            } else {
                log.log(Level.CONFIG, "shutdown - still waiting for {0} to be closed", SessionManager.this.sessionsByNodeId.size());
                if (log.isLoggable(Level.FINEST)) {
                    StringBuilder sb = new StringBuilder();
                    for (XMPPSession session : SessionManager.this.sessionsByNodeId.values()) {
                        sb.append("\n\t");
                        sb.append(session.toString());
                    }
                    log.log(Level.FINEST, "shutdown - waiting for following sessions:{0}", sb.toString());
                }
            }
        }
    }

    @Bean(name="session-close", parent=SessionManager.class, active=true)
    public static class SessionCloseProc
    extends XMPPProcessor
    implements XMPPProcessorIfc {
        @Inject
        SessionManager sm;

        @Override
        public int concurrentQueuesNo() {
            return super.concurrentQueuesNo() * 4;
        }

        @Override
        public String id() {
            return "session-close";
        }

        @Override
        public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Executing connection close for: {0}", packet);
            }
            String userJid = Command.getFieldValue(packet, "user-jid");
            this.sm.closeConnection(session, packet.getFrom(), userJid, false);
        }
    }

    @Bean(name="session-open", parent=SessionManager.class, active=true)
    public static class SessionOpenProc
    extends XMPPProcessor
    implements XMPPProcessorIfc {
        @Inject
        SessionManager sm;

        @Override
        public int concurrentQueuesNo() {
            return super.concurrentQueuesNo() * 2;
        }

        @Override
        public String id() {
            return "session-open";
        }

        @Override
        public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
            XMPPResourceConnection conn = session;
            if (conn == null) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Adding resource connection for: {0}", packet.getFrom());
                }
                String hostname = Command.getFieldValue(packet, "hostname");
                try {
                    conn = this.sm.createUserSession(packet.getFrom(), hostname);
                }
                catch (TigaseStringprepException ex) {
                    log.log(Level.WARNING, "Incrrect hostname, did not pass stringprep processing: {0}", hostname);
                    return;
                }
                this.sm.addTimerTask(new AuthenticationTimer(this.sm, packet.getFrom()), this.sm.authTimeout, TimeUnit.SECONDS);
            } else if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Stream opened for existing session, authorized: {0}", conn.isAuthorized());
            }
            conn.setSessionId(Command.getFieldValue(packet, "session-id"));
            conn.setDefLang(Command.getFieldValue(packet, "xml:lang"));
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Setting session-id {0} for connection: {1}", new Object[]{conn.getSessionId(), conn});
            }
            this.sm.fastAddOutPacket(packet.okResult((String)null, 0));
        }
    }

    public static interface MessageArchive {
        public void generateStableId(Packet var1);

        public boolean willArchive(Packet var1, XMPPResourceConnection var2) throws NotAuthorizedException;

        public void addStableId(Packet var1, XMPPResourceConnection var2);
    }

    private class StaleConnectionCloser
    extends TimerTask {
        public static final int DEF_QUEUE_SIZE = 1000;
        public static final long DEF_TIMEOUT = 30000L;
        private int maxQueueSize;
        private Set<JID> queueSet;
        private Thread thread;
        private long timeout;
        private Set<JID> workingSet;

        public StaleConnectionCloser() {
            this(1000, 30000L);
        }

        public StaleConnectionCloser(int queueSize, long timeout) {
            this.timeout = timeout;
            this.maxQueueSize = queueSize;
            this.workingSet = new HashSet<JID>(queueSize);
            this.queueSet = new HashSet<JID>(queueSize);
        }

        public void closeConnections() {
            if (this.workingSet.isEmpty()) {
                return;
            }
            log.log(Level.CONFIG, "Trying to find and remove stale XMPPResourceConnections");
            LinkedList<XMPPResourceConnection> staleConnections = new LinkedList<XMPPResourceConnection>();
            for (XMPPSession session : SessionManager.this.sessionsByNodeId.values()) {
                XMPPResourceConnection connection;
                List<XMPPResourceConnection> connections = session.getActiveResources();
                for (XMPPResourceConnection connection2 : connections) {
                    try {
                        JID connectionId = connection2.getConnectionId(false);
                        if (!this.workingSet.contains(connectionId)) continue;
                        staleConnections.offer(connection2);
                        this.workingSet.remove(connectionId);
                    }
                    catch (NoConnectionIdException ex) {
                        log.log(Level.FINEST, "found connection without proper connection id = {0}", connection2.toString());
                    }
                }
                while ((connection = (XMPPResourceConnection)staleConnections.poll()) != null) {
                    log.log(Level.FINE, "Found stale XMPPResourceConnection: {0}, removing...", connection);
                    session.removeResourceConnection(connection);
                }
                if (!this.workingSet.isEmpty()) continue;
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean queueForClose(JID connectionId) {
            boolean result;
            StaleConnectionCloser staleConnectionCloser = this;
            synchronized (staleConnectionCloser) {
                if (this.queueSet.size() > this.maxQueueSize) {
                    return false;
                }
                result = this.queueSet.add(connectionId);
            }
            if (!result && log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "connection with id {0} already queued for removing as stale XMPPResourceConnection", connectionId);
            }
            return result;
        }

        @Override
        public void run() {
            if (this.thread != null && this.thread.isAlive()) {
                return;
            }
            this.thread = new Thread(){

                @Override
                public void run() {
                    StaleConnectionCloser.this.process();
                    StaleConnectionCloser.this.thread = null;
                }
            };
            this.thread.start();
        }

        public int getMaxQueueSize() {
            return this.maxQueueSize;
        }

        public void setMaxQueueSize(int queueSize) {
            this.maxQueueSize = queueSize;
        }

        public long getTimeout() {
            return this.timeout;
        }

        private void process() {
            try {
                while (this.swapSets()) {
                    this.closeConnections();
                }
            }
            catch (Throwable th) {
                log.log(Level.SEVERE, "exception closing stale connections", th);
            }
            SessionManager.this.addTimerTask(this, this.timeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean swapSets() {
            StaleConnectionCloser staleConnectionCloser = this;
            synchronized (staleConnectionCloser) {
                Set<JID> tmp = this.workingSet;
                this.workingSet = this.queueSet;
                this.queueSet = tmp;
                this.queueSet.clear();
                return !this.workingSet.isEmpty();
            }
        }
    }

    private class ProcessorWorkerThread
    extends WorkerThread {
        private ArrayDeque<Packet> local_results = new ArrayDeque(100);

        private ProcessorWorkerThread() {
        }

        @Override
        public void process(QueueItem item) {
            XMPPProcessorIfc processor = item.getProcessor();
            try {
                processor.process(item.getPacket(), item.getConn(), SessionManager.this.naUserRepository, this.local_results, SessionManager.this.plugin_config.get(processor.id()));
                if (item.getConn() != null) {
                    SessionManager.this.setPermissions(item.getConn(), this.local_results);
                }
                SessionManager.this.addOutPackets(item.getPacket(), item.getConn(), this.local_results);
            }
            catch (InvalidPacketException e) {
                log.log(Level.CONFIG, "Invalid packet! Error: {0}, packet: {1}", new String[]{e.getLocalizedMessage(), item.getPacket().toStringSecure()});
            }
            catch (NotAuthorizedException e) {
                log.log(Level.CONFIG, "Session hasn't been authorised yet! Error: {0}, packet: {1}", new String[]{e.getLocalizedMessage(), item.getPacket().toStringSecure()});
                this.sendErrorBack(item.getPacket(), Authorization.NOT_AUTHORIZED, null);
            }
            catch (XMPPProcessorException e) {
                log.log(Level.FINEST, "Exception during packet processing: " + item.getPacket().toStringSecure(), e);
                this.sendErrorBack(item.getPacket(), e.getErrorCondition(), e.getMessage());
            }
            catch (XMPPException e) {
                log.log(Level.WARNING, "Exception during packet processing: " + item.getPacket().toStringSecure(), e);
                this.sendErrorBack(item.getPacket(), Authorization.INTERNAL_SERVER_ERROR, null);
            }
        }

        @Override
        public WorkerThread getNewInstance() {
            ProcessorWorkerThread worker = new ProcessorWorkerThread();
            return worker;
        }

        private void sendErrorBack(Packet packet, Authorization errorCondition, String message) {
            block3: {
                if (packet.getType() != StanzaType.error) {
                    try {
                        SessionManager.this.addOutPacket(errorCondition.getResponseMessage(packet, message, true));
                    }
                    catch (PacketErrorTypeException ex) {
                        if (!log.isLoggable(Level.FINEST)) break block3;
                        log.log(Level.FINEST, "Problem during generate error response", ex);
                    }
                }
            }
        }
    }

    @Bean(name="writer", active=true)
    public static class SMPacketWriter
    implements PacketWriter {
        @Inject(bean="service", nullAllowed=false)
        private SessionManager component;

        @Override
        public void write(Collection<Packet> packets) {
            if (packets != null) {
                packets.forEach(this::write);
            }
        }

        @Override
        public void write(Packet packet) {
            this.component.addOutPacket(packet);
        }

        @Override
        public void write(Packet packet, AsyncCallback callback) {
            throw new UnsupportedOperationException("writing packets with AsyncCallback is not supported in SM!");
        }
    }

    private class SessionCloseTimer
    extends TimerTask {
        private JID connId = null;
        private String sessId = null;

        private SessionCloseTimer(JID connId, String sessId) {
            this.connId = connId;
            this.sessId = sessId;
        }

        @Override
        public void run() {
            XMPPResourceConnection conn = SessionManager.this.connectionsByFrom.get(this.connId);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "session closed timer executed for connId = {0}, sessionId = {1}, conn = {2}", new Object[]{this.connId, this.sessId, conn});
            }
            if (conn != null && (this.sessId == null || this.sessId.equals(conn.getSessionId()))) {
                SessionManager.this.connectionsByFrom.remove(this.connId, conn);
                SessionManager.this.closeConnection(conn, this.connId, null, false);
            }
        }
    }

    private static class AuthenticationTimer
    extends TimerTask {
        private final SessionManager sm;
        private JID connId = null;

        private AuthenticationTimer(SessionManager sm, JID connId) {
            this.sm = sm;
            this.connId = connId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            XMPPResourceConnection conn = this.sm.connectionsByFrom.get(this.connId);
            if (conn != null) {
                XMPPResourceConnection xMPPResourceConnection = conn;
                synchronized (xMPPResourceConnection) {
                    if (!conn.isAuthorized()) {
                        conn.putSessionData("authentication-timeout", "authentication-timeout");
                        this.sm.connectionsByFrom.remove(this.connId);
                        ++this.sm.authTimeouts;
                        log.log(Level.FINE, "Authentication timeout expired, closing connection: {0}", this.connId);
                        this.sm.fastAddOutPacket(Command.CLOSE.getPacket(this.sm.getComponentId(), this.connId, StanzaType.set, conn.nextStanzaId()));
                    }
                }
            }
        }
    }

    public static interface ProcessorResultWriter {
        public void write(Packet var1, XMPPResourceConnection var2, Queue<Packet> var3);
    }
}

