/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver.proc;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.kernel.beans.Inject;
import tigase.server.xmppserver.S2SConnectionHandlerIfc;
import tigase.server.xmppserver.S2SIOService;

public class S2SAbstract {
    protected static final String DB_RESULT_EL_NAME = "db:result";
    protected static final String DB_VERIFY_EL_NAME = "db:verify";
    protected static final String DIALBACK_EL = "dialback";
    protected static final String DIALBACK_NS = "urn:xmpp:features:dialback";
    protected static final String FEATURES_EL = "features";
    protected static final String FEATURES_NS = "http://etherx.jabber.org/streams";
    protected static final String PROCEED_TLS_EL = "proceed";
    protected static final String RESULT_EL_NAME = "result";
    protected static final String START_TLS_EL = "starttls";
    protected static final String START_TLS_NS = "urn:ietf:params:xml:ns:xmpp-tls";
    public static final String STREAM_FEATURES_EL = "stream:features";
    protected static final String VERIFY_EL_NAME = "verify";
    protected static final String VERSION_ATT_NAME = "version";
    protected static final String XMLNS_CLIENT_VAL = "jabber:client";
    protected static final String XMLNS_DB_ATT = "xmlns:db";
    protected static final String XMLNS_DB_VAL = "jabber:server:dialback";
    protected static final String[] FEATURES_STARTTLS_PATH = new String[]{"features", "starttls"};
    protected static final String[] FEATURES_DIALBACK_PATH = new String[]{"features", "dialback"};
    private static final Logger log = Logger.getLogger(S2SAbstract.class.getName());
    public static boolean FORCE_VERSION = false;
    @Inject(nullAllowed=true)
    protected S2SConnectionHandlerIfc<S2SIOService> handler = null;

    public void init(S2SConnectionHandlerIfc<S2SIOService> handler, Map<String, Object> props) {
        this.handler = handler;
    }

    public void generateStreamError(boolean initStream, String error_el, S2SIOService serv) {
        Throwable thr = new Throwable();
        thr.fillInStackTrace();
        this.generateStreamError(initStream, error_el, serv, thr);
    }

    public void generateStreamError(boolean initStream, String error_el, S2SIOService serv, Throwable throwable) {
        StringBuilder strError = new StringBuilder();
        if (initStream) {
            strError.append("<?xml version='1.0'?><stream:stream xmlns='jabber:server' xmlns:stream='http://etherx.jabber.org/streams' id='tigase-server-error' from='" + this.handler.getDefHostName() + "' xml:lang='en'>");
        }
        strError.append("<stream:error><" + error_el + " xmlns='urn:ietf:params:xml:ns:xmpp-streams'/></stream:error></stream:stream>");
        try {
            log.log(Level.FINEST, throwable, () -> String.format("Sending stream error: %1$s: %2$s [%3$s]", error_el, strError.toString(), serv));
            this.handler.writeRawData(serv, strError.toString());
            serv.stop();
        }
        catch (Exception e) {
            serv.forceStop();
        }
    }
}

