/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DataRepository;
import tigase.db.Repository;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.xmppclient.SeeOtherHostDualIP;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.jid.BareJID;

@Repository.Meta(supportedUris={"jdbc:[^:]+:.*"})
public class SeeOtherHostDualIPSQLRepository
implements SeeOtherHostDualIP.DualIPRepository<DataRepository> {
    public static final String CLUSTER_NODES_TABLE = "tig_cluster_nodes";
    public static final String DB_GET_ALL_DATA_DB_QUERY_KEY = "cm-see-other-host/get-all-data-query";
    public static final String GET_ALL_QUERY_TIMEOUT_QUERY_KEY = "cm-see-other-host/get-all-query-timeout";
    private static final String DEF_DB_GET_ALL_DATA_QUERY = "select * from tig_cluster_nodes";
    private static final int DEF_QUERY_TIME_OUT = 10;
    private static final Logger log = Logger.getLogger(SeeOtherHostDualIPSQLRepository.class.getName());
    private DataRepository data_repo = null;
    @ConfigField(desc="SQL query to retrieve data")
    private String get_all_data_query = "select * from tig_cluster_nodes";
    @ConfigField(desc="SQL query timeout")
    private int query_timeout = 10;

    @Override
    public void setDataSource(DataRepository dataSource) {
        this.data_repo = dataSource;
        try {
            this.checkDB();
            this.data_repo.initPreparedStatement(this.get_all_data_query, this.get_all_data_query);
        }
        catch (SQLException ex) {
            throw new RuntimeException("Repository initialization failed", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<BareJID, BareJID> queryAllDB() throws SQLException {
        ConcurrentSkipListMap<BareJID, BareJID> result = new ConcurrentSkipListMap<BareJID, BareJID>();
        if (this.data_repo == null) {
            return null;
        }
        PreparedStatement get_all = this.data_repo.getPreparedStatement(null, this.get_all_data_query);
        get_all.setQueryTimeout(10);
        ResultSet rs = null;
        PreparedStatement preparedStatement = get_all;
        synchronized (preparedStatement) {
            try {
                rs = get_all.executeQuery();
                while (rs.next()) {
                    String user_jid = rs.getString("hostname");
                    String node_jid = rs.getString("secondary");
                    try {
                        BareJID hostname_hid = BareJID.bareJIDInstance((String)user_jid);
                        BareJID secondary = BareJID.bareJIDInstance((String)node_jid);
                        result.put(hostname_hid, secondary);
                    }
                    catch (TigaseStringprepException ex) {
                        log.warning("Invalid host or secondary hostname JID: " + user_jid + ", " + node_jid);
                    }
                }
            }
            finally {
                this.data_repo.release(null, rs);
            }
        }
        log.log(Level.CONFIG, "Loaded " + result.size() + " redirect definitions from database.");
        return result;
    }

    private void checkDB() throws SQLException {
        if (!this.data_repo.checkTable(CLUSTER_NODES_TABLE)) {
            throw new SQLException("Nodes redirection table: tig_cluster_nodes doesn't exits!");
        }
    }
}

