/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.core.Kernel;
import tigase.server.Packet;
import tigase.server.xmppclient.RegistrationThrottlingProcessor;
import tigase.xmpp.XMPPIOService;

@Bean(name="registration-throttling", parent=Kernel.class, active=false, exportable=true)
public class RegistrationThrottling
implements UnregisterAware {
    public static final String ID = "registration-throttling";
    @ConfigField(desc="Limit of allowed account registrations for IP in specified period")
    protected Integer limit = 4;
    @ConfigField(desc="Period for which limit is set")
    protected Duration period = Duration.ofDays(1L);
    private AtomicBoolean cleanUpScheduled = new AtomicBoolean(false);
    private ConcurrentHashMap<String, List<Long>> registrations = new ConcurrentHashMap();
    private Timer timer = new Timer("registration-timer", true);

    public void startFor(Kernel kernel) {
        kernel.registerBean(RegistrationThrottlingProcessor.class).exec();
    }

    public void stopFor(Kernel kernel) {
        kernel.unregister("registration-throttling-processor");
    }

    @Override
    public void beforeUnregister() {
        this.timer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkLimits(XMPPIOService service) {
        List registrationTimes;
        List list = registrationTimes = this.registrations.computeIfAbsent(service.getRemoteAddress(), k -> new ArrayList());
        synchronized (list) {
            this.cleanUp(registrationTimes);
            if (registrationTimes.size() <= this.limit) {
                registrationTimes.add(System.currentTimeMillis());
            }
            return registrationTimes.size() <= this.limit;
        }
    }

    protected boolean checkLimits(XMPPIOService service, Packet packet) {
        boolean result = this.checkLimits(service);
        this.scheduleCleanUpIfNeeded();
        return result;
    }

    protected void cleanUp(List<Long> registrationTimes) {
        long oldestAllowed = System.currentTimeMillis() - this.period.toMillis() + 5000L;
        registrationTimes.removeIf(ts -> ts < oldestAllowed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUpFromTimer() {
        Iterator<Map.Entry<String, List<Long>>> it = this.registrations.entrySet().iterator();
        while (it.hasNext()) {
            List<Long> registrationTimes;
            Map.Entry<String, List<Long>> e = it.next();
            List<Long> list = registrationTimes = e.getValue();
            synchronized (list) {
                this.cleanUp(registrationTimes);
                if (registrationTimes.isEmpty()) {
                    it.remove();
                }
            }
        }
        Optional earliest = this.registrations.values().stream().flatMap(times -> times.stream()).min(Long::compare);
        if (earliest.isPresent()) {
            this.timer.schedule((TimerTask)new CleanUpTask(), System.currentTimeMillis() - (Long)earliest.get());
        } else {
            this.cleanUpScheduled.compareAndSet(true, false);
        }
    }

    protected void scheduleCleanUpIfNeeded() {
        if (this.cleanUpScheduled.compareAndSet(false, true)) {
            this.timer.schedule((TimerTask)new CleanUpTask(), this.period.toMillis());
        }
    }

    protected class CleanUpTask
    extends TimerTask {
        protected CleanUpTask() {
        }

        @Override
        public void run() {
            RegistrationThrottling.this.cleanUpFromTimer();
        }
    }
}

