/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.rtbl.adhoc;

import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.db.TigaseDBException;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.rtbl.RTBL;
import tigase.server.rtbl.RTBLComponent;
import tigase.server.rtbl.RTBLSubscribeModule;
import tigase.server.rtbl.adhoc.AbstractAdHocCommand;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.JID;

@Bean(name="rtbl-command-delete", parent=RTBLComponent.class, active=true)
public class RTBLDeleteCommand
extends AbstractAdHocCommand {
    private static final Logger log = Logger.getLogger(RTBLDeleteCommand.class.getCanonicalName());
    @Inject
    private RTBLSubscribeModule subscribeModule;

    @Override
    public String getName() {
        return "Delete real-time blocklist";
    }

    @Override
    public String getNode() {
        return "rtbl-delete";
    }

    @Override
    protected Form prepareForm(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        Form form = new Form("form", "Delete real-time blocklist", "Select blocklist to delete");
        List<RTBL> blocklists = this.getRepository().getBlockLists();
        blocklists.sort(Comparator.comparing(RTBL::getJID).thenComparing(RTBL::getNode));
        String[] ids = (String[])blocklists.stream().map(rtbl -> rtbl.getJID().toString() + "/" + rtbl.getNode()).toArray(String[]::new);
        form.addField(Field.fieldListSingle((String)"blocklist", (String)"", (String)"Blocklist", (String[])ids, (String[])ids));
        return form;
    }

    @Override
    protected Form submitForm(AdhHocRequest request, AdHocResponse response, Form form) throws AdHocCommandException {
        String blocklistId = this.assertNotEmpty(form.getAsString("blocklist"), "You need to select blocklist!");
        JID tmp = JID.jidInstanceNS((String)blocklistId);
        try {
            this.getRepository().remove(tmp.getBareJID(), tmp.getResource());
            this.subscribeModule.unsubscribe(tmp.getBareJID(), tmp.getResource());
        }
        catch (TigaseDBException e) {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "failed to update database", e);
            }
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR);
        }
        return null;
    }
}

