/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.rtbl;

import tigase.kernel.beans.Bean;
import tigase.server.rtbl.RTBLComponent;
import tigase.server.rtbl.RTBLIqModule;
import tigase.util.common.TimerTask;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;

@Bean(name="rtblSubscribeModule", parent=RTBLComponent.class, active=true)
public class RTBLSubscribeModule
extends RTBLIqModule<Context> {
    private static final String PUBSUB_XMLNS = "http://jabber.org/protocol/pubsub";

    public RTBLSubscribeModule() {
        super("sub-");
    }

    public void subscribe(BareJID jid, String node) {
        this.sendIq(jid, StanzaType.set, iqEl -> iqEl.withElement("pubsub", PUBSUB_XMLNS, pubsubEl -> pubsubEl.withElement("subscribe", subscribeEl -> subscribeEl.withAttribute("node", node).withAttribute("jid", this.getOwnJID().toString()))), () -> new Context(Action.subscribe, node));
    }

    public void unsubscribe(BareJID jid, String node) {
        this.sendIq(jid, StanzaType.set, iqEl -> iqEl.withElement("pubsub", PUBSUB_XMLNS, pubsubEl -> pubsubEl.withElement("unsubscribe", unsubscribeEl -> unsubscribeEl.withAttribute("node", node).withAttribute("jid", this.getOwnJID().toString()))), () -> new Context(Action.unsubscribe, node));
    }

    @Override
    protected void handleResult(final RTBLIqModule.ResultEvent event, final Context ctx) {
        if (event.getResult() == RTBLIqModule.ResultEvent.Result.failureRetry) {
            this.getComponent().addTimerTask(new TimerTask(){

                @Override
                public void run() {
                    switch (ctx.action()) {
                        case subscribe: {
                            RTBLSubscribeModule.this.subscribe(event.getJid(), ctx.node());
                            break;
                        }
                        case unsubscribe: {
                            RTBLSubscribeModule.this.unsubscribe(event.getJid(), ctx.node());
                        }
                    }
                }
            }, 10000L);
        }
    }

    public record Context(Action action, String node) {
    }

    private static enum Action {
        subscribe,
        unsubscribe;

    }
}

