/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.rtbl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.eventbus.EventBus;
import tigase.eventbus.EventBusEvent;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.core.Kernel;
import tigase.server.rtbl.RTBL;
import tigase.stats.StatisticsContainerIfc;
import tigase.stats.StatisticsList;
import tigase.xmpp.jid.BareJID;

@Bean(name="rtblRepository", parent=Kernel.class, active=true, exportable=true)
public class RTBLRepository
implements Initializable,
UnregisterAware,
StatisticsContainerIfc {
    private static final Logger logger = Logger.getLogger(RTBLRepository.class.getCanonicalName());
    @Inject
    private UserRepository userRepository;
    @Inject(bean="eventBus")
    private EventBus eventBus;
    @ConfigField(desc="Reload interval")
    private long reloadInterval = TimeUnit.MINUTES.toMillis(10L);
    private BareJID repoUser = BareJID.bareJIDInstanceNS((String)"rtbl");
    private ConcurrentHashMap<Key, RTBL> cache = new ConcurrentHashMap();
    private Timer timer;
    private String name = "rtblRepository";

    @Override
    public void beforeUnregister() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.eventBus != null) {
            this.eventBus.unregisterAll(this);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void getStatistics(StatisticsList list) {
        list.add(this.getName(), "No. of lists", this.cache.size(), Level.FINE);
        this.cache.values().stream().sorted(Comparator.comparing(RTBL::getJID).thenComparing(RTBL::getNode)).forEachOrdered(rtbl -> list.add(this.getName(), "No. of items in " + rtbl.getJID() + "/" + rtbl.getNode(), rtbl.getBlocked().size(), Level.FINEST));
    }

    @Override
    public void initialize() {
        this.eventBus.registerAll(this);
        this.reload();
        if (this.reloadInterval > 0L) {
            this.timer = new Timer(true);
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    RTBLRepository.this.reload();
                }
            }, this.reloadInterval, this.reloadInterval);
        }
    }

    public List<RTBL> getBlockLists() {
        return new ArrayList<RTBL>(this.cache.values());
    }

    public RTBL getBlockList(BareJID jid, String node) {
        return this.cache.get(new Key(jid, node));
    }

    public boolean isBlocked(BareJID jid) {
        for (RTBL rtbl : this.cache.values()) {
            if (!rtbl.isBlocked(jid)) continue;
            return true;
        }
        return false;
    }

    public void update(RTBL rtbl) {
        Key key = rtbl.getKey();
        if (!this.cache.containsKey(key)) {
            return;
        }
        this.cache.put(key, rtbl);
        try {
            if (!this.userRepository.userExists(this.repoUser)) {
                this.userRepository.addUser(this.repoUser);
            }
        }
        catch (TigaseDBException tigaseDBException) {
            // empty catch block
        }
        try {
            RTBL oldList = this.loadList(key);
            Set prevBlocked = Optional.ofNullable(oldList).map(RTBL::getBlocked).orElse(Collections.emptySet());
            List<String> newToAdd = rtbl.getBlocked().stream().filter(it -> !prevBlocked.contains(it)).toList();
            for (String item : newToAdd) {
                this.updateStore(key, Action.add, item);
            }
            List oldToRemove = prevBlocked.stream().filter(it -> !rtbl.getBlocked().contains(it)).collect(Collectors.toList());
            for (String item : oldToRemove) {
                this.updateStore(key, Action.remove, item);
            }
        }
        catch (TigaseDBException ex) {
            logger.log(Level.WARNING, "failed to save updated RTBL " + rtbl);
        }
    }

    public void add(BareJID pubsubJid, String node, String hash) throws TigaseDBException {
        Key key = new Key(pubsubJid, node);
        if (this.cache.get(key) == null) {
            this.userRepository.setData(this.repoUser, key.getSubnode(), "jid", pubsubJid.toString());
            this.userRepository.setData(this.repoUser, key.getSubnode(), "node", node);
            this.userRepository.setData(this.repoUser, key.getSubnode(), "hash", hash);
            this.eventBus.fire(new RTBLAdded(pubsubJid, node, hash));
        }
    }

    @HandleEvent
    public void handleAdded(RTBLAdded event) {
        Key key = event.getKey();
        this.cache.putIfAbsent(key, new RTBL(key, event.getHash()));
    }

    public void remove(BareJID pubsubJid, String node) throws TigaseDBException {
        Key key = new Key(pubsubJid, node);
        this.userRepository.removeSubnode(this.repoUser, key.getSubnode());
        this.eventBus.fire(new RTBLRemoved(pubsubJid, node));
    }

    @HandleEvent
    public void handleRemoved(RTBLRemoved event) {
        Key key = event.getKey();
        this.cache.remove(key);
    }

    public void update(BareJID pubsubJid, String node, Action action, String id) {
        Key key = new Key(pubsubJid, node);
        this.updateStore(key, action, id);
        this.eventBus.fire(new RTBLChange(pubsubJid, node, action, id));
    }

    @HandleEvent
    public void handleChange(RTBLChange event) {
        Key key = event.getKey();
        RTBL rtbl = this.cache.get(key);
        if (rtbl != null) {
            switch (event.getAction()) {
                case add: {
                    rtbl.getBlocked().add(event.getId());
                    break;
                }
                case remove: {
                    rtbl.getBlocked().remove(event.getId());
                }
            }
        }
    }

    public void purge(BareJID pubsubJid, String node) {
        Key key = new Key(pubsubJid, node);
        RTBL rtbl = this.cache.get(key);
        if (rtbl != null) {
            HashSet<String> toRemove = new HashSet<String>(rtbl.getBlocked());
            rtbl.getBlocked().clear();
            for (String item : toRemove) {
                this.updateStore(key, Action.remove, item);
            }
            this.eventBus.fire(new RTBLReload(pubsubJid, node));
        }
    }

    public void reload(BareJID pubsubJid, String node) {
        this.eventBus.fire(new RTBLRemoved(pubsubJid, node));
    }

    @HandleEvent
    public void handleReload(RTBLReload event) {
        try {
            RTBL rtbl = this.loadList(event.getKey());
            if (rtbl != null) {
                this.cache.replace(rtbl.getKey(), rtbl);
            }
        }
        catch (TigaseDBException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateStore(Key key, Action action, String id) {
        switch (action) {
            case add: {
                try {
                    this.userRepository.setData(this.repoUser, key.getSubnode(), id, id);
                }
                catch (TigaseDBException ex) {
                    logger.log(Level.WARNING, "failed to save updated RTBL " + key + ", adding " + id + " failed", ex);
                }
                break;
            }
            case remove: {
                try {
                    this.userRepository.removeData(this.repoUser, key.getSubnode(), id);
                    break;
                }
                catch (TigaseDBException ex) {
                    logger.log(Level.WARNING, "failed to save updated RTBL " + key + ", removing " + id + " failed", ex);
                }
            }
        }
    }

    private RTBL loadList(Key key) throws TigaseDBException {
        if (this.userRepository.userExists(this.repoUser)) {
            try {
                Map<String, String> data = this.userRepository.getDataMap(this.repoUser, key.getSubnode());
                BareJID jid = BareJID.bareJIDInstanceNS((String)data.remove("jid"));
                String node = data.remove("node");
                String hash = data.remove("hash");
                if (jid == null || hash == null || node == null) {
                    return null;
                }
                return new RTBL(jid, node, hash, new CopyOnWriteArraySet<String>(data.keySet()));
            }
            catch (TigaseDBException ex) {
                logger.log(Level.WARNING, "could not load RTBL for " + key, ex);
            }
        }
        return null;
    }

    protected void reload() {
        try {
            String[] subnodes;
            if (this.userRepository.userExists(this.repoUser) && (subnodes = this.userRepository.getSubnodes(this.repoUser)) != null) {
                for (String subnode : subnodes) {
                    Key key = Key.parse(subnode);
                    try {
                        if (key == null) continue;
                        RTBL rtbl = this.loadList(key);
                        if (rtbl != null) {
                            this.cache.put(key, rtbl);
                            continue;
                        }
                        this.cache.remove(key);
                    }
                    catch (TigaseDBException ex) {
                        logger.log(Level.WARNING, "could not load RTBL " + key, ex);
                    }
                }
            }
        }
        catch (TigaseDBException ex) {
            logger.log(Level.WARNING, "could not load list of RTBLs", ex);
        }
    }

    public static class Key {
        private final BareJID jid;
        private final String node;

        public Key(BareJID jid, String node) {
            this.jid = jid;
            this.node = node;
        }

        public String getNode() {
            return this.node;
        }

        public BareJID getJid() {
            return this.jid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.jid, key.jid) && Objects.equals(this.node, key.node);
        }

        public int hashCode() {
            return Objects.hash(this.jid, this.node);
        }

        public String getSubnode() {
            return this.jid.toString() + "|" + this.node.replaceAll("/", "|");
        }

        public static Key parse(String data) {
            String[] parts = data.split("\\|");
            if (parts != null && parts.length > 1) {
                return new Key(BareJID.bareJIDInstanceNS((String)parts[0]), Arrays.stream(parts).skip(1L).collect(Collectors.joining("|")));
            }
            return null;
        }

        public String toString() {
            return "jid: " + this.jid + ", node: " + this.node;
        }
    }

    public static enum Action {
        add,
        remove;

    }

    public static class RTBLAdded
    extends RTBLEvent
    implements Serializable,
    EventBusEvent {
        private String hash;

        public RTBLAdded() {
        }

        public RTBLAdded(BareJID jid, String node, String hash) {
            super(jid, node);
            this.hash = hash;
        }

        public String getHash() {
            return this.hash;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }
    }

    public static class RTBLRemoved
    extends RTBLEvent
    implements Serializable,
    EventBusEvent {
        public RTBLRemoved() {
        }

        public RTBLRemoved(BareJID jid, String node) {
            super(jid, node);
        }
    }

    public static class RTBLChange
    extends RTBLEvent
    implements Serializable,
    EventBusEvent {
        private Action action;
        private String id;

        public RTBLChange() {
        }

        public RTBLChange(BareJID jid, String node, Action action, String id) {
            super(jid, node);
            this.action = action;
            this.id = id;
        }

        public Action getAction() {
            return this.action;
        }

        public void setAction(Action action) {
            this.action = action;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public static class RTBLReload
    extends RTBLEvent
    implements Serializable,
    EventBusEvent {
        public RTBLReload() {
        }

        public RTBLReload(BareJID jid, String node) {
            super(jid, node);
        }
    }

    public static abstract class RTBLEvent
    implements Serializable,
    EventBusEvent {
        private BareJID jid;
        private String node;

        public RTBLEvent() {
        }

        public RTBLEvent(BareJID jid, String node) {
            this.jid = jid;
            this.node = node;
        }

        public BareJID getJid() {
            return this.jid;
        }

        public void setJid(BareJID jid) {
            this.jid = jid;
        }

        public String getNode() {
            return this.node;
        }

        public void setNode(String node) {
            this.node = node;
        }

        public Key getKey() {
            return new Key(this.jid, this.node);
        }
    }
}

