/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.amp.db;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.annotations.TigaseDeprecated;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.DataSourceHelper;
import tigase.db.MsgRepositoryIfc;
import tigase.db.NonAuthUserRepository;
import tigase.db.OfflineMsgRepositoryIfc;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.db.beans.MDRepositoryBean;
import tigase.db.beans.MDRepositoryBeanWithStatistics;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.core.Kernel;
import tigase.osgi.ModulesManagerImpl;
import tigase.server.BasicComponent;
import tigase.server.xmppsession.SessionManager;
import tigase.xml.Element;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public abstract class MsgRepository<T, S extends DataSource>
implements MsgRepositoryIfc<S> {
    public static final String OFFLINE_MSGS_KEY = "offline-msgs";
    public static final String MSGS_STORE_LIMIT_KEY = "store-limit";
    protected static final int MAX_QUEUE_SIZE = 1000;
    private static final long MSGS_STORE_LIMIT_VAL = 100L;
    private static final String MSGS_USER_STORE_LIMIT_ENABLE_KEY = "user-store-limit-enable";
    private static final String NULL_STR = "NULL";
    private static final Map<String, MsgRepositoryIfc> repos = new ConcurrentSkipListMap<String, MsgRepositoryIfc>();
    protected AtomicInteger awaitingInExpiredQueue = new AtomicInteger(0);
    protected long earliestOffline = Long.MAX_VALUE;
    protected SimpleParser parser = SingletonFactory.getParserInstance();
    protected DelayQueue<MsgDBItem<T>> expiredQueue = new DelayQueue<MsgDBItem<T>>(){

        @Override
        public boolean offer(MsgDBItem<T> tMsgDBItem) {
            boolean result = false;
            result = MsgRepository.this.msgRepositoryIfc != null ? MsgRepository.this.msgRepositoryIfc.offerExpired(MsgRepository.this, tMsgDBItem.db_id, tMsgDBItem.msg, tMsgDBItem.expired) : super.offer(tMsgDBItem);
            if (result) {
                MsgRepository.this.awaitingInExpiredQueue.incrementAndGet();
            }
            return result;
        }
    };
    @ConfigField(desc="Limit of offline messages", alias="store-limit")
    private long msgs_store_limit = 100L;
    @ConfigField(desc="Support limits of offline messages set by users", alias="user-store-limit-enable")
    private boolean msgs_user_store_limit = false;
    @Inject
    private UserRepository userRepository;
    @Inject(nullAllowed=true)
    private MsgRepositoryPoolBean msgRepositoryIfc;

    public static MsgRepositoryIfc getInstance(String cls, String id_string) throws TigaseDBException {
        try {
            String key;
            MsgRepositoryIfc result;
            if (cls == null) {
                cls = RepositoryFactory.getRepoClassName(MsgRepositoryIfc.class, id_string);
            }
            if ((result = repos.get(key = cls + "#" + id_string)) == null) {
                result = (MsgRepositoryIfc)ModulesManagerImpl.getInstance().forName(cls).newInstance();
                repos.put(key, result);
            }
            return result;
        }
        catch (Exception ex) {
            throw new TigaseDBException("Could not create instance of " + cls + " for uri " + id_string, ex);
        }
    }

    @Override
    public abstract Queue<Element> loadMessagesToJID(List<String> var1, XMPPResourceConnection var2, boolean var3, OfflineMessagesProcessor var4) throws UserNotFoundException;

    @Override
    public abstract int deleteMessagesToJID(List<String> var1, XMPPResourceConnection var2) throws UserNotFoundException;

    @Override
    @Deprecated
    public void initRepository(String conn_str, Map<String, String> map) throws DBInitException {
        if (map != null) {
            String msgs_user_store_limit_enable;
            String msgs_store_limit_str = map.get(MSGS_STORE_LIMIT_KEY);
            if (msgs_store_limit_str != null) {
                this.msgs_store_limit = Long.parseLong(msgs_store_limit_str);
            }
            if ((msgs_user_store_limit_enable = map.get(MSGS_USER_STORE_LIMIT_ENABLE_KEY)) != null) {
                this.msgs_user_store_limit = Boolean.parseBoolean(msgs_user_store_limit_enable);
            }
        }
    }

    @Override
    @Deprecated
    public Element getMessageExpired(long time, boolean delete) {
        MsgDBItem item;
        if (this.expiredQueue.size() == 0) {
            this.loadExpiredQueue(1000);
        } else {
            item = (MsgDBItem)this.expiredQueue.peek();
            if (item != null && this.earliestOffline < item.expired.getTime()) {
                this.loadExpiredQueue(item.expired);
            }
        }
        item = (MsgDBItem)this.expiredQueue.poll();
        if (item == null) {
            return null;
        }
        this.awaitingInExpiredQueue.decrementAndGet();
        if (delete) {
            this.deleteMessage(item.db_id);
        }
        return item.msg;
    }

    @Override
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0")
    @Deprecated
    public void setCondition(ReentrantLock lock, Condition condition) {
    }

    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="Will be replaced by method in MsgRepositoryIfc returning loaded items")
    @Deprecated
    protected abstract void loadExpiredQueue(int var1);

    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="Will be replaced by method in MsgRepositoryIfc returning loaded items")
    @Deprecated
    protected abstract void loadExpiredQueue(Date var1);

    protected abstract void deleteMessage(T var1);

    protected long getMsgsStoreLimit(BareJID userJid, NonAuthUserRepository userRepo) throws UserNotFoundException {
        if (this.msgs_user_store_limit) {
            String limitStr = userRepo.getPublicData(userJid, OFFLINE_MSGS_KEY, MSGS_STORE_LIMIT_KEY, NULL_STR);
            if (limitStr == null) {
                throw new UserNotFoundException("User " + userJid + " not found in user repository");
            }
            if (NULL_STR != limitStr) {
                long limit = Long.parseLong(limitStr);
                if (limit == 0L) {
                    limit = -1L;
                }
                return limit;
            }
        } else if (!this.userRepository.userExists(userJid)) {
            throw new UserNotFoundException("User " + userJid + " not found in user repository");
        }
        return this.msgs_store_limit;
    }

    public static class MsgDBItem<T>
    implements Delayed {
        public final T db_id;
        public final Date expired;
        public final Element msg;

        public MsgDBItem(T db_id, Element msg, Date expired) {
            this.db_id = db_id;
            this.msg = msg;
            this.expired = expired;
        }

        @Override
        public int compareTo(Delayed o) {
            return (int)(this.getDelay(TimeUnit.NANOSECONDS) - o.getDelay(TimeUnit.NANOSECONDS));
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expired.getTime() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }
    }

    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0", note="It is expected to be moved to MsgRepositoryIfc")
    @Deprecated
    public static interface MsgRepositoryPoolBean<T> {
        public boolean offerExpired(MsgRepositoryIfc var1, T var2, Element var3, Date var4);
    }

    @Bean(name="msgRepository", parent=Kernel.class, active=true, exportable=true)
    @ConfigType(value={ConfigTypeEnum.DefaultMode, ConfigTypeEnum.SessionManagerMode, ConfigTypeEnum.ConnectionManagersMode, ConfigTypeEnum.ComponentMode})
    public static class MsgRepositoryMDBean
    extends MDRepositoryBeanWithStatistics<MsgRepositoryIfc>
    implements MsgRepositoryIfc,
    MsgRepositoryPoolBean {
        private static final Logger log = Logger.getLogger(MsgRepositoryMDBean.class.getCanonicalName());
        private DelayQueue<RepoAwareMsgDBItem> expiredQueue = new DelayQueue();
        private long earliestOffline = Long.MAX_VALUE;
        @TigaseDeprecated(since="8.2.0", removeIn="9.0.0")
        @Deprecated
        private final transient ReentrantLock lock = new ReentrantLock();
        @TigaseDeprecated(since="8.2.0", removeIn="9.0.0")
        @Deprecated
        private final Condition expiredMessagesCondition = this.lock.newCondition();

        public MsgRepositoryMDBean() {
            super(MsgRepositoryIfc.class, OfflineMsgRepositoryIfc.class);
        }

        @Override
        public boolean belongsTo(Class<? extends BasicComponent> component) {
            return SessionManager.class.isAssignableFrom(component);
        }

        @Override
        public Element getMessageExpired(long time, boolean delete) {
            RepoAwareMsgDBItem item;
            if (this.expiredQueue.size() == 0) {
                this.loadExpiredQueue(1000);
            } else {
                for (MsgRepositoryIfc repo : this.getRepositories().values()) {
                    if (!(repo instanceof MsgRepository) || ((MsgRepository)repo).awaitingInExpiredQueue.get() != 0) continue;
                    ((MsgRepository)repo).loadExpiredQueue(1000);
                }
                item = (RepoAwareMsgDBItem)this.expiredQueue.peek();
                if (item != null && this.earliestOffline < item.expired.getTime()) {
                    this.loadExpiredQueue(item.expired);
                }
            }
            item = null;
            while (item == null) {
                try {
                    item = (RepoAwareMsgDBItem)this.expiredQueue.take();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (item.getRepo() instanceof MsgRepository) {
                ((MsgRepository)item.getRepo()).awaitingInExpiredQueue.decrementAndGet();
                if (delete) {
                    ((MsgRepository)item.getRepo()).deleteMessage(item.db_id);
                }
            }
            return item.msg;
        }

        public boolean offerExpired(MsgRepositoryIfc repo, Object id, Element element, Date expired) {
            return this.expiredQueue.offer(new RepoAwareMsgDBItem(repo, id, element, expired));
        }

        protected void loadExpiredQueue(int min_elements) {
            int max = Math.max(min_elements / this.getRepositories().size(), 1);
            for (MsgRepositoryIfc repo : this.getRepositories().values()) {
                if (!(repo instanceof MsgRepository)) continue;
                ((MsgRepository)repo).loadExpiredQueue(max);
            }
            this.earliestOffline = Long.MAX_VALUE;
        }

        protected void loadExpiredQueue(Date expired) {
            if (this.expiredQueue.size() > 100000) {
                this.expiredQueue.clear();
                for (MsgRepositoryIfc repo : this.getRepositories().values()) {
                    if (!(repo instanceof MsgRepository)) continue;
                    ((MsgRepository)repo).awaitingInExpiredQueue.set(0);
                }
            }
            for (MsgRepositoryIfc repo : this.getRepositories().values()) {
                if (!(repo instanceof MsgRepository)) continue;
                ((MsgRepository)repo).loadExpiredQueue(expired);
            }
            this.earliestOffline = Long.MAX_VALUE;
        }

        @Override
        public Queue<Element> loadMessagesToJID(XMPPResourceConnection session, boolean delete) throws UserNotFoundException, TigaseDBException {
            Queue<Element> result = null;
            try {
                MsgRepositoryIfc repo = (MsgRepositoryIfc)this.getRepository(session.getBareJID().getDomain());
                result = repo.loadMessagesToJID(session, delete);
            }
            catch (NotAuthorizedException ex) {
                log.log(Level.WARNING, "Session not authorized yet!", ex);
            }
            return result;
        }

        @Override
        public boolean storeMessage(JID from, JID to, Date expired, Element msg, NonAuthUserRepository userRepo) throws UserNotFoundException, TigaseDBException {
            MsgRepositoryIfc repo = (MsgRepositoryIfc)this.getRepository(to.getDomain());
            boolean result = repo.storeMessage(from, to, expired, msg, userRepo);
            if (result && expired != null && expired.getTime() < this.earliestOffline) {
                this.earliestOffline = expired.getTime();
            }
            return result;
        }

        @Override
        @Deprecated
        public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
        }

        @Override
        public Map<Enum, Long> getMessagesCount(JID to) throws UserNotFoundException, TigaseDBException {
            return ((MsgRepositoryIfc)this.getRepository(to.getDomain())).getMessagesCount(to);
        }

        @Override
        public List<Element> getMessagesList(JID to) throws UserNotFoundException, TigaseDBException {
            return ((MsgRepositoryIfc)this.getRepository(to.getDomain())).getMessagesList(to);
        }

        @Override
        public void setCondition(ReentrantLock lock, Condition condition) {
        }

        public int deleteMessagesToJID(List db_ids, XMPPResourceConnection session) throws UserNotFoundException {
            return ((MsgRepositoryIfc)this.getRepository(session.getDomainAsJID().getDomain())).deleteMessagesToJID(db_ids, session);
        }

        public Queue<Element> loadMessagesToJID(List db_ids, XMPPResourceConnection session, boolean delete, OfflineMessagesProcessor proc) throws UserNotFoundException, TigaseDBException {
            return ((MsgRepositoryIfc)this.getRepository(session.getDomainAsJID().getDomain())).loadMessagesToJID(db_ids, session, delete, proc);
        }

        @Override
        public void setDataSource(DataSource dataSource) {
        }

        @Override
        public Class<?> getDefaultBeanClass() {
            return MsgRepositoryConfigBean.class;
        }

        @Override
        protected Class<? extends MsgRepositoryIfc> findClassForDataSource(DataSource dataSource) throws DBInitException {
            return DataSourceHelper.getDefaultClass(MsgRepository.class, dataSource.getResourceUri());
        }

        @Override
        protected void initializeRepository(String domain, MsgRepositoryIfc repo) {
            super.initializeRepository(domain, repo);
            repo.setCondition(this.lock, this.expiredMessagesCondition);
        }

        protected <T> T getValueForDomain(Map<String, T> map, String domain) {
            T value = map.get(domain);
            if (value == null) {
                value = map.get("default");
            }
            return value;
        }

        public static class RepoAwareMsgDBItem
        extends MsgDBItem {
            private final MsgRepositoryIfc repo;

            public RepoAwareMsgDBItem(MsgRepositoryIfc repo, Object db_id, Element msg, Date expired) {
                super(db_id, msg, expired);
                this.repo = repo;
            }

            public MsgRepositoryIfc getRepo() {
                return this.repo;
            }
        }

        public static class MsgRepositoryConfigBean
        extends MDRepositoryBean.MDRepositoryConfigBean<MsgRepositoryIfc> {
        }
    }

    public static interface OfflineMessagesProcessor {
        public void stamp(Element var1, String var2);
    }

    public static enum MSG_TYPES {
        none(0),
        message(1),
        presence(2);

        private final int numVal;

        public static MSG_TYPES getFromInt(int type) {
            switch (type) {
                case 1: {
                    return message;
                }
                case 2: {
                    return presence;
                }
            }
            return none;
        }

        private MSG_TYPES(int numVal) {
            this.numVal = numVal;
        }

        public int getNumVal() {
            return this.numVal;
        }
    }
}

