/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.amp.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.db.DataSourceHelper;
import tigase.db.beans.MDRepositoryBean;
import tigase.db.beans.MDRepositoryBeanWithStatistics;
import tigase.kernel.beans.Bean;
import tigase.server.amp.AmpComponent;
import tigase.server.amp.JidResourceMap;
import tigase.server.amp.db.MsgBroadcastRepositoryIfc;
import tigase.server.amp.db.MsgRepository;
import tigase.xml.Element;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public abstract class MsgBroadcastRepository<T, S extends DataSource>
implements DataSourceAware<S> {
    protected Map<String, BroadcastMsg> broadcastMessages = new ConcurrentHashMap<String, BroadcastMsg>();
    protected long broadcastMessagesLastCleanup = 0L;
    protected SimpleParser parser = SingletonFactory.getParserInstance();

    public abstract void loadMessagesToBroadcast();

    public BroadcastMsg getBroadcastMsg(String id) {
        return this.broadcastMessages.get(id);
    }

    public String dumpBroadcastMessageKeys() {
        StringBuilder sb = new StringBuilder();
        for (String key : this.broadcastMessages.keySet()) {
            if (sb.length() == 0) {
                sb.append("[");
            } else {
                sb.append(",");
            }
            sb.append(key);
        }
        return sb.append("]").toString();
    }

    public Collection<BroadcastMsg> getBroadcastMessages() {
        long now = System.currentTimeMillis();
        if (now - this.broadcastMessagesLastCleanup > 60000L) {
            this.broadcastMessagesLastCleanup = now;
            ArrayList<String> toRemove = new ArrayList<String>();
            for (Map.Entry<String, BroadcastMsg> e : this.broadcastMessages.entrySet()) {
                if (e.getValue().getDelay(TimeUnit.MILLISECONDS) >= 0L) continue;
                toRemove.add(e.getKey());
            }
            for (String key : toRemove) {
                this.broadcastMessages.remove(key);
            }
        }
        return Collections.unmodifiableCollection(this.broadcastMessages.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateBroadcastMessage(String id, Element msg, Date expire, BareJID recipient) {
        boolean isNew = false;
        Map<String, BroadcastMsg> map = this.broadcastMessages;
        synchronized (map) {
            BroadcastMsg<Object> bmsg = this.broadcastMessages.get(id);
            if (bmsg == null) {
                bmsg = new BroadcastMsg<Object>(null, msg, expire);
                this.broadcastMessages.put(id, bmsg);
                isNew = true;
                this.insertBroadcastMessage(id, msg, expire, recipient);
            }
            if (bmsg.addRecipient(recipient)) {
                this.ensureBroadcastMessageRecipient(id, recipient);
            }
            return isNew;
        }
    }

    protected abstract void ensureBroadcastMessageRecipient(String var1, BareJID var2);

    protected abstract void insertBroadcastMessage(String var1, Element var2, Date var3, BareJID var4);

    public class BroadcastMsg<T>
    extends MsgRepository.MsgDBItem<T> {
        private JidResourceMap<Boolean> recipients;

        public BroadcastMsg(T db_id, Element msg, Date expired) {
            super(db_id, msg, expired);
            this.recipients = new JidResourceMap();
        }

        public boolean needToSend(JID jid) {
            return this.recipients.containsKey(jid.getBareJID()) && (jid.getResource() == null || !this.recipients.containsKey(jid));
        }

        public void markAsSent(JID jid) {
            this.recipients.put(jid, Boolean.TRUE);
        }

        protected boolean addRecipient(BareJID jid) {
            if (this.recipients.containsKey(jid)) {
                return false;
            }
            this.recipients.put(JID.jidInstance((BareJID)jid), Boolean.TRUE);
            return true;
        }
    }

    @Bean(name="msgBroadcastRepository", parent=AmpComponent.class, active=true)
    public static class MsgBroadcastRepositoryBean
    extends MDRepositoryBeanWithStatistics<MsgBroadcastRepository>
    implements MsgBroadcastRepositoryIfc {
        public MsgBroadcastRepositoryBean() {
            super(MsgBroadcastRepositoryIfc.class);
        }

        @Override
        public void setDataSource(DataSource dataSource) {
        }

        @Override
        public void loadMessagesToBroadcast() {
            ((MsgBroadcastRepository)this.getRepository("default")).loadMessagesToBroadcast();
        }

        @Override
        public BroadcastMsg getBroadcastMsg(String id) {
            return ((MsgBroadcastRepository)this.getRepository("default")).getBroadcastMsg(id);
        }

        @Override
        public String dumpBroadcastMessageKeys() {
            return ((MsgBroadcastRepository)this.getRepository("default")).dumpBroadcastMessageKeys();
        }

        @Override
        public Collection<BroadcastMsg> getBroadcastMessages() {
            return ((MsgBroadcastRepository)this.getRepository("default")).getBroadcastMessages();
        }

        @Override
        public boolean updateBroadcastMessage(String id, Element msg, Date expire, BareJID recipient) {
            return ((MsgBroadcastRepository)this.getRepository("default")).updateBroadcastMessage(id, msg, expire, recipient);
        }

        @Override
        public Class<?> getDefaultBeanClass() {
            return MsgBroadcastRepositoryConfigBean.class;
        }

        @Override
        protected Class<? extends MsgBroadcastRepository> findClassForDataSource(DataSource dataSource) throws DBInitException {
            return DataSourceHelper.getDefaultClass(MsgBroadcastRepository.class, dataSource.getResourceUri());
        }

        public static class MsgBroadcastRepositoryConfigBean
        extends MDRepositoryBean.MDRepositoryConfigBean<MsgBroadcastRepository> {
        }
    }
}

