/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.amp;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.selector.ClusterModeRequired;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.core.Kernel;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Packet;
import tigase.server.amp.ActionIfc;
import tigase.server.amp.ActionResultsHandlerIfc;
import tigase.server.amp.ConditionIfc;
import tigase.server.amp.action.Broadcast;
import tigase.server.amp.cond.Deliver;
import tigase.server.amp.cond.ExpireAt;
import tigase.server.amp.cond.MatchResource;
import tigase.sys.TigaseRuntime;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.JID;

@Bean(name="amp", parent=Kernel.class, active=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode, ConfigTypeEnum.SessionManagerMode, ConfigTypeEnum.ConnectionManagersMode, ConfigTypeEnum.ComponentMode})
@ClusterModeRequired(active=false)
public class AmpComponent
extends AbstractMessageReceiver
implements ActionResultsHandlerIfc,
RegistrarBean {
    private static final String AMP_NODE = "http://jabber.org/protocol/amp";
    private static final Logger log = Logger.getLogger(AmpComponent.class.getName());
    private static final String AMP_XMLNS = "http://jabber.org/protocol/amp";
    private static final Element top_feature = new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/amp"});
    @Inject
    protected Broadcast broadcast = null;
    private ConcurrentSkipListMap<String, ActionIfc> actions = new ConcurrentSkipListMap();
    @Inject
    private List<ActionIfc> allActions = new ArrayList<ActionIfc>();
    private ConcurrentSkipListMap<String, ConditionIfc> conditions = new ConcurrentSkipListMap();

    public AmpComponent() {
        ConditionIfc condition = new Deliver();
        this.conditions.put(condition.getName(), condition);
        condition = new ExpireAt();
        this.conditions.put(condition.getName(), condition);
        condition = new MatchResource();
        this.conditions.put(condition.getName(), condition);
    }

    @Override
    public boolean addOutPacket(Packet packet) {
        return super.addOutPacket(packet);
    }

    @Override
    public boolean addOutPackets(Queue<Packet> packets) {
        return super.addOutPackets(packets);
    }

    @Override
    public String getDiscoCategoryType() {
        return "generic";
    }

    @Override
    public String getDiscoDescription() {
        return "IM AMP Support";
    }

    @Override
    public Element getDiscoInfo(String node, JID jid, JID from) {
        Element query = super.getDiscoInfo(node, jid, from);
        if (jid != null && (this.getName().equals(jid.getLocalpart()) || this.isLocalDomain(jid.toString())) && "http://jabber.org/protocol/amp".equals(node)) {
            if (query == null) {
                query = new Element("query");
                query.setXMLNS("http://jabber.org/protocol/disco#info");
            }
            query.addChild((XMLNodeIfc)new Element("identity", new String[]{"name", "category", "type"}, new String[]{this.getDiscoDescription(), "im", this.getDiscoCategoryType()}));
            query.addChild((XMLNodeIfc)top_feature);
            for (ActionIfc action : this.actions.values()) {
                query.addChild((XMLNodeIfc)new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/amp?action=" + action.getName()}));
            }
            for (ConditionIfc cond : this.conditions.values()) {
                query.addChild((XMLNodeIfc)new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/amp?condition=" + cond.getName()}));
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Found disco info: " + (query != null ? query.toString() : null));
        }
        return query;
    }

    @Override
    public int processingInThreads() {
        return TigaseRuntime.getTigaseRuntime().getCPUsNumber() * 4;
    }

    @Override
    public int processingOutThreads() {
        return TigaseRuntime.getTigaseRuntime().getCPUsNumber() * 4;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void processPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("My packet: " + packet);
        }
        if (this.broadcast.preprocess(packet)) {
            return;
        }
        ActionIfc def = null;
        def = packet.getAttributeStaticStr("offline") == null ? this.actions.get("deliver") : this.actions.get("store");
        boolean exec_def = true;
        Element amp = packet.getElement().getChild("amp", "http://jabber.org/protocol/amp");
        if (amp == null) {
            log.warning("Not an AMP packet! " + packet);
            return;
        }
        List rules = amp.getChildren();
        if (rules != null && rules.size() > 0) {
            for (Element rule : rules) {
                if (!this.matchCondition(packet, rule)) continue;
                exec_def = this.executeAction(packet, rule);
                break;
            }
        } else {
            log.warning("AMP packet but empty rule-set! " + packet);
            return;
        }
        if (exec_def) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Executing default action: " + def.getName() + ", packet: " + packet);
            }
            def.execute(packet, null);
        }
    }

    public void setAllActions(List<ActionIfc> actions) {
        ConcurrentSkipListMap<String, ActionIfc> map = new ConcurrentSkipListMap<String, ActionIfc>();
        for (ActionIfc action : actions) {
            action.setActionResultsHandler(this);
            map.put(action.getName(), action);
        }
        this.actions = map;
    }

    @Override
    public void register(Kernel kernel) {
    }

    @Override
    public void unregister(Kernel kernel) {
    }

    private boolean executeAction(Packet packet, Element rule) {
        String act = rule.getAttributeStaticStr("action");
        if (act != null) {
            ActionIfc action = this.actions.get(act);
            if (action != null) {
                boolean result = action.execute(packet, rule);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Matched action: " + action.getName() + ", result: " + result + ", packet: " + packet);
                }
                return result;
            }
            log.fine("No action found for act: " + act);
        } else {
            log.fine("No actionset for rule: " + rule);
        }
        return true;
    }

    private boolean matchCondition(Packet packet, Element rule) {
        String cond = rule.getAttributeStaticStr("condition");
        if (cond != null) {
            ConditionIfc condition = this.conditions.get(cond);
            if (condition != null) {
                boolean result = condition.match(packet, rule);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Matched condition: " + condition.getName() + ", result: " + result + ", packet: " + packet);
                }
                return result;
            }
            log.fine("No condition found for cond: " + cond);
        } else {
            log.fine("No condition set for rule: " + rule);
        }
        return false;
    }
}

