/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.io.CertificateContainerIfc;
import tigase.io.SSLContextContainerIfc;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.RegistrarBeanWithDefaultBeanClass;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.AbstractBeanConfigurator;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigurationChangedAware;
import tigase.kernel.core.Kernel;
import tigase.net.ConnectionOpenListener;
import tigase.net.ConnectionOpenThread;
import tigase.net.ConnectionType;
import tigase.net.IOService;
import tigase.net.SocketThread;
import tigase.net.SocketType;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.ServiceChecker;
import tigase.server.xmppclient.XMPPIOProcessor;
import tigase.stats.StatisticsList;
import tigase.util.common.TimerTask;
import tigase.util.repository.DataTypes;
import tigase.xml.Element;
import tigase.xmpp.StreamError;
import tigase.xmpp.XMPPDomBuilderHandler;
import tigase.xmpp.XMPPIOService;
import tigase.xmpp.XMPPIOServiceListener;
import tigase.xmpp.jid.JID;

public abstract class ConnectionManager<IO extends XMPPIOService<?>>
extends AbstractMessageReceiver
implements XMPPIOServiceListener<IO>,
RegistrarBean {
    public static final String HT_TRAFFIC_THROTTLING_PROP_KEY = "--cm-ht-traffic-throttling";
    public static final String HT_TRAFFIC_THROTTLING_PROP_VAL = "xmpp:50k:0:disc,bin:400m:0:disc";
    public static final String NET_BUFFER_HT_PROP_KEY = "--net-buff-high-throughput";
    public static final String NET_BUFFER_ST_PROP_KEY = "--net-buff-standard";
    public static final String PORT_LOCAL_HOST_PROP_KEY = "local-host";
    public static final String ST_TRAFFIC_THROTTLING_PROP_KEY = "--cm-traffic-throttling";
    public static final String ST_TRAFFIC_THROTTLING_PROP_VAL = "xmpp:2500:0:disc,bin:20m:0:disc";
    public static final String TRAFFIC_THROTTLING_PROP_KEY = "traffic-throttling";
    public static final String ELEMENTS_NUMBER_LIMIT_PROP_KEY = "elements-number-limit";
    public static final long LAST_MINUTE_BIN_LIMIT_PROP_VAL = 20000000L;
    public static final long LAST_MINUTE_PACKETS_LIMIT_PROP_VAL = 2500L;
    public static final String MAX_INACTIVITY_TIME = "max-inactivity-time";
    public static final String MAX_RECONNECTS_PROP_KEY = "max-reconnects";
    public static final int NET_BUFFER_HT_PROP_VAL = 65536;
    public static final int NET_BUFFER_ST_PROP_VAL = 2048;
    public static final int NET_BUFFER_LIMIT_HT_PROP_VAL = 0x1400000;
    public static final int NET_BUFFER_LIMIT_ST_PROP_VAL = 0x200000;
    public static final String PORT_CLASS_PROP_KEY = "class";
    public static final String PORT_IFC_PROP_KEY = "ifc";
    public static final String PORT_LISTENING_DELAY_KEY = "port-delay-listening";
    public static final boolean PORT_LISTENING_DELAY_DEF = false;
    public static final String PORT_KEY = "port-no";
    public static final String PORT_NEW_CONNECTIONS_THROTTLING_KEY = "new-connections-throttling";
    public static final String PORT_REMOTE_HOST_PROP_KEY = "remote-host";
    public static final String PORT_REMOTE_HOST_PROP_VAL = "localhost";
    public static final String PORT_SOCKET_PROP_KEY = "socket";
    public static final String PORT_TYPE_PROP_KEY = "type";
    public static final String PROP_KEY = "connections/";
    public static final int SOCKET_BUFFER_ST_PROP_VAL = 4096;
    public static final int SOCKET_BUFFER_HT_PROP_VAL = 65536;
    public static final long TOTAL_BIN_LIMIT_PROP_VAL = 0L;
    public static final long TOTAL_PACKETS_LIMIT_PROP_VAL = 0L;
    public static final String WHITE_CHAR_ACK_PROP_KEY = "white-char-ack";
    public static final String XMPP_ACK_PROP_KEY = "xmpp-ack";
    public static final boolean XMPP_ACK_PROP_VAL = false;
    public static final boolean WHITE_CHAR_ACK_PROP_VAL = false;
    public static final String PORTS_PROP_KEY = "connections/ports";
    public static final String WATCHDOG_DELAY = "watchdog_delay";
    public static final String WATCHDOG_TIMEOUT = "watchdog_timeout";
    public static final String WATCHDOG_PING_TYPE_KEY = "watchdog_ping_type";
    protected static final Element pingElement = new Element("iq", new Element[]{new Element("ping", new String[]{"xmlns"}, new String[]{"urn:xmpp:ping"})}, new String[]{"type", "id"}, new String[]{"get", "tigase-ping"});
    private static final Logger log = Logger.getLogger(ConnectionManager.class.getName());
    public static int ELEMENTS_NUMBER_LIMIT_PROP_VAL = 1000;
    private static ConnectionOpenThread connectThread = ConnectionOpenThread.getInstance();
    @ConfigField(desc="Interfaces to listen on", alias="ifc")
    public String[] PORT_IFC_PROP_VAL = new String[]{"*"};
    @ConfigField(desc="Delay before connection is established")
    protected long connectionDelay = 2000L;
    protected boolean delayPortListening = false;
    @ConfigField(desc="Limit of elements for single XMPP stanza", alias="elements-number-limit")
    protected int elements_number_limit = ELEMENTS_NUMBER_LIMIT_PROP_VAL;
    protected Kernel kernel;
    @ConfigField(desc="Default size of a network buffer", alias="net-buffer")
    protected int net_buffer = this.isHighThroughput() ? 65536 : 2048;
    @ConfigField(desc="Size of TCP receive socket buffer for connection", alias="socket-buffer-size")
    private int socketBufferSize = this.isHighThroughput() ? 65536 : 4096;
    @Inject(nullAllowed=true)
    protected XMPPIOProcessor[] processors = new XMPPIOProcessor[0];
    @ConfigField(desc="Traffic throttling")
    protected String trafficThrottling = null;
    @ConfigField(desc="Watchdog delay", alias="watchdog-delay")
    protected long watchdogDelay = 600000L;
    @ConfigField(desc="Watchdog ping type", alias="watchdog-ping-type")
    protected WATCHDOG_PING_TYPE watchdogPingType = WATCHDOG_PING_TYPE.WHITESPACE;
    @ConfigField(desc="Watchdog timeout", alias="watchdog-timeout")
    protected long watchdogTimeout = 1740000L;
    private long bytesReceived = 0L;
    private long bytesSent = 0L;
    @Inject
    private CertificateContainerIfc certificateContainer;
    @ConfigField(desc="Flash cross domain policy file path", alias="cross-domain-policy-file")
    private String flashCrossDomainPolicyFile = "etc/cross-domain-policy.xml";
    private String flassCrossDomainPolicy = null;
    private IOServiceStatisticsGetter ioStatsGetter = new IOServiceStatisticsGetter();
    @ConfigField(desc="Limit of bytes per minute for connection")
    private long last_minute_bin_limit = 20000000L;
    @ConfigField(desc="Limit of packets per minute for connection")
    private long last_minute_packets_limit = 2500L;
    @ConfigField(desc="Maximal allowed time of inactivity of connection")
    private long maxInactivityTime = this.getMaxInactiveTime();
    @ConfigField(desc="Limit of size for network buffer for connection", alias="net-buffer-limit")
    private int net_buffer_limit = 0;
    private Set<ConnectionListenerImpl> pending_open = Collections.synchronizedSet(new HashSet());
    @Inject
    private PortsConfigBean portsConfigBean;
    private ConcurrentHashMap<String, IO> services = new ConcurrentHashMap();
    private int services_size = 0;
    private long socketOverflow = 0L;
    @Inject(bean="sslContextContainer")
    private SSLContextContainerIfc sslContextContainer;
    private boolean started = false;
    @ConfigField(desc="Limit of total numer of bytes per connection")
    private long total_bin_limit = 0L;
    @ConfigField(desc="Limit of total number of packets per connection")
    private long total_packets_limit = 0L;
    private LinkedList<Map<String, Object>> waitingTasks = new LinkedList();
    private Watchdog watchdog = null;
    private long watchdogRuns = 0L;
    private long watchdogStopped = 0L;
    private long watchdogTests = 0L;
    private boolean white_char_ack = false;
    @ConfigField(desc="Action taken if XMPP limit is exceeded")
    private LIMIT_ACTION xmppLimitAction = LIMIT_ACTION.DISCONNECT;
    private boolean xmpp_ack = false;
    @ConfigField(desc="Service connection timeout", alias="service-connected-timeout")
    protected int serviceConnectedTimeout = 60;

    public ConnectionManager() {
    }

    protected ConnectionManager(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    protected boolean enableServiceConnectedTimeout(IO service) {
        return service != null && ((IOService)service).connectionType() == ConnectionType.accept;
    }

    @Override
    public void beanConfigurationChanged(Collection<String> changedFields) {
        super.beanConfigurationChanged(changedFields);
    }

    public boolean checkTrafficLimits(IO serv) {
        boolean xmppLimitHit = false;
        if (this.last_minute_packets_limit > 0L) {
            boolean bl = xmppLimitHit = ((XMPPIOService)serv).getPacketsReceived(false) >= this.last_minute_packets_limit;
        }
        if (!xmppLimitHit && this.total_packets_limit > 0L) {
            boolean bl = xmppLimitHit = ((XMPPIOService)serv).getTotalPacketsReceived() >= this.total_packets_limit;
        }
        if (xmppLimitHit) {
            Level level = Level.FINER;
            if (this.isHighThroughput()) {
                level = Level.WARNING;
            }
            switch (this.xmppLimitAction) {
                case DROP_PACKETS: {
                    if (log.isLoggable(level)) {
                        log.log(level, "[[{0}]] XMPP Limits exceeded on connection {1} dropping pakcets: {2}", new Object[]{this.getName(), serv, ((XMPPIOService)serv).getReceivedPackets()});
                    }
                    while (((XMPPIOService)serv).getReceivedPackets().poll() != null) {
                    }
                    break;
                }
                default: {
                    if (log.isLoggable(level)) {
                        log.log(level, "[[{0}]] XMPP Limits exceeded on connection {1} stopping, packets dropped: {2}", new Object[]{this.getName(), serv, ((XMPPIOService)serv).getReceivedPackets()});
                    }
                    ((XMPPIOService)serv).forceStop();
                }
            }
            return false;
        }
        boolean binLimitHit = false;
        long bytesSent = ((IOService)serv).getBytesSent(false);
        long bytesReceived = ((IOService)serv).getBytesReceived(false);
        if (this.last_minute_bin_limit > 0L) {
            binLimitHit = bytesSent >= this.last_minute_bin_limit || bytesReceived >= this.last_minute_bin_limit;
        }
        long totalSent = ((IOService)serv).getTotalBytesSent();
        long totalReceived = ((IOService)serv).getTotalBytesReceived();
        if (!binLimitHit && this.total_bin_limit > 0L) {
            boolean bl = binLimitHit = totalReceived >= this.total_bin_limit || totalSent >= this.total_bin_limit;
        }
        if (binLimitHit) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "[[{0}]] Binary Limits exceeded ({1}:{2}:{3}:{4}) on connection {5} stopping, packets dropped: {6}", new Object[]{this.getName(), bytesSent, bytesReceived, totalSent, totalReceived, serv, ((XMPPIOService)serv).getReceivedPackets()});
            }
            ((XMPPIOService)serv).forceStop();
            return false;
        }
        return true;
    }

    @Override
    public synchronized void everyMinute() {
        int tmp;
        super.everyMinute();
        this.services_size = tmp = this.services.size();
        this.doForAllServices(this.ioStatsGetter);
    }

    @Override
    public int hashCodeForPacket(Packet packet) {
        if (packet.getStanzaTo() != null) {
            return packet.getStanzaTo().hashCode();
        }
        if (packet.getTo() != null) {
            return packet.getTo().hashCode();
        }
        return super.hashCodeForPacket(packet);
    }

    @Override
    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put("servicesMap", (Object)this.services);
    }

    @Override
    public void initializationCompleted() {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "isInitializationComplete(): {0}", new Object[]{this.isInitializationComplete()});
        }
        if (this.isInitializationComplete()) {
            return;
        }
        super.initializationCompleted();
    }

    @Override
    public void packetsReady(IO serv) throws IOException {
        if (this.checkTrafficLimits(serv)) {
            this.writePacketsToSocket(serv, this.processSocketData(serv));
        }
    }

    @Override
    public int processingInThreads() {
        return Runtime.getRuntime().availableProcessors() * 4;
    }

    @Override
    public int processingOutThreads() {
        return Runtime.getRuntime().availableProcessors() * 4;
    }

    @Override
    public void processPacket(Packet packet) {
        this.writePacketToSocket(packet);
    }

    public abstract Queue<Packet> processSocketData(IO var1);

    public abstract boolean processUndeliveredPacket(Packet var1, Long var2, String var3);

    public abstract void reconnectionFailed(Map<String, Object> var1);

    public HashSet<Integer> getDefPorts() {
        HashSet<Integer> result = new HashSet<Integer>();
        int[] ports = this.getDefPlainPorts();
        int[] sslPorts = this.getDefSSLPorts();
        if (ports != null) {
            for (int port : ports) {
                result.add(port);
            }
        }
        if (sslPorts != null) {
            for (int port : sslPorts) {
                result.add(port);
            }
        }
        return result;
    }

    @Override
    public void register(Kernel kernel) {
        this.kernel = kernel;
    }

    @Override
    public void unregister(Kernel kernel) {
        this.kernel = null;
    }

    @Override
    public void release() {
        this.releaseListeners();
        super.release();
    }

    protected void serviceConnected(IO service) {
        ServiceConnectedTimer.cancel(service);
    }

    public void serviceStarted(IO service) {
        XMPPIOService serv;
        String id = this.getUniqueId(service);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "[[{0}]] Connection started: {1}", new Object[]{this.getName(), service});
        }
        if ((serv = (XMPPIOService)this.services.get(id)) != null) {
            if (serv == service) {
                log.log(Level.WARNING, "That would explain a lot, adding the same service twice, ID: {1} [{0}]", new Object[]{this.getName(), serv});
            } else {
                log.log(Level.FINE, "Attempt to add different service with the same ID: {1}; old: {2} (stopped)  [{0}]", new Object[]{this.getName(), service, serv});
                serv.stop();
            }
        }
        this.services.put(id, service);
        ++this.services_size;
        if (this.enableServiceConnectedTimeout(service)) {
            ServiceConnectedTimer<IO> startTimer = new ServiceConnectedTimer<IO>(service);
            this.addTimerTask(startTimer, (long)this.serviceConnectedTimeout, TimeUnit.SECONDS);
        }
    }

    @Override
    public boolean serviceStopped(IO service) {
        try {
            this.ioStatsGetter.check(service);
        }
        catch (Exception e) {
            log.log(Level.CONFIG, "Nothing serious to worry about but please notify the developer.", e);
        }
        ServiceConnectedTimer.cancel(service);
        String id = this.getUniqueId(service);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "[[{0}]] Connection stopped: {1}", new Object[]{this.getName(), service});
        }
        if (id != null) {
            boolean result = this.services.remove(id, service);
            if (result) {
                --this.services_size;
                this.redeliverWaitingPackets(service);
            } else if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "[[{0}]] Attempt to stop incorrect service: {1}", new Object[]{this.getName(), service});
            }
            return result;
        }
        return false;
    }

    protected boolean shouldRedeliverWaitingPackets(IO service) {
        return true;
    }

    protected void redeliverWaitingPackets(IO service) {
        if (!this.shouldRedeliverWaitingPackets(service)) {
            return;
        }
        Queue<Packet> undeliveredPackets = ((XMPPIOService)service).getWaitingPackets();
        log.log(Level.FINEST, "[[{0}]] processing undelivered packets: {1}", new Object[]{this.getName(), undeliveredPackets.size()});
        Packet p = null;
        while ((p = undeliveredPackets.poll()) != null) {
            this.processUndeliveredPacket(p, null, null);
        }
    }

    @Override
    public void start() {
        this.sslContextContainer.start();
        super.start();
        this.started = true;
        if (!this.delayPortListening) {
            this.connectWaitingTasks();
        } else {
            log.log(Level.INFO, "Delaying opening ports of component: {0}", this.getName());
        }
        this.setupWatchdogThread();
        if (null != this.watchdog) {
            this.watchdog.start();
        }
    }

    @Override
    public void stop() {
        if (null != this.watchdog) {
            this.watchdog.shutdown();
        }
        this.started = false;
        this.releaseListeners();
        for (XMPPIOService service : this.services.values()) {
            service.forceStop();
        }
        this.portsConfigBean.stop();
        super.stop();
        this.sslContextContainer.stop();
    }

    public void updateConnectionDetails(Map<String, Object> port_props) {
    }

    public void writePacketsToSocket(IO serv, Queue<Packet> packets) {
        if (serv != null) {
            if (packets != null && packets.size() > 0) {
                Packet p = null;
                while ((p = packets.poll()) != null) {
                    if (log.isLoggable(Level.FINER) && !log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINER, "Processing packet: {1}, type: {2} [{0}]", new Object[]{serv, p.getElemName(), p.getType()});
                    }
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Writing packet: {1} [{0}]", new Object[]{serv, p});
                    }
                    ((XMPPIOService)serv).addPacketToSend(p);
                }
                try {
                    ((XMPPIOService)serv).processWaitingPackets();
                    SocketThread.addSocketService(serv);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Exception during writing packets [" + serv + "]: ", e);
                    try {
                        ((XMPPIOService)serv).stop();
                    }
                    catch (Exception e1) {
                        log.log(Level.WARNING, "Exception stopping XMPPIOService [" + serv + "[: ", e1);
                    }
                }
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Can''t find service for packets: [{0}] ", packets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writePacketToSocket(IO ios, Packet p) {
        if (ios != null) {
            if (log.isLoggable(Level.FINER) && !log.isLoggable(Level.FINEST)) {
                log.log(Level.FINER, "Processing packet: {1}, type: {2} [{0}]", new Object[]{ios, p.getElemName(), p.getType()});
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Writing packet: {1} [{0}]", new Object[]{ios, p});
            }
            ((XMPPIOService)ios).addPacketToSend(p);
            if (((XMPPIOService)ios).writeInProgress.tryLock()) {
                try {
                    ((XMPPIOService)ios).processWaitingPackets();
                    SocketThread.addSocketService(ios);
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Exception during writing packets [" + ios + "[: ", e);
                    try {
                        ((XMPPIOService)ios).forceStop();
                    }
                    catch (Exception e1) {
                        log.log(Level.WARNING, "Exception stopping XMPPIOService [" + ios + "]: ", e1);
                    }
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Exception during writing packets [" + ios + "]: ", e);
                    try {
                        ((XMPPIOService)ios).stop();
                    }
                    catch (Exception e1) {
                        log.log(Level.WARNING, "Exception stopping XMPPIOService [" + ios + "]: ", e1);
                    }
                }
                finally {
                    ((XMPPIOService)ios).writeInProgress.unlock();
                }
            }
            return true;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Can''t find service for packet: <{0}> {1}, service id: {2}", new Object[]{p.getElemName(), p.getTo(), this.getServiceId(p)});
        }
        return false;
    }

    @Override
    public String xmppStreamError(IO serv, List<Element> err_el) {
        StreamError streamError = StreamError.getByCondition(err_el.get(0).getName());
        for (XMPPIOProcessor proc : this.processors) {
            proc.streamError((XMPPIOService)serv, streamError);
        }
        return "<stream:error xmlns:stream=\"http://etherx.jabber.org/streams\">" + err_el.get(0).toString() + "</stream:error>";
    }

    public PortsConfigBean getPortsConfigBean() {
        return this.portsConfigBean;
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        list.add(this.getName(), "Open connections", this.services_size, Level.INFO);
        if (list.checkLevel(Level.FINEST) || this.services.size() < 1000) {
            int waitingToSendSize = 0;
            for (XMPPIOService serv : this.services.values()) {
                waitingToSendSize += serv.waitingToSendSize();
            }
            list.add(this.getName(), "Waiting to send", waitingToSendSize, Level.FINE);
        }
        list.add(this.getName(), "Bytes sent", this.bytesSent, Level.FINE);
        list.add(this.getName(), "Bytes received", this.bytesReceived, Level.FINE);
        list.add(this.getName(), "Socket overflow", this.socketOverflow, Level.FINE);
        list.add(this.getName(), "Watchdog runs", this.watchdogRuns, Level.FINER);
        list.add(this.getName(), "Watchdog tests", this.watchdogTests, Level.FINE);
        list.add(this.getName(), "Watchdog stopped", this.watchdogStopped, Level.FINE);
        for (XMPPIOProcessor proc : this.processors) {
            proc.getStatistics(list);
        }
    }

    public IO getXMPPIOService(String serviceId) {
        return (IO)((XMPPIOService)this.services.get(serviceId));
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    public String getFlashCrossDomainPolicy() {
        return this.flassCrossDomainPolicy;
    }

    public void setFlashCrossDomainPolicyFile(String file) {
        this.flashCrossDomainPolicyFile = file;
        if (this.flashCrossDomainPolicyFile != null) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(this.flashCrossDomainPolicyFile));
                String line = br.readLine();
                StringBuilder sb = new StringBuilder();
                while (line != null) {
                    sb.append(line);
                    line = br.readLine();
                }
                sb.append('\u0000');
                br.close();
                this.flassCrossDomainPolicy = sb.toString();
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Problem reading cross domain poicy file: " + this.flashCrossDomainPolicyFile, ex);
            }
        }
    }

    public int getNet_buffer_limit() {
        if (this.net_buffer_limit == 0) {
            AbstractBeanConfigurator configurator = this.kernel.getInstance(AbstractBeanConfigurator.class);
            this.net_buffer_limit = this.isHighThroughput() ? ((Integer)configurator.getProperties().getOrDefault("net-buffer-high-throughput", 0x1400000)).intValue() : ((Integer)configurator.getProperties().getOrDefault("net-buffer-standard", 0x200000)).intValue();
        }
        return this.net_buffer_limit;
    }

    public void setNet_buffer_limit(int value) {
        this.net_buffer_limit = value;
    }

    public void setProcessors(XMPPIOProcessor[] processors) {
        if (processors == null) {
            processors = new XMPPIOProcessor[]{};
        }
        this.processors = processors;
    }

    public String getTrafficThrottling() {
        if (this.trafficThrottling == null) {
            AbstractBeanConfigurator configurator = this.kernel.getInstance(AbstractBeanConfigurator.class);
            String value = null;
            value = this.isHighThroughput() ? (String)configurator.getProperties().getOrDefault("cm-ht-traffic-throttling", HT_TRAFFIC_THROTTLING_PROP_VAL) : (String)configurator.getProperties().getOrDefault("cm-traffic-throttling", ST_TRAFFIC_THROTTLING_PROP_VAL);
            this.setTrafficThrottling(value);
        }
        return this.trafficThrottling;
    }

    public void setTrafficThrottling(String trafficThrottling) {
        this.trafficThrottling = trafficThrottling;
        String tmp = trafficThrottling;
        for (String tmp_s : tmp.split(",")) {
            String[] tmp_thr = tmp_s.split(":");
            if (tmp_thr[0].equalsIgnoreCase("xmpp")) {
                this.last_minute_packets_limit = DataTypes.parseNum(tmp_thr[1], Long.class, 2500L);
                log.finest(this.getName() + " last_minute_packets_limit = " + this.last_minute_packets_limit);
                this.total_packets_limit = DataTypes.parseNum(tmp_thr[2], Long.class, 0L);
                log.finest(this.getName() + " total_packets_limit = " + this.total_packets_limit);
                if (tmp_thr[3].equalsIgnoreCase("disc")) {
                    this.xmppLimitAction = LIMIT_ACTION.DISCONNECT;
                }
                if (tmp_thr[3].equalsIgnoreCase("drop")) {
                    this.xmppLimitAction = LIMIT_ACTION.DROP_PACKETS;
                }
            }
            if (!tmp_thr[0].equalsIgnoreCase("bin")) continue;
            this.last_minute_bin_limit = DataTypes.parseNum(tmp_thr[1], Long.class, 20000000L);
            log.finest(this.getName() + " last_minute_bin_limit = " + this.last_minute_bin_limit);
            this.total_bin_limit = DataTypes.parseNum(tmp_thr[2], Long.class, 0L);
            log.finest(this.getName() + " total_bin_limit = " + this.total_bin_limit);
        }
    }

    protected void connectWaitingTasks() {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Connecting waitingTasks: {0}", new Object[]{this.waitingTasks});
        }
        for (Map map : this.waitingTasks) {
            this.reconnectService(map, this.connectionDelay);
        }
        this.waitingTasks.clear();
        if (null != this.watchdog && Thread.State.NEW.equals((Object)this.watchdog.getState())) {
            this.watchdog.start();
        }
        this.delayPortListening = false;
        this.portsConfigBean.start();
    }

    protected void setupWatchdogThread() {
        this.watchdog = this.newWatchdog();
        this.watchdog.setName("Watchdog - " + this.getName());
        this.watchdog.setDaemon(true);
    }

    public void setWatchdogPingType(WATCHDOG_PING_TYPE watchdogPingType) {
        this.watchdogPingType = watchdogPingType;
    }

    protected Watchdog newWatchdog() {
        return new Watchdog();
    }

    protected void addWaitingTask(Map<String, Object> conn) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Adding waiting task: {0}, started: {1}, delayPortListening: {2}, to: {3}", new Object[]{conn, this.started, this.delayPortListening, this.waitingTasks});
        }
        if (this.started && !this.delayPortListening) {
            this.reconnectService(conn, this.connectionDelay);
        } else {
            this.waitingTasks.add(conn);
        }
    }

    protected <T> void checkHighThroughputProperty(String ht_def_key, T ht_dev_val, String st_def_key, T st_def_val, String prop_key, Class<T> prop_val_class, Map<String, Object> params, Map<String, Object> props) {
        T tmp = st_def_val;
        String str_tmp = null;
        if (this.isHighThroughput()) {
            tmp = ht_dev_val;
            str_tmp = (String)params.get(ht_def_key);
        } else {
            tmp = st_def_val;
            str_tmp = (String)params.get(st_def_key);
        }
        if (tmp == null) {
            tmp = st_def_val;
        }
        if (str_tmp != null) {
            if (prop_val_class.isAssignableFrom(Integer.class)) {
                tmp = prop_val_class.cast(DataTypes.parseNum(str_tmp, Integer.class, (Integer)tmp));
            }
            if (prop_val_class.isAssignableFrom(Long.class)) {
                tmp = prop_val_class.cast(DataTypes.parseNum(str_tmp, Long.class, (Long)tmp));
            }
            if (prop_val_class.isAssignableFrom(String.class)) {
                tmp = prop_val_class.cast(str_tmp);
            }
        }
        props.put(prop_key, tmp);
    }

    protected int countIOServices() {
        return this.services.size();
    }

    protected void doForAllServices(ServiceChecker<IO> checker) {
        for (XMPPIOService service : this.services.values()) {
            checker.check(service);
        }
    }

    protected boolean writePacketToSocket(Packet p) {
        IO ios = this.getXMPPIOService(p);
        if (ios != null) {
            return this.writePacketToSocket(ios, p);
        }
        return false;
    }

    protected boolean writePacketToSocket(Packet p, String serviceId) {
        IO ios = this.getXMPPIOService(serviceId);
        if (ios != null) {
            return this.writePacketToSocket(ios, p);
        }
        return false;
    }

    protected void writeRawData(IO ios, String data) {
        try {
            ((XMPPIOService)ios).writeRawData(data);
            SocketThread.addSocketService(ios);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Exception during writing data: " + data + " [" + ios + "]", e);
            try {
                ((XMPPIOService)ios).stop();
            }
            catch (Exception e1) {
                log.log(Level.WARNING, "Exception stopping XMPPIOService [" + ios + "]", e1);
            }
        }
    }

    protected int[] getDefPlainPorts() {
        return null;
    }

    protected int[] getDefSSLPorts() {
        return null;
    }

    protected String getDefTrafficThrottling() {
        String result = ST_TRAFFIC_THROTTLING_PROP_VAL;
        if (this.isHighThroughput()) {
            result = HT_TRAFFIC_THROTTLING_PROP_VAL;
        }
        return result;
    }

    protected abstract long getMaxInactiveTime();

    protected Map<String, Object> getParamsForPort(int port) {
        return null;
    }

    protected String getServiceId(Packet packet) {
        return this.getServiceId(packet.getTo());
    }

    protected String getServiceId(JID jid) {
        return jid.getResource();
    }

    protected String getUniqueId(IO serv) {
        return ((IOService)serv).getUniqueId();
    }

    protected IO getXMPPIOService(Packet p) {
        String id = this.getServiceId(p);
        if (id != null) {
            return (IO)((XMPPIOService)this.services.get(id));
        }
        return null;
    }

    protected abstract IO getXMPPIOServiceInstance();

    protected boolean isHighThroughput() {
        return false;
    }

    protected void socketAccepted(IO serv, SocketType type) {
    }

    protected void releaseListener(ConnectionOpenListener toStop) {
        toStop.release();
        this.pending_open.remove(toStop);
        connectThread.removeConnectionOpenListener(toStop);
    }

    private void reconnectService(final Map<String, Object> port_props, long delay) {
        if (log.isLoggable(Level.FINER)) {
            String cid = port_props.get("local-hostname") + "@" + port_props.get("remote-hostname");
            log.log(Level.FINER, "Reconnecting service for: {0}, scheduling next try in {1} seconds, cid: {2}, props: {3}", new Object[]{this.getName(), delay / 1000L, cid, port_props});
        }
        this.addTimerTask(new TimerTask(){

            @Override
            public void run() {
                String host = (String)port_props.get(ConnectionManager.PORT_REMOTE_HOST_PROP_KEY);
                if (host == null) {
                    host = (String)port_props.get("remote-hostname");
                }
                int port = (Integer)port_props.get(ConnectionManager.PORT_KEY);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Reconnecting service for component: {0}, to remote host: {1} on port: {2,number,#}", new Object[]{ConnectionManager.this.getName(), host, port});
                }
                ConnectionManager.this.startService(port_props);
            }
        }, delay);
    }

    private void releaseListeners() {
        for (ConnectionListenerImpl cli : this.pending_open) {
            connectThread.removeConnectionOpenListener(cli);
        }
        this.pending_open.clear();
    }

    protected ConnectionListenerImpl startService(Map<String, Object> port_props) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Starting service: {0}", new Object[]{port_props});
        }
        if (port_props == null) {
            throw new NullPointerException("port_props cannot be null.");
        }
        ConnectionListenerImpl cli = new ConnectionListenerImpl(port_props);
        if (cli.getConnectionType() == ConnectionType.accept) {
            this.pending_open.add(cli);
        }
        connectThread.addConnectionOpenListener(cli);
        return cli;
    }

    public static enum WATCHDOG_PING_TYPE {
        WHITESPACE,
        XMPP;

    }

    private class IOServiceStatisticsGetter
    implements ServiceChecker<IO> {
        private StatisticsList list = new StatisticsList(Level.ALL);

        private IOServiceStatisticsGetter() {
        }

        @Override
        public synchronized void check(IO service) {
            ConnectionManager.this.bytesReceived += ((IOService)service).getBytesReceived(true);
            ConnectionManager.this.bytesSent += ((IOService)service).getBytesSent(true);
            ConnectionManager.this.socketOverflow += ((IOService)service).getBuffOverflow(true);
            ((XMPPIOService)service).getPacketsReceived(true);
            ((XMPPIOService)service).getPacketsSent(true);
        }
    }

    protected class Watchdog
    extends Thread {
        Packet pingPacket;
        private boolean shutdown = false;

        protected Watchdog() {
        }

        @Override
        public void run() {
            while (!this.shutdown) {
                try {
                    Thread.sleep(ConnectionManager.this.watchdogDelay);
                    ++ConnectionManager.this.watchdogRuns;
                    this.executeWatchdog();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void shutdown() {
            this.shutdown = true;
        }

        protected long getDurationSinceLastTransfer(XMPPIOService service) {
            long curr_time = System.currentTimeMillis();
            return curr_time - (switch (ConnectionManager.this.watchdogPingType) {
                case WATCHDOG_PING_TYPE.XMPP -> service.getLastXmppPacketReceiveTime();
                default -> service.getLastTransferTime();
            });
        }

        private void executeWatchdog() {
            ConnectionManager.this.doForAllServices(new ServiceChecker<IO>(){

                @Override
                public void check(XMPPIOService service) {
                    try {
                        if (null != service) {
                            long sinceLastTransfer = Watchdog.this.getDurationSinceLastTransfer(service);
                            if (log.isLoggable(Level.FINEST)) {
                                log.log(Level.FINEST, "Testing service: {0}, sinceLastTransfer: {1}, maxInactivityTime: {2}, watchdogTimeout: {3}, watchdogDelay: {4}, watchdogPingType: {5} ", new Object[]{service, sinceLastTransfer, ConnectionManager.this.maxInactivityTime, ConnectionManager.this.watchdogTimeout, ConnectionManager.this.watchdogDelay, ConnectionManager.this.watchdogPingType});
                            }
                            if (sinceLastTransfer >= ConnectionManager.this.maxInactivityTime) {
                                if (log.isLoggable(Level.CONFIG)) {
                                    log.log(Level.CONFIG, "Max inactive time exceeded, stopping: {1} ( sinceLastTransfer: {2}, maxInactivityTime: {3}, watchdogTimeout: {4}, watchdogDelay: {5}, watchdogPingType: {6} ) [{0}]", new Object[]{Watchdog.this.getName(), service, sinceLastTransfer, ConnectionManager.this.maxInactivityTime, ConnectionManager.this.watchdogTimeout, ConnectionManager.this.watchdogDelay, ConnectionManager.this.watchdogPingType});
                                }
                                ++ConnectionManager.this.watchdogStopped;
                                service.forceStop();
                            } else if (sinceLastTransfer >= ConnectionManager.this.watchdogTimeout) {
                                switch (ConnectionManager.this.watchdogPingType) {
                                    case XMPP: {
                                        Watchdog.this.pingPacket = Iq.packetInstance(pingElement.clone(), JID.jidInstanceNS((String)((String)service.getSessionData().get("hostname-key"))), JID.jidInstanceNS((String)service.getUserJid()));
                                        if (Watchdog.this.pingPacket.getStanzaFrom() != null && Watchdog.this.pingPacket.getStanzaTo() != null) {
                                            if (log.isLoggable(Level.FINEST)) {
                                                log.log(Level.FINEST, "Sending XMPP ping {1} [{0}]", new Object[]{service, Watchdog.this.pingPacket});
                                            }
                                            if (ConnectionManager.this.writePacketToSocket(service, Watchdog.this.pingPacket)) break;
                                            ++ConnectionManager.this.watchdogStopped;
                                            service.forceStop();
                                            break;
                                        }
                                        if (!log.isLoggable(Level.WARNING)) break;
                                        log.log(Level.WARNING, "Could not sent watchdog XMPP ping - missing to or from: {0}, service: {1} ", new Object[]{Watchdog.this.pingPacket, String.valueOf(service)});
                                        break;
                                    }
                                    case WHITESPACE: {
                                        if (log.isLoggable(Level.FINEST)) {
                                            log.log(Level.FINEST, "Sending whitespace ping for service {0}", new Object[]{service});
                                        }
                                        service.writeRawData(" ");
                                    }
                                }
                                ++ConnectionManager.this.watchdogTests;
                            }
                        }
                    }
                    catch (IOException e) {
                        try {
                            if (service != null) {
                                log.log(Level.CONFIG, Watchdog.this.getName() + ": Found dead connection, stopping: " + service);
                                ++ConnectionManager.this.watchdogStopped;
                                service.forceStop();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    public static enum LIMIT_ACTION {
        DISCONNECT,
        DROP_PACKETS;

    }

    private static class ServiceConnectedTimer<IO extends XMPPIOService>
    extends TimerTask {
        private final IO service;

        private ServiceConnectedTimer(IO service) {
            this.service = service;
            ((IOService)service).getSessionData().put("ServiceConnectedTimer", this);
        }

        @Override
        public void run() {
            ((XMPPIOService)this.service).forceStop();
        }

        @Override
        public void cancel(boolean mayInterruptIfRunning) {
            ((IOService)this.service).getSessionData().remove("ServiceConnectedTimer");
            super.cancel(mayInterruptIfRunning);
        }

        public static void cancel(XMPPIOService service) {
            ServiceConnectedTimer timer = (ServiceConnectedTimer)service.getSessionData().get("ServiceConnectedTimer");
            if (timer != null) {
                timer.cancel();
            } else {
                log.log(Level.FINEST, "Missing service connected timer task: {0}", service);
            }
        }
    }

    @Bean(name="connections", parent=ConnectionManager.class, active=true, exportable=true)
    public static class PortsConfigBean
    implements RegistrarBeanWithDefaultBeanClass,
    Initializable {
        @Inject
        private ConnectionManager connectionManager;
        private Kernel kernel;
        @ConfigField(desc="Ports to enable", alias="ports")
        private HashSet<Integer> ports;
        @Inject(nullAllowed=true)
        private PortConfigBean[] portsBeans;

        public PortConfigBean[] getPortsBeans() {
            return this.portsBeans;
        }

        @Override
        public Class<?> getDefaultBeanClass() {
            return PortConfigBean.class;
        }

        @Override
        public void register(Kernel kernel) {
            this.kernel = kernel;
            if (kernel.getParent() != null) {
                String connManagerBean = kernel.getParent().getName();
                this.kernel.getParent().ln("service", kernel, connManagerBean);
            }
        }

        @Override
        public void unregister(Kernel kernel) {
            this.kernel = null;
        }

        @Override
        public void initialize() {
            if (this.ports == null) {
                this.ports = this.connectionManager.getDefPorts();
            }
            HashSet<Integer> sslPorts = new HashSet<Integer>();
            if (this.connectionManager.getDefSSLPorts() != null) {
                for (int port : this.connectionManager.getDefSSLPorts()) {
                    sslPorts.add(port);
                }
            }
            Object object = this.ports.iterator();
            while (object.hasNext()) {
                Integer port = (Integer)object.next();
                String name = String.valueOf(port);
                if (this.kernel.getDependencyManager().getBeanConfig(name) != null) continue;
                Class cls = sslPorts.contains((int)port) ? SecPortConfigBean.class : PortConfigBean.class;
                this.kernel.registerBean(name).asClass(cls).exec();
            }
        }

        public void start() {
            if (this.portsBeans != null) {
                Arrays.stream(this.portsBeans).forEach(portBean -> portBean.initialize());
            }
        }

        public void stop() {
        }
    }

    private class ConnectionListenerImpl
    implements ConnectionOpenListener {
        private Map<String, Object> port_props = null;

        private ConnectionListenerImpl(Map<String, Object> port_props) {
            this.port_props = port_props;
        }

        @Override
        public void accept(SocketChannel sc) {
            String cid = this.port_props.get("local-hostname") + "@" + this.port_props.get("remote-hostname");
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Accept called for service: {0}, port_props: {1}", new Object[]{cid, this.port_props});
            }
            Object serv = ConnectionManager.this.getXMPPIOServiceInstance();
            ((IOService)serv).setSslContextContainer(ConnectionManager.this.sslContextContainer);
            ((IOService)serv).setBufferLimit(ConnectionManager.this.net_buffer_limit);
            ((IOService)serv).setCertificateContainer(ConnectionManager.this.certificateContainer);
            ((XMPPDomBuilderHandler)((IOService)serv).getSessionData().get("XMPPDomBuilderHandler")).setElementsLimit(ConnectionManager.this.elements_number_limit);
            ((XMPPIOService)serv).setIOServiceListener(ConnectionManager.this);
            ((IOService)serv).setSessionData(this.port_props);
            try {
                ((IOService)serv).accept(sc, ConnectionManager.this.net_buffer);
                ConnectionManager.this.socketAccepted(serv, this.getSocketType());
                if (this.getSocketType() == SocketType.ssl) {
                    ((IOService)serv).startSSL(false, false, false);
                }
                ConnectionManager.this.serviceStarted(serv);
                SocketThread.addSocketService(serv);
            }
            catch (Exception e) {
                if (this.getConnectionType() == ConnectionType.connect) {
                    int recon;
                    if (log.isLoggable(Level.FINEST) && (sc != null || !(e instanceof Exception))) {
                        log.log(Level.FINEST, String.format("Problem reconnecting the service: %1$s, port_props: %2$s", serv, this.port_props), e);
                    }
                    ConnectionManager.this.updateConnectionDetails(this.port_props);
                    boolean reconnect = false;
                    Integer reconnects = (Integer)this.port_props.get(ConnectionManager.MAX_RECONNECTS_PROP_KEY);
                    if (reconnects != null && (recon = reconnects.intValue()) != 0) {
                        this.port_props.put(ConnectionManager.MAX_RECONNECTS_PROP_KEY, --recon);
                        reconnect = true;
                    }
                    if (reconnect) {
                        ConnectionManager.this.reconnectService(this.port_props, ConnectionManager.this.connectionDelay);
                    } else {
                        ConnectionManager.this.reconnectionFailed(this.port_props);
                    }
                }
                ((XMPPIOService)serv).forceStop();
            }
        }

        public String toString() {
            return this.port_props.toString();
        }

        @Override
        public ConnectionType getConnectionType() {
            String type = null;
            if (this.port_props.get(ConnectionManager.PORT_TYPE_PROP_KEY) == null) {
                log.warning(ConnectionManager.this.getName() + ": connection type is null: " + this.port_props.get(ConnectionManager.PORT_KEY).toString());
            } else {
                type = this.port_props.get(ConnectionManager.PORT_TYPE_PROP_KEY).toString();
            }
            return ConnectionType.valueOf(type);
        }

        @Override
        public String[] getIfcs() {
            return (String[])this.port_props.get(ConnectionManager.PORT_IFC_PROP_KEY);
        }

        @Override
        public int getPort() {
            return (Integer)this.port_props.get(ConnectionManager.PORT_KEY);
        }

        @Override
        public int getReceiveBufferSize() {
            return ConnectionManager.this.socketBufferSize;
        }

        @Override
        public InetSocketAddress getRemoteAddress() {
            return (InetSocketAddress)this.port_props.get("remote-address");
        }

        @Override
        public String getRemoteHostname() {
            if (this.port_props.containsKey(ConnectionManager.PORT_REMOTE_HOST_PROP_KEY)) {
                return (String)this.port_props.get(ConnectionManager.PORT_REMOTE_HOST_PROP_KEY);
            }
            return (String)this.port_props.get("remote-hostname");
        }

        @Override
        public SocketType getSocketType() {
            return SocketType.valueOf(this.port_props.get(ConnectionManager.PORT_SOCKET_PROP_KEY).toString());
        }

        @Override
        public String getSRVType() {
            String type = (String)this.port_props.get("srv-type");
            if (type == null || type.isEmpty()) {
                return null;
            }
            return type;
        }

        @Override
        public int getTrafficClass() {
            if (ConnectionManager.this.isHighThroughput()) {
                return 8;
            }
            return 2;
        }

        @Override
        public long getNewConnectionsThrottling() {
            return (Long)this.port_props.getOrDefault(ConnectionManager.PORT_NEW_CONNECTIONS_THROTTLING_KEY, 200L);
        }

        @Override
        public void release() {
            this.port_props.remove(ConnectionManager.MAX_RECONNECTS_PROP_KEY);
        }
    }

    public static class SecPortConfigBean
    extends PortConfigBean {
        public SecPortConfigBean() {
            this.socket = SocketType.ssl;
        }
    }

    public static class PortConfigBean
    implements ConfigurationChangedAware,
    Initializable,
    UnregisterAware {
        @ConfigField(desc="Interface to listen on")
        protected String[] ifc = null;
        @ConfigField(desc="New connections throttling", alias="new-connections-throttling")
        protected long newConnectionsThrottling = -1L;
        @ConfigField(desc="Socket type")
        protected SocketType socket = SocketType.plain;
        @ConfigField(desc="Port type")
        protected ConnectionType type = ConnectionType.accept;
        @Inject
        private ConnectionManager connectionManager;
        private ConnectionOpenListener connectionOpenListener = null;
        @ConfigField(desc="Port")
        private Integer name;

        public int getPort() {
            return this.name;
        }

        public boolean isSecure() {
            return this.socket == SocketType.tls || this.socket == SocketType.ssl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void beanConfigurationChanged(Collection<String> changedFields) {
            if (this.connectionManager == null || !this.connectionManager.isInitializationComplete() || this.connectionManager.delayPortListening) {
                return;
            }
            PortConfigBean portConfigBean = this;
            synchronized (portConfigBean) {
                if (this.connectionOpenListener != null) {
                    try {
                        this.connectionManager.releaseListener(this.connectionOpenListener);
                        this.connectionOpenListener = null;
                    }
                    catch (Throwable ex) {
                        log.log(Level.WARNING, "Error while processing handshake", ex);
                        throw ex;
                    }
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "connectionManager: {0}, changedFields: {1}, props: {2}", new Object[]{this.connectionManager, changedFields, this.getProps()});
                }
                this.connectionOpenListener = this.connectionManager.startService(this.getProps());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void beforeUnregister() {
            PortConfigBean portConfigBean = this;
            synchronized (portConfigBean) {
                if (this.connectionOpenListener != null) {
                    this.connectionManager.releaseListener(this.connectionOpenListener);
                    this.connectionOpenListener = null;
                }
            }
        }

        @Override
        public void initialize() {
            if (this.newConnectionsThrottling == -1L) {
                switch (this.name) {
                    case 5223: {
                        this.newConnectionsThrottling = 50L;
                        break;
                    }
                    case 5269: {
                        this.newConnectionsThrottling = 100L;
                        break;
                    }
                    case 5280: {
                        this.newConnectionsThrottling = 1000L;
                        break;
                    }
                    default: {
                        this.newConnectionsThrottling = 200L;
                    }
                }
            }
            this.beanConfigurationChanged(Collections.emptyList());
        }

        protected Map<String, Object> getProps() {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put(ConnectionManager.PORT_KEY, this.name);
            props.put(ConnectionManager.PORT_TYPE_PROP_KEY, (Object)this.type);
            props.put(ConnectionManager.PORT_SOCKET_PROP_KEY, (Object)this.socket);
            if (this.ifc == null) {
                props.put(ConnectionManager.PORT_IFC_PROP_KEY, this.connectionManager.PORT_IFC_PROP_VAL);
            } else {
                props.put(ConnectionManager.PORT_IFC_PROP_KEY, this.ifc);
            }
            props.put(ConnectionManager.PORT_REMOTE_HOST_PROP_KEY, ConnectionManager.PORT_REMOTE_HOST_PROP_VAL);
            props.put(ConnectionManager.PORT_NEW_CONNECTIONS_THROTTLING_KEY, this.newConnectionsThrottling);
            return props;
        }
    }
}

