/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusteredComponentIfc;
import tigase.server.XMPPServer;
import tigase.util.Version;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

public class ComponentInfo {
    private static final Logger log = Logger.getLogger(ComponentInfo.class.getName());
    private String cls;
    private HashMap<String, Object> cmpData;
    private String name = null;
    private String title;
    private String version;

    public static Package getImplementation(Class<?> c) {
        return c.getPackage() == null ? XMPPServer.class.getPackage() : c.getPackage();
    }

    public static String getImplementationInfo(Class<?> c) {
        return ComponentInfo.getImplementationTitle(c) + ", version: " + ComponentInfo.getImplementationVersion(c);
    }

    public static String getImplementationTitle(Class<?> c) {
        Package p = ComponentInfo.getImplementation(c);
        String title = p == null ? null : p.getImplementationTitle();
        return title == null ? "" : title;
    }

    public static Optional<Version> getImplementationVersion(String ... classes) {
        return Arrays.stream(classes).map(clz -> {
            try {
                return Class.forName(clz);
            }
            catch (Exception e) {
                log.log(Level.FINE, "Problem obtaining version for class: " + clz + ", exception: " + e.getMessage());
                return null;
            }
        }).filter(Objects::nonNull).map(clz -> {
            Version version = null;
            try {
                version = Version.of((String)ComponentInfo.getImplementationVersion(clz));
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Problem obtaining current version information");
                version = Version.ZERO;
            }
            return version;
        }).max(Version.VERSION_COMPARATOR);
    }

    public static String getImplementationVersion(Class<?> c) {
        String superVersion;
        Class<?> superClass;
        Package superPackage;
        Object version;
        Package p = ComponentInfo.getImplementation(c);
        Object object = version = p == null ? null : p.getImplementationVersion();
        if (ClusteredComponentIfc.class.isAssignableFrom(c) && p != (superPackage = ComponentInfo.getImplementation(superClass = c.getSuperclass())) && superPackage != null && !p.equals(superPackage) && (superVersion = superPackage.getImplementationVersion()) != null && version != null && !((String)version).equals(superVersion)) {
            version = (String)version + "-" + superVersion;
        }
        return version == null ? "" : version;
    }

    public static Optional<ComponentInfo> of(String className) {
        ComponentInfo componentInfo = null;
        try {
            Class<?> clazz = Class.forName(className);
            componentInfo = new ComponentInfo(clazz);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.ofNullable(componentInfo);
    }

    public ComponentInfo(String cmpTitle, String cmpVersion, String cmpCls) {
        this(null, cmpTitle, cmpVersion, cmpCls);
    }

    public ComponentInfo(String cmpName, String cmpTitle, String cmpVersion, String cmpCls) {
        this(null, cmpTitle, cmpVersion, cmpCls, new HashMap<String, Object>());
    }

    public ComponentInfo(String cmpName, String cmpTitle, String cmpVersion, String cmpCls, HashMap<String, Object> cmpData) {
        this.name = cmpName;
        this.title = cmpTitle;
        this.version = cmpVersion;
        this.cls = cmpCls;
        this.cmpData = cmpData;
    }

    public ComponentInfo(Class<?> c) {
        this(null, c);
    }

    public ComponentInfo(String cmpName, Class<?> c) {
        this.name = cmpName;
        this.title = ComponentInfo.getImplementationTitle(c);
        this.version = ComponentInfo.getImplementationVersion(c);
        this.cls = c.getName();
        this.cmpData = new HashMap();
    }

    public String getName() {
        return this.name;
    }

    public String getComponentTitle() {
        return this.title;
    }

    public String getComponentVersion() {
        return this.version;
    }

    public String getComponentClass() {
        return this.cls;
    }

    public HashMap<String, Object> getComponentData() {
        return this.cmpData;
    }

    public String toString() {
        return (String)(this.name == null ? "" : this.name + " :: ") + "componentInfo{" + (String)(this.title.isEmpty() ? "" : "Title=" + this.title + ", ") + (String)(this.version.isEmpty() ? "" : "Version=" + this.version + ", ") + "Class=" + this.cls + (String)(this.cmpData.isEmpty() ? "" : ", componentData=" + this.cmpData) + "}";
    }

    public Element toElement() {
        Element cmpInfo = new Element("cmpInfo");
        if (this.name != null) {
            cmpInfo.addChild((XMLNodeIfc)new Element("name", this.name));
        }
        if (!this.title.isEmpty()) {
            cmpInfo.addChild((XMLNodeIfc)new Element("title", this.title));
        }
        if (!this.version.isEmpty()) {
            cmpInfo.addChild((XMLNodeIfc)new Element("version", this.version));
        }
        if (!this.cls.isEmpty()) {
            cmpInfo.addChild((XMLNodeIfc)new Element("class", this.cls));
        }
        if (!this.cmpData.isEmpty()) {
            Element data = new Element("cmpData");
            for (String key : this.cmpData.keySet()) {
                data.addChild((XMLNodeIfc)new Element(key, this.cmpData.get(key).toString()));
            }
            cmpInfo.addChild((XMLNodeIfc)data);
        }
        return cmpInfo;
    }
}

