/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.Bindings;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.ClusteredComponentIfc;
import tigase.conf.Configurable;
import tigase.conf.ConfigurationException;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.disco.XMPPService;
import tigase.eventbus.EventBusFactory;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigurationChangedAware;
import tigase.osgi.ModulesManagerImpl;
import tigase.osgi.OSGiScriptEngineManager;
import tigase.server.CmdAcl;
import tigase.server.Command;
import tigase.server.ComponentInfo;
import tigase.server.DataForm;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.server.XMPPServer;
import tigase.server.script.AbstractScriptCommand;
import tigase.server.script.AddScriptCommand;
import tigase.server.script.CommandIfc;
import tigase.server.script.RemoveScriptCommand;
import tigase.stats.ComponentStatisticsProvider;
import tigase.stats.StatisticsList;
import tigase.util.common.DependencyChecker;
import tigase.util.dns.DNSResolverFactory;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.vhosts.AbstractVHostItemExtension;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostItemExtensionManager;
import tigase.vhosts.VHostItemExtensionProvider;
import tigase.vhosts.VHostListener;
import tigase.vhosts.VHostManagerIfc;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class BasicComponent
implements Configurable,
XMPPService,
VHostListener,
ClusteredComponentIfc,
Initializable,
ConfigurationChangedAware {
    public static final String ALL_PROP_KEY = "ALL";
    public static final String COMMAND_PROP_NODE = "command";
    public static final String SCRIPTS_DIR_PROP_DEF = "scripts/admin";
    public static final String SCRIPTS_DIR_PROP_KEY = "scripts-dir";
    private static final Logger log = Logger.getLogger(BasicComponent.class.getName());
    private final CopyOnWriteArrayList<JID> connectedNodes = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<JID> connectedNodesWithLocal = new CopyOnWriteArrayList();
    private final List<JID> connectedNodesWithLocal_ro = Collections.unmodifiableList(this.connectedNodesWithLocal);
    private final List<JID> connectedNodes_ro = Collections.unmodifiableList(this.connectedNodes);
    @ConfigField(desc="List of admins JIDs", alias="admins")
    protected ConcurrentSkipListSet<BareJID> admins = new ConcurrentSkipListSet();
    protected Map<String, CommandIfc> scriptCommands = new ConcurrentHashMap<String, CommandIfc>(20);
    protected ConcurrentSkipListSet<String> trusted = new ConcurrentSkipListSet();
    @Inject(nullAllowed=true)
    protected VHostManagerIfc vHostManager = null;
    private String DEF_HOSTNAME_PROP_VAL = null;
    private ComponentInfo cmpInfo = null;
    @ConfigField(alias="commands", desc="Commands ACL")
    private ConcurrentHashMap<String, CopyOnWriteArraySet<CmdAcl>> commandsACL = new ConcurrentHashMap(20);
    @ConfigField(desc="Component JID")
    private JID compId = null;
    @ConfigField(desc="Default hostname")
    private BareJID defHostname = null;
    @ConfigField(desc="Service Discovery Extensions", alias="disco-extensions")
    private Map<String, ArrayList<String>> discoExtensions = new HashMap<String, ArrayList<String>>();
    private boolean initializationCompleted = false;
    @ConfigField(desc="Component name")
    private String name = null;
    private boolean nonAdminCommands = false;
    protected ScriptEngineManager scriptEngineManager = null;
    @ConfigField(desc="Base directory for scripts", alias="scripts-dir")
    private String scriptsBaseDir = "scripts/admin";
    private String scriptsCompDir = null;
    private ServiceEntity serviceEntity = null;
    @Inject(nullAllowed=true)
    private List<ComponentStatisticsProvider> statisticsProviders;
    @ConfigField(alias="trusted", desc="List of trusted JIDs")
    private String[] trustedProp = null;
    private static final List<String> DISCO_EXTENSION_ADDRESSES = Arrays.asList("abuse-addresses", "admin-addresses", "feedback-addresses", "sales-addresses", "security-addresses", "support-addresses");

    public BasicComponent() {
        DependencyChecker.checkDependencies(this.getClass());
        this.DEF_HOSTNAME_PROP_VAL = DNSResolverFactory.getInstance().getDefaultHost();
        this.defHostname = BareJID.bareJIDInstanceNS((String)this.DEF_HOSTNAME_PROP_VAL);
    }

    public void addComponentDomain(String domain) {
        this.vHostManager.addComponentDomain(domain);
    }

    @Override
    public void beanConfigurationChanged(Collection<String> changedFields) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Bean: {0} configuration changed: {1}", new Object[]{this.getClass().getName(), changedFields});
        }
        if (changedFields.contains("trusted")) {
            this.refreshTrustedJids();
        }
    }

    public boolean canCallCommand(JID jid, String commandId) {
        return this.canCallCommand(jid, null, commandId);
    }

    public boolean canCallCommand(JID jid, String domain, String commandId) {
        boolean result;
        if (jid == null) {
            return false;
        }
        boolean bl = result = this.isAdmin(jid) || this.isTrusted(jid);
        if (result) {
            return true;
        }
        Set acl = this.commandsACL.get(ALL_PROP_KEY);
        if (acl != null) {
            result = this.checkCommandAcl(jid, domain, acl);
        }
        if (!result && (acl = (Set)this.commandsACL.get(commandId)) != null) {
            result = this.checkCommandAcl(jid, domain, acl);
        }
        return result;
    }

    public boolean checkCommandAcl(JID jid, Set<CmdAcl> acl) {
        return this.checkCommandAcl(jid, null, acl);
    }

    public boolean checkCommandAcl(JID jid, String domain, Set<CmdAcl> acl) {
        block9: for (CmdAcl cmdAcl : acl) {
            switch (cmdAcl.getType()) {
                case ALL: {
                    return true;
                }
                case ADMIN: {
                    if (!this.isAdmin(jid)) continue block9;
                    return true;
                }
                case LOCAL: {
                    if (!this.isLocalDomain(jid.getDomain())) continue block9;
                    return true;
                }
                case NONE: {
                    return false;
                }
                case DOMAIN_ADMIN: {
                    if (!this.isLocalDomain(jid.getDomain())) continue block9;
                    if (domain == null) {
                        return true;
                    }
                    VHostItem vHostItem = this.getVHostItem(domain);
                    if (vHostItem == null) break;
                    if (!vHostItem.isAdmin(jid.getBareJID().toString())) continue block9;
                    return true;
                }
                case DOMAIN_OWNER: {
                    if (!this.isLocalDomain(jid.getDomain())) continue block9;
                    if (domain == null) {
                        return true;
                    }
                    VHostItem vHostItem = this.getVHostItem(domain);
                    if (vHostItem == null) break;
                    if (!vHostItem.isOwner(jid.getBareJID().toString())) continue block9;
                    return true;
                }
                case DOMAIN: {
                    if (!cmdAcl.isDomainAllowed(jid.getDomain())) continue block9;
                    return true;
                }
                default: {
                    if (!cmdAcl.isJIDAllowed(jid.getBareJID())) continue block9;
                    return true;
                }
            }
        }
        return false;
    }

    public void everyHour() {
        for (CommandIfc comm : this.scriptCommands.values()) {
            comm.everyHour();
        }
        if (this.statisticsProviders != null) {
            this.statisticsProviders.forEach(ComponentStatisticsProvider::everyHour);
        }
    }

    public void everyMinute() {
        for (CommandIfc comm : this.scriptCommands.values()) {
            comm.everyMinute();
        }
        if (this.statisticsProviders != null) {
            this.statisticsProviders.forEach(ComponentStatisticsProvider::everyMinute);
        }
    }

    public void everySecond() {
        for (CommandIfc comm : this.scriptCommands.values()) {
            comm.everySecond();
        }
        if (this.statisticsProviders != null) {
            this.statisticsProviders.forEach(ComponentStatisticsProvider::everySecond);
        }
    }

    @Override
    public boolean handlesLocalDomains() {
        return false;
    }

    @Override
    public boolean handlesNameSubdomains() {
        return true;
    }

    @Override
    public boolean handlesNonLocalDomains() {
        return false;
    }

    public void initBindings(Bindings binds) {
        binds.put("vhostMan", (Object)this.vHostManager);
        binds.put("adminsSet", (Object)this.admins);
        binds.put("cmdsAcl", (Object)this.commandsACL);
        binds.put("scriptManager", (Object)this.scriptEngineManager);
        binds.put("adminCommands", (Object)this.scriptCommands);
        binds.put("adminDisco", (Object)this.serviceEntity);
        binds.put("scriptBaseDir", (Object)this.scriptsBaseDir);
        binds.put("scriptCompDir", (Object)this.scriptsCompDir);
        binds.put("connectedNodes", (Object)this.connectedNodes);
        binds.put("connectedNodesWithLocal", (Object)this.connectedNodesWithLocal);
        binds.put("componentName", (Object)this.getName());
        binds.put("component", (Object)this);
        binds.put("eventBus", (Object)EventBusFactory.getInstance());
    }

    @Override
    public void initializationCompleted() {
        this.initializationCompleted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeConnected(String node) {
        int pos;
        Object[] tmp;
        JID jid = JID.jidInstanceNS((String)this.getName(), (String)node, null);
        boolean added = false;
        CopyOnWriteArrayList<JID> copyOnWriteArrayList = this.connectedNodesWithLocal;
        synchronized (copyOnWriteArrayList) {
            if (!this.connectedNodesWithLocal.contains(jid)) {
                tmp = this.connectedNodesWithLocal.toArray(new JID[this.connectedNodesWithLocal.size() + 1]);
                tmp[tmp.length - 1] = jid;
                Arrays.sort(tmp);
                pos = Arrays.binarySearch(tmp, jid);
                this.connectedNodesWithLocal.add(pos, jid);
                added = true;
            }
        }
        copyOnWriteArrayList = this.connectedNodes;
        synchronized (copyOnWriteArrayList) {
            if (!this.connectedNodes.contains(jid) && !this.getComponentId().equals((Object)jid)) {
                tmp = this.connectedNodes.toArray(new JID[this.connectedNodes.size() + 1]);
                tmp[tmp.length - 1] = jid;
                Arrays.sort(tmp);
                pos = Arrays.binarySearch(tmp, jid);
                this.connectedNodes.add(pos, jid);
                added = true;
            }
        }
        if (added) {
            log.log(Level.FINE, "Node connected: {0}", node);
            this.onNodeConnected(jid);
            this.refreshTrustedJids();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeDisconnected(String node) {
        JID jid = JID.jidInstanceNS((String)this.getName(), (String)node, null);
        boolean removed = false;
        CopyOnWriteArrayList<JID> copyOnWriteArrayList = this.connectedNodesWithLocal;
        synchronized (copyOnWriteArrayList) {
            removed |= this.connectedNodesWithLocal.remove(jid);
        }
        copyOnWriteArrayList = this.connectedNodes;
        synchronized (copyOnWriteArrayList) {
        }
        if (removed |= this.connectedNodes.remove(jid)) {
            log.log(Level.FINE, "Node disonnected: {0}", node);
            this.onNodeDisconnected(jid);
            this.refreshTrustedJids();
        }
    }

    @Override
    public void processPacket(Packet packet, Queue<Packet> results) {
        if (packet.isCommand() && this.getName().equals(packet.getStanzaTo().getLocalpart()) && this.isLocalDomain(packet.getStanzaTo().getDomain())) {
            this.processScriptCommand(packet, results);
        }
    }

    @Override
    public void release() {
    }

    public void removeComponentDomain(String domain) {
        this.vHostManager.removeComponentDomain(domain);
    }

    public void removeServiceDiscoveryItem(String jid, String node, String description) {
        ServiceEntity item = new ServiceEntity(jid, node, description, null);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Modifying service-discovery info, removing: {0}", item);
        }
        this.serviceEntity.removeItems(item);
    }

    @Override
    public void setClusterController(ClusterControllerIfc cl_controller) {
    }

    public void updateServiceDiscoveryItem(String jid, String node, String description, boolean admin) {
        this.updateServiceDiscoveryItem(jid, node, description, admin, (String[])null);
    }

    public void updateServiceDiscoveryItem(String jid, String node, String description, boolean admin, String ... features) {
        this.updateServiceDiscoveryItem(jid, node, description, null, null, admin, features);
    }

    public void updateServiceDiscoveryItem(String jid, String node, String description, String category, String type, boolean admin, String ... features) {
        if (this.serviceEntity.getJID().equals(jid) && this.serviceEntity.getNode() == node) {
            this.serviceEntity.setAdminOnly(admin);
            this.serviceEntity.setDescription(description);
            if (category != null || type != null) {
                this.serviceEntity.addIdentities(new ServiceIdentity(category, type, description));
            }
            if (features != null) {
                this.serviceEntity.setFeatures("http://jabber.org/protocol/commands");
                this.serviceEntity.addFeatures(features);
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Modifying service-discovery info: {0}", this.serviceEntity);
            }
        } else {
            ServiceEntity item = new ServiceEntity(jid, node, description, this::getDiscoExtensionsForm, admin);
            if (category != null || type != null) {
                item.addIdentities(new ServiceIdentity(category, type, description));
            }
            if (features != null) {
                item.addFeatures(features);
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Adding new item: {0}", item);
            }
            this.serviceEntity.addItems(item);
        }
    }

    public void updateServiceEntity() {
        this.serviceEntity = new ServiceEntity(this.name, null, this.getDiscoDescription(), this::getDiscoExtensionsForm, true);
        this.serviceEntity.addIdentities(new ServiceIdentity(this.getDiscoCategory(), this.getDiscoCategoryType(), this.getDiscoDescription()));
        this.serviceEntity.addFeatures("http://jabber.org/protocol/commands");
    }

    @Override
    public JID getComponentId() {
        return this.compId;
    }

    public void setCompId(JID jid) {
        this.compId = jid;
    }

    @Override
    public ComponentInfo getComponentInfo() {
        if (this.cmpInfo == null) {
            this.cmpInfo = new ComponentInfo(this.getName(), this.getClass());
        }
        return this.cmpInfo;
    }

    @Override
    @Deprecated
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        LinkedHashMap<String, Object> defs = new LinkedHashMap<String, Object>(50);
        defs.put("component-id", this.compId.toString());
        this.DEF_HOSTNAME_PROP_VAL = DNSResolverFactory.getInstance().getDefaultHost();
        defs.put("def-hostname", this.DEF_HOSTNAME_PROP_VAL);
        return defs;
    }

    public BareJID getDefHostName() {
        return this.defHostname;
    }

    public BareJID getDefVHostItem() {
        return this.vHostManager != null ? this.vHostManager.getDefVHostItem() : this.getDefHostName();
    }

    public String getDiscoCategory() {
        return "component";
    }

    public String getDiscoCategoryType() {
        return "generic";
    }

    public String getDiscoDescription() {
        return "Undefined description";
    }

    public List<Element> getDiscoFeatures() {
        return null;
    }

    @Override
    public List<Element> getDiscoFeatures(JID from) {
        return this.getDiscoFeatures();
    }

    @Override
    public Element getDiscoInfo(String node, JID jid, JID from) {
        if (this.getName().equals(jid.getLocalpart()) || jid.toString().startsWith(this.getName() + ".")) {
            Element form;
            Element queryEl = this.serviceEntity.getDiscoInfo(node, this.isAdmin(from) || this.nonAdminCommands);
            if (queryEl != null && (form = this.getDiscoExtensionsForm(jid.getDomain())) != null) {
                queryEl.addChild((XMLNodeIfc)form);
            }
            return queryEl;
        }
        return null;
    }

    public Element getDiscoExtensionsForm(String domain) {
        VHostItem vHostItem = this.vHostManager.getVHostItemDomainOrComponent(domain);
        Element form = null;
        if (vHostItem != null) {
            ServerInfoVHostItemExtension extension = vHostItem.getExtension(ServerInfoVHostItemExtension.class);
            Function<String, Supplier> addressesFromVHost = field -> {
                if (extension == null) {
                    return Collections::emptyList;
                }
                switch (field) {
                    case "abuse-addresses": {
                        return extension::getAbuseAddresses;
                    }
                    case "admin-addresses": {
                        return extension::getAdminAddresses;
                    }
                    case "feedback-addresses": {
                        return extension::getFeedbackAddresses;
                    }
                    case "sales-addresses": {
                        return extension::getSalesAddresses;
                    }
                    case "security-addresses": {
                        return extension::getSecurityAddresses;
                    }
                    case "support-addresses": {
                        return extension::getSupportAddresses;
                    }
                }
                return Collections::emptyList;
            };
            for (String field2 : DISCO_EXTENSION_ADDRESSES) {
                List<String> addresses;
                List<String> vhostAddresses = (List<String>)addressesFromVHost.apply(field2).get();
                List globalAddresses = this.discoExtensions.get(field2);
                if (vhostAddresses.isEmpty() && (globalAddresses == null || globalAddresses.isEmpty())) continue;
                List<String> list = addresses = globalAddresses == null ? vhostAddresses : Stream.concat(vhostAddresses.stream(), globalAddresses.stream()).collect(Collectors.toList());
                if (form == null) {
                    form = DataForm.createDataForm(Command.DataType.result);
                    DataForm.addHiddenField(form, "FORM_TYPE", "http://jabber.org/network/serverinfo");
                }
                DataForm.addFieldListMultiValue(form, field2, addresses);
            }
        }
        if (!this.discoExtensions.isEmpty()) {
            if (form == null) {
                form = DataForm.createDataForm(Command.DataType.result);
                DataForm.addHiddenField(form, "FORM_TYPE", "http://jabber.org/network/serverinfo");
            }
            for (Map.Entry<String, ArrayList<String>> item : this.discoExtensions.entrySet()) {
                if (DISCO_EXTENSION_ADDRESSES.contains(item.getKey())) continue;
                DataForm.addFieldListMultiValue(form, item.getKey(), (List<String>)item.getValue());
            }
            return form;
        }
        return form;
    }

    @Override
    public List<Element> getDiscoItems(String node, JID jid, JID from) {
        List<Element> result = null;
        boolean isAdminFrom = this.isAdmin(from);
        if (this.getName().equals(jid.getLocalpart()) || jid.toString().startsWith(this.getName() + ".")) {
            if (node != null) {
                result = node.equals("http://jabber.org/protocol/commands") && (isAdminFrom || this.nonAdminCommands) ? this.getScriptItems(node, jid, from) : this.serviceEntity.getDiscoItems(node, jid.toString(), isAdminFrom || this.nonAdminCommands);
            } else {
                result = this.serviceEntity.getDiscoItems(null, jid.toString(), isAdminFrom || this.nonAdminCommands);
                if (result != null) {
                    Iterator<Element> it = result.iterator();
                    while (it.hasNext()) {
                        Element element = it.next();
                        if (element.getAttributeStaticStr("node") != null) continue;
                        it.remove();
                    }
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Found disco items: {0}", result != null ? result.toString() : null);
            }
            return result;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "{0} General disco items request, node: {1}", new Object[]{this.getName(), node});
        }
        if (node == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0} Disco items request for null node", new Object[]{this.getName()});
            }
            Element res = null;
            if (!this.serviceEntity.isAdminOnly() || this.isAdmin(from) || this.nonAdminCommands) {
                res = this.serviceEntity.getDiscoItem(null, this.isSubdomain() ? this.getName() + "." + jid : this.getName() + "@" + jid.toString());
            }
            result = this.serviceEntity.getDiscoItems(null, null, isAdminFrom || this.nonAdminCommands);
            if (res != null) {
                if (result != null) {
                    Iterator<Element> it = result.iterator();
                    while (it.hasNext()) {
                        Element element = it.next();
                        if (element.getAttributeStaticStr("node") == null) continue;
                        it.remove();
                    }
                    result.add(0, res);
                } else {
                    result = Arrays.asList(res);
                }
            }
        }
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        try {
            this.setCompId(JID.jidInstance((String)name, (String)this.defHostname.getDomain(), null));
        }
        catch (TigaseStringprepException ex) {
            log.log(Level.WARNING, "Problem setting component ID: ", ex);
        }
    }

    public void getStatistics(StatisticsList list) {
        String compName = this.getName();
        for (CommandIfc comm : this.scriptCommands.values()) {
            comm.getStatistics(compName, list);
        }
        if (this.connectedNodes.size() > 0) {
            list.add(this.getName(), "Known cluster nodes", this.connectedNodes.size(), Level.FINEST);
        }
        if (this.statisticsProviders != null) {
            this.statisticsProviders.stream().filter(provider -> provider.belongsTo(this.getClass())).forEach(provider -> provider.getStatistics(compName, list));
        }
    }

    public List<Element> getScriptItems(String node, JID jid, JID from) {
        LinkedList<Element> result = null;
        boolean isAdminFrom = this.isAdmin(from);
        if (node.equals("http://jabber.org/protocol/commands") && (isAdminFrom || this.nonAdminCommands)) {
            result = new LinkedList<Element>();
            for (CommandIfc comm : this.scriptCommands.values()) {
                if (comm.isAdminOnly() && !isAdminFrom) continue;
                Element item = new Element("item", new String[]{"node", "name", "jid"}, new String[]{comm.getCommandId(), comm.getDescription(), jid.toString()});
                if (comm.getGroup() != null) {
                    item.setAttribute("group", comm.getGroup());
                }
                result.add(item);
            }
        }
        return result;
    }

    public VHostItem getVHostItem(String domain) {
        return this.vHostManager != null ? this.vHostManager.getVHostItem(domain) : null;
    }

    public boolean isAdmin(JID jid) {
        return this.admins.contains(jid.getBareJID());
    }

    @Override
    public boolean isInitializationComplete() {
        return this.initializationCompleted;
    }

    public boolean isLocalDomain(String domain) {
        return this.vHostManager != null ? this.vHostManager.isLocalDomain(domain) : false;
    }

    public boolean isLocalDomainOrComponent(String domain) {
        return this.vHostManager != null ? this.vHostManager.isLocalDomainOrComponent(domain) : false;
    }

    public boolean isSubdomain() {
        return false;
    }

    public boolean isTrusted(JID jid) {
        if (this.trusted.contains(jid.getBareJID().toString())) {
            return true;
        }
        return this.isAdmin(jid);
    }

    public boolean isTrusted(String jid) {
        return this.trusted.contains(jid);
    }

    public void setAdmins(Set<BareJID> admins) {
        this.admins.addAll(admins);
        this.admins.retainAll(admins);
    }

    @Override
    @Deprecated
    public void setProperties(Map<String, Object> props) throws ConfigurationException {
    }

    public void setCommandsACL(ConcurrentHashMap<String, CopyOnWriteArraySet<CmdAcl>> commandsACL) {
        this.commandsACL = commandsACL;
        this.nonAdminCommands = commandsACL.entrySet().stream().filter(e -> !((CopyOnWriteArraySet)e.getValue()).contains(CmdAcl.ADMIN) || ((CopyOnWriteArraySet)e.getValue()).size() > 1).findAny().isPresent();
    }

    public void setScriptsBaseDir(String scriptsBaseDir) {
        this.scriptsBaseDir = scriptsBaseDir;
        this.scriptsCompDir = scriptsBaseDir + "/" + this.getName();
        if (this.scriptEngineManager != null) {
            this.reloadScripts();
        }
    }

    @Override
    public void setVHostManager(VHostManagerIfc manager) {
        this.vHostManager = manager;
    }

    public List<JID> getNodesConnected() {
        return this.connectedNodes_ro;
    }

    public List<JID> getNodesConnectedWithLocal() {
        return this.connectedNodesWithLocal_ro;
    }

    public boolean processScriptCommand(Packet pc, Queue<Packet> results) {
        if (pc.getPermissions() == Permissions.NONE) {
            return false;
        }
        Iq iqc = (Iq)pc;
        Command.Action action = Command.getAction(iqc);
        if (action == Command.Action.cancel) {
            Packet result = iqc.commandResult(Command.DataType.result);
            Command.addTextField(result, "Note", "Command canceled.");
            results.offer(result);
            return true;
        }
        String strCommand = iqc.getStrCommand();
        CommandIfc com = this.scriptCommands.get(strCommand);
        if (strCommand != null && com != null) {
            boolean allowed = false;
            try {
                allowed = this.canCallCommand(iqc.getStanzaFrom(), strCommand);
                if (allowed) {
                    Bindings binds;
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "Processing admin command: {0}", pc);
                    }
                    if ((binds = com.getBindings()) == null) {
                        binds = this.scriptEngineManager.getBindings();
                    }
                    this.initBindings(binds);
                    Function<String, Boolean> isAllowedForDomain = domain -> this.canCallCommand(iqc.getStanzaFrom(), (String)domain, strCommand);
                    binds.put("isAllowedForDomain", (Object)isAllowedForDomain);
                    com.runCommand(iqc, binds, results);
                } else {
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "Command rejected non-admin detected: {0}", pc.getStanzaFrom());
                    }
                    results.offer(Authorization.FORBIDDEN.getResponseMessage(pc, "Only Administrator can call the command.", true));
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Unknown admin command processing exception: " + pc, e);
            }
            return true;
        }
        return false;
    }

    @Override
    public void initialize() {
        this.nodeConnected(this.defHostname.getDomain());
        if (this.scriptEngineManager == null) {
            this.scriptEngineManager = this.createScriptEngineManager();
        }
        this.updateServiceEntity();
        this.setScriptsBaseDir(this.scriptsBaseDir);
        this.reloadScripts();
        this.cmpInfo = new ComponentInfo(this.getName(), this.getClass());
        log.log(Level.INFO, "Loading component: " + this.cmpInfo);
        this.initializationCompleted();
    }

    public Optional<Element> getServiceEntityCaps(JID fromJid) {
        return this.getServiceEntity().getCaps(this.isAdmin(fromJid) || this.nonAdminCommands, fromJid.getDomain());
    }

    protected ScriptEngineManager createScriptEngineManager() {
        if (XMPPServer.isOSGi()) {
            return new OSGiScriptEngineManager();
        }
        return new ScriptEngineManager();
    }

    protected void onNodeConnected(JID jid) {
    }

    protected void onNodeDisconnected(JID jid) {
    }

    protected Map<String, CommandIfc> getScriptCommands() {
        return this.scriptCommands;
    }

    protected ServiceEntity getServiceEntity() {
        return this.serviceEntity;
    }

    protected boolean isNonAdminCommands() {
        return this.nonAdminCommands;
    }

    protected void reloadScripts() {
        log.log(Level.CONFIG, "Reloading admin scripts for component: {0}.", new Object[]{this.getName()});
        this.scriptCommands.clear();
        AbstractScriptCommand command2 = new AddScriptCommand();
        command2.init("add-script", "New command script", "Scripts");
        this.scriptCommands.put(command2.getCommandId(), command2);
        command2 = new RemoveScriptCommand();
        command2.init("del-script", "Remove command script", "Scripts");
        this.scriptCommands.put(command2.getCommandId(), command2);
        this.loadScripts();
    }

    private void loadScripts() {
        String[] dirs;
        log.log(Level.CONFIG, "Loading admin scripts for component: {0}.", new Object[]{this.getName()});
        File file = null;
        AddScriptCommand addCommand = new AddScriptCommand();
        Bindings binds = this.scriptEngineManager.getBindings();
        ArrayList<String> extensions = new ArrayList<String>();
        for (ScriptEngineFactory engineFactory : this.scriptEngineManager.getEngineFactories()) {
            extensions.addAll(engineFactory.getExtensions());
        }
        this.initBindings(binds);
        for (String scriptsPath : dirs = new String[]{this.scriptsBaseDir, this.scriptsCompDir}) {
            log.log(Level.CONFIG, "{0}: Loading scripts from directory: {1}", new Object[]{this.getName(), scriptsPath});
            try {
                File adminDir = new File(scriptsPath);
                if (adminDir == null || !adminDir.exists()) continue;
                for (File f : adminDir.listFiles(new ExtFilter(extensions))) {
                    if (!f.isFile() || f.toString().endsWith("~") || f.isHidden()) continue;
                    String cmdId = null;
                    String cmdDescr = null;
                    String cmdGroup = null;
                    String comp = null;
                    String compClass = null;
                    file = f;
                    StringBuilder sb = new StringBuilder();
                    BufferedReader buffr = new BufferedReader(new FileReader(file));
                    String line = null;
                    while ((line = buffr.readLine()) != null) {
                        sb.append(line).append("\n");
                        int idx = line.indexOf("AS:Description:");
                        if (idx >= 0) {
                            cmdDescr = line.substring(idx + "AS:Description:".length()).trim();
                        }
                        if ((idx = line.indexOf("AS:CommandId:")) >= 0) {
                            cmdId = line.substring(idx + "AS:CommandId:".length()).trim();
                        }
                        if ((idx = line.indexOf("AS:Component:")) >= 0) {
                            comp = line.substring(idx + "AS:Component:".length()).trim();
                        }
                        if ((idx = line.indexOf("AS:ComponentClass:")) >= 0) {
                            compClass = line.substring(idx + "AS:ComponentClass:".length()).trim();
                        }
                        if ((idx = line.indexOf("AS:Group:")) < 0) continue;
                        cmdGroup = line.substring(idx + "AS:Group:".length()).trim();
                    }
                    buffr.close();
                    if (cmdId == null || cmdDescr == null) {
                        log.log(Level.WARNING, "Admin script found but it has no command ID or commanddescription: {0}", file);
                        continue;
                    }
                    boolean found = false;
                    if (comp != null) {
                        String[] comp_names;
                        for (String cmp : comp_names = comp.split(",")) {
                            cmp = cmp.trim();
                            found |= this.getName().equals(cmp);
                        }
                    }
                    if (null != compClass) {
                        String[] comp_classes;
                        for (String cmp : comp_classes = compClass.split(",")) {
                            try {
                                Class<?> loadClass = ModulesManagerImpl.getInstance().forName(cmp);
                                found |= loadClass.isAssignableFrom(this.getClass());
                            }
                            catch (NoClassDefFoundError ex) {
                                log.log(Level.WARNING, "Tried loading script with class defined as: {0} for class: {1}", new String[]{cmp, this.getClass().getCanonicalName()});
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                // empty catch block
                            }
                        }
                    }
                    if (!found) {
                        log.log(Level.FINEST, "{0}: skipping admin script {1}, id: {2}, descr: {3}, group: {4} for component: {5} or class: {6}", new Object[]{this.getName(), file, cmdId, cmdDescr, cmdGroup, comp, compClass});
                        continue;
                    }
                    int idx = file.toString().lastIndexOf(46);
                    String ext = file.toString().substring(idx + 1);
                    if (cmdGroup != null && cmdGroup.contains("${componentName}")) {
                        cmdGroup = cmdGroup.replace("${componentName}", this.getDiscoDescription());
                    }
                    addCommand.addAdminScript(cmdId, cmdDescr, cmdGroup, sb.toString(), null, ext, binds);
                    log.log(Level.CONFIG, "{0}: Loaded admin command from file: {1}, id: {2}, ext: {3}, descr: {4}", new Object[]{this.getName(), file, cmdId, ext, cmdDescr});
                }
            }
            catch (IOException | ScriptException e) {
                log.log(Level.WARNING, "Can''t load the admin script file: " + file, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshTrustedJids() {
        CopyOnWriteArrayList<JID> copyOnWriteArrayList = this.connectedNodesWithLocal;
        synchronized (copyOnWriteArrayList) {
            this.trusted.clear();
            if (this.trustedProp != null) {
                for (String trustedStr : this.trustedProp) {
                    if (trustedStr.contains("{clusterNode}")) {
                        for (JID nodeJid : this.connectedNodesWithLocal) {
                            String node = nodeJid.getDomain();
                            String jid = trustedStr.replace("{clusterNode}", node);
                            this.trusted.add(jid);
                        }
                        continue;
                    }
                    this.trusted.add(trustedStr);
                }
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "component {0} got trusted jids set as {1}", new Object[]{this.getName(), this.trusted});
        }
    }

    public static class ServerInfoVHostItemExtension
    extends AbstractVHostItemExtension<ServerInfoVHostItemExtension> {
        public static final String ID = "disco-server-info";
        private List<String> abuseAddresses = Collections.EMPTY_LIST;
        private List<String> adminAddresses = Collections.EMPTY_LIST;
        private List<String> feedbackAddresses = Collections.EMPTY_LIST;
        private List<String> salesAddresses = Collections.EMPTY_LIST;
        private List<String> securityAddresses = Collections.EMPTY_LIST;
        private List<String> supportAddresses = Collections.EMPTY_LIST;

        public List<String> getAbuseAddresses() {
            return this.abuseAddresses;
        }

        public List<String> getAdminAddresses() {
            return this.adminAddresses;
        }

        public List<String> getFeedbackAddresses() {
            return this.feedbackAddresses;
        }

        public List<String> getSalesAddresses() {
            return this.salesAddresses;
        }

        public List<String> getSecurityAddresses() {
            return this.securityAddresses;
        }

        public List<String> getSupportAddresses() {
            return this.supportAddresses;
        }

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public void initFromElement(Element item) {
            this.abuseAddresses = ServerInfoVHostItemExtension.childrenToList(item, "abuse");
            this.adminAddresses = ServerInfoVHostItemExtension.childrenToList(item, "admin");
            this.feedbackAddresses = ServerInfoVHostItemExtension.childrenToList(item, "feedback");
            this.salesAddresses = ServerInfoVHostItemExtension.childrenToList(item, "sales");
            this.securityAddresses = ServerInfoVHostItemExtension.childrenToList(item, "security");
            this.supportAddresses = ServerInfoVHostItemExtension.childrenToList(item, "support");
        }

        @Override
        public void initFromCommand(String prefix, Packet packet) throws IllegalArgumentException {
            this.abuseAddresses = ServerInfoVHostItemExtension.fromCommandField(packet, prefix + "-abuse");
            this.adminAddresses = ServerInfoVHostItemExtension.fromCommandField(packet, prefix + "-admin");
            this.feedbackAddresses = ServerInfoVHostItemExtension.fromCommandField(packet, prefix + "-feedback");
            this.salesAddresses = ServerInfoVHostItemExtension.fromCommandField(packet, prefix + "-sales");
            this.securityAddresses = ServerInfoVHostItemExtension.fromCommandField(packet, prefix + "-security");
            this.supportAddresses = ServerInfoVHostItemExtension.fromCommandField(packet, prefix + "-support");
        }

        @Override
        public String toDebugString() {
            return "abuse: " + this.adminAddresses + ", admin: " + this.adminAddresses + ", feedback: " + this.feedbackAddresses + ", sales: " + this.salesAddresses + ", security: " + this.securityAddresses + ", support: " + this.supportAddresses;
        }

        @Override
        public Element toElement() {
            Element el = new Element(this.getId());
            ServerInfoVHostItemExtension.elementsFromList("abuse", this.abuseAddresses).forEach(arg_0 -> ((Element)el).addChild(arg_0));
            ServerInfoVHostItemExtension.elementsFromList("admin", this.adminAddresses).forEach(arg_0 -> ((Element)el).addChild(arg_0));
            ServerInfoVHostItemExtension.elementsFromList("feedback", this.feedbackAddresses).forEach(arg_0 -> ((Element)el).addChild(arg_0));
            ServerInfoVHostItemExtension.elementsFromList("sales", this.salesAddresses).forEach(arg_0 -> ((Element)el).addChild(arg_0));
            ServerInfoVHostItemExtension.elementsFromList("security", this.securityAddresses).forEach(arg_0 -> ((Element)el).addChild(arg_0));
            ServerInfoVHostItemExtension.elementsFromList("support", this.supportAddresses).forEach(arg_0 -> ((Element)el).addChild(arg_0));
            return el.getChildren() != null ? el : null;
        }

        @Override
        public void addCommandFields(String prefix, Packet packet, boolean forDefault) {
            Element command2 = packet.getElemChild(BasicComponent.COMMAND_PROP_NODE, "http://jabber.org/protocol/commands");
            DataForm.addFieldMultiValue(command2, prefix + "-abuse", this.abuseAddresses, "Abuse reporting addresses");
            DataForm.addFieldMultiValue(command2, prefix + "-admin", this.adminAddresses, "Admin addresses");
            DataForm.addFieldMultiValue(command2, prefix + "-feedback", this.feedbackAddresses, "Feedback addresses");
            DataForm.addFieldMultiValue(command2, prefix + "-sales", this.salesAddresses, "Sales addresses");
            DataForm.addFieldMultiValue(command2, prefix + "-security", this.securityAddresses, "Security addresses");
            DataForm.addFieldMultiValue(command2, prefix + "-support", this.supportAddresses, "Support addresses");
        }

        @Override
        public ServerInfoVHostItemExtension mergeWithDefaults(ServerInfoVHostItemExtension defaults) {
            return this;
        }

        private static List<String> fromCommandField(Packet packet, String field) {
            List<String> values = Optional.ofNullable(Command.getFieldValues(packet, field)).map(Arrays::asList).orElse(Collections.EMPTY_LIST).stream().map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            return values.isEmpty() ? Collections.EMPTY_LIST : values;
        }

        private static List<String> childrenToList(Element el, String name) {
            return Optional.ofNullable(el.mapChildren(child -> child.getName() == name, Element::getCData)).orElse(Collections.EMPTY_LIST);
        }

        private static Stream<Element> elementsFromList(String name, List<String> values) {
            return values.stream().map(v -> new Element(name, v));
        }

        @Bean(name="disco-server-info", parent=VHostItemExtensionManager.class, active=true)
        public static class ServerInfoVHostItemExtensionProvider
        implements VHostItemExtensionProvider<ServerInfoVHostItemExtension> {
            @Override
            public String getId() {
                return ServerInfoVHostItemExtension.ID;
            }

            @Override
            public Class<ServerInfoVHostItemExtension> getExtensionClazz() {
                return ServerInfoVHostItemExtension.class;
            }
        }
    }

    private class ExtFilter
    implements FileFilter {
        List<String> extensions;

        public ExtFilter(List<String> extensions) {
            this.extensions = extensions;
        }

        @Override
        public boolean accept(File file) {
            boolean matched = false;
            for (String extension : this.extensions) {
                matched |= file.isFile() && file.getName().toLowerCase().endsWith(extension);
            }
            return matched;
        }
    }
}

