/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor.tasks;

import java.util.Map;
import tigase.eventbus.EventBus;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.monitor.InfoTask;
import tigase.monitor.MonitorComponent;
import tigase.monitor.tasks.AbstractConfigurableTimerTask;
import tigase.monitor.tasks.TasksEvent;
import tigase.server.monitor.MonitorRuntime;
import tigase.util.datetime.TimestampHelper;

@Bean(name="load-checker-task", parent=MonitorComponent.class, active=true)
public class LoadCheckerTask
extends AbstractConfigurableTimerTask
implements InfoTask,
Initializable {
    public static final String MONITOR_EVENT_NAME = "tigase.monitor.tasks.LoadAverageMonitorEvent";
    private static final TimestampHelper dtf = new TimestampHelper();
    private boolean triggered = false;
    @ConfigField(desc="Average Load Threshold")
    private long averageLoadThreshold = 10L;
    @Inject
    private MonitorComponent component;
    @Inject
    private EventBus eventBus;
    @Inject
    private MonitorRuntime runtime;

    public long getAverageLoadThreshold() {
        return this.averageLoadThreshold;
    }

    public void setAverageLoadThreshold(Long averageLoadThreshold) {
        this.averageLoadThreshold = averageLoadThreshold;
    }

    @Override
    public Form getCurrentConfiguration() {
        Form form = super.getCurrentConfiguration();
        form.addField(Field.fieldTextSingle((String)"averageLoadThreshold", (String)String.valueOf(this.averageLoadThreshold), (String)"Alarm when AverageLoad is bigger than"));
        return form;
    }

    @Override
    public Form getTaskInfo() {
        Form result = new Form("", "Load Information", "");
        result.addField(Field.fieldTextSingle((String)"averageLoad", (String)Double.toString(this.runtime.getLoadAverage()), (String)"Load Average"));
        return result;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.eventBus.registerEvent(LoadCheckerTaskEvent.class, "Fired when load is too high", false);
    }

    @Override
    public void setNewConfiguration(Form form) {
        Field tmp = form.get("averageLoadThreshold");
        if (tmp != null) {
            this.averageLoadThreshold = Long.parseLong(tmp.getValue());
        }
        super.setNewConfiguration(form);
    }

    @Override
    protected void run() {
        double curAverageLoad = this.runtime.getLoadAverage();
        if (curAverageLoad >= (double)this.averageLoadThreshold) {
            LoadCheckerTaskEvent event = new LoadCheckerTaskEvent(curAverageLoad);
            if (!this.triggered) {
                this.eventBus.fire(event);
                this.triggered = true;
            }
        } else {
            this.triggered = false;
        }
    }

    static class LoadCheckerTaskEvent
    extends TasksEvent {
        double averageLoad;

        public LoadCheckerTaskEvent(String name, String description) {
            super(name, description);
        }

        public LoadCheckerTaskEvent(double averageLoad) {
            super("DiskUsageEvent", "Fired when load is too high");
            this.averageLoad = averageLoad;
        }

        @Override
        public Map<String, String> getAdditionalData() {
            return Map.of("averageLoad", "" + this.averageLoad);
        }

        public double getAverageLoad() {
            return this.averageLoad;
        }
    }
}

