/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor;

import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.comp.RepositoryItemAbstract;
import tigase.form.Form;
import tigase.monitor.MonitorTask;
import tigase.util.Base64;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

public class TaskConfigItem
extends RepositoryItemAbstract
implements Comparable<TaskConfigItem> {
    public static final String CLASS_ELEM = "class";
    public static final String ELEM_NAME = "monitor-task";
    public static final String SCRIPT_ELEM = "script";
    public static final String SCRIPT_EXT_ATT = "scriptExtension";
    public static final String TASK_CLASS_ATT = "taskClass";
    public static final String TASK_NAME_ATT = "taskName";
    public static final String TASK_TYPE_ATT = "type";
    protected static final String[] TASK_CLASS_PATH = new String[]{"monitor-task", "class"};
    protected static final String[] TASK_SCRIPT_PATH = new String[]{"monitor-task", "script"};
    private static final Logger log = Logger.getLogger(TaskConfigItem.class.getName());
    private Form configuration;
    private String scriptExtension;
    private Class<? extends MonitorTask> taskClass;
    private String taskName;
    private String taskScript;
    private Type type;

    public TaskConfigItem() {
    }

    public TaskConfigItem(String taskName, Class<? extends MonitorTask> taskClass) {
        this.taskName = taskName;
        this.taskClass = taskClass;
        this.type = Type.task;
    }

    @Override
    public int compareTo(TaskConfigItem o) {
        return this.taskName.compareTo(o.taskName);
    }

    public Form getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Form configuration) {
        this.configuration = configuration;
    }

    @Override
    public String getElemName() {
        return ELEM_NAME;
    }

    @Override
    public String getKey() {
        return this.taskName;
    }

    @Override
    protected void setKey(String key) {
        this.setTaskName(key);
    }

    public String getScriptExtension() {
        return this.scriptExtension;
    }

    public void setScriptExtension(String scriptExtension) {
        this.scriptExtension = scriptExtension;
    }

    public Class<? extends MonitorTask> getTaskClass() {
        return this.taskClass;
    }

    private void setTaskClass(String tmp) {
        if (tmp == null) {
            return;
        }
        try {
            this.taskClass = Class.forName(tmp);
        }
        catch (ClassNotFoundException e) {
            log.log(Level.WARNING, "Error creating instance", e);
        }
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getTaskScript() {
        return this.taskScript;
    }

    public void setTaskScript(String taskScript) {
        this.taskScript = taskScript;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public void initFromElement(Element elem) {
        if (elem.getName() != ELEM_NAME) {
            throw new IllegalArgumentException("Incorrect element name, expected: monitor-task");
        }
        super.initFromElement(elem);
        this.taskName = elem.getAttributeStaticStr(TASK_NAME_ATT);
        try {
            this.type = Type.valueOf(elem.getAttributeStaticStr(TASK_TYPE_ATT));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.scriptExtension = elem.getAttributeStaticStr(SCRIPT_EXT_ATT);
        this.setTaskClass(elem.getAttributeStaticStr(TASK_CLASS_ATT));
        this.setTaskScriptEncoded(elem.getCDataStaticStr(TASK_SCRIPT_PATH));
        Element form = elem.getChild("x", "jabber:x:data");
        if (form != null) {
            this.configuration = new Form(form);
        }
    }

    @Override
    public void initFromPropertyString(String propString) {
    }

    public void setTaskClass(Class<? extends MonitorTask> taskClass) {
        this.taskClass = taskClass;
    }

    @Override
    public Element toElement() {
        Element elem = super.toElement();
        elem.addAttribute(TASK_NAME_ATT, this.taskName);
        elem.addAttribute(TASK_TYPE_ATT, this.type.name());
        if (this.scriptExtension != null) {
            elem.addAttribute(SCRIPT_EXT_ATT, this.scriptExtension);
        }
        if (this.taskScript != null) {
            elem.addChild((XMLNodeIfc)new Element(SCRIPT_ELEM, Base64.encode((byte[])this.taskScript.getBytes())));
        }
        if (this.taskClass != null) {
            elem.addChild((XMLNodeIfc)new Element(CLASS_ELEM, this.taskClass.getName()));
        }
        if (this.configuration != null) {
            elem.addChild((XMLNodeIfc)this.configuration.getElement());
        }
        return elem;
    }

    @Override
    public String toPropertyString() {
        return null;
    }

    public String toString() {
        return "taskName=" + this.taskName + ", taskClass=" + this.taskClass + ", type=" + this.type + ", configuration=" + this.configuration;
    }

    private void setTaskScriptEncoded(String tmp) {
        if (tmp == null) {
            return;
        }
        this.taskScript = new String(Base64.decode((String)tmp));
    }

    public static enum Type {
        scriptTask,
        scriptTimerTask,
        task;

    }
}

