/*
 * Decompiled with CFR 0.152.
 */
package tigase.kernel.beans.config;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.conf.AbstractConfigBuilder;
import tigase.db.util.SchemaManager;
import tigase.kernel.BeanUtils;
import tigase.kernel.KernelException;
import tigase.kernel.TypesConverter;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.BeanSelector;
import tigase.kernel.beans.Converter;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.RegistrarBeanWithDefaultBeanClass;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.BeanConfigurator;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigurationChangedAware;
import tigase.kernel.core.BeanConfig;
import tigase.kernel.core.BeanConfigBuilder;
import tigase.kernel.core.DependencyManager;
import tigase.kernel.core.Kernel;
import tigase.osgi.ModulesManagerImpl;
import tigase.osgi.util.ClassUtilBean;

public abstract class AbstractBeanConfigurator
implements BeanConfigurator {
    private static final Logger log = Logger.getLogger(AbstractBeanConfigurator.class.getCanonicalName());
    private final ConcurrentHashMap<BeanConfig, HashMap<Field, Object>> defaultFieldValues = new ConcurrentHashMap();
    @Inject(bean="defaultTypesConverter")
    protected TypesConverter defaultTypesConverter;
    @Inject(bean="kernel", nullAllowed=false)
    protected Kernel kernel;
    private boolean accessToAllFields = false;

    public static Map<String, Class<?>> getBeanClassesFromAnnotations(Kernel kernel, Class<?> requiredClass) {
        Set<Class<?>> classes = ClassUtilBean.getInstance().getAllClasses();
        List<Class<?>> toRegister = AbstractBeanConfigurator.registerBeansForBeanOfClassGetBeansToRegister(kernel, requiredClass, classes);
        HashMap result = new HashMap();
        for (Class<?> cls : toRegister) {
            Bean annotation = cls.getAnnotation(Bean.class);
            result.put(annotation.name(), cls);
        }
        return result;
    }

    protected static boolean isBeanClassRegisteredInParentKernel(Kernel kernel, String name, Class<?> clazz) {
        if (kernel == null) {
            return false;
        }
        BeanConfig bc = kernel.getDependencyManager().getBeanConfig(name);
        if (bc == null) {
            return AbstractBeanConfigurator.isBeanClassRegisteredInParentKernel(kernel.getParent(), name, clazz);
        }
        if (bc.getClazz().equals(clazz)) {
            return true;
        }
        Bean annotation = clazz.getAnnotation(Bean.class);
        for (Class<?> ifc : clazz.getInterfaces()) {
            Bean existingBeanAnnotation;
            if (!ifc.isAssignableFrom(bc.getClazz()) || ifc.equals(RegistrarBean.class) || ifc.equals(Initializable.class) || ifc.equals(UnregisterAware.class) || (existingBeanAnnotation = bc.getClazz().getAnnotation(Bean.class)) != null && !annotation.parent().isAssignableFrom(existingBeanAnnotation.parent())) continue;
            return true;
        }
        return false;
    }

    protected static Map<String, BeanDefinition> mergeWithBeansPropertyValue(Map<String, BeanDefinition> beanPropConfigMap, Map<String, Object> values) {
        List beansProp = null;
        Object beansValue = values.get("beans");
        if (beansValue instanceof String) {
            beansProp = Arrays.asList(((String)beansValue).split(","));
        } else if (beansValue instanceof List) {
            beansProp = (List)beansValue;
        }
        if (beansProp != null) {
            Iterator iterator = beansProp.iterator();
            while (iterator.hasNext()) {
                String beanStr;
                String beanName = beanStr = (String)iterator.next();
                boolean active = true;
                if (beanStr.startsWith("-")) {
                    beanName = beanStr.substring(1);
                    active = false;
                } else if (beanStr.startsWith("+")) {
                    beanName = beanStr.substring(1);
                }
                if (beanPropConfigMap.get(beanName) != null) {
                    throw new RuntimeException("Invalid 'beans' property value - duplicated entry for bean " + beanName + "! in " + beansProp);
                }
                BeanDefinition cfg = new BeanDefinition();
                cfg.setBeanName(beanName);
                cfg.setActive(active);
                beanPropConfigMap.put(beanName, cfg);
            }
        }
        return beanPropConfigMap;
    }

    public static void registerBeansForBeanOfClass(Kernel kernel, Class<?> cls) {
        Set<Class<?>> classes = ClassUtilBean.getInstance().getAllClasses();
        AbstractBeanConfigurator.registerBeansForBeanOfClass(kernel, cls, classes);
    }

    protected static void registerBeansForBeanOfClass(Kernel kernel, Class<?> requiredClass, Set<Class<?>> classes) {
        List<Class<?>> toRegister = AbstractBeanConfigurator.registerBeansForBeanOfClassGetBeansToRegister(kernel, requiredClass, classes);
        for (Class<?> cls : toRegister) {
            Bean annotation = cls.getAnnotation(Bean.class);
            if (AbstractBeanConfigurator.isBeanClassRegisteredInParentKernel(kernel.getParent(), annotation.name(), cls)) continue;
            kernel.registerBean(cls).execWithoutInject();
        }
    }

    protected static List<Class<?>> registerBeansForBeanOfClassGetBeansToRegister(Kernel kernel, Class<?> requiredClass, Set<Class<?>> classes) {
        HashMap matching = new HashMap();
        for (Class<?> cls : classes) {
            Bean bean = AbstractBeanConfigurator.registerBeansForBeanOfClassShouldRegister(kernel, requiredClass, cls);
            if (bean == null) continue;
            matching.put(cls, bean);
        }
        HashMap map = new HashMap();
        Class<?> req = requiredClass;
        do {
            Optional<List> interfaces = Optional.ofNullable(req.getInterfaces()).map(Arrays::asList);
            Iterator it = matching.entrySet().iterator();
            block2: while (it.hasNext()) {
                Class[] exParents;
                Map.Entry e = it.next();
                Class expParent = ((Bean)e.getValue()).parent();
                if (expParent.equals(req)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("comparing exp parent " + expParent.getCanonicalName() + " with " + req.getCanonicalName() + " for " + ((Class)e.getKey()).getCanonicalName());
                    }
                    AbstractBeanConfigurator.putInMap(map, ((Bean)e.getValue()).name(), (Class)e.getKey(), req);
                    it.remove();
                    continue;
                }
                if (interfaces.isPresent()) {
                    boolean found = false;
                    for (Class reqIfc : interfaces.get()) {
                        if (!reqIfc.equals(expParent)) continue;
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("comparing required interface " + reqIfc.getCanonicalName() + " with exp parent" + expParent.getCanonicalName() + " for " + ((Class)e.getKey()).getCanonicalName());
                        }
                        AbstractBeanConfigurator.putInMap(map, ((Bean)e.getValue()).name(), (Class)e.getKey(), req);
                        it.remove();
                        found = true;
                        break;
                    }
                    if (found) continue;
                }
                for (Class exp : exParents = ((Bean)e.getValue()).parents()) {
                    if (!exp.equals(req)) continue;
                    AbstractBeanConfigurator.putInMap(map, ((Bean)e.getValue()).name(), (Class)e.getKey(), req);
                    it.remove();
                    continue block2;
                }
            }
        } while ((req = req.getSuperclass()) != null && !req.equals(Object.class) && !matching.isEmpty());
        List<Class<?>> toRegister = map.values().stream().map(SchemaManager.Pair::getKey).collect(Collectors.toList());
        if (log.isLoggable(Level.FINEST)) {
            log.finest("for class " + requiredClass.getCanonicalName() + " we need to register: " + toRegister);
        }
        return toRegister;
    }

    private static void putInMap(Map<String, SchemaManager.Pair<Class<?>, Class>> map, String key, Class<?> value, Class parent) {
        SchemaManager.Pair<Class<?>, Class> oldValue = map.get(key);
        if (oldValue == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("setting class " + value.getCanonicalName() + " for " + key + " for parent " + parent.getCanonicalName());
            }
            map.put(key, new SchemaManager.Pair(value, parent));
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("checking class " + value.getCanonicalName() + " for " + key + " for parent " + parent.getCanonicalName());
            }
            if (oldValue.getValue().isAssignableFrom(parent)) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("replacing with class " + value.getCanonicalName() + " for " + key + " for parent " + parent.getCanonicalName());
                }
                map.put(key, new SchemaManager.Pair(value, parent));
            }
        }
    }

    protected static Bean registerBeansForBeanOfClassShouldRegister(Kernel kernel, Class<?> requiredClass, Class<?> cls) {
        Class<? extends BeanSelector>[] selectors;
        Bean annotation = cls.getDeclaredAnnotation(Bean.class);
        if (annotation == null) {
            return null;
        }
        Class parent = annotation.parent();
        if (parent == Object.class) {
            Class[] parents = annotation.parents();
            boolean matches = false;
            Class[] classArray = parents;
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                Class p = classArray[i];
                matches |= p.isAssignableFrom(requiredClass);
            }
            if (!matches) {
                return null;
            }
        } else if (!parent.isAssignableFrom(requiredClass)) {
            return null;
        }
        if ((selectors = annotation.selectors()).length > 0) {
            for (Class<? extends BeanSelector> selectorCls : selectors) {
                try {
                    BeanSelector selector = selectorCls.newInstance();
                    if (!selector.shouldRegister(cls, kernel)) {
                        return null;
                    }
                }
                catch (IllegalAccessException | InstantiationException e) {
                    log.log(Level.SEVERE, "could not instantiate BeanSelector " + selectorCls.getCanonicalName() + " for " + cls.getCanonicalName(), e);
                }
            }
        }
        try {
            BeanSelector selector = kernel.getInstance(BeanSelector.class);
            if (selector != null && !selector.shouldRegister(cls, kernel)) {
                return null;
            }
        }
        catch (KernelException ex) {
            log.log(Level.FINEST, "Could not find implementation of bean selector, skipping bean selection...");
        }
        return annotation;
    }

    public abstract Map<String, Object> getProperties();

    public void configure(BeanConfig beanConfig, Object bean, Map<String, Object> values) {
        if (values == null) {
            return;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Configuring bean '" + beanConfig.getBeanName() + "'...");
        }
        this.registerBeans(beanConfig, bean, values);
        HashMap valuesToSet = new HashMap();
        block12: for (Map.Entry<String, Object> entry : values.entrySet()) {
            String property = entry.getKey();
            Object value = entry.getValue();
            try {
                Object v;
                Field field;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Preparing property '" + property + "' of bean '" + beanConfig.getBeanName() + "'...");
                }
                if ((field = BeanUtils.getField(beanConfig, property)) == null) {
                    switch (property) {
                        case "name": 
                        case "class": 
                        case "beans": {
                            continue block12;
                        }
                    }
                    if (property.contains("/") || value instanceof BeanDefinition || this.kernel.getDependencyManager().getBeanConfig(property) != null || bean instanceof RegistrarBean && (this.kernel.getDependencyManager().getBeanConfig(beanConfig.getBeanName() + "#KERNEL") == null || ((Kernel)this.kernel.getInstance(beanConfig.getBeanName() + "#KERNEL")).getDependencyManager().getBeanConfig(property) != null)) continue;
                    log.config("Field '" + property + "' does not exists in bean '" + beanConfig.getBeanName() + "'. Ignoring!");
                    continue;
                }
                ConfigField cf = field.getAnnotation(ConfigField.class);
                if (!this.accessToAllFields && cf == null) {
                    log.fine("Field '" + property + "' of bean '" + beanConfig.getBeanName() + "' Can''t be configured (missing @ConfigField). Ignoring!");
                    continue;
                }
                TypesConverter converter = this.defaultTypesConverter;
                Converter cAnn = field.getAnnotation(Converter.class);
                if (cAnn != null) {
                    converter = this.kernel.getInstance(cAnn.converter());
                }
                Type expType = BeanUtils.getGetterSetterMethodsParameterType(field);
                Class clazz = null;
                if (expType != null) {
                    if (expType instanceof Class) {
                        clazz = (Class)expType;
                    } else if (expType instanceof ParameterizedType) {
                        Type type = ((ParameterizedType)expType).getRawType();
                        if (type instanceof Class) {
                            clazz = (Class)type;
                        } else {
                            expType = null;
                        }
                    } else {
                        expType = null;
                    }
                }
                if (expType != null) {
                    v = converter.convert(value, clazz, expType);
                    valuesToSet.put(field, v);
                    continue;
                }
                v = converter.convert(value, field.getType(), field.getGenericType());
                valuesToSet.put(field, v);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Can''t prepare value of property '" + property + "' of bean '" + beanConfig.getBeanName() + "': '" + value + "'", e);
                throw new RuntimeException("Can''t prepare value of property '" + property + "' of bean '" + beanConfig.getBeanName() + "': '" + value + "'");
            }
        }
        HashSet<String> changedFields = new HashSet<String>();
        for (Map.Entry item : valuesToSet.entrySet()) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Setting property '" + ((Field)item.getKey()).getName() + "' of bean '" + beanConfig.getBeanName() + "'...");
            }
            try {
                Object oldValue = BeanUtils.getValue(bean, (Field)item.getKey());
                Object newValue = item.getValue();
                if (!this.equals(oldValue, newValue)) {
                    BeanUtils.setValue(bean, (Field)item.getKey(), newValue);
                    changedFields.add(((Field)item.getKey()).getName());
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.finest("Property '" + ((Field)item.getKey()).getName() + "' of bean '" + beanConfig.getBeanName() + "' has been set to " + item.getValue());
                    continue;
                }
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest("Property '" + ((Field)item.getKey()).getName() + "' of bean '" + beanConfig.getBeanName() + "' has NOT been set to " + item.getValue() + " because is identical with previous value.");
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Can''t set property '" + ((Field)item.getKey()).getName() + "' of bean '" + beanConfig.getBeanName() + "' with value '" + item.getValue() + "'", e);
                throw new RuntimeException("Can''t set property '" + ((Field)item.getKey()).getName() + "' of bean '" + beanConfig.getBeanName() + "' with value '" + item.getValue() + "'");
            }
        }
        if (bean instanceof ConfigurationChangedAware) {
            ((ConfigurationChangedAware)bean).beanConfigurationChanged(Collections.unmodifiableCollection(changedFields));
        }
    }

    @Override
    public void configure(BeanConfig beanConfig, Object bean) throws KernelException {
        try {
            this.grabDefaultConfig(beanConfig, bean);
            Map<String, Object> ccc = this.getConfiguration(beanConfig);
            this.configure(beanConfig, bean, ccc);
        }
        catch (Exception e) {
            throw new KernelException("Cannot inject configuration to bean " + beanConfig.getBeanName(), e);
        }
    }

    public TypesConverter getDefaultTypesConverter() {
        return this.defaultTypesConverter;
    }

    public void setDefaultTypesConverter(TypesConverter defaultTypesConverter) {
        this.defaultTypesConverter = defaultTypesConverter;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public boolean isAccessToAllFields() {
        return this.accessToAllFields;
    }

    public void setAccessToAllFields(boolean accessToAllFields) {
        this.accessToAllFields = accessToAllFields;
    }

    @Override
    public void registerBeans(BeanConfig beanConfig, Object bean, Map<String, Object> values) {
        if (beanConfig != null && Kernel.class.isAssignableFrom(beanConfig.getClazz())) {
            return;
        }
        Kernel kernel = beanConfig == null ? this.getKernel() : beanConfig.getKernel();
        Set<String> toUnregister = new ArrayList<BeanConfig>(kernel.getDependencyManager().getBeanConfigs()).stream().filter(bc -> bc.getSource() == BeanConfig.Source.configuration).filter(bc -> beanConfig == null || bc.getRegisteredBy().contains(beanConfig)).map(bc -> bc.getBeanName()).collect(Collectors.toSet());
        Map<String, Class<?>> beansFromAnnotations = AbstractBeanConfigurator.getBeanClassesFromAnnotations(kernel, beanConfig == null ? Kernel.class : beanConfig.getClazz());
        HashMap beanDefinitionsFromConfig = values == null ? new HashMap() : AbstractBeanConfigurator.mergeWithBeansPropertyValue(this.getBeanDefinitions(values), values);
        beansFromAnnotations.forEach((name, cls) -> {
            BeanDefinition definition;
            if (beanDefinitionsFromConfig != null && (definition = (BeanDefinition)beanDefinitionsFromConfig.get(name)) != null) {
                return;
            }
            if (AbstractBeanConfigurator.isBeanClassRegisteredInParentKernel(kernel.getParent(), name, cls)) {
                return;
            }
            BeanConfig bc = kernel.getDependencyManager().getBeanConfig((String)name);
            if (bc != null && bc.getSource() == BeanConfig.Source.annotation && bc.getClazz().equals(cls)) {
                return;
            }
            if (beanConfig != null && beanConfig.getState() == BeanConfig.State.initialized) {
                kernel.registerBean((Class<?>)cls).setSource(BeanConfig.Source.annotation).registeredBy(beanConfig).exec();
            } else {
                kernel.registerBean((Class<?>)cls).setSource(BeanConfig.Source.annotation).registeredBy(beanConfig).execWithoutInject();
            }
            bc = kernel.getDependencyManager().getBeanConfig((String)name);
            if (bc != null && bc.getState() == BeanConfig.State.inactive && this.hasDirectConfiguration(bc)) {
                log.log(Level.CONFIG, "bean " + bc.getBeanName() + " is disabled but configuration is specified");
            }
        });
        for (BeanDefinition cfg : beanDefinitionsFromConfig.values()) {
            try {
                Class<?> clazz = cfg.getClazzName() == null ? beansFromAnnotations.get(cfg.getBeanName()) : ModulesManagerImpl.getInstance().forName(cfg.getClazzName());
                BeanConfig oldBc = kernel.getDependencyManager().getBeanConfig(cfg.getBeanName());
                if (clazz == null) {
                    if (bean != null && bean instanceof RegistrarBeanWithDefaultBeanClass) {
                        clazz = ((RegistrarBeanWithDefaultBeanClass)bean).getDefaultBeanClass();
                    } else if (oldBc != null) {
                        clazz = oldBc.getClazz();
                    }
                    if (clazz == null) {
                        log.log(Level.WARNING, "unknown class {0} for bean {1} (from: {2}), skipping registration of a bean", new Object[]{cfg.getClazzName(), cfg.getBeanName(), beanConfig != null ? beanConfig.getBeanName() : "n/a"});
                        continue;
                    }
                }
                if (!tigase.util.reflection.ClassUtilBean.getInstance().getAllClasses().contains(clazz)) continue;
                toUnregister.remove(cfg.getBeanName());
                if (oldBc != null && oldBc.getClazz().equals(clazz) && (oldBc.isExportable() || cfg.isExportable() == oldBc.isExportable())) {
                    kernel.setBeanActive(cfg.getBeanName(), cfg.isActive());
                    continue;
                }
                Bean ba = clazz.getAnnotation(Bean.class);
                BeanConfigBuilder cfgBuilder = kernel.registerBean(cfg.getBeanName()).asClass(clazz);
                cfgBuilder.setActive(cfg.isActive()).setSource(BeanConfig.Source.configuration);
                if (cfg.isExportable()) {
                    cfgBuilder.exportable();
                }
                if (ba != null && ba.exportable()) {
                    cfgBuilder.exportable();
                }
                cfgBuilder.registeredBy(beanConfig);
                if (beanConfig != null && beanConfig.getState() == BeanConfig.State.initialized) {
                    cfgBuilder.exec();
                    continue;
                }
                cfgBuilder.execWithoutInject();
            }
            catch (ClassNotFoundException ex) {
                log.log(Level.FINER, "could not register bean '" + cfg.getBeanName() + "' as class '" + cfg.getClazzName() + "' is not available", ex);
            }
        }
        toUnregister.forEach(beanName -> kernel.unregister((String)beanName));
    }

    @Override
    public void configurationChanged() {
        this.refreshConfiguration(this.kernel);
    }

    public void restoreDefaults(String beanName) {
        BeanConfig beanConfig = this.kernel.getDependencyManager().getBeanConfig(beanName);
        Object bean = this.kernel.getInstance(beanName);
        try {
            Field[] fields;
            HashMap<Field, Object> defaultConfig = this.defaultFieldValues.get(beanConfig);
            if (defaultConfig == null) {
                return;
            }
            for (Field field : fields = DependencyManager.getAllFields(beanConfig.getClazz())) {
                ConfigField configField = field.getAnnotation(ConfigField.class);
                if (configField == null || !defaultConfig.containsKey(field)) continue;
                Object valueToSet = defaultConfig.get(field);
                BeanUtils.setValue(bean, field, valueToSet);
            }
        }
        catch (Exception e) {
            throw new KernelException("Cannot inject configuration to bean " + beanConfig.getBeanName(), e);
        }
    }

    protected abstract Map<String, Object> getConfiguration(BeanConfig var1);

    protected Map<Field, Object> grabDefaultConfig(BeanConfig beanConfig, Object bean) {
        try {
            Field[] fields;
            HashMap<Field, Object> defaultConfig = this.defaultFieldValues.get(beanConfig);
            if (defaultConfig == null) {
                defaultConfig = new HashMap();
                this.defaultFieldValues.put(beanConfig, defaultConfig);
            }
            for (Field field : fields = DependencyManager.getAllFields(beanConfig.getClazz())) {
                ConfigField configField = field.getAnnotation(ConfigField.class);
                if (configField == null) continue;
                Object currentValue = BeanUtils.getValue(bean, field);
                if (defaultConfig.containsKey(field)) continue;
                defaultConfig.put(field, currentValue);
            }
            return defaultConfig;
        }
        catch (Exception e) {
            throw new KernelException("Cannot grab default values of bean " + beanConfig.getBeanName(), e);
        }
    }

    protected Map<Field, Object> grabCurrentConfig(Object bean, String beanName) {
        HashMap<Field, Object> config = new HashMap<Field, Object>();
        try {
            Field[] fields;
            for (Field field : fields = DependencyManager.getAllFields(bean.getClass())) {
                ConfigField configField = field.getAnnotation(ConfigField.class);
                if (configField == null) continue;
                Object currentValue = BeanUtils.getValue(bean, field);
                if (config.containsKey(field)) continue;
                config.put(field, currentValue);
            }
        }
        catch (Exception ex) {
            log.log(Level.FINEST, "retrieval of configuration for bean " + beanName + " failed", ex);
        }
        return config;
    }

    protected Map<String, BeanDefinition> getBeanDefinitions(Map<String, Object> values) {
        return new HashMap<String, BeanDefinition>();
    }

    protected ArrayDeque<String> getBeanConfigPath(BeanConfig beanConfig) {
        Kernel kernel = beanConfig.getKernel();
        ArrayDeque<String> path = new ArrayDeque<String>();
        if (!beanConfig.getBeanName().equals(beanConfig.getKernel().getName())) {
            path.push(beanConfig.getBeanName());
        }
        while (kernel.getParent() != null && kernel != this.kernel) {
            path.push(kernel.getName());
            kernel = kernel.getParent();
        }
        return path;
    }

    protected abstract boolean hasDirectConfiguration(BeanConfig var1);

    protected void refreshConfiguration(Kernel kernel) {
        this.refreshConfiguration_removeUndefinedBeans(kernel);
        this.registerBeans(null, null, this.getProperties());
        this.refreshConfiguration_updateConfiguration(kernel);
    }

    protected void refreshConfiguration_removeUndefinedBeans(Kernel kernel) {
        Set<Class<?>> classes = tigase.util.reflection.ClassUtilBean.getInstance().getAllClasses();
        Set<BeanConfig> toRemove = kernel.getDependencyManager().getBeanConfigs().stream().filter(bc -> bc.getSource() != BeanConfig.Source.hardcoded).filter(bc -> !classes.contains(bc.getClazz())).filter(bc -> {
            String name = bc.getClazz().getCanonicalName();
            return !name.startsWith("java.") && !name.startsWith("javax.") && !name.startsWith("com.sun.");
        }).collect(Collectors.toSet());
        toRemove.forEach(bc -> kernel.unregister(bc.getBeanName()));
        for (String name : kernel.getNamesOf(Kernel.class)) {
            Kernel subkernel = (Kernel)kernel.getInstance(name);
            if (subkernel == null || subkernel == kernel) continue;
            this.refreshConfiguration_removeUndefinedBeans(subkernel);
        }
    }

    protected void refreshConfiguration_updateConfiguration(Kernel kernel) {
        Set<BeanConfig> toReconfigure = kernel.getDependencyManager().getBeanConfigs().stream().filter(bc -> bc.getState() == BeanConfig.State.initialized).filter(bc -> !(bc instanceof Kernel.DelegatedBeanConfig)).filter(bc -> !Kernel.class.isAssignableFrom(bc.getClazz())).collect(Collectors.toSet());
        toReconfigure.forEach(bc -> {
            if (kernel.isBeanClassRegistered(bc.getBeanName())) {
                this.configure((BeanConfig)bc, kernel.getInstance(bc.getBeanName()));
            }
        });
        for (String name : kernel.getNamesOf(Kernel.class)) {
            Kernel subkernel = (Kernel)kernel.getInstance(name);
            if (subkernel == null || subkernel == kernel) continue;
            this.refreshConfiguration_updateConfiguration(subkernel);
        }
    }

    private final boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static class BeanDefinition
    extends HashMap {
        private boolean active = true;
        private String beanName;
        private String clazzName;
        private boolean exportable = false;

        public BeanDefinition() {
        }

        public BeanDefinition(BeanDefinition def) {
            this.beanName = def.getBeanName();
            this.clazzName = def.getClazzName();
            this.active = def.isActive();
            this.exportable = def.isExportable();
            this.putAll(def);
        }

        public String getBeanName() {
            return this.beanName;
        }

        public void setBeanName(String beanName) {
            this.beanName = beanName;
        }

        public String getClazzName() {
            return this.clazzName;
        }

        public void setClazzName(String clazzName) {
            this.clazzName = clazzName;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public boolean isExportable() {
            return this.exportable;
        }

        public void setExportable(boolean exportable) {
            this.exportable = exportable;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof BeanDefinition) {
                BeanDefinition o1 = (BeanDefinition)o;
                if (!this.beanName.equals(o1.beanName)) {
                    return false;
                }
                if (this.clazzName == null ? o1.clazzName != null : !this.clazzName.equals(o1.clazzName)) {
                    return false;
                }
                if (this.exportable != o1.exportable) {
                    return false;
                }
                if (this.active != o1.active) {
                    return false;
                }
                return super.equals(o);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 21 + Objects.hash(this.beanName, this.clazzName, this.exportable, this.active);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("BeanConfig{");
            sb.append("beanName='").append(this.beanName).append('\'');
            sb.append(", clazz=").append(this.clazzName);
            sb.append(", exportable=").append(this.exportable);
            sb.append(", active=").append(this.active);
            sb.append(", props=[");
            Iterator it = this.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                sb.append("" + e.getKey()).append("=").append("" + e.getValue());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append('}');
            return sb.toString();
        }

        public static class Builder
        extends AbstractConfigBuilder<BeanDefinition, Builder> {
            private final Map<String, Object> parent;

            public Builder(Map<String, Object> parent) {
                super(new BeanDefinition());
                this.parent = parent;
            }

            public Builder() {
                this(null);
            }

            public Builder active(boolean active) {
                ((BeanDefinition)this.map).setActive(active);
                return this;
            }

            public Builder name(String name) {
                ((BeanDefinition)this.map).setBeanName(name);
                return this;
            }

            public Builder clazz(Class<?> clazz) {
                ((BeanDefinition)this.map).setClazzName(clazz == null ? null : clazz.getCanonicalName());
                return this;
            }

            public Builder clazz(String clazz) {
                ((BeanDefinition)this.map).setClazzName(clazz);
                return this;
            }

            @Override
            public BeanDefinition build() {
                if (this.parent != null) {
                    this.parent.put(((BeanDefinition)this.map).getBeanName(), this.map);
                }
                return (BeanDefinition)this.map;
            }
        }
    }
}

