/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import tigase.cert.CertificateUtil;
import tigase.io.CertificateContainerIfc;
import tigase.io.SSLContextContainerIfc;
import tigase.kernel.beans.Inject;

public abstract class SSLContextContainerAbstract
implements SSLContextContainerIfc {
    private static final Logger log = Logger.getLogger(SSLContextContainerAbstract.class.getCanonicalName());
    @Inject
    private final CertificateContainerIfc certificateContainer;
    private SecureRandom secureRandom = new SecureRandom();

    public static <T> T find(Map<String, T> lookupMap, String domain) {
        String wildcardDomain;
        T cert;
        String string = domain = domain != null ? domain.toLowerCase() : domain;
        if (lookupMap.containsKey(domain)) {
            return lookupMap.get(domain);
        }
        if (lookupMap.containsKey("*." + domain)) {
            return lookupMap.get("*." + domain);
        }
        int idx = domain.indexOf(".");
        if (idx >= 0 && (cert = lookupMap.get(wildcardDomain = "*" + domain.substring(idx))) != null) {
            lookupMap.put(domain, cert);
            return cert;
        }
        return null;
    }

    static void removeMatchedDomains(Map<String, ?> collection, Set<String> domains) {
        collection.keySet().removeAll(domains);
        Set wildcardDomainsWithoutAsterisk = domains.stream().filter(domain -> domain.startsWith("*.")).map(domain -> domain.substring(2)).collect(Collectors.toSet());
        collection.keySet().removeIf(alias -> {
            String parentDomain = alias.substring(alias.indexOf(".") + 1);
            return wildcardDomainsWithoutAsterisk.contains(parentDomain);
        });
    }

    static Set<String> getSpareDomainNamesToRemove(Set<String> collection, Set<String> domains) {
        Set wildcardDomainsWithoutAsterisk = domains.stream().filter(domain -> domain.startsWith("*.")).map(domain -> domain.substring(2)).collect(Collectors.toSet());
        return collection.stream().filter(alias -> {
            boolean isWildcard = alias.startsWith("*.");
            String parentDomain = alias.indexOf(".") != -1 ? alias.substring(alias.indexOf(".") + 1) : null;
            return !isWildcard && parentDomain != null && wildcardDomainsWithoutAsterisk.contains(parentDomain);
        }).collect(Collectors.toSet());
    }

    public SSLContextContainerAbstract(CertificateContainerIfc certContainer) {
        this.certificateContainer = certContainer;
    }

    @Override
    public void addCertificates(Map<String, String> params) throws CertificateParsingException {
        this.certificateContainer.addCertificates(params);
    }

    @Override
    public SSLContext getSSLContext(String protocol, String hostname, boolean clientMode) {
        return this.getSSLContext(protocol, hostname, clientMode, null);
    }

    @Override
    public KeyStore getTrustStore() {
        return this.certificateContainer != null ? this.certificateContainer.getTrustStore() : null;
    }

    protected KeyManager[] createCertificate(String alias) throws Exception {
        return this.certificateContainer.createCertificate(alias);
    }

    protected SSLContext createSSLContext(String protocol) throws NoSuchAlgorithmException, NoSuchProviderException {
        return SSLContext.getInstance(protocol);
    }

    protected SSLHolder createContextHolder(String protocol, String hostname, String alias, boolean clientMode, TrustManager[] tms) throws Exception {
        SSLContext sslContext = null;
        hostname = hostname != null ? hostname.toLowerCase() : hostname;
        alias = alias != null ? alias.toLowerCase() : alias;
        KeyManager[] kms = this.getKeyManagers(hostname);
        if (kms == null) {
            if (clientMode) {
                sslContext = this.createSSLContext(protocol);
                sslContext.init(null, tms, this.secureRandom);
                SSLHolder sslHolder = new SSLHolder(tms, sslContext, null);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Created new SSLHolder: {0} for domain: {1} (with alias: {2})", new String[]{String.valueOf(sslHolder), hostname, alias, String.valueOf(clientMode)});
                }
                return sslHolder;
            }
            if (log.isLoggable(Level.CONFIG)) {
                log.log(Level.CONFIG, "Key manager for hostname: {0} does not exist, generating new one", new String[]{hostname});
            }
            kms = this.createCertificate(alias);
        }
        X509Certificate crt = null;
        if (kms.length > 0 && kms[0] instanceof X509KeyManager) {
            X509KeyManager km = (X509KeyManager)kms[0];
            X509Certificate[] chain = km.getCertificateChain(alias);
            if (chain == null) {
                chain = km.getCertificateChain("*." + alias);
            }
            if (chain == null) {
                chain = km.getCertificateChain(this.getParentWildcardDomain(alias));
            }
            crt = chain == null || chain.length == 0 ? null : chain[0];
        }
        sslContext = this.createSSLContext(protocol);
        sslContext.init(kms, tms, this.secureRandom);
        SSLHolder sslHolder = new SSLHolder(tms, sslContext, crt);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Created new SSLHolder: {0} for domain: {1} (with alias: {2})", new String[]{String.valueOf(sslHolder), hostname, alias, String.valueOf(clientMode)});
        }
        return sslHolder;
    }

    protected String getDefCertAlias() {
        return this.certificateContainer.getDefCertAlias();
    }

    protected KeyManager[] getKeyManagers(String hostname) {
        return this.certificateContainer.getKeyManagers(hostname);
    }

    protected TrustManager[] getTrustManagers() {
        return this.certificateContainer.getTrustManagers();
    }

    private String getParentWildcardDomain(String hostname) {
        return hostname.indexOf(46) > 0 ? "*" + hostname.substring(hostname.indexOf(46)) : hostname;
    }

    protected class SSLHolder {
        final X509Certificate domainCertificate;
        final SSLContext sslContext;
        final TrustManager[] tms;

        public SSLHolder(TrustManager[] tms, SSLContext sslContext, X509Certificate domainCertificate) {
            this.tms = tms;
            this.sslContext = sslContext;
            this.domainCertificate = domainCertificate;
        }

        public SSLContext getSSLContext() {
            return this.sslContext;
        }

        public boolean isValid(TrustManager[] tms) {
            return tms == this.tms;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("SSLHolder{");
            if (this.domainCertificate != null) {
                sb.append("domainCertificate=subject: ").append(CertificateUtil.getCertCName((X509Certificate)this.domainCertificate)).append(", altNames: ").append(CertificateUtil.getCertAltCName((X509Certificate)this.domainCertificate)).append(", issuer: ").append(this.domainCertificate.getIssuerDN());
            }
            sb.append(", sslContext=").append(this.sslContext);
            sb.append(", tms=").append(this.tms == null ? "null" : Arrays.asList(this.tms).toString());
            sb.append('}');
            return sb.toString();
        }
    }
}

