/*
 * Decompiled with CFR 0.152.
 */
package tigase.eventbus.impl;

import java.util.Collection;
import java.util.logging.Logger;
import tigase.eventbus.HandleEvent;
import tigase.eventbus.RegistrationException;
import tigase.eventbus.impl.AbstractHandler;
import tigase.eventbus.impl.ReflectEventListenerHandler;
import tigase.eventbus.impl.ReflectEventSourceListenerHandler;
import tigase.util.reflection.ReflectionHelper;

public class ReflectEventListenerHandlerFactory {
    private static final ReflectionHelper.Handler<HandleEvent, AbstractHandler> HANDLER = (consumer, method, annotation) -> {
        if (method.getParameterCount() < 1) {
            throw new RegistrationException("Handler method must have parameter to receive event!");
        }
        Class<?> eventType = method.getParameters()[0].getType();
        String packageName = eventType.getPackage().getName();
        String eventName = eventType.getSimpleName();
        ReflectEventListenerHandler handler = switch (method.getParameterCount()) {
            case 1 -> new ReflectEventListenerHandler(annotation.filter(), packageName, eventName, consumer, method);
            case 2 -> {
                Class<?> sourPar = method.getParameters()[1].getType();
                if (!sourPar.equals(Object.class)) {
                    throw new RegistrationException("Second parameter (event source) must be Object type.");
                }
                yield new ReflectEventSourceListenerHandler(annotation.filter(), packageName, eventName, consumer, method);
            }
            default -> throw new RegistrationException("Handler method must have exactly one parameter!");
        };
        method.setAccessible(true);
        return handler;
    };
    protected final Logger log = Logger.getLogger(this.getClass().getName());

    public Collection<AbstractHandler> create(Object consumer) throws RegistrationException {
        return ReflectionHelper.collectAnnotatedMethods(consumer, HandleEvent.class, HANDLER);
    }
}

