/*
 * Decompiled with CFR 0.152.
 */
package tigase.disco;

import java.util.ArrayList;
import java.util.List;
import tigase.xml.Element;

public class ServiceIdentity {
    private final String category;
    private final String lang;
    private final String name;
    private final String type;

    public static String[] getServiceIdentitiesCapsFromDiscoInfo(Element discoInfo) {
        ArrayList<String> list = new ArrayList<String>();
        for (ServiceIdentity serviceIdentity : ServiceIdentity.getServiceIdentitiesFromDiscoInfo(discoInfo)) {
            String asCapsString = serviceIdentity.getAsCapsString();
            list.add(asCapsString);
        }
        return list.toArray(new String[0]);
    }

    public static ServiceIdentity[] getServiceIdentitiesFromDiscoInfo(Element discoInfo) {
        ArrayList<ServiceIdentity> list = new ArrayList<ServiceIdentity>();
        List identityElements = discoInfo.findChildren(child -> child.getName().equals("identity"));
        if (identityElements != null && !identityElements.isEmpty()) {
            for (Element identityElement : identityElements) {
                ServiceIdentity serviceIdentityFromElement = ServiceIdentity.of(identityElement);
                list.add(serviceIdentityFromElement);
            }
        }
        return list.toArray(new ServiceIdentity[0]);
    }

    private static ServiceIdentity of(Element identity) throws IllegalArgumentException {
        String lang = identity.getAttributeStaticStr("xml:lang");
        String category = identity.getAttributeStaticStr("category");
        String name = identity.getAttributeStaticStr("name");
        String type = identity.getAttributeStaticStr("type");
        if (category == null || type == null) {
            throw new IllegalArgumentException(String.format("Neither category: %s nor type: %s can be null", category, type));
        }
        if (name == null && lang == null) {
            return new ServiceIdentity(category, type);
        }
        if (lang == null) {
            return new ServiceIdentity(category, type, name);
        }
        return new ServiceIdentity(category, type, name, lang);
    }

    public ServiceIdentity(String category, String type) {
        this.category = category;
        this.type = type;
        this.name = "";
        this.lang = "";
    }

    public ServiceIdentity(String category, String type, String name) {
        this.category = category;
        this.type = type;
        this.name = name;
        this.lang = "";
    }

    public ServiceIdentity(String category, String type, String name, String lang) {
        this.category = category;
        this.type = type;
        this.name = name;
        this.lang = lang;
    }

    public String getCategory() {
        return this.category;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Element getElement() {
        return new Element("identity", new String[]{"category", "type", "name"}, new String[]{this.category, this.type, this.name});
    }

    public String getAsCapsString() {
        return String.format("%s/%s/%s/%s", this.category, this.type, this.lang, this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceIdentity that = (ServiceIdentity)o;
        if (!this.category.equals(that.category)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        return this.lang.equals(that.lang);
    }

    public String getLang() {
        return this.lang;
    }

    public int hashCode() {
        int result = this.category.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.lang.hashCode();
        return result;
    }
}

