/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.xml;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.Repository;
import tigase.db.UserNotFoundException;
import tigase.db.xml.XMLDataSource;
import tigase.server.amp.db.MsgRepository;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.db.NodeNotFoundException;
import tigase.xml.db.XMLDB;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Repository.Meta(supportedUris={"memory://.*"})
public class XMLMsgRepository
extends MsgRepository<String, XMLDataSource> {
    private static final Logger log = Logger.getLogger(XMLMsgRepository.class.getCanonicalName());
    private XMLDataSource dataSource;
    private XMLDB xmldb;

    @Override
    public void setDataSource(XMLDataSource dataSource) {
        this.dataSource = dataSource;
        this.xmldb = dataSource.getXMLDB();
    }

    @Override
    public Map<Enum, Long> getMessagesCount(JID to) throws UserNotFoundException {
        throw new UnsupportedOperationException("Feature not implemented!");
    }

    @Override
    public List<Element> getMessagesList(JID to) throws UserNotFoundException {
        throw new UnsupportedOperationException("Feature not implemented!");
    }

    @Override
    public Queue<Element> loadMessagesToJID(XMPPResourceConnection session, boolean delete) throws UserNotFoundException {
        return this.loadMessagesToJID(null, session, delete, null);
    }

    @Override
    public boolean storeMessage(JID from, JID to, Date expired, Element msg, NonAuthUserRepository userRepo) throws UserNotFoundException {
        BareJID user = to.getBareJID();
        try {
            String[] old_data = this.xmldb.getDataList(user.toString(), "offline", "messages");
            String[] all = null;
            String[] list = new String[]{msg.toString()};
            if (old_data != null) {
                all = new String[old_data.length + 1];
                System.arraycopy(old_data, 0, all, 0, old_data.length);
                System.arraycopy(list, 0, all, old_data.length, list.length);
                this.xmldb.setData(user.toString(), "offline", "messages", (Object)all);
            } else {
                this.xmldb.setData(user.toString(), "offline", "messages", (Object)list);
            }
        }
        catch (NodeNotFoundException e) {
            throw new UserNotFoundException("User not found " + user, e);
        }
        return false;
    }

    @Override
    public Queue<Element> loadMessagesToJID(List<String> db_ids, XMPPResourceConnection session, boolean delete, MsgRepository.OfflineMessagesProcessor proc) throws UserNotFoundException {
        BareJID user = null;
        try {
            user = session.getBareJID();
            String[] msgs = this.xmldb.getDataList(user.toString(), "offline", "messages");
            if (msgs != null) {
                if (delete) {
                    this.xmldb.removeData(user.toString(), "offline", "messages");
                }
                DomBuilderHandler domHandler = new DomBuilderHandler();
                StringBuilder sb = new StringBuilder();
                for (String msg : msgs) {
                    sb.append(msg);
                }
                char[] data = sb.toString().toCharArray();
                this.parser.parse((SimpleHandler)domHandler, data, 0, data.length);
                return domHandler.getParsedElements();
            }
        }
        catch (NotAuthorizedException e) {
            log.log(Level.WARNING, "Session not authorized yet!", e);
        }
        catch (NodeNotFoundException e) {
            throw new UserNotFoundException("User not found " + user, e);
        }
        return null;
    }

    @Override
    public int deleteMessagesToJID(List<String> db_ids, XMPPResourceConnection session) throws UserNotFoundException {
        Queue<Element> msgs = this.loadMessagesToJID(null, session, true, null);
        return msgs == null ? 0 : msgs.size();
    }

    @Override
    protected void loadExpiredQueue(int max) {
    }

    @Override
    protected void loadExpiredQueue(Date expired) {
    }

    @Override
    protected void deleteMessage(String db_id) {
        throw new UnsupportedOperationException("Removal of messages using id is not supported!");
    }
}

