/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.util.importexport;

import java.io.Writer;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Logger;
import tigase.component.exceptions.RepositoryException;
import tigase.db.util.importexport.DataSourceHelper;
import tigase.db.util.importexport.Exporter;
import tigase.db.util.importexport.RepositoryHolder;
import tigase.db.util.importexport.RepositoryManager;
import tigase.db.util.importexport.RepositoryManagerExtension;
import tigase.kernel.core.BeanConfig;
import tigase.kernel.core.Kernel;

public abstract class RepositoryManagerExtensionBase
implements RepositoryManagerExtension {
    private static final Logger log = Logger.getLogger(RepositoryManagerExtensionBase.class.getSimpleName());
    private Kernel kernel;
    private DataSourceHelper dataSourceHelper;
    private RepositoryHolder repositoryHolder;
    private Path rootPath;

    @Override
    public void initialize(Kernel kernel, DataSourceHelper dataSourceHelper, RepositoryHolder repositoryHolder, Path rootPath) {
        this.kernel = kernel;
        this.dataSourceHelper = dataSourceHelper;
        this.repositoryHolder = repositoryHolder;
        this.rootPath = rootPath;
    }

    public <X> X getRepository(Class<X> ifc, String name) throws RepositoryException, InstantiationException, IllegalAccessException {
        return this.repositoryHolder.getRepository(ifc, name);
    }

    public List<String> getNamesOfComponent(Class<?> clazz) {
        return this.kernel.getDependencyManager().getBeanConfigs().stream().filter(beanConfig -> beanConfig.getState() != BeanConfig.State.inactive).filter(beanConfig -> clazz.isAssignableFrom(beanConfig.getClazz())).map(BeanConfig::getBeanName).toList();
    }

    public Path getRootPath() {
        return this.rootPath;
    }

    protected void exportInclude(Writer parentWriter, Path filePath, RepositoryManager.ThrowingConsumer<Writer> consumer) throws Exception {
        Exporter.exportInclude(parentWriter, this.rootPath, filePath, consumer);
    }
}

