/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.util.importexport;

import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.InvalidParameterException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.auth.CredentialsDecoderBean;
import tigase.auth.credentials.Credentials;
import tigase.auth.credentials.entries.PlainCredentialsEntry;
import tigase.auth.credentials.entries.ScramCredentialsEntry;
import tigase.auth.credentials.entries.ScramSha1CredentialsEntry;
import tigase.auth.credentials.entries.ScramSha256CredentialsEntry;
import tigase.auth.credentials.entries.ScramSha512CredentialsEntry;
import tigase.db.AbstractAuthRepositoryWithCredentials;
import tigase.db.AuthRepository;
import tigase.db.UserNotFoundException;
import tigase.db.util.importexport.AbstractImporterExtension;
import tigase.db.util.importexport.DataSourceHelper;
import tigase.db.util.importexport.ImporterExtension;
import tigase.db.util.importexport.RepositoryHolder;
import tigase.db.util.importexport.RepositoryManager;
import tigase.db.util.importexport.RepositoryManagerExtensionBase;
import tigase.kernel.beans.Bean;
import tigase.kernel.core.Kernel;
import tigase.util.Base64;
import tigase.util.ClassUtil;
import tigase.util.ui.console.CommandlineParameter;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;

public class CredentialsExtension
extends RepositoryManagerExtensionBase {
    private static final Logger log = Logger.getLogger(CredentialsExtension.class.getSimpleName());
    private final CommandlineParameter EXPORT_PLAIN_CREDENTIALS = new CommandlineParameter.Builder(null, "plain-credentials").description("Export PLAIN credentials (if any exist)").type(Boolean.class).requireArguments(false).defaultValue("false").build();
    private final CommandlineParameter IMPORT_PLAIN_CREDENTIALS = new CommandlineParameter.Builder(null, "plain-credentials").description("Import PLAIN credentials").type(Boolean.class).requireArguments(false).defaultValue("false").build();

    @Override
    public void initialize(Kernel kernel, DataSourceHelper dataSourceHelper, RepositoryHolder repositoryHolder, Path rootPath) {
        repositoryHolder.registerPrepFn(AbstractAuthRepositoryWithCredentials.class, this::prepareAuthRepo);
        super.initialize(kernel, dataSourceHelper, repositoryHolder, rootPath);
    }

    @Override
    public Stream<CommandlineParameter> getExportParameters() {
        return Stream.concat(super.getExportParameters(), Stream.of(this.EXPORT_PLAIN_CREDENTIALS));
    }

    @Override
    public Stream<CommandlineParameter> getImportParameters() {
        return Stream.concat(super.getImportParameters(), Stream.of(this.IMPORT_PLAIN_CREDENTIALS));
    }

    @Override
    public void exportDomainData(String domain, Writer writer) throws Exception {
    }

    @Override
    public void exportUserData(Path userDirPath, BareJID user, Writer writer) throws Exception {
        AuthRepository authRepository = this.getRepository(AbstractAuthRepositoryWithCredentials.class, user.getDomain());
        try {
            Credentials credentials = authRepository.getCredentials(user, "default");
            if (credentials instanceof AuthRepository.DefaultCredentials) {
                Field entriesField = AuthRepository.DefaultCredentials.class.getDeclaredField("entries");
                entriesField.setAccessible(true);
                for (AuthRepository.DefaultCredentials.RawEntry entry : (List)entriesField.get(credentials)) {
                    String mechanism = entry.getMechanism();
                    Credentials.Entry e1 = credentials.getEntryForMechanism(mechanism);
                    if (e1 instanceof ScramCredentialsEntry) {
                        ScramCredentialsEntry saslEntry = (ScramCredentialsEntry)e1;
                        this.writeSCRAM(saslEntry, writer);
                        continue;
                    }
                    if (!(e1 instanceof PlainCredentialsEntry)) continue;
                    PlainCredentialsEntry plainEntry = (PlainCredentialsEntry)e1;
                    if (!RepositoryManager.isSet(this.EXPORT_PLAIN_CREDENTIALS)) {
                        this.writeSCRAM(new ScramSha1CredentialsEntry(plainEntry), writer);
                        this.writeSCRAM(new ScramSha256CredentialsEntry(plainEntry), writer);
                        this.writeSCRAM(new ScramSha512CredentialsEntry(plainEntry), writer);
                        continue;
                    }
                    writer.append("<plain-credentials xmlns='tigase:xep-0227:sasl:0#plain' mechanism='").append(plainEntry.getMechanism()).append("'>");
                    writer.append("<password>").append(Base64.encode((byte[])plainEntry.getPassword().getBytes(StandardCharsets.UTF_8))).append("</password>");
                    writer.append("</plain-credentials>");
                }
            }
        }
        catch (UserNotFoundException ex) {
            log.log(Level.FINEST, "No credentials for user " + user);
        }
    }

    protected void writeSCRAM(ScramCredentialsEntry saslEntry, Writer writer) throws Exception {
        writer.append("<scram-credentials xmlns='urn:xmpp:pie:0#scram' mechanism='").append(saslEntry.getMechanism()).append("'>");
        writer.append("<iter-count>").append(String.valueOf(saslEntry.getIterations())).append("</iter-count>");
        writer.append("<salt>").append(Base64.encode((byte[])saslEntry.getSalt())).append("</salt>");
        writer.append("<server-key>").append(Base64.encode((byte[])saslEntry.getServerKey())).append("</server-key>");
        writer.append("<stored-key>").append(Base64.encode((byte[])saslEntry.getStoredKey())).append("</stored-key>");
        writer.append("</scram-credentials>");
    }

    protected AbstractAuthRepositoryWithCredentials prepareAuthRepo(AbstractAuthRepositoryWithCredentials authRepo) {
        CredentialsDecoderBean decoder = new CredentialsDecoderBean();
        try {
            Field f = CredentialsDecoderBean.class.getDeclaredField("decoders");
            f.setAccessible(true);
            List decoders = ClassUtil.getClassesImplementing(Credentials.Decoder.class).stream().map(clazz -> {
                try {
                    Credentials.Decoder d = (Credentials.Decoder)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    Bean bean = d.getClass().getAnnotation(Bean.class);
                    if (bean != null) {
                        Class<?> x = d.getClass();
                        while (x != null) {
                            try {
                                Field f1 = x.getDeclaredField("name");
                                f1.setAccessible(true);
                                f1.set(d, bean.name());
                                x = null;
                            }
                            catch (NoSuchFieldException ex) {
                                x = x.getSuperclass();
                            }
                        }
                    }
                    return d;
                }
                catch (Throwable ex) {
                    log.log(Level.WARNING, "failed to initialize credentials decoder " + clazz, ex);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            System.out.println(decoders);
            f.set(decoder, decoders);
            authRepo.setCredentialsCodecs(null, decoder);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
        return authRepo;
    }

    @Override
    public ImporterExtension startImportUserData(BareJID userJid, String name, Map<String, String> attrs) throws Exception {
        return switch (name) {
            case "scram-credentials" -> {
                if ("urn:xmpp:pie:0#scram".equals(attrs.get("xmlns"))) {
                    yield new SCRAMAuthImportExtension(this.getRepository(AbstractAuthRepositoryWithCredentials.class, userJid.getDomain()), userJid, attrs.get("mechanism"));
                }
                yield null;
            }
            case "plain-credentials" -> {
                if ("tigase:xep-0227:sasl:0#plain".equals(attrs.get("xmlns"))) {
                    yield new PlainAuthImportExtension(this.getRepository(AbstractAuthRepositoryWithCredentials.class, userJid.getDomain()), userJid, attrs.get("mechanism"), RepositoryManager.isSet(this.IMPORT_PLAIN_CREDENTIALS));
                }
                yield null;
            }
            default -> null;
        };
    }

    public static class SCRAMAuthImportExtension
    extends AuthImportExtension {
        private byte[] salt;
        private int iterations;
        private byte[] storedKey;
        private byte[] serverKey;

        public SCRAMAuthImportExtension(AuthRepository authRepository, BareJID user, String mechanism) {
            super(authRepository, user, mechanism);
        }

        @Override
        public boolean handleElement(Element element) throws Exception {
            return switch (element.getName()) {
                case "iter-count" -> {
                    this.iterations = Integer.parseInt(element.getCData());
                    yield true;
                }
                case "salt" -> {
                    this.salt = Base64.decode((String)element.getCData());
                    yield true;
                }
                case "server-key" -> {
                    this.serverKey = Base64.decode((String)element.getCData());
                    yield true;
                }
                case "stored-key" -> {
                    this.storedKey = Base64.decode((String)element.getCData());
                    yield true;
                }
                default -> false;
            };
        }

        @Override
        public void close() throws Exception {
            if (this.iterations <= 0) {
                throw new InvalidParameterException("Iterations cannot be less or equal 0!");
            }
            if (this.salt == null) {
                throw new InvalidParameterException("Salt cannot be null!");
            }
            if (this.serverKey == null) {
                throw new InvalidParameterException("ServerKey cannot be null!");
            }
            if (this.storedKey == null) {
                throw new InvalidParameterException("StoredKey cannot be null!");
            }
            this.save(ScramCredentialsEntry.Encoder.encode(this.salt, this.iterations, this.storedKey, this.serverKey));
            super.close();
        }
    }

    public static class PlainAuthImportExtension
    extends AuthImportExtension {
        private String password = null;
        private boolean importPLAIN;

        protected PlainAuthImportExtension(AuthRepository authRepository, BareJID user, String mechanism, boolean importPLAIN) {
            super(authRepository, user, mechanism);
        }

        @Override
        public boolean handleElement(Element element) throws Exception {
            if ("password".equals(element.getName())) {
                this.password = new String(Base64.decode((String)element.getCData()), StandardCharsets.UTF_8);
                return true;
            }
            return false;
        }

        @Override
        public void close() throws Exception {
            if (this.importPLAIN) {
                this.save(this.password);
            } else {
                PlainCredentialsEntry plainEntry = new PlainCredentialsEntry(this.password);
                this.save("SCRAM-SHA-1", ScramCredentialsEntry.Encoder.encode(new ScramSha1CredentialsEntry(plainEntry)));
                this.save("SCRAM-SHA-256", ScramCredentialsEntry.Encoder.encode(new ScramSha256CredentialsEntry(plainEntry)));
                this.save("SCRAM-SHA-512", ScramCredentialsEntry.Encoder.encode(new ScramSha512CredentialsEntry(plainEntry)));
            }
            super.close();
        }
    }

    public static abstract class AuthImportExtension
    extends AbstractImporterExtension {
        protected final AuthRepository authRepository;
        private final BareJID user;
        private final String mechanism;

        protected AuthImportExtension(AuthRepository authRepository, BareJID user, String mechanism) {
            this.authRepository = authRepository;
            this.user = user;
            this.mechanism = mechanism;
        }

        protected void save(String data) throws Exception {
            this.save(this.mechanism, data);
        }

        protected void save(String mechanism, String data) throws Exception {
            log.finest("importing user " + this.user + " credentials for " + mechanism + "...");
            this.authRepository.updateCredential(this.user, "default", mechanism, data);
        }
    }
}

