/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.util;

import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DataSourceAware;
import tigase.db.Repository;
import tigase.eventbus.EventBus;
import tigase.eventbus.EventBusFactory;
import tigase.eventbus.HandleEvent;
import tigase.eventbus.events.StartupFinishedEvent;
import tigase.util.Version;
import tigase.util.dns.DNSResolverFactory;

public class SchemaVersionCheckerLogger {
    private static final Logger log = Logger.getLogger(SchemaVersionCheckerLogger.class.getName());
    private static final SchemaVersionCheckerLogger INSTANCE = new SchemaVersionCheckerLogger();
    private final EventBus eventBus;
    private Set<VersionCheckerSchemaInfo> components = new ConcurrentSkipListSet<VersionCheckerSchemaInfo>();

    public static SchemaVersionCheckerLogger getInstance() {
        return INSTANCE;
    }

    private SchemaVersionCheckerLogger() {
        this.eventBus = EventBusFactory.getInstance();
        this.eventBus.registerAll(this);
    }

    public void logVersion(VersionCheckerSchemaInfo component) {
        this.components.add(component);
    }

    @HandleEvent
    public void printErrorMessage(StartupFinishedEvent event) {
        if (event.getNode() == null || !DNSResolverFactory.getInstance().getDefaultHost().equals(event.getNode())) {
            return;
        }
        if (!this.components.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n\n\tIt's possible that following data sources are out of date:");
            this.components.forEach(item -> sb.append("\n\t\t* ").append(item));
            sb.append("\n\tPlease upgrade the installation by running:");
            sb.append("\n\t\t$ ./scripts/tigase.sh upgrade-schema etc/tigase.conf").append("\n");
            sb.append("\n\t(this warning is printed each time SNAPSHOT version is started, you can ignore this");
            sb.append("\n\tmessage if you've just run above command)").append("\n");
            log.log(Level.INFO, sb.toString());
        }
    }

    public static class VersionCheckerSchemaInfo
    implements Comparable<VersionCheckerSchemaInfo> {
        private static final Comparator<VersionCheckerSchemaInfo> VERSION_COMPARATOR = Comparator.comparing(schemaInfo -> schemaInfo.repositoryId).thenComparing(ver -> ver.databaseVersion.orElse(null), Comparator.nullsLast(Version.VERSION_COMPARATOR)).thenComparing(schemaInfo -> schemaInfo.requiredVersion);
        Optional<Version> databaseVersion;
        String datasourceClassName;
        String repositoryId;
        Version requiredVersion;

        public VersionCheckerSchemaInfo(Class<? extends DataSourceAware> datasourceClass, Optional<Version> databaseVersion, Version requiredVersion) {
            this.datasourceClassName = datasourceClass.getSimpleName();
            this.repositoryId = datasourceClass.getAnnotation(Repository.SchemaId.class).id();
            this.databaseVersion = databaseVersion;
            this.requiredVersion = requiredVersion;
        }

        @Override
        public int compareTo(VersionCheckerSchemaInfo that) {
            return VERSION_COMPARATOR.compare(this, that);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VersionCheckerSchemaInfo that = (VersionCheckerSchemaInfo)o;
            if (this.repositoryId != null ? !this.repositoryId.equals(that.repositoryId) : that.repositoryId != null) {
                return false;
            }
            if (this.databaseVersion.isPresent() ? !this.databaseVersion.equals(that.databaseVersion) : that.databaseVersion.isPresent()) {
                return false;
            }
            return this.requiredVersion != null ? this.requiredVersion.equals((Object)that.requiredVersion) : that.requiredVersion == null;
        }

        public int hashCode() {
            int result = this.repositoryId != null ? this.repositoryId.hashCode() : 0;
            result = 31 * result + (this.databaseVersion != null ? this.databaseVersion.hashCode() : 0);
            result = 31 * result + (this.requiredVersion != null ? this.requiredVersion.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.repositoryId).append(" (").append(this.datasourceClassName).append(")");
            String ver = this.databaseVersion.isPresent() ? this.databaseVersion.get().toString() : "n/a";
            sb.append(" ~ version in database: ").append(ver).append(", required version: ").append(this.requiredVersion).append(")");
            return sb.toString();
        }
    }
}

