/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Time;
import java.time.Duration;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.annotations.TigaseDeprecated;
import tigase.db.AuthRepository;
import tigase.db.AuthorizationException;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.DataSourceAware;
import tigase.db.Repository;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.db.util.RepositoryVersionAware;
import tigase.util.Base64;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.jid.BareJID;

@Repository.Meta(supportedUris={"jdbc:[^:]+:.*"})
@Repository.SchemaId(id="server", name="Tigase XMPP Server (Core)")
@Deprecated
@TigaseDeprecated(since="8.0.0")
public class TigaseAuth
implements AuthRepository,
DataSourceAware<DataRepository>,
RepositoryVersionAware {
    private static final Logger log = Logger.getLogger("tigase.db.jdbc.TigaseAuth");
    private static final String[] non_sasl_mechs = new String[]{"password"};
    private static final String[] sasl_mechs = new String[]{"PLAIN"};
    private static final String INIT_DB_QUERY = "{ call TigInitdb() }";
    private static final String ADD_USER_PLAIN_PW_QUERY = "{ call TigAddUserPlainPw(?, ?) }";
    private static final String REMOVE_USER_QUERY = "{ call TigRemoveUser(?) }";
    private static final String GET_PASSWORD_QUERY = "{ call TigGetPassword(?) }";
    private static final String UPDATE_PASSWORD_PLAIN_PW_QUERY = "{ call TigUpdatePasswordPlainPw(?, ?) }";
    private static final String USER_LOGIN_PLAIN_PW_QUERY = "{ call TigUserLoginPlainPw(?, ?) }";
    private static final String USER_LOGOUT_QUERY = "{ call TigUserLogout(?) }";
    private static final String USERS_COUNT_QUERY = "{ call TigAllUsersCount() }";
    private static final String USERS_DOMAIN_COUNT_QUERY = "select count(*) from tig_users where user_id like ?";
    private static final String ACTIVE_USERS_COUNT_QUERY = "select count(*) from tig_users where last_used >= now() - ?";
    private static final String DEF_UPDATELOGINTIME_QUERY = "{ call TigUpdateLoginTime(?) }";
    private DataRepository data_repo = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUser(BareJID user, String password) throws UserExistsException, TigaseDBException {
        ResultSet rs = null;
        try {
            PreparedStatement add_user_plain_pw_sp;
            PreparedStatement preparedStatement = add_user_plain_pw_sp = this.data_repo.getPreparedStatement(user, ADD_USER_PLAIN_PW_QUERY);
            synchronized (preparedStatement) {
                try {
                    add_user_plain_pw_sp.setString(1, user.toString());
                    add_user_plain_pw_sp.setString(2, password);
                    rs = add_user_plain_pw_sp.executeQuery();
                    this.data_repo.release(null, rs);
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
            }
        }
        catch (SQLIntegrityConstraintViolationException e) {
            throw new UserExistsException("Error while adding user to repository, user exists?", e);
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", e);
        }
    }

    @Override
    public String getResourceUri() {
        return this.data_repo.getResourceUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getActiveUsersCountIn(Duration duration) {
        ResultSet rs = null;
        try {
            PreparedStatement active_users_count_st;
            long users = -1L;
            PreparedStatement preparedStatement = active_users_count_st = this.data_repo.getPreparedStatement(null, USERS_DOMAIN_COUNT_QUERY);
            synchronized (preparedStatement) {
                try {
                    active_users_count_st.setTime(1, Time.valueOf("0"));
                    rs = active_users_count_st.executeQuery();
                    if (rs.next()) {
                        users = rs.getLong(1);
                    }
                    this.data_repo.release(null, rs);
                    rs = null;
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    rs = null;
                    throw throwable;
                }
            }
            return users;
        }
        catch (SQLException e) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUsersCount() {
        ResultSet rs = null;
        try {
            PreparedStatement users_count_sp;
            long users = -1L;
            PreparedStatement preparedStatement = users_count_sp = this.data_repo.getPreparedStatement(null, USERS_COUNT_QUERY);
            synchronized (preparedStatement) {
                try {
                    rs = users_count_sp.executeQuery();
                    if (rs.next()) {
                        users = rs.getLong(1);
                    }
                }
                finally {
                    this.data_repo.release(null, rs);
                    rs = null;
                }
            }
            return users;
        }
        catch (SQLException e) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUsersCount(String domain) {
        ResultSet rs = null;
        try {
            PreparedStatement users_domain_count_st;
            long users = -1L;
            PreparedStatement preparedStatement = users_domain_count_st = this.data_repo.getPreparedStatement(null, USERS_DOMAIN_COUNT_QUERY);
            synchronized (preparedStatement) {
                try {
                    users_domain_count_st.setString(1, "%@" + domain);
                    rs = users_domain_count_st.executeQuery();
                    if (rs.next()) {
                        users = rs.getLong(1);
                    }
                    this.data_repo.release(null, rs);
                    rs = null;
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    rs = null;
                    throw throwable;
                }
            }
            return users;
        }
        catch (SQLException e) {
            return -1L;
        }
    }

    @Override
    public void setDataSource(DataRepository dataSource) throws DBInitException {
        try {
            this.data_repo = dataSource;
            this.data_repo.initPreparedStatement(INIT_DB_QUERY, INIT_DB_QUERY);
            this.data_repo.initPreparedStatement(ADD_USER_PLAIN_PW_QUERY, ADD_USER_PLAIN_PW_QUERY);
            this.data_repo.initPreparedStatement(REMOVE_USER_QUERY, REMOVE_USER_QUERY);
            this.data_repo.initPreparedStatement(GET_PASSWORD_QUERY, GET_PASSWORD_QUERY);
            this.data_repo.initPreparedStatement(UPDATE_PASSWORD_PLAIN_PW_QUERY, UPDATE_PASSWORD_PLAIN_PW_QUERY);
            this.data_repo.initPreparedStatement(USER_LOGIN_PLAIN_PW_QUERY, USER_LOGIN_PLAIN_PW_QUERY);
            this.data_repo.initPreparedStatement(USER_LOGOUT_QUERY, USER_LOGOUT_QUERY);
            this.data_repo.initPreparedStatement(USERS_COUNT_QUERY, USERS_COUNT_QUERY);
            this.data_repo.initPreparedStatement(USERS_DOMAIN_COUNT_QUERY, USERS_DOMAIN_COUNT_QUERY);
            this.data_repo.initPreparedStatement(DEF_UPDATELOGINTIME_QUERY, DEF_UPDATELOGINTIME_QUERY);
            this.data_repo.getPreparedStatement(null, INIT_DB_QUERY).executeQuery();
        }
        catch (Exception ex) {
            throw new DBInitException("Failed to initialize repository " + this.getClass().getCanonicalName(), ex);
        }
    }

    @Override
    @Deprecated
    public void initRepository(String connection_str, Map<String, String> params) throws DBInitException {
        try {
            if (this.data_repo == null) {
                DataRepository dataRepository = RepositoryFactory.getDataRepository(null, connection_str, params);
                dataRepository.checkSchemaVersion(this, true);
                this.setDataSource(dataRepository);
            }
        }
        catch (Exception e) {
            this.data_repo = null;
            throw new DBInitException("Problem initializing jdbc connection: " + connection_str, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logout(BareJID user) throws UserNotFoundException, TigaseDBException {
        try {
            PreparedStatement user_logout_sp;
            PreparedStatement preparedStatement = user_logout_sp = this.data_repo.getPreparedStatement(user, USER_LOGOUT_QUERY);
            synchronized (preparedStatement) {
                user_logout_sp.setString(1, user.toString());
                user_logout_sp.execute();
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loggedIn(BareJID user) throws TigaseDBException {
        try {
            PreparedStatement ps;
            PreparedStatement preparedStatement = ps = this.data_repo.getPreparedStatement(user, DEF_UPDATELOGINTIME_QUERY);
            synchronized (preparedStatement) {
                ps.setString(1, user.toString());
                ps.execute();
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", e);
        }
    }

    @Override
    public boolean otherAuth(Map<String, Object> props) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        String proto = (String)props.get("protocol");
        if (proto.equals("sasl")) {
            String mech = (String)props.get("mechanism");
            if (mech.equals("PLAIN")) {
                try {
                    return this.saslAuth(props);
                }
                catch (TigaseStringprepException ex) {
                    throw new AuthorizationException("Stringprep failed for: " + props, ex);
                }
            }
            throw new AuthorizationException("Mechanism is not supported: " + mech);
        }
        if (proto.equals("nonsasl")) {
            String password = (String)props.get("password");
            BareJID user_id = (BareJID)props.get("user-id");
            if (password != null) {
                return this.plainAuth(user_id, password);
            }
            String digest = (String)props.get("digest");
            if (digest != null) {
                throw new AuthorizationException("Not supported.");
            }
        }
        throw new AuthorizationException("Protocol is not supported: " + proto);
    }

    @Override
    public void queryAuth(Map<String, Object> authProps) {
        String protocol = (String)authProps.get("protocol");
        if (protocol.equals("nonsasl")) {
            authProps.put("result", non_sasl_mechs);
        }
        if (protocol.equals("sasl")) {
            authProps.put("result", sasl_mechs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUser(BareJID user) throws UserNotFoundException, TigaseDBException {
        try {
            PreparedStatement remove_user_sp;
            PreparedStatement preparedStatement = remove_user_sp = this.data_repo.getPreparedStatement(user, REMOVE_USER_QUERY);
            synchronized (preparedStatement) {
                remove_user_sp.setString(1, user.toString());
                remove_user_sp.execute();
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePassword(BareJID user, String password) throws UserNotFoundException, TigaseDBException {
        try {
            PreparedStatement update_pass_plain_pw_sp;
            PreparedStatement preparedStatement = update_pass_plain_pw_sp = this.data_repo.getPreparedStatement(user, UPDATE_PASSWORD_PLAIN_PW_QUERY);
            synchronized (preparedStatement) {
                update_pass_plain_pw_sp.setString(1, user.toString());
                update_pass_plain_pw_sp.setString(2, password);
                update_pass_plain_pw_sp.execute();
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getPassword(BareJID user) throws UserNotFoundException, TigaseDBException {
        ResultSet rs = null;
        try {
            PreparedStatement get_pass_sp;
            PreparedStatement preparedStatement = get_pass_sp = this.data_repo.getPreparedStatement(user, GET_PASSWORD_QUERY);
            synchronized (preparedStatement) {
                block7: {
                    String string;
                    try {
                        get_pass_sp.setString(1, user.toString());
                        rs = get_pass_sp.executeQuery();
                        if (!rs.next()) break block7;
                        string = rs.getString(1);
                        this.data_repo.release(null, rs);
                    }
                    catch (Throwable throwable) {
                        this.data_repo.release(null, rs);
                        throw throwable;
                    }
                    return string;
                }
                throw new UserNotFoundException("User does not exist: " + user);
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem with retrieving user password.", e);
        }
    }

    @Override
    public boolean isUserDisabled(BareJID user) throws UserNotFoundException, TigaseDBException {
        return false;
    }

    @Override
    public void setUserDisabled(BareJID user, Boolean value) throws UserNotFoundException, TigaseDBException {
        throw new TigaseDBException("Feature not supported");
    }

    @Override
    public void setAccountStatus(BareJID user, AuthRepository.AccountStatus status) throws TigaseDBException {
        throw new TigaseDBException("Feature not supported");
    }

    @Override
    public AuthRepository.AccountStatus getAccountStatus(BareJID user) throws TigaseDBException {
        return AuthRepository.AccountStatus.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean plainAuth(BareJID user, String password) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        ResultSet rs = null;
        String res_string = null;
        try {
            PreparedStatement user_login_plain_pw_sp;
            PreparedStatement preparedStatement = user_login_plain_pw_sp = this.data_repo.getPreparedStatement(user, USER_LOGIN_PLAIN_PW_QUERY);
            synchronized (preparedStatement) {
                block12: {
                    block13: {
                        boolean bl;
                        try {
                            user_login_plain_pw_sp.setString(1, user.toString());
                            user_login_plain_pw_sp.setString(2, password);
                            switch (this.data_repo.getDatabaseType()) {
                                case jtds: 
                                case sqlserver: {
                                    user_login_plain_pw_sp.executeUpdate();
                                    rs = user_login_plain_pw_sp.getGeneratedKeys();
                                    break;
                                }
                                default: {
                                    rs = user_login_plain_pw_sp.executeQuery();
                                }
                            }
                            boolean auth_result_ok = false;
                            if (!rs.next()) break block12;
                            res_string = rs.getString(1);
                            if (res_string != null) {
                                BareJID result = BareJID.bareJIDInstance((String)res_string);
                                auth_result_ok = user.equals((Object)result);
                            }
                            if (!auth_result_ok) break block13;
                            bl = true;
                            this.data_repo.release(null, rs);
                        }
                        catch (Throwable throwable) {
                            this.data_repo.release(null, rs);
                            throw throwable;
                        }
                        return bl;
                    }
                    if (!log.isLoggable(Level.FINE)) break block12;
                    log.log(Level.FINE, "Login failed, for user: ''{0}'', password: ''{1}'', from DB got: {2}", new Object[]{user, password, res_string});
                }
                this.data_repo.release(null, rs);
                throw new UserNotFoundException("User does not exist: " + user);
            }
        }
        catch (TigaseStringprepException ex) {
            throw new AuthorizationException("Stringprep failed for: " + res_string, ex);
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", e);
        }
    }

    private boolean saslAuth(Map<String, Object> props) throws UserNotFoundException, TigaseDBException, AuthorizationException, TigaseStringprepException {
        int user_idx;
        int auth_idx;
        String data_str = (String)props.get("data");
        String domain = (String)props.get("realm");
        props.put("result", null);
        byte[] in_data = data_str != null ? Base64.decode((String)data_str) : new byte[]{};
        for (auth_idx = 0; in_data[auth_idx] != 0 && auth_idx < in_data.length; ++auth_idx) {
        }
        String authoriz = new String(in_data, 0, auth_idx);
        for (user_idx = ++auth_idx; in_data[user_idx] != 0 && user_idx < in_data.length; ++user_idx) {
        }
        String user_name = new String(in_data, auth_idx, user_idx - auth_idx);
        BareJID jid = null;
        jid = BareJID.parseJID((String)user_name)[0] == null ? BareJID.bareJIDInstance((String)user_name, (String)domain) : BareJID.bareJIDInstance((String)user_name);
        props.put("user-id", jid);
        String passwd = new String(in_data, ++user_idx, in_data.length - user_idx);
        return this.plainAuth(jid, passwd);
    }
}

